/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.midi.file;

import gnu.javax.sound.midi.file.ExtendedMidiFileFormat;
import gnu.javax.sound.midi.file.MidiDataInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;

public class MidiFileReader
extends javax.sound.midi.spi.MidiFileReader {
    public MidiFileFormat getMidiFileFormat(InputStream in) throws InvalidMidiDataException, IOException {
        int resolution;
        float divisionType;
        DataInputStream din = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        if (din.readInt() != 1297377380) {
            throw new InvalidMidiDataException("Invalid MIDI chunk header.");
        }
        int bytes = din.readInt();
        if (bytes < 6) {
            throw new InvalidMidiDataException("Invalid MIDI chunk header length: " + bytes);
        }
        short type = din.readShort();
        if (type < 0 || type > 2) {
            throw new InvalidMidiDataException("Invalid MIDI file type value: " + type);
        }
        short ntracks = din.readShort();
        if (ntracks <= 0) {
            throw new InvalidMidiDataException("Invalid number of MIDI tracks: " + ntracks);
        }
        int division = din.readShort();
        if ((division & 0x8000) != 0) {
            division = -(division >>> 8 & 0xFF);
            switch (division) {
                case 24: {
                    divisionType = 24.0f;
                    break;
                }
                case 25: {
                    divisionType = 25.0f;
                    break;
                }
                case 29: {
                    divisionType = 29.97f;
                    break;
                }
                case 30: {
                    divisionType = 30.0f;
                    break;
                }
                default: {
                    throw new InvalidMidiDataException("Invalid MIDI frame division type: " + division);
                }
            }
            resolution = division & 0xFF;
        } else {
            divisionType = 0.0f;
            resolution = division & Short.MAX_VALUE;
        }
        din.skip(bytes - 6);
        return new ExtendedMidiFileFormat(type, divisionType, resolution, -1, -1L, ntracks);
    }

    public MidiFileFormat getMidiFileFormat(URL url) throws InvalidMidiDataException, IOException {
        InputStream is = url.openStream();
        try {
            MidiFileFormat midiFileFormat = this.getMidiFileFormat(is);
            return midiFileFormat;
        }
        finally {
            is.close();
        }
    }

    public MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            MidiFileFormat midiFileFormat = this.getMidiFileFormat(is);
            return midiFileFormat;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public Sequence getSequence(InputStream is) throws InvalidMidiDataException, IOException {
        MidiDataInputStream din = new MidiDataInputStream(is);
        ExtendedMidiFileFormat mff = (ExtendedMidiFileFormat)this.getMidiFileFormat(din);
        Sequence seq = new Sequence(mff.getDivisionType(), mff.getResolution());
        int ntracks = mff.getNumberTracks();
        while (ntracks-- > 0) {
            Track track = seq.createTrack();
            int Mtrk = din.readInt();
            if (Mtrk != 1297379947) {
                throw new InvalidMidiDataException("Invalid MIDI track header.");
            }
            din.readInt();
            int runningStatus = -1;
            int click = 0;
            boolean done = false;
            block11: while (!done) {
                MidiMessage mm;
                int dtime = din.readVariableLengthInt();
                click += dtime;
                int sbyte = din.readUnsignedByte();
                if (sbyte < 240) {
                    ShortMessage sm;
                    block0 : switch (sbyte & 0xF0) {
                        case 128: 
                        case 144: 
                        case 160: 
                        case 176: 
                        case 224: 
                        case 242: {
                            sm = new ShortMessage();
                            sm.setMessage(sbyte, din.readByte(), din.readByte());
                            runningStatus = sbyte;
                            break;
                        }
                        case 192: 
                        case 208: 
                        case 243: 
                        case 245: {
                            sm = new ShortMessage();
                            sm.setMessage(sbyte, din.readByte(), 0);
                            runningStatus = sbyte;
                            break;
                        }
                        case 246: 
                        case 247: 
                        case 248: 
                        case 250: 
                        case 251: 
                        case 252: 
                        case 254: 
                        case 255: {
                            sm = new ShortMessage();
                            sm.setMessage(sbyte, 0, 0);
                            runningStatus = sbyte;
                            break;
                        }
                        default: {
                            if (runningStatus != -1) {
                                switch (runningStatus & 0xF0) {
                                    case 128: 
                                    case 144: 
                                    case 160: 
                                    case 176: 
                                    case 224: 
                                    case 242: {
                                        sm = new ShortMessage();
                                        sm.setMessage(runningStatus, sbyte, din.readByte());
                                        break block0;
                                    }
                                    case 192: 
                                    case 208: 
                                    case 243: 
                                    case 245: {
                                        ShortMessage sm2 = new ShortMessage();
                                        sm2.setMessage(runningStatus, sbyte, 0);
                                        continue block11;
                                    }
                                    case 246: 
                                    case 247: 
                                    case 248: 
                                    case 250: 
                                    case 251: 
                                    case 252: 
                                    case 254: 
                                    case 255: {
                                        ShortMessage sm3 = new ShortMessage();
                                        sm3.setMessage(runningStatus, 0, 0);
                                        continue block11;
                                    }
                                    default: {
                                        throw new InvalidMidiDataException("Invalid Short MIDI Event: " + sbyte);
                                    }
                                }
                            }
                            throw new InvalidMidiDataException("Invalid Short MIDI Event: " + sbyte);
                        }
                    }
                    mm = sm;
                } else if (sbyte == 240 || sbyte == 247) {
                    int slen = din.readVariableLengthInt();
                    byte[] sysex = new byte[slen];
                    din.readFully(sysex);
                    SysexMessage sm = new SysexMessage();
                    sm.setMessage(sbyte, sysex, slen);
                    mm = sm;
                    runningStatus = -1;
                } else if (sbyte == 255) {
                    byte mtype = din.readByte();
                    int mlen = din.readVariableLengthInt();
                    byte[] meta = new byte[mlen];
                    din.readFully(meta);
                    MetaMessage metam = new MetaMessage();
                    metam.setMessage(mtype, meta, mlen);
                    mm = metam;
                    if (mtype == 47) {
                        done = true;
                    }
                    runningStatus = -1;
                } else {
                    throw new InvalidMidiDataException("Invalid status byte: " + sbyte);
                }
                track.add(new MidiEvent(mm, click));
            }
        }
        return seq;
    }

    public Sequence getSequence(URL url) throws InvalidMidiDataException, IOException {
        InputStream is = url.openStream();
        try {
            Sequence sequence = this.getSequence(is);
            return sequence;
        }
        finally {
            is.close();
        }
    }

    public Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            Sequence sequence = this.getSequence(is);
            return sequence;
        }
        finally {
            ((InputStream)is).close();
        }
    }
}

