/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html.css;

import gnu.java.lang.CPStringBuilder;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector {
    private String[] selector;
    private String[] elements;
    private String[] ids;
    private String[] classes;
    private int specificity;
    private boolean implicit;

    public Selector(String sel) {
        StringTokenizer selectorTokens = new StringTokenizer(sel, " ");
        this.selector = new String[selectorTokens.countTokens()];
        int i = this.selector.length - 1;
        while (selectorTokens.hasMoreTokens()) {
            this.selector[i] = selectorTokens.nextToken();
            --i;
        }
        this.calculateSpecificity();
    }

    public boolean matches(String[] tags, List<Map<String, String>> attributes) {
        boolean match = false;
        int numSel = this.selector.length;
        int numTags = tags.length;
        if (numSel <= numTags) {
            match = true;
            int tagIndex = 0;
            int j = 0;
            while (j < numSel && match) {
                boolean tagMatch = false;
                while (tagIndex < numTags && !tagMatch) {
                    String pathClass = attributes.get(tagIndex).get("class");
                    String pseudoClass = attributes.get(tagIndex).get("_pseudo");
                    String dynClass = attributes.get(tagIndex).get("_dynamic");
                    String pathId = attributes.get(tagIndex).get("id");
                    String tag = this.elements[j];
                    String clazz = this.classes[j];
                    String id = this.ids[j];
                    tagMatch = tag.equals("") || tag.equals("*") || tag.equals(tags[tagIndex]);
                    tagMatch = tagMatch && (clazz.equals("*") || clazz.equals(dynClass) || clazz.equals(pseudoClass) || clazz.equals(pathClass));
                    boolean bl = tagMatch = tagMatch && (id.equals("*") || id.equals(pathId));
                    if (j == 0) break;
                    ++tagIndex;
                }
                match = tagMatch;
                ++j;
            }
        }
        return match;
    }

    public int getSpecificity() {
        return this.specificity;
    }

    public String toString() {
        CPStringBuilder b = new CPStringBuilder();
        int i = this.selector.length - 1;
        while (i >= 0) {
            b.append(this.selector[i]);
            if (i > 0) {
                b.append(' ');
            }
            --i;
        }
        return b.toString();
    }

    private void calculateSpecificity() {
        int a = this.implicit ? 1 : 0;
        int b = 0;
        int c = 0;
        int d = 0;
        int numSel = this.selector.length;
        this.elements = new String[numSel];
        this.ids = new String[numSel];
        this.classes = new String[numSel];
        int i = 0;
        while (i < numSel) {
            String id;
            String clazz;
            String sel = this.selector[i];
            int clazzIndex = sel.indexOf(46);
            if (clazzIndex == -1) {
                clazzIndex = sel.indexOf(58);
            }
            int idIndex = sel.indexOf(35);
            if (clazzIndex == -1) {
                clazz = "*";
                clazzIndex = sel.length();
            } else {
                ++c;
                clazz = sel.substring(clazzIndex + 1, idIndex > 0 ? Math.min(idIndex, sel.length()) : sel.length());
            }
            if (idIndex == -1) {
                id = "*";
                idIndex = sel.length();
            } else {
                ++b;
                id = sel.substring(idIndex + 1, clazzIndex > 0 ? Math.min(clazzIndex, sel.length()) : sel.length());
            }
            String tag = sel.substring(0, Math.min(Math.min(clazzIndex, idIndex), sel.length()));
            if (!tag.equals("") && !tag.equals("*")) {
                ++d;
            }
            this.elements[i] = tag;
            this.ids[i] = id;
            this.classes[i] = clazz;
            ++i;
        }
        this.specificity = a * 20 ^ 3 + b * 20 ^ 2 + c * 20 + d;
    }
}

