/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.LowPriorityEvent;
import gnu.java.awt.peer.NativeEventLoopRunningEvent;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventDispatchThread;
import java.awt.Frame;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.PaintEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.lang.reflect.InvocationTargetException;
import java.util.EmptyStackException;

public class EventQueue {
    private static final int NORM_PRIORITY = 0;
    private static final int LOW_PRIORITY = 1;
    private Queue[] queues;
    private EventQueue next;
    private EventQueue prev;
    private AWTEvent currentEvent;
    private long lastWhen = System.currentTimeMillis();
    private EventDispatchThread dispatchThread = new EventDispatchThread(this);
    private boolean nativeLoopRunning = false;

    private boolean isShutdown() {
        if (this.nativeLoopRunning) {
            return false;
        }
        if (this.peekEvent() != null) {
            return false;
        }
        return !Frame.hasDisplayableFrames();
    }

    public EventQueue() {
        this.queues = new Queue[2];
        this.queues[0] = new Queue();
        this.queues[1] = new Queue();
    }

    public synchronized AWTEvent getNextEvent() throws InterruptedException {
        if (this.next != null) {
            return this.next.getNextEvent();
        }
        AWTEvent res = this.getNextEventImpl(true);
        while (res == null) {
            if (this.isShutdown()) {
                this.dispatchThread = null;
                throw new InterruptedException();
            }
            this.wait();
            res = this.getNextEventImpl(true);
        }
        return res;
    }

    private AWTEvent getNextEventImpl(boolean remove) {
        AWTEvent next = null;
        int i = 0;
        while (i < this.queues.length && next == null) {
            Queue q = this.queues[i];
            if (q.queueHead != null) {
                next = q.queueHead;
                if (remove) {
                    q.queueHead = next.queueNext;
                    if (q.queueHead == null) {
                        q.queueTail = null;
                    }
                    next.queueNext = null;
                }
            }
            ++i;
        }
        return next;
    }

    public synchronized AWTEvent peekEvent() {
        if (this.next != null) {
            return this.next.peekEvent();
        }
        return this.getNextEventImpl(false);
    }

    public synchronized AWTEvent peekEvent(int id) {
        if (this.next != null) {
            return this.next.peekEvent(id);
        }
        AWTEvent evt = null;
        int i = 0;
        while (i < this.queues.length && evt == null) {
            Queue q = this.queues[i];
            evt = q.queueHead;
            while (evt != null && evt.id != id) {
                evt = evt.queueNext;
            }
            ++i;
        }
        return evt;
    }

    public void postEvent(AWTEvent evt) {
        this.postEventImpl(evt);
    }

    private final synchronized void postEventImpl(AWTEvent evt) {
        int priority = 0;
        if (evt instanceof PaintEvent || evt instanceof LowPriorityEvent) {
            priority = 1;
        }
        if (evt instanceof NativeEventLoopRunningEvent) {
            this.nativeLoopRunning = ((NativeEventLoopRunningEvent)evt).isRunning();
            this.notify();
            return;
        }
        this.postEventImpl(evt, priority);
    }

    private final void postEventImpl(AWTEvent evt, int priority) {
        if (evt == null) {
            throw new NullPointerException();
        }
        if (this.next != null) {
            this.next.postEvent(evt);
            return;
        }
        Object source = evt.getSource();
        Queue q = this.queues[priority];
        if (source instanceof Component) {
            Component comp = (Component)source;
            ComponentPeer peer = comp.peer;
            if (peer != null && evt instanceof PaintEvent && !(peer instanceof LightweightPeer)) {
                peer.coalescePaintEvent((PaintEvent)evt);
            }
            AWTEvent previous = null;
            AWTEvent qevt = q.queueHead;
            while (qevt != null) {
                Component srccmp;
                AWTEvent coalescedEvt;
                Object src = qevt.getSource();
                if (qevt.id == evt.id && src == comp && (coalescedEvt = (srccmp = (Component)src).coalesceEvents(qevt, evt)) != null) {
                    if (qevt != coalescedEvt) {
                        if (previous != null) {
                            assert (previous.queueNext == qevt);
                            previous.queueNext = coalescedEvt;
                        } else {
                            assert (q.queueHead == qevt);
                            q.queueHead = coalescedEvt;
                        }
                        coalescedEvt.queueNext = qevt.queueNext;
                        if (q.queueTail == qevt) {
                            q.queueTail = coalescedEvt;
                        }
                        qevt.queueNext = null;
                    }
                    return;
                }
                previous = qevt;
                qevt = qevt.queueNext;
            }
        }
        if (q.queueHead == null) {
            q.queueHead = evt;
            q.queueTail = evt;
        } else {
            q.queueTail.queueNext = evt;
            q.queueTail = evt;
        }
        if (this.dispatchThread == null || !this.dispatchThread.isAlive()) {
            this.dispatchThread = new EventDispatchThread(this);
            this.dispatchThread.start();
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Can't call invokeAndWait from event dispatch thread");
        }
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Object notifyObject = new Object();
        InvocationEvent ie = new InvocationEvent(eq, runnable, notifyObject, true);
        Object object = notifyObject;
        synchronized (object) {
            eq.postEvent(ie);
            notifyObject.wait();
        }
        Exception exception = ie.getException();
        if (exception != null) {
            throw new InvocationTargetException(exception);
        }
    }

    public static void invokeLater(Runnable runnable) {
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        InvocationEvent ie = new InvocationEvent(eq, runnable, null, false);
        eq.postEvent(ie);
    }

    public static boolean isDispatchThread() {
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (eq.next != null) {
            eq = eq.next;
        }
        return Thread.currentThread() == eq.dispatchThread;
    }

    public static AWTEvent getCurrentEvent() {
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        Thread ct = Thread.currentThread();
        while (ct != eq.dispatchThread) {
            if (eq.next == null) {
                return null;
            }
            eq = eq.next;
        }
        return eq.currentEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void push(EventQueue newEventQueue) {
        if (newEventQueue == null) {
            throw new NullPointerException();
        }
        if (this.next != null) {
            this.next.push(newEventQueue);
            return;
        }
        if (this.dispatchThread == null) {
            this.dispatchThread = new EventDispatchThread(this);
        }
        EventQueue eventQueue = newEventQueue;
        synchronized (eventQueue) {
            while (true) {
                if (this.peekEvent() == null) {
                    newEventQueue.prev = this;
                    break;
                }
                try {
                    newEventQueue.postEventImpl(this.getNextEvent());
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.next = newEventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pop() throws EmptyStackException {
        EventQueue previous = this.prev;
        if (previous == null) {
            throw new EmptyStackException();
        }
        EventQueue eventQueue = previous;
        synchronized (eventQueue) {
            EventQueue eventQueue2 = this;
            synchronized (eventQueue2) {
                EventQueue nextQueue = this.next;
                if (nextQueue != null) {
                    nextQueue.pop();
                } else {
                    previous.next = null;
                    while (this.peekEvent() != null) {
                        try {
                            previous.postEventImpl(this.getNextEvent());
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.prev = null;
                    if (this.dispatchThread != null) {
                        this.dispatchThread.interrupt();
                        this.dispatchThread = null;
                    }
                }
            }
        }
    }

    protected void dispatchEvent(AWTEvent evt) {
        this.currentEvent = evt;
        if (evt instanceof InputEvent) {
            this.lastWhen = ((InputEvent)evt).getWhen();
        } else if (evt instanceof ActionEvent) {
            this.lastWhen = ((ActionEvent)evt).getWhen();
        } else if (evt instanceof InvocationEvent) {
            this.lastWhen = ((InvocationEvent)evt).getWhen();
        }
        if (evt instanceof ActiveEvent) {
            ActiveEvent active_evt = (ActiveEvent)((Object)evt);
            active_evt.dispatch();
        } else {
            Object source = evt.getSource();
            if (source instanceof Component) {
                Component srccmp = (Component)source;
                srccmp.dispatchEvent(evt);
            } else if (source instanceof MenuComponent) {
                MenuComponent srccmp = (MenuComponent)source;
                srccmp.dispatchEvent(evt);
            }
        }
    }

    public static long getMostRecentEventTime() {
        EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (Thread.currentThread() != eq.dispatchThread) {
            return System.currentTimeMillis();
        }
        return eq.lastWhen;
    }

    private class Queue {
        AWTEvent queueHead;
        AWTEvent queueTail;

        private Queue() {
        }
    }
}

