/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import gnu.java.lang.CPStringBuilder;
import java.awt.datatransfer.MimeTypeParseException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

class MimeType
implements Externalizable {
    private String primaryType;
    private String subType;
    private HashMap parameters = new HashMap();

    public MimeType() {
    }

    MimeType(String mime) throws MimeTypeParseException {
        this();
        this.parse(mime);
    }

    void addParameter(String param, String value) {
        this.parameters.put(param, value);
    }

    void removeParameter(String param) {
        this.parameters.remove(param);
    }

    String getParameter(String key) {
        return (String)this.parameters.get(key);
    }

    String getPrimaryType() {
        return this.primaryType;
    }

    String getSubType() {
        return this.subType;
    }

    String getBaseType() {
        return String.valueOf(this.primaryType) + '/' + this.subType;
    }

    boolean matches(MimeType other) {
        boolean match = false;
        if (other != null) {
            match = this.primaryType.equals(other.primaryType) && (this.subType.equals("*") || other.subType.equals("*") || this.subType.equals(other.subType));
        }
        return match;
    }

    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        String mime = in.readUTF();
        this.parameters.clear();
        try {
            this.parse(mime);
        }
        catch (MimeTypeParseException ex) {
            IOException ioEx = new IOException();
            ioEx.initCause(ex);
            throw ioEx;
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.toString());
    }

    public String toString() {
        CPStringBuilder s = new CPStringBuilder();
        s.append(this.primaryType);
        s.append('/');
        s.append(this.subType);
        if (this.parameters.size() > 0) {
            Set entries = this.parameters.entrySet();
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                s.append("; ");
                Map.Entry entry = i.next();
                s.append(entry.getKey());
                s.append('=');
                s.append(entry.getValue());
            }
        }
        return s.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void parse(String mime) throws MimeTypeParseException {
        tokenizer = new StringTokenizer(mime);
        try {
            this.primaryType = tokenizer.nextToken("/");
            this.subType = tokenizer.nextToken("/;");
            if (true) ** GOTO lbl15
        }
        catch (NoSuchElementException v0) {
            throw new MimeTypeParseException("Expected / separator");
        }
        do {
            if ((i = (keyValuePair = tokenizer.nextToken(";")).indexOf(61)) == -1) {
                throw new MimeTypeParseException("Expected = as parameter separator");
            }
            key = keyValuePair.substring(0, i).trim();
            value = keyValuePair.substring(i + 1).trim();
            this.parameters.put(key, value);
lbl15:
            // 2 sources

        } while (tokenizer.hasMoreTokens());
    }
}

