/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

public class ErrorManager {
    public static final int GENERIC_FAILURE = 0;
    public static final int WRITE_FAILURE = 1;
    public static final int FLUSH_FAILURE = 2;
    public static final int CLOSE_FAILURE = 3;
    public static final int OPEN_FAILURE = 4;
    public static final int FORMAT_FAILURE = 5;
    private volatile boolean everUsed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String message, Exception ex, int errorCode) {
        String codeMsg;
        if (this.everUsed) {
            return;
        }
        ErrorManager errorManager = this;
        synchronized (errorManager) {
            if (this.everUsed) {
                return;
            }
            this.everUsed = true;
        }
        switch (errorCode) {
            case 0: {
                codeMsg = "GENERIC_FAILURE";
                break;
            }
            case 1: {
                codeMsg = "WRITE_FAILURE";
                break;
            }
            case 2: {
                codeMsg = "FLUSH_FAILURE";
                break;
            }
            case 3: {
                codeMsg = "CLOSE_FAILURE";
                break;
            }
            case 4: {
                codeMsg = "OPEN_FAILURE";
                break;
            }
            case 5: {
                codeMsg = "FORMAT_FAILURE";
                break;
            }
            default: {
                codeMsg = String.valueOf(errorCode);
            }
        }
        System.err.println("Error upon logging: " + codeMsg);
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        if (ex != null) {
            ex.printStackTrace();
        }
    }
}

