/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import gnu.java.lang.CPStringBuilder;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;

public class MaskFormatter
extends DefaultFormatter {
    private static final char NUM_CHAR = '#';
    private static final char ESCAPE_CHAR = '\'';
    private static final char UPPERCASE_CHAR = 'U';
    private static final char LOWERCASE_CHAR = 'L';
    private static final char ALPHANUM_CHAR = 'A';
    private static final char LETTER_CHAR = '?';
    private static final char ANYTHING_CHAR = '*';
    private static final char HEX_CHAR = 'H';
    private String mask;
    private String invalidChars;
    private String validChars;
    private String placeHolder;
    private char placeHolderChar = (char)32;
    private boolean valueContainsLiteralCharacters = true;
    private static String hexString = "0123456789abcdefABCDEF";
    int maskLength = 0;

    public MaskFormatter() {
        this.setAllowsInvalid(false);
    }

    public MaskFormatter(String mask) throws ParseException {
        this();
        this.setMask(mask);
    }

    public String getMask() {
        return this.mask;
    }

    public String getInvalidCharacters() {
        return this.invalidChars;
    }

    public void setInvalidCharacters(String invalidCharacters) {
        this.invalidChars = invalidCharacters;
    }

    public String getValidCharacters() {
        return this.validChars;
    }

    public void setValidCharacters(String validCharacters) {
        this.validChars = validCharacters;
    }

    public String getPlaceholder() {
        return this.placeHolder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeHolder = placeholder;
    }

    public char getPlaceholderCharacter() {
        return this.placeHolderChar;
    }

    public void setPlaceholderCharacter(char placeholder) {
        this.placeHolderChar = placeholder;
    }

    public boolean getValueContainsLiteralCharacters() {
        return this.valueContainsLiteralCharacters;
    }

    public void setValueContainsLiteralCharacters(boolean containsLiteralChars) {
        this.valueContainsLiteralCharacters = containsLiteralChars;
    }

    public void setMask(String mask) throws ParseException {
        this.mask = mask;
        int end = mask.length() - 1;
        this.maskLength = 0;
        int i = 0;
        while (i <= end) {
            if (mask.charAt(i) == '\'') {
                if (i != end) {
                    ++this.maskLength;
                }
                ++i;
            } else {
                ++this.maskLength;
            }
            ++i;
        }
    }

    public void install(JFormattedTextField ftf) {
        super.install(ftf);
        if (ftf != null) {
            try {
                this.valueToString(ftf.getValue());
            }
            catch (ParseException parseException) {
                ftf.setText("");
                this.setEditValid(false);
            }
        }
    }

    public Object stringToValue(String value) throws ParseException {
        return super.stringToValue(this.convertStringToValue(value));
    }

    private String convertStringToValue(String value) throws ParseException {
        CPStringBuilder result = new CPStringBuilder();
        int length = this.mask.length();
        int i = 0;
        int j = 0;
        while (j < length) {
            char valueChar;
            boolean isPlaceHolder;
            char maskChar = this.mask.charAt(j);
            if (i < value.length()) {
                isPlaceHolder = false;
                valueChar = value.charAt(i);
                if (maskChar != '\'' && maskChar != valueChar) {
                    if (this.invalidChars != null && this.invalidChars.indexOf(valueChar) != -1) {
                        throw new ParseException("Invalid character: " + valueChar, i);
                    }
                    if (this.validChars != null && this.validChars.indexOf(valueChar) == -1) {
                        throw new ParseException("Invalid character: " + valueChar, i);
                    }
                }
            } else if (this.placeHolder != null && i < this.placeHolder.length()) {
                isPlaceHolder = true;
                valueChar = this.placeHolder.charAt(i);
            } else {
                isPlaceHolder = true;
                valueChar = this.placeHolderChar;
            }
            switch (maskChar) {
                case '#': {
                    if (!Character.isDigit(valueChar)) {
                        throw new ParseException("Number expected: " + valueChar, i);
                    }
                    result.append(valueChar);
                    ++i;
                    break;
                }
                case 'U': {
                    if (!Character.isLetter(valueChar)) {
                        throw new ParseException("Letter expected", i);
                    }
                    result.append(Character.toUpperCase(valueChar));
                    ++i;
                    break;
                }
                case 'L': {
                    if (!Character.isLetter(valueChar)) {
                        throw new ParseException("Letter expected", i);
                    }
                    result.append(Character.toLowerCase(valueChar));
                    ++i;
                    break;
                }
                case 'A': {
                    if (!Character.isLetterOrDigit(valueChar)) {
                        throw new ParseException("Letter or number expected", i);
                    }
                    result.append(valueChar);
                    ++i;
                    break;
                }
                case '?': {
                    if (!Character.isLetter(valueChar)) {
                        throw new ParseException("Letter expected", i);
                    }
                    result.append(valueChar);
                    ++i;
                    break;
                }
                case 'H': {
                    if (hexString.indexOf(valueChar) == -1 && !isPlaceHolder) {
                        throw new ParseException("Hexadecimal character expected", i);
                    }
                    result.append(valueChar);
                    ++i;
                    break;
                }
                case '*': {
                    result.append(valueChar);
                    ++i;
                    break;
                }
                case '\'': {
                    if (++j < length) {
                        maskChar = this.mask.charAt(j);
                        if (!isPlaceHolder && this.getValueContainsLiteralCharacters() && valueChar != maskChar) {
                            throw new ParseException("Invalid character: " + valueChar, i);
                        }
                        if (this.getValueContainsLiteralCharacters()) {
                            result.append(maskChar);
                        }
                        ++i;
                        break;
                    }
                    if (isPlaceHolder) break;
                    throw new ParseException("Bad match at trailing escape: ", i);
                }
                default: {
                    if (!isPlaceHolder && this.getValueContainsLiteralCharacters() && valueChar != maskChar) {
                        throw new ParseException("Invalid character: " + valueChar, i);
                    }
                    if (this.getValueContainsLiteralCharacters()) {
                        result.append(maskChar);
                    }
                    ++i;
                }
            }
            ++j;
        }
        return result.toString();
    }

    public String valueToString(Object value) throws ParseException {
        String string = value != null ? value.toString() : "";
        return this.convertValueToString(string);
    }

    private String convertValueToString(String value) throws ParseException {
        CPStringBuilder result = new CPStringBuilder();
        int length = this.mask.length();
        int i = 0;
        int j = 0;
        while (j < length) {
            char valueChar;
            boolean isPlaceHolder;
            char maskChar = this.mask.charAt(j);
            if (i < value.length()) {
                isPlaceHolder = false;
                valueChar = value.charAt(i);
                if (maskChar != '\'' && valueChar != maskChar) {
                    if (this.invalidChars != null && this.invalidChars.indexOf(valueChar) != -1) {
                        throw new ParseException("Invalid character: " + valueChar, i);
                    }
                    if (this.validChars != null && this.validChars.indexOf(valueChar) == -1) {
                        throw new ParseException("Invalid character: " + valueChar + " maskChar: " + maskChar, i);
                    }
                }
            } else if (this.placeHolder != null && i < this.placeHolder.length()) {
                isPlaceHolder = true;
                valueChar = this.placeHolder.charAt(i);
            } else {
                isPlaceHolder = true;
                valueChar = this.placeHolderChar;
            }
            switch (maskChar) {
                case '#': {
                    if (!isPlaceHolder && !Character.isDigit(valueChar)) {
                        throw new ParseException("Number expected: " + valueChar, i);
                    }
                    result.append(valueChar);
                    ++i;
                    break;
                }
                case 'U': {
                    if (!Character.isLetter(valueChar)) {
                        throw new ParseException("Letter expected", i);
                    }
                    result.append(Character.toUpperCase(valueChar));
                    ++i;
                    break;
                }
                case 'L': {
                    if (!Character.isLetter(valueChar)) {
                        throw new ParseException("Letter expected", i);
                    }
                    result.append(Character.toLowerCase(valueChar));
                    ++i;
                    break;
                }
                case 'A': {
                    if (!Character.isLetterOrDigit(valueChar)) {
                        throw new ParseException("Letter or number expected", i);
                    }
                    result.append(valueChar);
                    ++i;
                    break;
                }
                case '?': {
                    if (!Character.isLetter(valueChar)) {
                        throw new ParseException("Letter expected", i);
                    }
                    result.append(valueChar);
                    ++i;
                    break;
                }
                case 'H': {
                    if (hexString.indexOf(valueChar) == -1 && !isPlaceHolder) {
                        throw new ParseException("Hexadecimal character expected", i);
                    }
                    result.append(valueChar);
                    ++i;
                    break;
                }
                case '*': {
                    result.append(valueChar);
                    ++i;
                    break;
                }
                case '\'': {
                    if (++j >= length) break;
                    maskChar = this.mask.charAt(j);
                    if (!isPlaceHolder && this.getValueContainsLiteralCharacters() && valueChar != maskChar) {
                        throw new ParseException("Invalid character: " + valueChar, i);
                    }
                    if (this.getValueContainsLiteralCharacters()) {
                        ++i;
                    }
                    result.append(maskChar);
                    break;
                }
                default: {
                    if (!isPlaceHolder && this.getValueContainsLiteralCharacters() && valueChar != maskChar) {
                        throw new ParseException("Invalid character: " + valueChar, i);
                    }
                    if (this.getValueContainsLiteralCharacters()) {
                        ++i;
                    }
                    result.append(maskChar);
                }
            }
            ++j;
        }
        return result.toString();
    }
}

