#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/htdig/htdig.conf.new

( cd usr/lib/htdig_db ; rm -rf libhtdb.so )
( cd usr/lib/htdig_db ; ln -sf libhtdb-3.2.0.so libhtdb.so )
( cd usr/lib/htdig ; rm -rf libht.so )
( cd usr/lib/htdig ; ln -sf libht-3.2.0.so libht.so )
( cd usr/lib/htdig ; rm -rf libhtword.so )
( cd usr/lib/htdig ; ln -sf libhtword-3.2.0.so libhtword.so )
( cd usr/lib/htdig ; rm -rf libhtnet.so )
( cd usr/lib/htdig ; ln -sf libhtnet-3.2.0.so libhtnet.so )
( cd usr/lib/htdig ; rm -rf libcommon.so )
( cd usr/lib/htdig ; ln -sf libcommon-3.2.0.so libcommon.so )
( cd usr/lib/htdig ; rm -rf libfuzzy.so )
( cd usr/lib/htdig ; ln -sf libfuzzy-3.2.0.so libfuzzy.so )
