#ifndef __COMMON_H__
#define __COMMON_H__

#include <gtk/gtk.h>
#include <gst/gst.h>
#include <panel-applet.h>


#define APPLET_HEIGHT 26
#define SCROLL_LENGTH_PIXEL 60


gboolean debug;



typedef struct
{
  gchar *label_text;
  gchar *menu_text;
  gchar *url;
} data_struct;


typedef struct 
{

  PanelApplet *panel_applet;
  GtkWidget   *vbox;

  GtkWidget *play_button;
  GtkWidget *menu_button;

  GtkWidget *dialog_menu;
  GtkWidget *treeview;

  GtkWidget *play_run_image;
  GtkWidget *play_stop_image;
  GtkWidget *play_error_image;
  GtkWidget *play_connect_image;

  GtkWidget *main_label1;
  GtkWidget *main_label2;
  GtkWidget *main_layout;

  GtkWidget *eventbox;
 
  GtkWidget *scroll_label1;
  GtkWidget *scroll_label2; 
  GtkWidget *info_label;

  gboolean new_title1;
  gboolean new_title2;
  gint label_pos1;
  gint label_pos2;  

  gint label_len1;
  gint label_len2;  

  gboolean display_locked;
  guint lock_timer;

  guint scroll_timer;
  GtkWidget *scroll_layout;

  guint buffer_id;
  guint tag_id_scroll;
  guint tag_id_no_scroll;
  guint state_id;

  GtkWidget *progressbar;

  GList *data;

  gchar *url;
  gchar *caption;
  
  GstElement *play;
  GstBus *bus;

  gchar *title;
  gchar *genre;
  gchar *comment;
  gchar *location;
  gchar *album;
  gint bitrate;
  
  GtkWidget *label_caption;
  GtkWidget *label_stream;
  GtkWidget *label_title;
  GtkWidget *label_album;
  GtkWidget *label_genre;
  GtkWidget *label_comment;
  GtkWidget *label_location;
  GtkWidget *label_bitrate;

  PanelAppletBackgroundType background_type;

  GtkWidget  *tooltip;
  guint tooltip_timer;
  gint screen_width;
  gint screen_height;
  
  GtkWidget *menu;

  gboolean xtest;
  
} Applet;

void show_image (Applet *applet, GtkWidget *image);

#endif
