#include <gtk/gtk.h>
#include "string.h"
#include <panel-applet.h> 

#include "common.h"

void prepare_title1 (Applet *applet) {

  gchar *markup = g_markup_printf_escaped ("<span font_desc='6'>%s  :::  </span>", 
    applet->title);
  gtk_label_set_markup (GTK_LABEL (applet->scroll_label1), markup);
  g_free (markup); 

  GtkRequisition req;
  gtk_widget_size_request  (applet->scroll_label1, &req);
  applet->label_len1= req.width;
  
}    

void prepare_title2 (Applet *applet) {

  gchar *markup = g_markup_printf_escaped ("<span font_desc='6'>%s  :::  </span>", 
    applet->title);
  gtk_label_set_markup (GTK_LABEL (applet->scroll_label2), markup);
  g_free (markup); 

  GtkRequisition req;
  gtk_widget_size_request  (applet->scroll_label2, &req);
  applet->label_len2= req.width; 
  
}      

gboolean scroll_timer (gpointer data) {

  Applet *applet= (Applet*) data;

  //printf ("scroll timer\n");
 
  if (-applet->label_pos1 + SCROLL_LENGTH_PIXEL >= applet->label_len1 + applet->label_len2) {
    
    if (applet->new_title1) {
      prepare_title1 (applet);
      applet->new_title1=FALSE;
    }  

    applet->label_pos1 = SCROLL_LENGTH_PIXEL+1;
  }  else {
    applet->label_pos1-=1; 
  } 

  if (-applet->label_pos2 + SCROLL_LENGTH_PIXEL >= applet->label_len1 + applet->label_len2) {
    
    if (applet->new_title2) {
      prepare_title2 (applet);
      applet->new_title2=FALSE;
    }  

    applet->label_pos2 = SCROLL_LENGTH_PIXEL+1;
  }  else {
    applet->label_pos2-=1; 
  } 

  gtk_layout_move (GTK_LAYOUT (applet->scroll_layout), applet->scroll_label1, 
      applet->label_pos1, 1);       

  gtk_layout_move (GTK_LAYOUT (applet->scroll_layout), applet->scroll_label2, 
     applet->label_pos2, 1);     

  return TRUE;
}  

void display_info_text (Applet *applet, gchar *text)
{

  if (text == NULL)
    return;

  gchar *markup = g_markup_printf_escaped ("<span font_desc='6'> %s </span>", text);
  gtk_label_set_markup (GTK_LABEL (applet->info_label), markup);
  g_free (markup);

  if (!GTK_WIDGET_VISIBLE (applet->info_label))
    gtk_widget_show (applet->info_label); 

}  

void set_label_text (Applet *applet, gchar *text)
{

  gchar *markup1;
  gchar *markup2; 

  if (text == NULL)
    return;

  markup1 = g_markup_printf_escaped ("<span foreground=\"black\" font_desc='8'>%s</span>", text);
  gtk_label_set_markup (GTK_LABEL (applet->main_label1), markup1);
  g_free (markup1);

  markup2 = g_markup_printf_escaped ("<span foreground=\"white\" font_desc='8'>%s</span>", text);
  gtk_label_set_markup (GTK_LABEL (applet->main_label2), markup2);
  g_free (markup2); 
  
} 

void start_scrolling (Applet *applet) {

  if (debug) printf ("start_scrolling\n");

  if (GTK_WIDGET_VISIBLE (applet->info_label)) {
    gtk_widget_hide (applet->info_label);
  }

  prepare_title1 (applet);
  applet->label_pos1=SCROLL_LENGTH_PIXEL+1;
        
  prepare_title2 (applet);
  applet->label_pos2=SCROLL_LENGTH_PIXEL+ applet->label_len1+1;
    
  applet->scroll_timer=g_timeout_add  (50, scroll_timer, applet); 

}

void stop_scrolling (Applet *applet) {

  if (applet->tag_id_scroll !=0 ) {
    g_signal_handler_disconnect  (applet->bus, applet->tag_id_scroll);
    applet->tag_id_scroll=0;
  }

  if (applet->scroll_timer !=0 ) {
    g_source_remove (applet->scroll_timer);
    applet->scroll_timer=0;
  }
 
  gtk_layout_move (GTK_LAYOUT (applet->scroll_layout), applet->scroll_label1, 
      SCROLL_LENGTH_PIXEL+1, 1); 
  gtk_layout_move (GTK_LAYOUT (applet->scroll_layout), applet->scroll_label2, 
      SCROLL_LENGTH_PIXEL+1, 1);

}

