#include "config.h"

#ifdef HAVE_XTEST

#include <gtk/gtk.h>
#include <panel-applet.h> 

#include <gdk/gdk.h>
#include <gdk/gdkx.h> 
#include "string.h"
#include "common.h" 
#include <X11/extensions/XTest.h>
//#include <signal.h>
#include <stdlib.h>
#include "X11/keysym.h"


void irc_init (Applet* applet) {

   int e, error, major, minor;

   applet->xtest=TRUE;

   if  (!XTestQueryExtension (GDK_DISPLAY(), &e, &error, &major, &minor )){
    printf ("no XTest extension found ;(\n");
    applet->xtest=FALSE; 
   } 
}


void announce_title (Applet *applet) {
  
  Display *display_xlib=GDK_DISPLAY();  
  unsigned int ret=XKeysymToKeycode(display_xlib,XK_Return);   
  unsigned int shift_l=XKeysymToKeycode(display_xlib,XK_Shift_L) ;

  if (applet->xtest==FALSE || applet->title == NULL)
    return;

  gchar *text=g_strdup_printf ("/me is listening to \"%s\" using iStream Gnome Applet",
      applet->title);

  gchar *pointer=text;

  gint index;
  for (index=0; index < strlen (text); index++) {

    gchar* letter= g_strndup (pointer, sizeof (char));
    //printf ("letter: %s\n", letter);

    unsigned int keycode;

    do {

      if (strcmp (letter, " ") == 0) {
        keycode=XKeysymToKeycode(display_xlib, XK_space);
        XTestFakeKeyEvent(display_xlib, keycode, True, 1);        
        XTestFakeKeyEvent(display_xlib, keycode, False, 1);   
        break;
      }

      if (strcmp (letter, "-") == 0) {
        keycode=XKeysymToKeycode(display_xlib, XK_space);
        XTestFakeKeyEvent(display_xlib, 61, True, 1);        
        XTestFakeKeyEvent(display_xlib, 61, False, 1);   
        break;
      } 

      if (strcmp (letter, ".") == 0) {
        keycode=XKeysymToKeycode(display_xlib, XK_space);
        XTestFakeKeyEvent(display_xlib, 60, True, 1);        
        XTestFakeKeyEvent(display_xlib, 60, False, 1);   
        break;
      } 

      if (strcmp (letter, "?") == 0) {
        XTestFakeKeyEvent(display_xlib, shift_l, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 20, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 20, False, CurrentTime);
        XTestFakeKeyEvent(display_xlib, shift_l, False, CurrentTime); 
       
        break;
      }   

      if (strcmp (letter, "(") == 0) {
        XTestFakeKeyEvent(display_xlib, shift_l, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 17, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 17, False, CurrentTime);
        XTestFakeKeyEvent(display_xlib, shift_l, False, CurrentTime); 
       
        break;
      } 

       if (strcmp (letter, ")") == 0) {
        XTestFakeKeyEvent(display_xlib, shift_l, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 18, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 18, False, CurrentTime);
        XTestFakeKeyEvent(display_xlib, shift_l, False, CurrentTime); 
       
        break;
      } 

       if (strcmp (letter, "%") == 0) {
        XTestFakeKeyEvent(display_xlib, shift_l, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 14, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 14, False, CurrentTime);
        XTestFakeKeyEvent(display_xlib, shift_l, False, CurrentTime); 
       
        break;
      } 

      if (strcmp (letter, "&") == 0) {
        XTestFakeKeyEvent(display_xlib, shift_l, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 15, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 15, False, CurrentTime);
        XTestFakeKeyEvent(display_xlib, shift_l, False, CurrentTime); 
       
        break;
      }

       if (strcmp (letter, "$") == 0) {
        XTestFakeKeyEvent(display_xlib, shift_l, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 13, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 13, False, CurrentTime);
        XTestFakeKeyEvent(display_xlib, shift_l, False, CurrentTime); 
       
        break;
      }  

      if (strcmp (letter, "") == 0) {
        XTestFakeKeyEvent(display_xlib, shift_l, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 12, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 12, False, CurrentTime);
        XTestFakeKeyEvent(display_xlib, shift_l, False, CurrentTime); 
       
        break;
      } 

       if (strcmp (letter, "\"") == 0) {
        XTestFakeKeyEvent(display_xlib, shift_l, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 11, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 11, False, CurrentTime);
        XTestFakeKeyEvent(display_xlib, shift_l, False, CurrentTime); 
       
        break;
      }  

      if (strcmp (letter, "!") == 0) {
        XTestFakeKeyEvent(display_xlib, shift_l, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 10, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 10, False, CurrentTime);
        XTestFakeKeyEvent(display_xlib, shift_l, False, CurrentTime); 
       
        break;
      }   

      if (strcmp (letter, ":") == 0) {
        XTestFakeKeyEvent(display_xlib, shift_l, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 60, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 60, False, CurrentTime);
        XTestFakeKeyEvent(display_xlib, shift_l, False, CurrentTime); 
       
        break;
      }   

      if (strcmp (letter, "/") == 0) {
        keycode=16; //XKeysymToKeycode(display_xlib, XK_backslash);
        XTestFakeKeyEvent(display_xlib, shift_l, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 16, True, CurrentTime);
        XTestFakeKeyEvent(display_xlib, 16, False, CurrentTime);
        XTestFakeKeyEvent(display_xlib, shift_l, False, CurrentTime);
        break;
      }

      keycode = XKeysymToKeycode(display_xlib, XStringToKeysym(letter)); 

      if (!g_ascii_isdigit((gchar) *letter) && g_ascii_isupper ((gchar) *letter))
        XTestFakeKeyEvent(display_xlib, shift_l, True, CurrentTime);

      XTestFakeKeyEvent(display_xlib, keycode, True, 1);        
      XTestFakeKeyEvent(display_xlib, keycode, False, 1);   

      if (!g_ascii_isdigit((gchar) *letter) && g_ascii_isupper ((gchar) *letter))
        XTestFakeKeyEvent(display_xlib, shift_l, False, CurrentTime);  


    } while (0);

    g_free (letter);
    pointer++;

  }
  
  XTestFakeKeyEvent(display_xlib, ret, True, 1);
  XTestFakeKeyEvent(display_xlib, ret, False, 1);  

  g_free (text);


}

#endif
