#include <gnome.h>
#include <panel-applet.h>
#include <panel-applet-gconf.h>
#include <gst/gst.h>
#include "config.h"
#include "common.h"
#include "menu.h"
#include "stream.h"
#include "tooltip.h"
#include "display.h"
#include "irc.h"

gboolean debug=FALSE;


static void
applet_back_change (PanelApplet *a, PanelAppletBackgroundType	type,
  GdkColor *color, GdkPixmap			*pixmap, Applet			*applet)
{

  GtkRcStyle *rc_style;
  GtkStyle *style;

  GtkRcStyle *rc_style2;
  GtkStyle *style2;

  gtk_widget_set_style (GTK_WIDGET (applet->panel_applet), NULL);
  rc_style = gtk_rc_style_new ();
  gtk_widget_modify_style (GTK_WIDGET (applet->panel_applet), rc_style);
  gtk_rc_style_unref (rc_style);

  gtk_widget_set_style (GTK_WIDGET (applet->main_layout), NULL);
  rc_style2 = gtk_rc_style_new ();
  gtk_widget_modify_style (GTK_WIDGET (applet->main_layout), rc_style2);
  gtk_rc_style_unref (rc_style2); 

  applet->background_type=type;

  switch (type) {
    case PANEL_COLOR_BACKGROUND:
      gtk_widget_modify_bg (GTK_WIDGET (applet->panel_applet),
        GTK_STATE_NORMAL, color);

      gtk_widget_modify_bg (GTK_WIDGET (applet->main_layout),
        GTK_STATE_NORMAL, color);
    break;

    case PANEL_PIXMAP_BACKGROUND:
      style = gtk_style_copy (GTK_WIDGET (
      applet->panel_applet)->style);
      if (style->bg_pixmap[GTK_STATE_NORMAL])
        g_object_unref (style->bg_pixmap[GTK_STATE_NORMAL]);
      style->bg_pixmap[GTK_STATE_NORMAL] = g_object_ref(pixmap);
      gtk_widget_set_style (GTK_WIDGET (applet->panel_applet), style);
      g_object_unref (style);

      style2 = gtk_style_copy (GTK_WIDGET (applet->main_layout)->style);
      if (style2->bg_pixmap[GTK_STATE_NORMAL])
        g_object_unref (style2->bg_pixmap[GTK_STATE_NORMAL]);
      style2->bg_pixmap[GTK_STATE_NORMAL] = g_object_ref(pixmap);
      gtk_widget_set_style (GTK_WIDGET (applet->main_layout), style2);
      g_object_unref (style2);  

    break;

    case PANEL_NO_BACKGROUND:
    default:
    break;
  }

}

static void
about_cb (BonoboUIComponent *uic, Applet *applet,
  const gchar *verbname)
{
  static const gchar *authors [] = {
  "Applet: Jochen Baier <email@jochen-baier.de>\n"\
  "Icon: http://dragonxp.deviantart.com", NULL};

  gtk_show_about_dialog (NULL,
  "name",		_("iStream"),
  "version",	VERSION,
  "comments",	("iStream you listen."),
  "copyright",	"\xC2\xA9 2007 Jochen Baier",
  "authors",	authors,
  "logo-icon-name",	"istream",
  NULL);
}

#ifdef HAVE_XTEST
static void
announce_cb (BonoboUIComponent *uic, Applet *applet,
  const gchar *verbname)
{ 
  announce_title (applet);
}

#endif

void show_image (Applet *applet, GtkWidget *image)
{

  if (GTK_WIDGET_VISIBLE(applet->play_run_image))
    gtk_widget_hide (applet->play_run_image);
  if (GTK_WIDGET_VISIBLE(applet->play_stop_image))
    gtk_widget_hide (applet->play_stop_image);
  if (GTK_WIDGET_VISIBLE(applet->play_connect_image))
    gtk_widget_hide (applet->play_connect_image);
  if (GTK_WIDGET_VISIBLE(applet->play_error_image))
    gtk_widget_hide (applet->play_error_image);

  gtk_widget_show (image);
}

gboolean
play_released  (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                             Applet *applet)
{

 if (debug) printf ("play released\n");

 gtk_layout_move (GTK_LAYOUT (applet->main_layout), applet->play_button, 3, 0); 

 if (GTK_WIDGET_VISIBLE(applet->play_run_image) || 
     GTK_WIDGET_VISIBLE(applet->play_connect_image) ) {
   if (debug) printf ("play -> stop\n");
    stream_stop (applet);
   } else {
    if (debug) printf ("stop/error -> play\n");
    stream_play (applet);
  }

  return FALSE;
}

gboolean
play_clicked  (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                             Applet *applet)
{

 if (debug) printf ("play clicked\n");

  gtk_layout_move (GTK_LAYOUT (applet->main_layout), applet->play_button, 4, 1);

  return FALSE;
}  

gboolean
show_menu_clicked (GtkWidget      *event_box, 
                         GdkEventButton *event,
                         Applet *applet)
{

  gtk_layout_move (GTK_LAYOUT (applet->main_layout), applet->menu_button, 213, 2);  
  return FALSE;
}

static Applet *
create_applet (PanelApplet *panel_applet)
{ 

 
  GtkWidget *play_vbox;
  GtkWidget *main_background;
  GtkWidget *image4; 

  Applet *applet = g_new0 (Applet, 1);   

  applet->panel_applet = panel_applet;
  applet->vbox = gtk_vbox_new (TRUE, 0);
  gtk_widget_show (applet->vbox);
  gtk_container_add (GTK_CONTAINER (panel_applet), applet->vbox);    

  applet->main_layout = gtk_layout_new (NULL, NULL);
  gtk_widget_show ( applet->main_layout);
  gtk_box_pack_start (GTK_BOX (applet->vbox), applet->main_layout, FALSE, FALSE, 0); 
  gtk_widget_set_size_request ( applet->main_layout , 227, 26);      
  gtk_layout_set_size (GTK_LAYOUT ( applet->main_layout), 230, 26);

  main_background = gtk_image_new_from_file  (
      PACKAGE_DATA_DIR "/pixmaps/istream_background.png");
  gtk_widget_show (main_background);
  gtk_layout_put (GTK_LAYOUT ( applet->main_layout ), main_background, 0, 0);

  applet->main_label1 = gtk_label_new ("");
  gtk_label_set_use_markup (GTK_LABEL (applet->main_label1), TRUE); 
  gtk_widget_show (applet->main_label1);
  gtk_layout_put (GTK_LAYOUT ( applet->main_layout ), applet->main_label1, 23, 6);
  gtk_widget_set_size_request (applet->main_label1, 120, 16);
  gtk_label_set_justify (GTK_LABEL (applet->main_label1), GTK_JUSTIFY_CENTER); 

  applet->main_label2 = gtk_label_new ("");
  gtk_label_set_use_markup (GTK_LABEL (applet->main_label2), TRUE); 
  gtk_widget_show (applet->main_label2);
  gtk_layout_put (GTK_LAYOUT ( applet->main_layout ), applet->main_label2,  22, 4);
  gtk_widget_set_size_request (applet->main_label2, 120, 16);
  gtk_label_set_justify (GTK_LABEL (applet->main_label2), GTK_JUSTIFY_CENTER); 

  applet->scroll_layout = gtk_layout_new (NULL, NULL);
  gtk_widget_show (applet->scroll_layout);
  gtk_layout_put (GTK_LAYOUT ( applet->main_layout ), applet->scroll_layout, 146, 6);   
  gtk_widget_set_size_request (applet->scroll_layout, 60, 12);
  gtk_layout_set_size (GTK_LAYOUT (applet->scroll_layout), 60, 12);
  gtk_widget_modify_bg (GTK_WIDGET (applet->scroll_layout),
        GTK_STATE_NORMAL, &applet->scroll_layout->style->white);   

  applet->scroll_label1 = gtk_label_new ("");
  gtk_label_set_use_markup (GTK_LABEL (applet->scroll_label1), TRUE); 
  gtk_widget_show (applet->scroll_label1);
  gtk_layout_put (GTK_LAYOUT (applet->scroll_layout), applet->scroll_label1, 200, 1);  

  applet->scroll_label2 = gtk_label_new ("");
  gtk_label_set_use_markup (GTK_LABEL (applet->scroll_label2), TRUE); 
  gtk_widget_show (applet->scroll_label2);
  gtk_layout_put (GTK_LAYOUT (applet->scroll_layout), applet->scroll_label2, 200, 1); 

  applet->info_label = gtk_label_new ("");
  gtk_label_set_use_markup (GTK_LABEL (applet->info_label), TRUE); 
  gtk_layout_put (GTK_LAYOUT (applet->scroll_layout), applet->info_label, 0, 1);   
 
  applet->play_button = gtk_event_box_new ();
  gtk_widget_show (applet->play_button);
  gtk_layout_put (GTK_LAYOUT ( applet->main_layout ), applet->play_button, 3, 0);
  //gtk_widget_set_size_request (applet->play_button, 21, 21);
  gtk_event_box_set_visible_window (GTK_EVENT_BOX (applet->play_button), FALSE);

  play_vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (play_vbox);
  gtk_container_add (GTK_CONTAINER (applet->play_button), play_vbox);
  applet->play_run_image = gtk_image_new_from_icon_name ("audio-volume-medium", 
      GTK_ICON_SIZE_LARGE_TOOLBAR);
  applet->play_stop_image = gtk_image_new_from_icon_name ("audio-volume-muted", 
      GTK_ICON_SIZE_LARGE_TOOLBAR);
  applet->play_error_image = gtk_image_new_from_icon_name ("dialog-warning",
      GTK_ICON_SIZE_LARGE_TOOLBAR);
  applet->play_connect_image = gtk_image_new_from_icon_name ("media-playlist-repeat", 
      GTK_ICON_SIZE_LARGE_TOOLBAR);
  
  gtk_box_pack_start (GTK_BOX (play_vbox), applet->play_stop_image, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (play_vbox), applet->play_run_image, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (play_vbox), applet->play_error_image, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (play_vbox), applet->play_connect_image, TRUE, TRUE, 0);
  
  gtk_widget_show (applet->play_stop_image);  
  

  applet->menu_button = gtk_event_box_new ();
  gtk_widget_show (applet->menu_button);
  gtk_layout_put (GTK_LAYOUT ( applet->main_layout ), applet->menu_button, 213, 1);
  gtk_widget_set_size_request (applet->menu_button, 10, 21);
  gtk_event_box_set_visible_window (GTK_EVENT_BOX (applet->menu_button), FALSE);

  image4 = gtk_image_new_from_icon_name ("stock_navigate-next", GTK_ICON_SIZE_SMALL_TOOLBAR);  
  gtk_widget_show (image4);
  gtk_container_add (GTK_CONTAINER (applet->menu_button), image4);
  gtk_widget_set_size_request (image4, 10, 21); 

  applet->eventbox = gtk_event_box_new ();
  gtk_widget_show (applet->eventbox);
  gtk_layout_put (GTK_LAYOUT (applet->main_layout), applet->eventbox, 25, 1);
  gtk_widget_set_size_request (applet->eventbox, 190, 24);
  gtk_event_box_set_visible_window (GTK_EVENT_BOX (applet->eventbox), FALSE);

  return applet; 

}

void free_menu (Applet *applet)
{

  GList *tmp=applet->data;
  
  while  (tmp != NULL) {
    data_struct *new_data=tmp->data;
    g_free (new_data->url);
    g_free (new_data->label_text);
    g_free (new_data->menu_text);
    tmp= tmp->next;
  }

  g_list_free (applet->data);
 
}

static void
destroy_cb (GtkObject *object, Applet *applet)
{

  if (debug) printf ("destroy_cb\n");
  
  stream_stop (applet);
  stream_close (applet);
  menu_done (applet);  
  free_menu (applet);
  
  g_free (applet->title);
  g_free (applet->genre);
  g_free (applet->comment);
  g_free (applet->location);
  g_free (applet->album);

  if (applet->tooltip && GTK_IS_WIDGET (applet->tooltip))
    gtk_widget_destroy (applet->tooltip);
  
  gtk_widget_destroy (GTK_WIDGET (applet->panel_applet));
  g_free (applet);

}

static const char menu_xml [] =
   "<popup name=\"button3\">\n"

  #ifdef HAVE_XTEST

   "   <menuitem name=\"Announce Item\" "
   "           verb=\"Announce\" "
   "           _label=\"Announce title in _IRC\"\n"
   "          pixtype=\"stock\" "
   "          pixname=\"gtk-info\"/>\n"

  #endif
   "   <menuitem name=\"About Item\" "
   "           verb=\"About\" "
   "           _label=\"_About\"\n"
   "          pixtype=\"stock\" "
   "          pixname=\"gnome-stock-about\"/>\n"
   "</popup>\n";

static const BonoboUIVerb menu_verbs [] = {
        BONOBO_UI_UNSAFE_VERB ("About", about_cb),

        #ifdef HAVE_XTEST

        BONOBO_UI_UNSAFE_VERB ("Announce", announce_cb),  

        #endif

        BONOBO_UI_VERB_END
};

static gboolean
applet_init(PanelApplet *panel_applet)
{
  Applet *applet;
  
  gtk_window_set_default_icon_name ("iStream");
  applet = create_applet (panel_applet);
  panel_applet_set_flags (applet->panel_applet, PANEL_APPLET_EXPAND_MINOR);
  panel_applet_setup_menu (applet->panel_applet, menu_xml,
    menu_verbs, applet);

  applet->background_type =PANEL_NO_BACKGROUND;
  applet->data = NULL;
  applet->caption=NULL;
  applet->url=NULL;
  applet->play=NULL;
  applet->title=NULL;
  applet->genre=NULL;
  applet->comment=NULL;
  applet->location=NULL;
  applet->album=NULL;
  applet->bitrate=0;
  applet->tooltip=NULL;
  applet->tooltip_timer=0;
  applet->menu=NULL;
  applet->label_pos1=0;
  applet->label_pos2=0;  
  applet->new_title1=FALSE;
  applet->new_title2=FALSE;
  applet->label_len1=0;
  applet->label_len2=0;
  applet->scroll_timer =0;
  applet->display_locked=TRUE;
  applet->lock_timer=0;
  applet->buffer_id=0;
  applet->tag_id_scroll=0;
  applet->tag_id_no_scroll=0;
  applet->state_id=0;
  applet->xtest=FALSE;

  g_signal_connect (applet->panel_applet, "change_background",
    G_CALLBACK (applet_back_change), applet);
  
  g_signal_connect ((gpointer) applet->play_button, "button_press_event",
    G_CALLBACK (play_clicked), applet); 

  g_signal_connect ((gpointer) applet->play_button, "button_release_event",
    G_CALLBACK (play_released), applet);

   g_signal_connect ((gpointer) applet->menu_button, "button_press_event",
    G_CALLBACK (show_menu_clicked), applet);   

  g_signal_connect ((gpointer) applet->menu_button, "button_release_event",
    G_CALLBACK (show_menu_released), applet);
 
  g_signal_connect (GTK_WIDGET (applet->panel_applet),
    "destroy",  G_CALLBACK (destroy_cb), applet);

  gtk_widget_show (GTK_WIDGET (applet->panel_applet));
  
  #ifdef HAVE_XTEST 
  irc_init (applet);
  #endif

  menu_init (applet);
  stream_init (applet);
  tooltip_init (applet);

  return TRUE;
}

static gboolean
istream_applet_factory (PanelApplet *panel_applet, const gchar *iid, gpointer     data)
{

  gboolean retval = FALSE;

  if (!strcmp (iid, "OAFIID:GNOME_istreamApplet"))
    retval = applet_init (panel_applet); 
  
  if (retval == FALSE) {
    exit (-1);
  }
  
  return retval;
}

PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_istreamApplet_Factory",
  PANEL_TYPE_APPLET, "istream", "0", istream_applet_factory, NULL)
