#include <string.h>
#include <stdlib.h>
#include <panel-applet.h>
#include <gtk/gtk.h>

#include "common.h"
#include "stream.h"
#include "display.h"

static gint menu_popup_clicked_cb(GtkWidget *widget, gpointer data);


void remove_empty_lines (gchar *string)
{

   while (1) {
    gchar *empty_line=strstr (string, "\n\n");
    if (empty_line)
       *(++empty_line)='#';
    else
      break;
   }

}

void get_data_list (Applet *applet)
{

  gchar *content=NULL;
  gchar *filename;
  gchar **splitted, **line_splitted;
  gchar *bracket=NULL;
  gint i=0;
  gboolean first=TRUE;
  
  filename=g_strconcat (g_get_home_dir (), G_DIR_SEPARATOR_S, ".istream", NULL);

  if (!g_file_get_contents (filename, &content, NULL, NULL)) {
  
    content=g_strdup (
 
    "#format is:\n"\
    "#\n"\
    "#<Displayed Text> (<invisible Text>)=<url>\n"\
    "#\n"\
    "#url format:\n"\
    "#\n"\
    "#http://<....>\n"\
    "#file:///home/user/<file>\n"\
    "#\n"\
    "#\n"\
    "# my radio stations:\n"\
    "#\n"\
    "edge-radio (Metal)=http://67.43.161.248:6001\n"\
    "mth.Alternative (Alternative)=http://alternative.mthn.net:8700\n"\
    "mth.Electro (Electro)=http://electro.mthn.net:8400\n"\
    "RadioFG (Techno)=http://ufg.impek.tv:80\n"\
    "Di.FM (Gabber)=http://205.188.215.226:8006\n"\
    "chroniX-Aggresion (Metal)=http://205.188.215.225:8010\n"\
    "chroniX-Metal (Metal)=http://205.188.215.225:8022\n");

    g_file_set_contents (filename, content, strlen (content), NULL);

  } else {
    remove_empty_lines (content);
  }

  g_free (filename);
  
  if (debug) printf ("prefs content: %s\n", content);

  splitted=g_strsplit (content,"\n",0);
  
  while (1) {

    if (splitted[i] != NULL && strlen (splitted[i]) >= 1) {
    
      if (debug) printf ("line %d: %s\n", i, splitted[i]);
    
      if (g_str_has_prefix (splitted[i], "#")) {
        i++;
        continue;
      }

      line_splitted=g_strsplit (splitted[i],"=",2);
      
      if (debug) {
        printf ("line_splitted[0]: %s\n", line_splitted[0]);
        printf ("line_splitted[1]: %s\n", line_splitted[1]);
      }

      if (!gst_uri_is_valid (line_splitted[1])) {
        set_label_text (applet, "Invalide url in file.");
        show_image (applet, applet->play_error_image);
        g_strfreev (line_splitted);
        i++;
        continue;
      }

      data_struct *new_data=g_new (data_struct, 1);
      new_data->url =  line_splitted[1];
      new_data->menu_text=line_splitted[0];
      new_data->label_text = g_strdup (line_splitted[0]);
      bracket=NULL;
      bracket=strstr (new_data->label_text, "(");
      if (bracket)
        *bracket=0;

      applet->data=g_list_prepend (applet->data, new_data);

      if (first) {
        applet->url=new_data->url;
        applet->caption=new_data->label_text;
        set_label_text (applet, new_data->label_text);
        first=FALSE;
      } 

    }
    else {
      break;
    }
    
    i++;
  
  }

  g_free (content);
  g_strfreev (splitted);

}

static gint
menu_popup_clicked_cb(GtkWidget *widget, gpointer data)
{

  gdk_pointer_ungrab(GDK_CURRENT_TIME);
  //gdk_keyboard_ungrab(GDK_CURRENT_TIME);
  gtk_grab_remove(GTK_WIDGET(widget));
  gtk_widget_hide (GTK_WIDGET(widget));
  return FALSE;
}

void get_data (GList *list, gchar *command, gchar **caption, gchar **url)
{

  GList *tmp=list;
  
  while  (tmp != NULL) {
  
    data_struct *new_data=tmp->data;
    
    if (!strcmp (new_data->menu_text, command)) {
      *url=new_data->url;
      *caption=new_data->label_text;
      break;
    }

    tmp= tmp->next;
  
  }
 
}

static gboolean 
menu_list_button_press_cb (GtkWidget      *widget,
  GdkEventButton *event, Applet *applet)
{

  GtkTreeView *tree = g_object_get_data (G_OBJECT (applet->panel_applet), "tree");
  GtkTreeIter iter;
  GtkTreeModel *model;
  gchar *command;

  if (debug) printf ("menu clicked\n");

  if (event->type == GDK_BUTTON_RELEASE) {
  
    if (!gtk_tree_selection_get_selected (gtk_tree_view_get_selection (tree),
      &model,  &iter)) return FALSE;

    gtk_widget_hide(applet->dialog_menu); 
    
    gtk_tree_model_get (GTK_TREE_MODEL (model), &iter, 0, &command, -1);
    get_data (applet->data, command, &applet->caption, &applet->url);
    set_label_text (applet, applet->caption);
    g_free (command);
    stream_stop (applet);
    stream_play (applet);

    return TRUE;
  }
  
  return FALSE;

}

void create_dialog (Applet *applet) {
  GtkWidget *window;
  GtkWidget *scrolled_window;
  GtkListStore *store;
  GtkTreeIter iter;
  GtkTreeModel *model;
  GtkWidget    *treeview;
  GtkCellRenderer *cell_renderer;
  GtkTreeViewColumn *column;
  GtkWidget *layout1;
  GtkWidget *image;
  
  window = gtk_window_new(GTK_WINDOW_POPUP); 
  gtk_window_set_screen (GTK_WINDOW (window), gtk_widget_get_screen (
        GTK_WIDGET (applet->panel_applet)));
  gtk_window_set_policy(GTK_WINDOW(window), 0, 0, 1);
  gtk_widget_set_size_request (window, 232, 267);

  layout1 = gtk_layout_new (NULL, NULL);
  gtk_widget_show (layout1);
  gtk_container_add (GTK_CONTAINER (window), layout1);
  gtk_widget_set_size_request (layout1, 227, 266);
  gtk_layout_set_size (GTK_LAYOUT (layout1), 227, 266);
 
  image = gtk_image_new_from_file (PACKAGE_DATA_DIR "/pixmaps/istream_menu.png");
  gtk_widget_show (image);
  gtk_layout_put (GTK_LAYOUT (layout1), image, 0, 0);      

  scrolled_window=gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window),
    GTK_POLICY_NEVER,  GTK_POLICY_AUTOMATIC);
  gtk_widget_set_size_request (scrolled_window, 176, 216);
  gtk_layout_put (GTK_LAYOUT (layout1), scrolled_window, 25, 23);        
  gtk_widget_show(scrolled_window);

  gtk_widget_realize (window);

  GdkPixbuf *pixi= gdk_pixbuf_new_from_file (
      PACKAGE_DATA_DIR "/pixmaps/istream_menu.png", NULL);
  GdkBitmap *mask_return;
  gdk_pixbuf_render_pixmap_and_mask   (pixi, NULL, &mask_return, 255);
  g_object_unref (pixi);
  gtk_widget_shape_combine_mask(window, mask_return, 0, 0 );
  g_object_unref (mask_return);
  
  store = gtk_list_store_new (1, G_TYPE_STRING);
  
  if (applet->data == NULL) {
    gtk_list_store_append (store, &iter);
    gtk_list_store_set (store, &iter,0, "No stations to select.", -1);
  } else {

    GList *tmp=applet->data;

    while  (tmp != NULL) {
      data_struct *new_data=tmp->data;
      if (debug) printf ("add label_text: %s\n", new_data->menu_text);
      gtk_list_store_prepend (store, &iter);
      gtk_list_store_set (store, &iter,0, new_data->menu_text,-1);
      tmp= tmp->next;
    }

  }

  model = GTK_TREE_MODEL(store);
  treeview = gtk_tree_view_new_with_model (model);
  g_object_set_data (G_OBJECT (applet->panel_applet), "tree", treeview);
  cell_renderer = gtk_cell_renderer_text_new ();
  g_object_set(cell_renderer, "size", 7 * PANGO_SCALE, NULL);


  //g_object_set(G_OBJECT(cell_renderer), "xalign", 0.5, NULL);
  column = gtk_tree_view_column_new_with_attributes (NULL, cell_renderer,
                   "text", 0, NULL);

  gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
  gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview), FALSE);
  
  if (applet->data == NULL) {
    gtk_tree_selection_set_mode( (GtkTreeSelection *)gtk_tree_view_get_selection
      (GTK_TREE_VIEW (treeview)), GTK_SELECTION_NONE);
  } else {
    gtk_tree_selection_set_mode( (GtkTreeSelection *)gtk_tree_view_get_selection
      (GTK_TREE_VIEW (treeview)), GTK_SELECTION_SINGLE);
    g_signal_connect (G_OBJECT (treeview), "button_release_event",
      G_CALLBACK (menu_list_button_press_cb), (gpointer) applet);
  }
  g_object_unref (G_OBJECT (model));
  gtk_container_add(GTK_CONTAINER(scrolled_window),treeview);
  gtk_widget_modify_bg (GTK_WIDGET (treeview),
        GTK_STATE_NORMAL, &treeview->style->white); 
  gtk_widget_show (treeview); 
  //gtk_widget_size_request (applet->main_layout, &layout);    
  //gtk_widget_set_size_request (GTK_WIDGET(window), layout.width, -1);  
 

  g_signal_connect_after(GTK_OBJECT(window),
    "button_release_event",  GTK_SIGNAL_FUNC(menu_popup_clicked_cb),  (gpointer) applet);  

  applet->dialog_menu=window;
  applet->treeview=treeview;

}


gboolean
show_menu_released (GtkWidget      *event_box, 
                         GdkEventButton *event,
                         Applet *applet)
{

  gint win_x, win_y;
  gint layout_x, layout_y;
  gint applet_x, applet_y;
  GtkRequisition win; 
  GtkRequisition app;

  gtk_layout_move (GTK_LAYOUT (applet->main_layout), applet->menu_button, 213, 1);

  gtk_widget_size_request (applet->dialog_menu, &win);
  gtk_widget_size_request (GTK_WIDGET (applet->panel_applet), &app); 
  gdk_window_get_origin (GTK_WIDGET (applet->main_layout)->window, &layout_x, &layout_y);        gdk_window_get_origin (GTK_WIDGET (applet->panel_applet)->window, &applet_x, &applet_y); 
  win_x=layout_x;

  PanelAppletOrient orient=panel_applet_get_orient (applet->panel_applet);

  if (orient == PANEL_APPLET_ORIENT_DOWN) {
    win_y=applet_y + app.height + 7;
  } else {
    win_y=applet_y -win.height -7; 
  }  

  gtk_window_move (GTK_WINDOW (applet->dialog_menu), win_x, win_y);
  gtk_widget_show(applet->dialog_menu);

  gtk_tree_selection_unselect_all ((GtkTreeSelection *)gtk_tree_view_get_selection
      (GTK_TREE_VIEW (applet->treeview)));

  gdk_pointer_grab (applet->dialog_menu->window,  TRUE, GDK_BUTTON_RELEASE_MASK
    | GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK 
    | GDK_POINTER_MOTION_MASK,  NULL, NULL, GDK_CURRENT_TIME); 
  
  //gdk_keyboard_grab (window->window, TRUE, GDK_CURRENT_TIME);
  gtk_grab_add(applet->dialog_menu);
  gtk_widget_grab_focus (applet->treeview);       

  return TRUE;
}

void menu_init (Applet *applet) {
                                
  get_data_list (applet);
  create_dialog (applet);
}   

void menu_done (Applet *applet) {

  gdk_pointer_ungrab(GDK_CURRENT_TIME);
  //gdk_keyboard_ungrab(GDK_CURRENT_TIME);
  gtk_grab_remove(applet->dialog_menu);
  gtk_widget_destroy(applet->dialog_menu);

} 
