#include <gst/gst.h>
#include <gtk/gtk.h>
#include "string.h"

#include "stream.h"
#include "tooltip.h"
#include "menu.h"
#include "display.h"


void tag_scroll(const GstTagList *list,
  const gchar *tag,
  Applet *applet)

{

  gchar *title;
  gchar *genre;
  gchar *comment;
  gchar *location;
  gchar *album;
  gint bitrate;

  if (debug) printf ("tag: %s\n", tag);
   
  do {
  
    if (!strcmp (tag, GST_TAG_TITLE)) {
      if (gst_tag_list_get_string (list,tag, &title)) {

        g_strstrip(title);  

        if (applet->title==NULL || strcmp (title, applet->title) != 0) {
          if (debug) printf ("new title (scroll)\n");

          if (applet->title!=NULL)
            g_free (applet->title);
          applet->title=title;

          if (applet->scroll_timer == 0) {
            start_scrolling (applet);
          } else {
            applet->new_title1=TRUE;
            applet->new_title2=TRUE;
          }

        }

      }

      break;
    }

    if (!strcmp (tag, GST_TAG_GENRE)) {
      if (gst_tag_list_get_string (list,tag, &genre)) {
        if (debug) printf ("genre is: %s\n", genre);
        if (applet->genre)
          g_free (applet->genre);
        applet->genre=genre;
      }
      break;
    }

    if (!strcmp (tag, GST_TAG_COMMENT)) {
      if (gst_tag_list_get_string (list,tag, &comment)) {
        if (debug) printf ("comment is: %s\n", comment);
        if (applet->comment)
          g_free (applet->comment);
        applet->comment=comment;
      }
      break;
    }

    if (!strcmp (tag, GST_TAG_LOCATION)) {
      if (gst_tag_list_get_string (list,tag, &location)) {
        if (debug) printf ("location is: %s\n", location);
        if (applet->location)
          g_free (applet->location);
        applet->location=location;
      }
      break;
    }

    if (!strcmp (tag, GST_TAG_ALBUM)) {
      if (gst_tag_list_get_string (list,tag, &album)) {
        if (debug) printf ("album is: %s\n", album);
        if (applet->album)
          g_free (applet->album);
        applet->album=album;
      }
      break;
    }

    if (!strcmp (tag, GST_TAG_BITRATE)) {
      if (gst_tag_list_get_uint (list,tag, (guint *)&bitrate)) {
        bitrate /= 1000;
        if (debug) printf ("bitrate is: %d\n", bitrate);
        applet->bitrate=bitrate;
      }
      break;
    }

 }

  while (0);
  
  if (applet->tooltip && GTK_WIDGET_VISIBLE (applet->tooltip))
    update_tooltip_labels (applet);

} 

void tag_no_scroll(const GstTagList *list,
  const gchar *tag,
  Applet *applet)

{

  gchar *title;
  gchar *genre;
  gchar *comment;
  gchar *location;
  gchar *album;
  gint bitrate;

  if (debug) printf ("tag: %s\n", tag);
   
  do {
  
    if (!strcmp (tag, GST_TAG_TITLE)) {
      if (gst_tag_list_get_string (list,tag, &title)) {
        g_strstrip(title);

        if (applet->title==NULL || strcmp (title, applet->title) != 0) {
          if (debug) printf ("new title (no scroll)\n");

          if (applet->title!=NULL)
            g_free (applet->title);
          applet->title=title;
        }
      }
      break; 
    } 

    if (!strcmp (tag, GST_TAG_GENRE)) {
      if (gst_tag_list_get_string (list,tag, &genre)) {
        if (debug) printf ("genre is: %s\n", genre);
        if (applet->genre)
          g_free (applet->genre);
        applet->genre=genre;
      }
      break;
    }

    if (!strcmp (tag, GST_TAG_COMMENT)) {
      if (gst_tag_list_get_string (list,tag, &comment)) {
        if (debug) printf ("comment is: %s\n", comment);
        if (applet->comment)
          g_free (applet->comment);
        applet->comment=comment;
      }
      break;
    }

    if (!strcmp (tag, GST_TAG_LOCATION)) {
      if (gst_tag_list_get_string (list,tag, &location)) {
        if (debug) printf ("location is: %s\n", location);
        if (applet->location)
          g_free (applet->location);
        applet->location=location;
      }
      break;
    }

    if (!strcmp (tag, GST_TAG_ALBUM)) {
      if (gst_tag_list_get_string (list,tag, &album)) {
        if (debug) printf ("album is: %s\n", album);
        if (applet->album)
          g_free (applet->album);
        applet->album=album;
      }
      break;
    }

    if (!strcmp (tag, GST_TAG_BITRATE)) {
      if (gst_tag_list_get_uint (list,tag, (guint *)&bitrate)) {
        bitrate /= 1000;
        if (debug) printf ("bitrate is: %d\n", bitrate);
        applet->bitrate=bitrate;
      }
      break;
    }     

 }

  while (0);
  
  if (applet->tooltip && GTK_WIDGET_VISIBLE (applet->tooltip))
    update_tooltip_labels (applet);

} 

static gboolean
cb_tag_scroll (GstBus     *bus,
		 GstMessage *message,
		 gpointer    data)
{
  
   GstTagList *tag_list;
   Applet *applet= (Applet*) data; 

   if (debug) printf ("tag_message scroll\n");
   gst_message_parse_tag (message, &tag_list);
   gst_tag_list_foreach (tag_list, (GstTagForeachFunc) tag_scroll, applet);
   gst_tag_list_free    (tag_list);
 
  return TRUE;
}

static gboolean
cb_tag_no_scroll (GstBus     *bus,
		 GstMessage *message,
		 gpointer    data)
{

   GstTagList *tag_list;

   Applet *applet= (Applet*) data; 

   if (debug) printf ("tag_message no scroll\n");
   gst_message_parse_tag (message, &tag_list);
   gst_tag_list_foreach (tag_list, (GstTagForeachFunc) tag_no_scroll, applet);
   gst_tag_list_free    (tag_list);  
 
  return TRUE;
}  

static gboolean
cb_error (GstBus     *bus,
		 GstMessage *message,
		 gpointer    data)
{

  Applet *applet= (Applet*) data;   
  GError *err;
  gchar *debug;

  gst_message_parse_error (message, &err, NULL);
  if (debug) g_print ("Error: %s\n", err->message);

  if (applet->lock_timer !=0 ) {
      g_source_remove (applet->lock_timer);
      applet->lock_timer=0;        
  }

  if (applet->tag_id_no_scroll !=0 ) {
    g_signal_handler_disconnect  (applet->bus, applet->tag_id_no_scroll);
    applet->tag_id_no_scroll=0;
  }  

  stream_stop (applet);
  show_image (applet, applet->play_error_image);

  if (applet->title != NULL)
    g_free (applet->title);

  applet->title=g_strdup(err->message);
  g_error_free (err);   
  start_scrolling (applet);

  return TRUE;
             
} 

static gboolean
cb_warning (GstBus     *bus,
		 GstMessage *message,
		 gpointer    data)
{

  Applet *applet= (Applet*) data;   
  GError *err;
  gchar *debug;

  gst_message_parse_warning (message, &err, NULL);
  if (debug) g_print ("Warning: %s\n", err->message);

  stream_stop (applet);
  show_image (applet, applet->play_error_image);

  if (applet->title != NULL)
    g_free (applet->title);

  applet->title=g_strdup(err->message);
  g_error_free (err);   
  start_scrolling (applet);

  return TRUE;
             
}    

gboolean remove_lock (gpointer data) {

  Applet *applet= (Applet*) data;

  if (debug) printf ("remove lock\n");

  gtk_widget_hide (applet->info_label);

  if (applet->tag_id_no_scroll !=0 ) {
    g_signal_handler_disconnect  (applet->bus, applet->tag_id_no_scroll);
    applet->tag_id_no_scroll=0;
  }

  applet->tag_id_scroll=g_signal_connect (applet->bus, "message::tag", 
    G_CALLBACK (cb_tag_scroll), (gpointer) applet);

  if (applet->title != NULL)
    start_scrolling(applet);

  return FALSE;
}

static gboolean
cb_buffering (GstBus     *bus,
		 GstMessage *message,
		 gpointer    data)
{  

  gint percent;
  gchar *text;

  Applet *applet= (Applet*) data;
  
  gst_message_parse_buffering     (message, &percent);                      
  if (debug) printf ("buffer percent: %d\n", percent); 

  if (percent == 0) {

    if (applet->lock_timer !=0 ) {
      g_source_remove (applet->lock_timer);
      applet->lock_timer=0;
      stop_scrolling (applet);

      if (applet->tag_id_no_scroll ==0) {
        applet->tag_id_no_scroll=g_signal_connect (applet->bus, "message::tag", 
        G_CALLBACK (cb_tag_no_scroll), (gpointer) applet); 
      }
      show_image (applet, applet->play_connect_image);
    } 
  }

  if (percent == 100) {
    text= g_strdup ("Playing");
    applet->lock_timer=g_timeout_add (2000, remove_lock, (gpointer) applet);
    show_image (applet, applet->play_run_image);
  } else {
    text=g_strdup_printf ("Buffering: %d", percent);   
  }

  display_info_text (applet, text);
  g_free (text);

  return TRUE;

}

/*static gboolean                                                                 */
/*cb_state (GstBus     *bus,                                                      */
/*     GstMessage *message,                                                       */
/*     gpointer    data)                                                          */
/*{                                                                               */
/*                                                                                */
/*      gint percent;                                                             */
/*      gdouble fraction;                                                         */
/*      gchar *text;                                                              */
/*                                                                                */
/*      GstState oldstate, newstate, pending;                                     */
/*                                                                                */
/*      Applet *applet= (Applet*) data;                                           */
/*                                                                                */
/*                                                                                */
/*      printf ("state dinens\n");                                                */
/*                                                                                */
/*      gst_message_parse_state_changed (message, &oldstate, &newstate, &pending);*/
/*                                                                                */
/*      switch (newstate)  {                                                      */
/*                                                                                */
/*        case GST_STATE_VOID_PENDING:                                            */
/*          if (debug) printf ("pendig\n");                                       */
/*          break;                                                                */
/*        case GST_STATE_NULL:                                                    */
/*          if (debug) printf ("state null\n");                                   */
/*          break;                                                                */
/*        case GST_STATE_READY:                                                   */
/*          if (debug) printf ("state ready\n");                                  */
/*          break;                                                                */
/*        case  GST_STATE_PAUSED:                                                 */
/*          if (debug) printf ("state paused\n");                                 */
/*          break;                                                                */
/*        case  GST_STATE_PLAYING:                                                */
/*          if (debug) printf ("state is playing\n");                             */
/*                                                                                */
/*          break;                                                                */
/*                                                                                */
/*     }                                                                          */
/*                                                                                */
/*  return TRUE;                                                                  */
/*}                                                                               */

static gboolean
cb_eos (GstBus     *bus,
		 GstMessage *message,
		 gpointer    data)
{  
  //Applet *applet= (Applet*) data;     
  if (debug) printf ("end of stream\n");

  return TRUE;
}


void stream_init (Applet *applet)
{

  gst_init (NULL, NULL);
  applet->play=NULL;

  applet->play = gst_element_factory_make ("playbin", "play");
  if (!applet->play) {
    set_label_text (applet, "Init Gstreamer failed!");
    return;
  }

  applet->bus = gst_pipeline_get_bus (GST_PIPELINE (applet->play));
  gst_bus_add_signal_watch (applet->bus);

  g_signal_connect (applet->bus, "message::error", 
      G_CALLBACK (cb_error), (gpointer) applet); 

  g_signal_connect (applet->bus, "message::warning", 
      G_CALLBACK (cb_warning), (gpointer) applet);

  g_signal_connect (applet->bus, "message::eos", 
      G_CALLBACK (cb_eos), (gpointer) applet);  

}

void stream_close (Applet *applet)
{

  if (applet->play) {
   gst_element_set_state (applet->play, GST_STATE_NULL);
   gst_bus_remove_signal_watch (applet->bus);
   gst_object_unref (applet->bus); 
   gst_object_unref (GST_OBJECT (applet->play));
   applet->play=NULL;
  }

}

/*static gboolean                                                    */
/*cb_print_position (GstElement *pipeline)                           */
/*{                                                                  */
/*  GstFormat fmt = GST_FORMAT_TIME;                                 */
/*  gint64 pos, len;                                                 */
/*                                                                   */
/*  if (gst_element_query_position (pipeline, &fmt, &pos)            */
/*    && gst_element_query_duration (pipeline, &fmt, &len)) {        */
/*    g_print ("Time: %" GST_TIME_FORMAT " / %" GST_TIME_FORMAT "\r",*/
/*       GST_TIME_ARGS (pos), GST_TIME_ARGS (len));                  */
/*  }                                                                */
/*                                                                   */
/*  |+ call me again +|                                              */
/*  return TRUE;                                                     */
/*}                                                                  */


gboolean gst_play (gpointer data) {

  Applet *applet= (Applet*) data;

  gst_element_set_state (applet->play, GST_STATE_PLAYING);      

  return FALSE;
}


void stream_play (Applet *applet)
{

  if (applet->url == NULL) {
    display_info_text (applet, "No server !");
    show_image (applet, applet->play_error_image);
    return;
  }  

  if (applet->title != NULL) {
    g_free (applet->title); 
    applet->title=NULL;
  }

  show_image (applet, applet->play_connect_image); 
  display_info_text (applet, "Connecting");

  applet->tag_id_no_scroll=g_signal_connect (applet->bus, "message::tag", 
    G_CALLBACK (cb_tag_no_scroll), (gpointer) applet);

  applet->buffer_id=g_signal_connect (applet->bus, "message::buffering", 
      G_CALLBACK (cb_buffering), (gpointer) applet); 
 
  /*applet->state_id=g_signal_connect (applet->bus, "message::state-changed",*/
  /*    G_CALLBACK (cb_state), (gpointer) applet);                           */
 
  g_object_set (G_OBJECT (applet->play), "uri", applet->url, NULL);
  g_idle_add_full (G_PRIORITY_LOW, gst_play, (gpointer) applet, NULL); 

}

void stream_stop (Applet *applet)
{

  if (!applet->play)
    return;

  if (debug) printf ("stream stop\n");

  show_image (applet, applet->play_stop_image);  

  gst_element_set_state (applet->play, GST_STATE_NULL); 

  stop_scrolling (applet);

  if (applet->buffer_id !=0 ) {
    g_signal_handler_disconnect  (applet->bus, applet->buffer_id);
    applet->buffer_id=0;
  } 

  if (GTK_WIDGET_VISIBLE (applet->info_label)) {
    gtk_widget_hide (applet->info_label);
  } 

  if (applet->title != NULL) {
    g_free (applet->title);
    applet->title=NULL;
  }

  if (applet->genre != NULL) {
    g_free (applet->genre);
    applet->genre=NULL;
  }

  if (applet->comment != NULL) {
    g_free (applet->comment);
    applet->comment=NULL;
  }

  if (applet->location != NULL) {
    g_free (applet->location);
    applet->location=NULL;
  }

  if (applet->album != NULL) {
    g_free (applet->album);
    applet->album=NULL;
  }

  applet->bitrate=0;

}
