#include <string.h>
#include <stdlib.h>
#include <panel-applet.h>
#include <gtk/gtk.h>

#include "common.h"

void set_label (GtkWidget *label, gchar *text)
{

 // gchar *markup;

  if (text!=NULL && strlen (text) <=1)
    return;

  if (text == NULL)
    gtk_label_set_text (GTK_LABEL (label), "N/A");
  else
   gtk_label_set_text (GTK_LABEL (label), text);

}

void update_tooltip_labels  (Applet *applet)
{

  gchar *bitrate_string;

  if (debug) printf ("update tooltip labels\n");

  if (applet->tooltip == NULL)
    return;

  set_label (applet->label_caption, applet->caption);
  set_label (applet->label_title,  applet->title);
  set_label (applet->label_album,  applet->album);
  set_label (applet->label_genre,  applet->genre);
  set_label (applet->label_comment,  applet->comment);
  set_label (applet->label_location,  applet->location);

  bitrate_string =g_strdup_printf ("%d", applet->bitrate);
  set_label (applet->label_bitrate, applet->bitrate ? bitrate_string:"N/A");
  g_free (bitrate_string);

}

gboolean
expose_handler (GtkWidget       *widget,
    GdkEventExpose  *event,
    gpointer         user_data)
{

 gint width, height;

  gtk_paint_flat_box (widget->style, widget->window,
                      GTK_STATE_NORMAL, GTK_SHADOW_OUT, 
                      NULL, widget, "tooltip",
                      0, 0, -1, -1);

  gdk_drawable_get_size (widget->window, &width, &height);  
  gdk_draw_line (widget->window, widget->style->black_gc, 4, 23, width-4, 23);

  return FALSE;
}

void new_row (GtkWidget *vbox, gchar *caption, GtkWidget **label)
{

  GtkWidget *hbox;
  GtkWidget *caption_label;

  hbox = gtk_hbox_new (FALSE, 15);
  gtk_widget_show (hbox);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);

  caption_label = gtk_label_new (caption);
  gtk_widget_show (caption_label);
  gtk_box_pack_start (GTK_BOX (hbox), caption_label, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (caption_label ), 0, 0);
  gtk_widget_set_size_request (caption_label, 80, -1);
  gtk_label_set_justify (GTK_LABEL (caption_label), GTK_JUSTIFY_LEFT);


  *label=gtk_label_new (NULL);
  gtk_widget_show (*label);
  gtk_box_pack_start (GTK_BOX (hbox), *label, FALSE, FALSE, 0);
  gtk_widget_set_size_request (*label, 200, -1);
  gtk_label_set_line_wrap (GTK_LABEL (*label), TRUE);
  gtk_misc_set_alignment (GTK_MISC (*label), 0.5, 0);
}

void
create_tooltip_window (Applet *applet)
{

  GtkWidget *vbox;

  applet->tooltip = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_widget_set_app_paintable (applet->tooltip, TRUE);
  gtk_window_set_resizable (GTK_WINDOW (applet->tooltip), FALSE);
  gtk_widget_set_name (applet->tooltip, "gtk-tooltips");
  vbox = gtk_vbox_new (FALSE, 5);
  gtk_widget_show (vbox);
  gtk_container_add (GTK_CONTAINER (applet->tooltip), vbox);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);

  applet->label_caption = gtk_label_new ("N/A");
  gtk_widget_show (applet->label_caption);
  gtk_box_pack_start (GTK_BOX (vbox), applet->label_caption, FALSE, FALSE, 1);
  gtk_label_set_justify (GTK_LABEL (applet->label_caption), GTK_JUSTIFY_CENTER);

  new_row (vbox, "Title:", &applet->label_title);
  new_row (vbox, "Album:", &applet->label_album);
  new_row (vbox, "Genre:", &applet->label_genre);
  new_row (vbox, "Comment:", &applet->label_comment);
  new_row (vbox, "Location:", &applet->label_location);
  new_row (vbox, "Bitrate:", &applet->label_bitrate);

}

gboolean show_tooltip (gpointer user_data)
{
  
  Applet *applet = (Applet *) user_data;

  gint applet_x, applet_y, applet_width, applet_height, win_x, win_y;
  GtkRequisition req;
  
  update_tooltip_labels (applet);

  gdk_window_get_geometry (GTK_WIDGET (applet->panel_applet)->window, NULL, NULL,
    &applet_width, &applet_height, NULL);
  gdk_window_get_origin (GTK_WIDGET (applet->panel_applet)->window, &applet_x, &applet_y);

  gtk_widget_size_request (applet->tooltip, &req);

  win_x=applet_x + applet_width/2 - req.width/2;

  PanelAppletOrient orient=panel_applet_get_orient (applet->panel_applet);

  if (orient == PANEL_APPLET_ORIENT_DOWN) {
     win_y=applet_y + applet_height + 5;     
   } else {
     win_y=applet_y - req.height - 5;     
  }    

  if ((win_x + req.width) >= applet->screen_width)
    win_x=applet->screen_width - req.width -5;
  
  if (win_x <= 0)
    win_x=5;
  
  gtk_window_move (GTK_WINDOW(applet->tooltip), win_x, win_y);
  gtk_widget_show (applet->tooltip);

  return FALSE;

}

gboolean
enter_notify_event           (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        Applet *applet)
{

  applet->tooltip_timer=g_timeout_add (1000, show_tooltip, (gpointer) applet);
  return FALSE;

}

gboolean
leave_notify_event           (GtkWidget       *widget,
                                        GdkEventCrossing *event,
                                        Applet *applet)
{

  if (applet->tooltip_timer) {
    g_source_remove (applet->tooltip_timer);
    applet->tooltip_timer=0;
  }

  if (GTK_WIDGET_VISIBLE (applet->tooltip))
    gtk_widget_hide (applet->tooltip);

  return FALSE;
}


void tooltip_init (Applet *applet)
{


  if (debug) printf ("tooltip_init\n");

  create_tooltip_window (applet);
  gtk_widget_realize (applet->tooltip);

  applet->screen_width = gdk_screen_get_width (gdk_screen_get_default ());

  g_signal_connect (applet->tooltip, "expose_event",
     G_CALLBACK (expose_handler), NULL);

  g_signal_connect ( GTK_WIDGET (applet->eventbox), "enter-notify-event",
    G_CALLBACK (enter_notify_event), applet);

  g_signal_connect ( GTK_WIDGET (applet->eventbox), "leave-notify-event",
    G_CALLBACK (leave_notify_event), applet); 

}
