
#ifndef __SOURCE_H
#define __SOURCE_H

#include <gst/gst.h>
#include <gst/interfaces/tuner.h>
#include <gst/interfaces/tunerchannel.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>

#define OUT_TYPE_MOUSE 	0
#define OUT_TYPE_KEY	1
#define OUT_TYPE_TCP	2
#define OUT_TYPE_EXE    3


struct sensor
{
    xmlChar *name;                  /** name of this source */
    double thr_threshold;           /** threshold values */
    guchar thr_R, thr_G, thr_B;     
    int wrp_x1, wrp_y1;             /** warp filter */
    int wrp_x2, wrp_y2;
    int wrp_x3, wrp_y3;
    int wrp_x4, wrp_y4;
    int x, y;                       /** calculated/detected x/y coordinates */
    int out_type;                   /** output-type */
    int out_width, out_height;      /** output dimensions */
    int buttonmask;                 /** buttonmask */
    int offdelay;                   /** off-delay */
    int ondelay;                    /** on-delay */
    int repeat_delay;               /** min. amount of frames between 2 events */
    int m_framecount;               /** framecounter */
    int key_framecount;             /** framecounter for key-output */
    gboolean laser_detected;
    int key;                        /** key for keyboard output */
    char *out_program;              /** program to execute */
    struct sensor *next_sensor;
};

struct video_src
{
    int disabled;                   /* if set, this source will be ignored completly */
    /*
     * pointer to next video-source 
     */
    struct video_src *next_source;
    /*
     * array of sensors 
     */
    struct sensor *first_sensor;
    /*
     * name of this source 
     */
    xmlChar *name;
    /*
     * optional input-channel 
     */
    xmlChar *tuner;
    /*
     * capabilities 
     */
    int width, height, bpp, depth, endianess;
    int red_mask, green_mask, blue_mask;
    int swap_rb;
    int framecount;
    
    /*
     * gstreamer pipeline description 
     */
    xmlChar *gst_string;
    /*
     * gstreamer stuff 
     */
    GstElement *bin,*gst_source,*gst_sink;
    GstBus *bus;
    GstCaps *caps;
    /*
     * rgb-buffer 
     */
    guchar *out_buffer;
};





int                     src_init();
struct video_src        *src_get();
struct video_src        *src_init_from_xml(xmlNode * node);    
struct sensor           *src_sensor_append(struct sensor *first_sensor,
                                                xmlNode * node);
    

#endif
