#ifndef __SENSOR_H
#define __SENSOR_H

#include <gnome.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>

typedef struct sensor
{
    xmlChar *name;
    int wrp_x1, wrp_y1;     /** warp filter edges */
    int wrp_x2, wrp_y2;
    int wrp_x3, wrp_y3;
    int wrp_x4, wrp_y4;
    int *wrp_gr_x;          /** currently "grabbed" warp-point */
    int *wrp_gr_y;
    int ondelay;            /** amount of milliseconds the laser must be detected */
    int offdelay;           /** amount of milliseconds the laser must be off */
    int repeat_delay;          /** minimum amount of frames between two events */
    int x, y;               /** detected x/y */
    int out_type;           /** sensor OUT_TYPE_* type */
    int out_width, out_height;  /** dimensions of virtual-display */
    int buttonmask;         /** buttons to simulateo with mouse-output */
    int out_key;
    char *out_program;
    /*
     * threshold filter 
     */
    double thr_threshold;
    guchar thr_R, thr_G, thr_B;
    struct sensor *next_sensor;
}sensor;

int             sensor_init();
void            sensor_set(struct sensor *s);
struct sensor   *sensor_get();
void            sensor_list_free(struct sensor *sensors);
struct sensor   *sensor_append_from_xml(struct sensor *first_sensor, xmlNode * node);
struct sensor   *sensor_append(struct sensor *first_sensor,
                                 struct sensor *this_sensor);
void            sensor_pulldown_refresh();
void            sensor_gui_update();
void            sensor_gui_update_pulldown();
int             sensor_gui_init();                                 
char            *sensor_key_string(int menu_entry);                                 
                                 
#endif
