#ifndef __SOURCE_H
#define __SOURCE_H

#include <gnome.h>
#include <glade/glade.h>
#include <gst/gst.h>
#include <gst/interfaces/tuner.h>
#include <gst/interfaces/tunerchannel.h>

typedef struct video_src
{
    int disabled;                       /** if set, source is disabled */
    struct video_src *next_source;      /** pointer to next video-source */
    struct sensor *first_sensor;        /** array of sensors */
    xmlChar *name;                      /** name of this source */
    xmlChar *tuner;                     /** optional input-channel */
    /* capabilities */
    int width, height, bpp, depth, endianess;
    int red_mask, green_mask, blue_mask;
    int swap_rb;
    xmlChar *gst_string;                /** gstreamer pipeline description */
    /* gstreamer stuff */
    GstElement *bin,*gst_source,*gst_sink;
    GstBus *bus;
    GstCaps *caps;
    GdkPixbuf *input_pixbuf;            /** input-preview */
    GdkPixbuf *output_pixbuf;           /** postprocessed preview */
    GdkPixbuf *gst_input_pixbuf;        /** gStreamer input-pixmap buffer */
    GtkTextBuffer *cap_textbuffer;      /** text-buffer for textview_caps */
    /*
     * flags 
     */
    gboolean draw_source, draw_dst;
    gboolean do_capture;
    gboolean idle_func;
}video_src;








int                 src_init();
int                 src_gui_init();
struct video_src    *src_get();
struct video_src    *src_get_first();
unsigned int        src_get_framecount();
void                src_set_framecount(unsigned int c);
gboolean            src_get_laserDetected();
void                src_set_laserDetected(gboolean ld);
void                src_set_updateSrcGui(int v);
void                src_set_updateWarpGui(int v);
void                src_cleanup();
struct video_src    *src_init_from_xml(xmlNodePtr source_xml);
void                src_gui_update();    
int                 src_listlen();
struct video_src    *src_new(xmlChar * name, xmlChar * pipeline,
                                        xmlChar * tuner);
struct video_src    *src_append(struct video_src *first_source,
                                        struct video_src *source);
struct video_src    *src_get_n(int n);
void                src_gui_update_pulldown();
int                 src_listpos(struct video_src *source);
void                src_caps_init(struct video_src *source, GstBuffer * buffer);    
void                src_free_gst(struct video_src *source);


#endif
