#ifndef __MAIN_H
#define __MAIN_H


/** OpenGL debugging function */
#define	GL_CHECKERROR					\
{										\
    GLenum gl_error;					\
    gl_error = glGetError();			\
										\
    if (gl_error != GL_NO_ERROR)		\
    {									\
		fprintf(stderr,					\
			"%s (%d): OpenGL error: %d\n",	\
			__FILE__, __LINE__, gl_error);		\
		m_cleanup();					\
		exit(-1);						\
    }									\
}

/** structure to define an OpenGL texture */
struct Texture 
{
	char *filename;
	GLuint id;
	struct Texture *next;
};

/** this defines one drip running down */
struct Drip {
 int x,y;
 int lifetime;
 int smegginess;
 struct Drip *previous_drip;
 struct Drip *next_drip;
};

int m_getScreenWidth();
int m_getScreenHeight();
int m_getScreenDepth();
int m_getMouseClicked();
int m_getMouseDragged();
int m_getMouseX();
int m_getMouseY();
void m_cleanup();

#endif
