
#ifndef __OBJECT_H
#define __OBJECT_H

#include "include/ArcBall.h"

#define LIGHT_FLASH_R 5
#define LIGHT_FLASH_G 5
#define LIGHT_FLASH_B 5
#define LIGHT_FLASH_A 5

#define LIGHT_AMBIENT_R 1
#define LIGHT_AMBIENT_G 1
#define LIGHT_AMBIENT_B 1
#define LIGHT_AMBIENT_A 1

#define LIGHT_DIFFUSE_R 1
#define LIGHT_DIFFUSE_G 1
#define LIGHT_DIFFUSE_B 1
#define LIGHT_DIFFUSE_A 1

/** OpenGL debugging function */
#define	GL_CHECKERROR					\
{										\
    GLenum gl_error;					\
    gl_error = glGetError();			\
										\
    if (gl_error != GL_NO_ERROR)		\
    {									\
		fprintf(stderr,					\
			"%s (%d): OpenGL error: %d\n",	\
			__FILE__, __LINE__, gl_error);		\
		m_cleanup();					\
		exit(-1);						\
    }									\
}

/** structure to define an OpenGL texture */
struct Texture 
{
	char *filename;
	GLuint id;
	struct Texture *next;
};

int obj_init();
int obj_gl_init(int screen_width, int screen_height);
void obj_cleanup();
int obj_textureLoad(const char *filename, GLuint *id);
void obj_rotate();
void Matrix3fSetZero(Matrix3fT* NewObj);
void obj_cubeDraw();
void obj_pyramidDraw();
	
GLfloat *obj_getLightAmbient();
GLfloat *obj_getLightDiffuse();
GLfloat *obj_getLightDiffusePos();
void obj_lightAmbientFlash();
Matrix4fT *obj_getRotMatrix();
struct Texture *obj_getFirstTexture();
void obj_setFirstTexture(struct Texture *t);
	
#endif
