#ifndef __OGMRIP_VERSION_H__
#define __OGMRIP_VERSION_H__

/**
 * OGMRIP_MAJOR_VERSION:
 *
 * Compile time major version of OGMRip
 */
#define OGMRIP_MAJOR_VERSION       (0)

/**
 * OGMRIP_MINOR_VERSION:
 *
 * Compile time minor version of OGMRip
 */
#define OGMRIP_MINOR_VERSION       (11)

/**
 * OGMRIP_MICRO_VERSION:
 *
 * Compile time micro version of OGMRip
 */
#define OGMRIP_MICRO_VERSION       (2)

/**
 * MPLAYER_MAJOR_VERSION:
 *
 * Compile time major version of MPlayer
 */
#define MPLAYER_MAJOR_VERSION      (1)

/**
 * MPLAYER_MINOR_VERSION:
 *
 * Compile time minor version of MPlayer
 */
#define MPLAYER_MINOR_VERSION      (0)

/**
 * MPLAYER_PRE_VERSION:
 *
 * Compile time pre version of MPlayer
 */
#define MPLAYER_PRE_VERSION        (0)

/**
 * MPLAYER_RC_VERSION:
 *
 * Compile time rc version of MPlayer
 */
#define MPLAYER_RC_VERSION         (2)

/**
 * OGMRIP_CHECK_VERSION:
 * @major: A major version number
 * @minor: A minor version number
 * @micro: A micro version number
 *
 * Checks whether version is equal or greather than major.minor.micro
 */

#define OGMRIP_CHECK_VERSION(major,minor,micro)  \
  ((OGMRIP_MAJOR_VERSION > (major)) || \
   (OGMRIP_MAJOR_VERSION == (major) && OGMRIP_MINOR_VERSION > (minor)) || \
   (OGMRIP_MAJOR_VERSION == (major) && OGMRIP_MINOR_VERSION == (minor) && OGMRIP_MICRO_VERSION >= (micro)))

/**
 * MPLAYER_CHECK_VERSION:
 * @major: A major version number
 * @minor: A minor version number
 * @rc: An rc version number
 * @pre: A pre version number
 *
 * Check if version is equal or greather than major.minor, major.minor-rc or
 * major.minor-pre, in that order
 */

#define MPLAYER_CHECK_VERSION(major,minor,rc,pre) \
  ((MPLAYER_MAJOR_VERSION > (major)) || \
   (MPLAYER_MAJOR_VERSION == (major) && MPLAYER_MINOR_VERSION > (minor)) || \
   (MPLAYER_MAJOR_VERSION == (major) && MPLAYER_MINOR_VERSION == (minor) && \
    ((MPLAYER_RC_VERSION == 0 && MPLAYER_PRE_VERSION == 0) || \
     ((MPLAYER_RC_VERSION != 0 || MPLAYER_PRE_VERSION != 0) && ((rc) != 0 || (pre) != 0) && (MPLAYER_RC_VERSION > (rc))) || \
     ((MPLAYER_RC_VERSION != 0 || MPLAYER_PRE_VERSION != 0) && ((rc) != 0 || (pre) != 0) && MPLAYER_RC_VERSION == (rc) && MPLAYER_PRE_VERSION >= (pre)))))

#endif /* __OGMRIP_VERSION_H__ */

