# GNOME Specimen, a font preview application for GNOME
# Copyright (C) 2006--2007  Wouter Bolsterlee <wbolster@gnome.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.


from os.path import join, exists, dirname, realpath

PACKAGE     = "gnome-specimen"
VERSION     = "0.4"

# Don't bother using translations from the source directory (too much hassle,
# if not impossible because of the $LANG/LC_MESSAGES directories)
LOCALEDIR   = "/usr/share/locale"

# Allow to run uninstalled by detecting gnome-specimen.in
if exists(join(dirname(__file__), '../gnome-specimen.in')):
    print "Running from source directory; not using installation paths!"

    source_datadir = realpath(join(dirname(__file__), '../data'))

    DATADIR     = source_datadir
    PKGDATADIR  = source_datadir
    GLADEDIR    = source_datadir

# Normal situation: use installation paths from ./configure
else:
    DATADIR     = "/usr/share"
    PKGDATADIR  = "/usr/share/gnome-specimen"
    GLADEDIR    = "/usr/share/gnome-specimen/glade"
