
#!/bin/sh
###
# Place the NetworkManager init script.
###
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}


config etc/rc.d/rc.networkmanager.new



###
# Create netdev group if they don't exist.
###
group_exists=`grep ^netdev etc/group`
if [[ "${group_exists}" == "" ]]; then
	groupadd -g 63 netdev
fi


# if rc.networkmanager is executable, run it on startup
run=`grep ". /etc/rc.d/rc.networkmanager" etc/rc.d/rc.local`
if [[ "${run}" == "" ]]; then
cat << EOF >>etc/rc.d/rc.local

# To disable networkmanager, chmod rc.networkmanager to 644
if [ -x /etc/rc.d/rc.networkmanager ]; then
  . /etc/rc.d/rc.networkmanager start
fi
EOF
fi

# if rc.networkmanager is executable, stop on shutdown
run=`grep ". /etc/rc.d/rc.networkmanager" etc/rc.d/rc.local_shutdown`
if [[ "${run}" == "" ]]; then
cat << EOF >>etc/rc.d/rc.local_shutdown

# To disable networkmanager shutdown, chmod rc.networkmanager to 644
if [ -x /etc/rc.d/rc.networkmanager ]; then
  . /etc/rc.d/rc.networkmanager stop
fi
EOF
fi




( echo -e "\E[0;32mNote for Slackware Users:\E[0;0m" )
( echo -e "\E[0;32m-----                     \E[0;0m" )
( echo -e "\E[0;32mTo allow users to connect to the NetworkManager daemon, they have to be in the \E[0;0m" )
( echo -e "\E[0;32mgroup -netdev-\E[0;0m" )







if [ -x /usr/bin/scrollkeeper-update ]; then
  /usr/bin/scrollkeeper-update -p /var/lib/scrollkeeper 1> /dev/null 2> /dev/null
fi

if [ -x /usr/bin/update-mime-database ]; then
  /usr/bin/update-mime-database /usr/share/mime &> /dev/null
fi

if [ -x /usr/bin/update-desktop-database ]; then
  /usr/bin/update-desktop-database 1> /dev/null 2> /dev/null
fi

if [ -x /usr/bin/gtk-update-icon-cache ]; then
  /usr/bin/gtk-update-icon-cache  -f -q /usr/share/icons/hicolor 1> /dev/null 2> /dev/null
fi

( cd usr/lib ; rm -rf libnm_glib_vpn.so.0 )
( cd usr/lib ; ln -sf libnm_glib_vpn.so.0.0.0 libnm_glib_vpn.so.0 )
( cd usr/lib ; rm -rf libnm_glib.so )
( cd usr/lib ; ln -sf libnm_glib.so.0.0.0 libnm_glib.so )
( cd usr/lib ; rm -rf libnm_glib_vpn.so )
( cd usr/lib ; ln -sf libnm_glib_vpn.so.0.0.0 libnm_glib_vpn.so )
( cd usr/lib ; rm -rf libnm-util.so.0 )
( cd usr/lib ; ln -sf libnm-util.so.0.0.0 libnm-util.so.0 )
( cd usr/lib ; rm -rf libnm-util.so )
( cd usr/lib ; ln -sf libnm-util.so.0.0.0 libnm-util.so )
( cd usr/lib ; rm -rf libnm_glib.so.0 )
( cd usr/lib ; ln -sf libnm_glib.so.0.0.0 libnm_glib.so.0 )
( cd usr/doc/NetworkManager-svn_3645 ; rm -rf INSTALL )
( cd usr/doc/NetworkManager-svn_3645 ; ln -sf /usr/share/automake-1.9/INSTALL INSTALL )
( cd usr/doc/NetworkManager-svn_3645 ; rm -rf COPYING )
( cd usr/doc/NetworkManager-svn_3645 ; ln -sf /usr/share/automake-1.9/COPYING COPYING )
