import gtk

class Preferences:

    def __init__(self, parent=None):      
        self.parent = parent
        self.win = gtk.Window()  
        self.win.connect("delete_event", self.on_win_delete_event)
        self.win.set_title("Preferences")  
        self.win.set_destroy_with_parent(True)        

        vbox = gtk.VBox(False, 3)       
        vbox.set_border_width(4)        
        frame = gtk.Frame("Select voice")
        vbox.pack_start(frame, False, False, 3)
        
        vbox1 = gtk.VBox(False, 3)
        vbox1.set_border_width(4)
        frame.add(vbox1)   

        self.radio_0 = gtk.RadioButton(None, label="_English voice")
        self.radio_0.set_active(True)
        self.radio_1 = gtk.RadioButton(self.radio_0, label="_Spanish voice") 
        vbox1.pack_start(self.radio_0, False, False, 3)
        vbox1.pack_start(self.radio_1, False, False, 3)
        
        hbox = gtk.HBox(False, 3)
        self.check = gtk.CheckButton("_Custom message:")
        hbox.pack_start(self.check, False, False, 0)
        vbox1.pack_start(hbox, False, False, 3)

        hbox2 = gtk.HBox(False, 0)
        self.entry = gtk.Entry()
        self.entry.set_text("ellpc11k for spanish voice")       
        self.entry.set_sensitive(False)
        hbox2.pack_start(self.entry, False, False, 5)
        vbox1.pack_start(hbox2, False, False, 5)
        
        btn_box = gtk.HButtonBox()
        btn_box.set_layout(gtk.BUTTONBOX_DEFAULT_STYLE)
        clear_btn = gtk.Button(label=None, stock=gtk.STOCK_CLEAR)
        clear_btn.connect("clicked", self.on_clear)
        close_btn = gtk.Button(stock=gtk.STOCK_CLOSE)
        close_btn.connect("clicked", self.on_btn_close)
        btn_box.add(clear_btn)
        btn_box.add(close_btn)
        vbox.pack_start(btn_box, False, False, 0)
        
        self.win.add(vbox)
        self.new()

    def new(self):
        pass
        
    def on_win_delete_event(self, window, event):    
        window.hide()
        return True
        
    def on_clear(self, widget):        
        self.entry.set_text("")
        
    def on_btn_close(self, widget):
        self.win.hide()
