<?xml version='1.0' encoding='UTF-8'?>
<!--

  Convert a jMemorize flashcard file to an ignuit flashcard file.
  Command line usage:

  xsltproc -novalid -o outfile.xml jMemorize.xsl infile.jml

  trm 2008-01-18

-->
<xsl:stylesheet version='1.0'
  xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

  <xsl:output method='xml' indent='yes' encoding='UTF-8' />

  <xsl:template match='/Lesson/Category//Card'>
    <card>
      <front>
        <xsl:value-of select='@Frontside' />
      </front>
      <back>
        <xsl:value-of select='@Backside' />
      </back>
    </card>
  </xsl:template>

  <xsl:template match='/Lesson'>
    <deck>
      <xsl:attribute name='version'>
        <xsl:text>1</xsl:text>
      </xsl:attribute>
      <xsl:attribute name='title'>
        <xsl:text>Imported jMemorize File</xsl:text>
      </xsl:attribute>
      <xsl:attribute name='style'>
        <xsl:text>1</xsl:text>
      </xsl:attribute>
      <category>
        <xsl:attribute name='title'>
          <xsl:text>Imported jMemorize Cards</xsl:text>
        </xsl:attribute>
        <xsl:apply-templates />
      </category>
    </deck>
  </xsl:template>

</xsl:stylesheet>
