
#!/bin/sh
###
# Place the firestarter init script.
###
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}


config etc/rc.d/rc.firestarter.new


###
# Use rc.local to start Firestarter at boot.
###

# if rc.firestarter is executable, run it on startup
run=`grep ". /etc/rc.d/rc.firestarter" etc/rc.d/rc.local`
if [[ "${run}" == "" ]]; then
cat << EOF >> etc/rc.d/rc.local

#Firestarter
# To disable Firestarter chmod rc.firestarter to 644
if [ -x /etc/rc.d/rc.firestarter ]; then
	sh /etc/rc.d/rc.firestarter start
fi
EOF
fi


###
# Use rc.local_shutdown to stop Firestarter daemon
###

# if rc.firestarter is executable, stop on shutdown
chmod +x /etc/rc.d/rc.local_shutdown
run=`grep ". /etc/rc.d/rc.firestarter" etc/rc.d/rc.local_shutdown`
if [[ "${run}" == "" ]]; then
cat << EOF >>etc/rc.d/rc.local_shutdown

# To disable Firestarter shutdown, chmod rc.firestarter to 644
if [ -x /etc/rc.d/rc.firestarter ]; then
  . /etc/rc.d/rc.firestarter stop
fi
EOF
fi
#



if [ -x /usr/bin/update-mime-database ]; then
  /usr/bin/update-mime-database /usr/share/mime &> /dev/null
fi

if [ -x /usr/bin/update-desktop-database ]; then
  /usr/bin/update-desktop-database &> /dev/null
fi

if [ -x /usr/bin/gtk-update-icon-cache ]; then
  /usr/bin/gtk-update-icon-cache  -f -q /usr/share/icons/hicolor &> /dev/null
fi

( cd usr/share/applications ; rm -rf firestarter.desktop )
( cd usr/share/applications ; ln -sf /tmp/tgz/package/firestarter/usr/share/gnome/apps/Internet/firestarter.desktop firestarter.desktop )
