#include "VideoViewer.h"

#include <QtGui>

#include <iostream>

VideoViewer::VideoViewer(QString src) {
  setAcceptDrops(true) ;
  source = 0 ;
  texture = new glTexture ;
  setSource(src) ;
}

void
VideoViewer::setSource(QString s) {
  if (source) {
    unsubscribeFrom(source) ;
    delete source ;
  }
  try {
    source = ImageSource::create(s.toStdString()) ;
    subscribeTo(source) ;
    source->start() ;
    setWindowTitle(s) ;
  } catch (...) {
    source = 0 ;
    setWindowTitle("<no source>") ;  
  }
}

void
VideoViewer::dragEnterEvent(QDragEnterEvent *event) {
  const QMimeData *mdata = event->mimeData() ;
#if 0
  std::cerr << "html: " << mdata->hasHtml()
		  << " image: " << mdata->hasImage()
		  << " text: " << mdata->hasText()
		  << " URLs: " << mdata->hasUrls()
		  << std::endl ;
#endif
  if (mdata->hasUrls() || mdata->hasText()) event->acceptProposedAction();
}

void
VideoViewer::dropEvent(QDropEvent *event) {
  const QMimeData *mdata = event->mimeData() ;
  if (mdata->hasUrls()) {
    const QList<QUrl> urls = event->mimeData()->urls() ;
    setSource(urls[0].toString()) ;
    event->acceptProposedAction();
  } else if (mdata->hasText()) {
    setSource(mdata->text()) ;
    event->acceptProposedAction();
  }
}

void
VideoViewer::react(Observable *obs) {
  if (source && obs==source) {
    Image img ;
    if (source->getNextImage(&img)) {
	 // std::cerr << source->getFrameCount() << std::endl ;
	 if (source->getFrameCount()==1) resize(img.getWidth(), img.getHeight()) ;
	 texture->update(&img) ;
	 update() ;
    }
  }
}

void
VideoViewer::initializeGL(void) {
  glClearColor(0.2,0.2,0.2,1.0) ;
}

void
VideoViewer::paintGL(void) {
  QPainter painter ;
  painter.begin(this) ;

  glColor3f(1,1,1) ;
  float x1=0, y1=height(), x2=width(), y2=0 ;
  texture->display(x1,y1,x2,y2,true) ;

  if (source->getFrameCount()%100) {
    char fps[256] ;
    snprintf(fps,256,"%d fps",(int)source->getMeanRate()) ;
    painter.setPen(Qt::white) ;
    painter.drawText(10,15,fps) ;
  }

#if 0
  glColor3f(1,0,0) ;
  // glTranslatef(0,0,0.3) ;
  glRectf(200,100,300,200) ;
#endif

  painter.end() ;
}

QSize
VideoViewer::sizeHint(void) const {
  return QSize(texture->getWidth(), texture->getHeight()) ;
}

VideoViewer::~VideoViewer(void) {
  unsubscribeFrom(source) ;
  delete source ;
  delete texture ;
}
