#include <nucleo/core/ReactiveEngine.H>

#include <QApplication>
#include <QFileDialog>

#include "VideoViewer.h"

#include <iostream>

using namespace nucleo ;

int
main(int argc, char *argv[]) {
  char *ENGINE = getenv("NUCLEO_ENGINE") ;
  ReactiveEngine::setEngineType(ENGINE?ENGINE:"qt") ;

  QApplication app(argc, argv);
  app.setStyle("plastique") ;

  QString source ;
  if (argc>1)
    source = argv[1] ;
  else {
    source = QFileDialog::getOpenFileName(0, "Choose a file", getenv("HOME")) ;
    if (source=="") source = QString("videoin:") ;
  }

  VideoViewer viewer(source) ;
  viewer.show() ;

  return app.exec();
}
