#include <nucleo/nucleo.H>
#include <nucleo/utils/AppUtils.H>
#include <nucleo/core/ReactiveEngine.H>
#include <nucleo/image/source/ImageSource.H>
#include <nucleo/image/processing/difference/Difference.H>
#include <nucleo/image/sink/ImageSink.H>

using namespace nucleo ;

class Tester : public ReactiveObject {

protected:

  ImageSource *source ;
  Image img ;
  DifferenceFilter filter ;
  ImageSink *sink ;

  void react(Observable *obs) {
    if (source->getNextImage(&img)) {
	 filter.filter(&img) ;
	 sink->handle(&img) ;
    }
    if (!source->isActive() || !sink->isActive())
	 ReactiveEngine::stop() ;
  }

public:

  Tester(const char *src, const char *dst) {
    sink = ImageSink::create(dst) ;
    sink->start() ;
    source = ImageSource::create(src) ;
    subscribeTo(source) ;
    source->start() ;
  }

  ~Tester(void) {
    unsubscribeFrom(source) ;
    delete source ;
    delete sink ;
  }

} ;

int
main(int argc, char **argv) {
  char *SRC = getenv("NUCLEO_SRC1") ;
  char *DST = "glwindow:?fps" ;
  if (parseCommandLine(argc, argv, "i:o:", "ss", &SRC, &DST)<0) {
	 std::cerr << std::endl << argv[0] << " [-i source] [-o sink]" << std::endl ;
	 exit(1) ;
  }

  Tester t(SRC, DST) ;

  ReactiveEngine::run() ;
}
