/*
 *
 * nucleo/apps/multivideo.java --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

package fr.lri.insitu.nucleo.apps ;

import fr.lri.insitu.nucleo.nucleoException ;
import fr.lri.insitu.nucleo.swing.VideoPanel ;

import javax.swing.*;
import java.awt.*;

class VideoFrame extends JInternalFrame {

    private VideoPanel panel = null ;

    VideoFrame(String u) throws nucleoException {
	   super(u, true, false, true, true) ; // can't close for now
	   panel = new VideoPanel(u, (Container)this) ;
	   setContentPane(panel) ;
	   setVisible(true);
	   pack() ;
	   show() ;
    }

}

public class multivideo extends JFrame {

  public static void main(String[] args) throws nucleoException {
    new multivideo(args) ;
  }

  public multivideo(String[] args) throws nucleoException {
    super("multivideo");
    try {
	   UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName()) ;
	   // UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName()) ;
    } catch (Exception e) {}

    Container content = getContentPane();
    content.setBackground(Color.white);

    JDesktopPane desktop = new JDesktopPane();
    desktop.setBackground(Color.white);

    content.add(desktop, BorderLayout.CENTER);
    setSize(450, 400);

    for(int i=0; i<args.length; i++) {
	   VideoFrame frame = new VideoFrame(args[i]) ;
	   frame.setLocation(i*50+10, i*50+10);
	   frame.setBackground(Color.black);
	   frame.setSize(80, 60);
	   desktop.add(frame);
	   frame.moveToFront();
    }

    setVisible(true);
  }

}
