/*
 *
 * nucleo/apps/videoClient.java --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

package fr.lri.insitu.nucleo.apps ;

import fr.lri.insitu.nucleo.nucleoException ;
import fr.lri.insitu.nucleo.image.source.AsyncImageSource ;
import fr.lri.insitu.nucleo.image.source.AsyncImageSourceEvent ;
import fr.lri.insitu.nucleo.image.source.AsyncImageSourceListener ;

import javax.swing.*;
import java.awt.* ;
import java.awt.image.* ;
import java.awt.geom.* ;
import java.awt.event.* ;

public class videoClient extends JApplet implements AsyncImageSourceListener {

    // -----------------------------------------------------------------------------------------------

    private JFrame window = null ;

    private AsyncImageSource isource = null ;
    private BufferedImage img = null ;

    private boolean firstImage = true ; 

    // -----------------------------------------------------------------------------------------------

    // Applet version
    public void init() {
	   // System.out.println("init()") ;
	   try {
		  isource = new AsyncImageSource(getParameter("source")) ;
		  isource.addListener(this) ;
	   } catch (nucleoException e) {
		  System.out.println(e.toString()) ;
	   }
    }

    public void init(String u) throws nucleoException {
	   // System.out.println("init(String u, JFrame p)") ;
	   isource = new AsyncImageSource(u) ;
	   isource.addListener(this) ;

        window = new JFrame(u) ;
        window.getContentPane().add(this, BorderLayout.CENTER) ;
        window.pack() ;
	   window.show() ;
    }

    // -----------------------------------------------------------------------------------------------

    public void handleImageSourceEvent(AsyncImageSourceEvent e) {
	   img = e.getImage() ;

	   if (firstImage && window!=null) {
		  int w=img.getWidth(), h=img.getHeight() ;
		  Insets i = window.getInsets() ;
		  window.setSize(w+i.left+i.right,h+i.top+i.bottom) ;
		  resize(w,h) ;
	   }

	   repaint() ;
    }

    public void paint(Graphics g) {
	   // super.paint(g) ;
	   if (img==null) return ;

	   Graphics2D g2 = (Graphics2D) g ;

	   if (firstImage) {
		  g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED) ;
		  g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR) ;
		  firstImage = false ;
	   }

	   BufferedImageOp op = null ;
	   int w=img.getWidth(), h=img.getHeight() ;

	   Dimension d = getSize() ;
	   double sx = (double)d.width/w ;
	   double sy = (double)d.height/h ;
	   if (sx!=1.0 || sy!=1.0) {
		  AffineTransform at = new AffineTransform() ;
		  AffineTransform sc = at.getScaleInstance(sx, sy) ;
		  op = new AffineTransformOp(sc, null) ;
	   }
	   
	   g2.drawImage(img, op, 0, 0) ;
    }

    // -----------------------------------------------------------------------------------------------
    // Application

    public static void main(String argv[]) throws nucleoException {
	   String source = "nudp://127.0.0.1:8989" ;
	   try { source = argv[0] ; } catch (Exception e) {}

        videoClient client = new videoClient() ;
	   client.init(source) ;
    }

}
