/*
 *
 * nucleo/image/sink/ImageSinkFactory.java --
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 */

package fr.lri.insitu.nucleo.image.sink ;

import fr.lri.insitu.nucleo.nucleoException ;

import java.net.URI ;
import java.awt.image.* ;

public class ImageSinkFactory {  

    public static ImageSink createSink(String u) throws nucleoException {
	   try {
		  URI uri = new URI(u) ;
		  return createSink(uri) ;
	   } catch (Exception e) {
		  throw new nucleoException(e) ;
	   }
    }


    public static ImageSink createSink(URI uri) throws nucleoException {
	   if (uri.getScheme().equals("nudp")) {
		  return new nudpImageSink(uri.getHost(), uri.getPort()) ;
	   }

	   return null ;
    }

}
