#ifndef __COMMON_H__
#define __COMMON_H__

/*
  QtCurve (C) Craig Drummond, 2003 Craig.Drummond@lycos.co.uk

----

  Released under the GNU General Public License (GPL) v2.

----

  Permission is hereby granted, free of charge, to any person obtaining a
  copy of this software and associated documentation files(the "Software"),
  to deal in the Software without restriction, including without limitation
  the rights to use, copy, modify, merge, publish, distribute, sublicense,
  and/or sell copies of the Software, and to permit persons to whom the
  Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
  DEALINGS IN THE SOFTWARE.
*/

/* This file is quite 'hacky' as it contains lots of static function definitions - but I want to share the code
   between Qt and Gtk, but not polute the namespace with exported functions... */

#include <string.h>
#include <math.h>
#include "config.h"

#ifdef __cplusplus
#include <qstring.h>
#include <qsettings.h>
#ifdef QTC_CONFIG_DIALOG
#include <qapplication.h>
#endif
#else
#include <glib.h>
#endif

#define QTC_GROUP           "Settings"
#define QTC_GROUP_LEN       8
#define QTC_DESCR_GROUP     "Description"
#define QTC_DESCR_GROUP_LEN 11

#define QTC_CHECK_SIZE   13
#define QTC_RADIO_SIZE   13
#define QTC_MIN_BTN_SIZE 8
#define QTC_LV_SIZE(X)   LV_EXP_ARR==(X) ? 7 : 5

#define NUM_STD_SHADES   7

/* KDE/Qt Can have mouse-over for tabs, so they need an extra shading... */
#if defined  __cplusplus && defined QTC_TAB_BAR_MOUSE_OVER
#define NUM_EXTRA_SHADES 3
#else
#define NUM_EXTRA_SHADES 2
#endif

#define TOTAL_SHADES     NUM_STD_SHADES+NUM_EXTRA_SHADES
#define ORIGINAL_SHADE   TOTAL_SHADES

#define SHADE_ORIG_HIGHLIGHT NUM_STD_SHADES
#define SHADE_4_HIGHLIGHT    NUM_STD_SHADES+1
#if defined  __cplusplus && defined QTC_TAB_BAR_MOUSE_OVER
#define SHADE_2_HIGHLIGHT    NUM_STD_SHADES+2
#endif

/* 3d effect - i.e. buttons, etc */
#define QTC_SHADES \
    static const double shades[11][NUM_STD_SHADES]=\
    { \
      { 1.08, 1.03, 0.91, 0.780, 0.832, 0.74, 1.8 }, \
      { 1.09, 1.03, 0.91, 0.781, 0.833, 0.72, 1.8 }, \
      { 1.10, 1.03, 0.91, 0.782, 0.834, 0.70, 1.8 }, \
      { 1.11, 1.04, 0.91, 0.783, 0.835, 0.68, 1.8 }, \
      { 1.12, 1.04, 0.91, 0.784, 0.836, 0.66, 1.8 }, \
      { 1.13, 1.05, 0.91, 0.785, 0.838, 0.64, 1.8 }, \
      { 1.14, 1.05, 0.91, 0.786, 0.840, 0.62, 1.8 }, \
      { 1.15, 1.06, 0.91, 0.787, 0.842, 0.60, 1.8 }, /* default */ \
      { 1.17, 1.06, 0.91, 0.788, 0.844, 0.45, 1.8 }, \
      { 1.19, 1.07, 0.91, 0.789, 0.846, 0.40, 1.8 }, \
      { 1.21, 1.07, 0.91, 0.790, 0.848, 0.35, 1.8 } \
    };

#define QTC_SHADE(c, s) \
    (c>10 || c<0 || s>=NUM_STD_SHADES || s<0 ? 1.0 : shades[c][s])

#define TAB_APPEARANCE(A)   (A) /* (APPEARANCE_GLASS==(A) ? APPEARANCE_GRADIENT : (A)) */

#define SHADE_BEVEL_GRAD_LIGHT     1.05
#define SHADE_BEVEL_GRAD_DARK      0.93
#define SHADE_BEVEL_GRAD_SEL_LIGHT 1.05
#define SHADE_BEVEL_GRAD_SEL_DARK  0.95

#define SHADE_SLIDER_LIGHT         1.1
#define SHADE_SLIDER_DARK          0.8

#define SHADE_SBAR_LIGHT           1.02
#define SHADE_SBAR_DARK            0.95

#define SHADE_MENU_LIGHT           1.02
#define SHADE_MENU_DARK            0.96

#define SHADE_TAB_LIGHT            1.0
#define SHADE_TAB_DARK             1.0
#define SHADE_TAB_SEL_LIGHT        1.1
#define SHADE_TAB_SEL_DARK         1.0

#define SHADE_BOTTOM_TAB_LIGHT     1.0
#define SHADE_BOTTOM_TAB_DARK      1.0
#define SHADE_BOTTOM_TAB_SEL_LIGHT 1.0
#define SHADE_BOTTOM_TAB_SEL_DARK  0.9

#define SHADE_GLASS_TOP_A(A, W) (APPEARANCE_DULL_GLASS==A \
                                    ? (WIDGET_DEF_BUTTON==W ? 1.05 : 1.20) \
                                    : (WIDGET_DEF_BUTTON==W ? 1.08 : 1.7))
#define SHADE_GLASS_TOP_B(A, W) 0.96
#define SHADE_GLASS_BOT_A(A) 0.99
#define SHADE_GLASS_BOT_B(A) (APPEARANCE_DULL_GLASS==A ? 1.05 : 1.16)

#define IS_GLASS(A) (APPEARANCE_DULL_GLASS==A || APPEARANCE_SHINY_GLASS==A)
#define IS_FLAT(A)  (APPEARANCE_FLAT==A)
#define SHADE_SELECTION_TOP 1.15
#define SHADE_SELECTION_BOT 0.9

#ifdef __cplusplus
#define MENUBAR_DARK_LIMIT 160
#define TOO_DARK(A) ((A).red()<MENUBAR_DARK_LIMIT || (A).green()<MENUBAR_DARK_LIMIT || (A).blue()<MENUBAR_DARK_LIMIT)
#else
#define MENUBAR_DARK_LIMIT (160<<8)
#define TOO_DARK(A) ((A).red<MENUBAR_DARK_LIMIT || (A).green<MENUBAR_DARK_LIMIT || (A).blue<MENUBAR_DARK_LIMIT)
#endif

#define MENUBAR_SHADE_LIGHT_FACTOR 1.20
#define DEFAULT_HIGHLIGHT_FACTOR   1.05
#define MAX_HIGHLIGHT_FACTOR         50
#define MIN_HIGHLIGHT_FACTOR          0
#define MENUBAR_DARK_FACTOR        0.95
#define POPUPMENU_LIGHT_FACTOR     1.15

#define USE_SHADED_MENU_BAR_COLORS (SHADE_CUSTOM==opts.shadeMenubars || SHADE_SELECTED==opts.shadeMenubars)
#define MENUBAR_GLASS_SELECTED_DARK_FACTOR 0.9
/*#define GLASS_MAX_PIXELS 12 */
#define GLASS_BORDER     0.4
#define BEVEL_BORDER(w)    (WIDGET_LISTVIEW_HEADER==w ? 6 : 4)
#define SHADE_BEVEL_TOP    1.07
#define SHADE_BEVEL_MID_TOP    1.01
#define SHADE_BEVEL_MID_BOT    0.975
#define SHADE_BEVEL_BOT(w) (WIDGET_LISTVIEW_HEADER==(w) ? 0.86 : 0.90)

#define NUM_SPLITTER_DASHES 21

#define WIDGET_BUTTON(w) (WIDGET_STD_BUTTON==w || WIDGET_DEF_BUTTON==w)
#define COLORED_BORDER_SIZE 3
#define PROGRESS_CHUNK_WIDTH 10
#define PROGRESS_ANIMATION 100
#define MIN_SLIDER_SIZE(A) (LINE_DOTS==A ? 24 : 20)

typedef enum
{
    WIDGET_TAB_TOP,
    WIDGET_TAB_BOT,
    WIDGET_STD_BUTTON,
    WIDGET_DEF_BUTTON,
    WIDGET_LISTVIEW_HEADER,
    WIDGET_OTHER
} EWidget;

typedef enum
{
    CORNER_TL = 0x1,
    CORNER_TR = 0x2,
    CORNER_BR = 0x4,
    CORNER_BL = 0x8
} ECornerBits;

#define ROUNDED_NONE            0x0
#define ROUNDED_TOP             (CORNER_TL|CORNER_TR)
#define ROUNDED_BOTTOM          (CORNER_BL|CORNER_BR)
#define ROUNDED_LEFT            (CORNER_TL|CORNER_BL)
#define ROUNDED_RIGHT           (CORNER_TR|CORNER_BR)
#define ROUNDED_TOPRIGHT        CORNER_TR
#define ROUNDED_BOTTOMRIGHT     CORNER_BR
#define ROUNDED_TOPLEFT         CORNER_TL
#define ROUNDED_BOTTOMLEFT      CORNER_BL
#define ROUNDED_ALL             (CORNER_TL|CORNER_TR|CORNER_BR|CORNER_BL)

#define QTC_ROUNDED (ROUND_NONE!=opts.round)

typedef enum
{
    IND_CORNER,
    IND_FONT_COLOR,
    IND_COLORED,
    IND_NONE
} EDefBtnIndicator;

typedef enum
{
    LINE_RAISED,
    LINE_SUNKEN,
    LINE_DOTS,
    LINE_DASHES
} ELine;

#define LINE_NONE LINE_DASHES

typedef enum
{
    TB_NONE,
    TB_LIGHT,
    TB_DARK
} ETBarBorder;

typedef enum
{
    LV_EXP_PM,
    LV_EXP_ARR
} ELvExpander;

typedef enum
{
    LV_LINES_NONE,
    LV_LINES_DOTTED,
    LV_LINES_SOLID
} ELvLines;

typedef enum
{
    BORDER_FLAT,
    BORDER_RAISED,
    BORDER_SUNKEN
} EBorder;

typedef enum
{
    APPEARANCE_FLAT,
    APPEARANCE_DULL_GLASS,
    APPEARANCE_SHINY_GLASS,
    APPEARANCE_GRADIENT,
    APPEARANCE_INVERTED,
    APPEARANCE_BEVELLED
} EAppearance;

typedef enum
{
    SHADE_NONE,
    SHADE_SELECTED,
    SHADE_CUSTOM,
    SHADE_DARKEN    /* For menubar only! */
} EShade;

typedef enum
{
    HEADER_COLOR_BGND,
    HEADER_COLOR_BTN,
    HEADER_COLOR_CUSTOM
} EHeaderColor;

typedef enum
{
    FOCUS_DOTS,
    FOCUS_COLORED
} EFocus;

typedef enum
{
    ROUND_NONE,
    ROUND_SLIGHT,
    ROUND_FULL
} ERound;

#define DEF_IND_STR                "fontcolor"
#define DEF_LINE_STR               "dots"
#define DEF_TB_BORDER              "none"
#define DEF_APPEARANCE_STR         "bevelled"
#define DEF_MENU_APPEARANCE_STR    "gradient"
#define DEF_TOOLBAR_APPEARANCE_STR "gradient"
#define DEF_SLIDER_SHADE_STR       "selected"
#define DEF_TBS_STR                "dots"
#define DEF_COLOR_STR              "background"
#define DEF_FOCUS_STR              "colored"
#define DEF_TOOLBAR_SHADE_STR      "none"

/*#define DEF_MENU_SHADE_STR         "darken"*/

#ifdef __cplusplus
typedef bool   qtc_bool;
typedef QColor qtc_color;
#define qtc_true true
#define qtc_false false
#else
typedef gboolean qtc_bool;
typedef GdkColor qtc_color;
#define qtc_true TRUE
#define qtc_false FALSE
#endif

#ifndef QTC_COMMON_NO_FUNCTIONS

#ifndef QTC_COMMON_ONLY_COVERTERS
#define QTC_MIN(a, b) ((a) < (b) ? (a) : (b))
#define QTC_MAX(a, b) ((b) < (a) ? (a) : (b))

static void qtc_rgb2hls(double *r, double *g, double *b)
{
    double min,
           max,
           red=*r,
           green=*g,
           blue=*b,
           h=0,
           l,
           s=0,
           delta;

    if(red > green)
    {
        max=QTC_MAX(red, blue);
        min=QTC_MIN(green, blue);
    }
    else
    {
        max=QTC_MAX(green, blue);
        min=QTC_MIN(red, blue);
    }

    l=(max +min)/ 2;
    s=0;
    h=0;

    if(max !=min)
    {
        if(l <=0.5)
            s=(max-min)/(max +min);
        else
            s=(max-min)/(2-max-min);

        delta=max-min;

        if(red==max)
            h=(green-blue)/ delta;
        else if(green==max)
            h=2 +(blue-red)/ delta;
        else if(blue==max)
            h=4 +(red-green)/ delta;

        h *=60;
        if(h < 0.0)
            h +=360;
    }

    *r=h;
    *g=l;
    *b=s;
}

static void qtc_hls2rgb(double *h, double *l, double *s)
{
    double hue,
           lightness=*l,
           saturation=*s,
           m1,
           m2,
           r,
           g,
           b;

    if(lightness <=0.5)
        m2=lightness *(1 +saturation);
    else
        m2=lightness +saturation-lightness * saturation;
    m1=2 * lightness-m2;

    if(0==saturation)
    {
        *h=lightness;
        *l=lightness;
        *s=lightness;
    }
    else
    {
        hue=*h +120;
        while(hue > 360)
            hue-=360;
        while(hue < 0)
            hue +=360;
        if(hue < 60)
            r=m1 +(m2-m1)* hue / 60;
        else if(hue < 180)
            r=m2;
        else if(hue < 240)
            r=m1 +(m2-m1)*(240-hue)/ 60;
        else
            r=m1;

        hue=*h;
        while(hue > 360)
            hue-=360;
        while(hue < 0)
            hue +=360;

        if(hue < 60)
            g=m1 +(m2-m1)* hue / 60;
        else if(hue < 180)
            g=m2;
        else if(hue < 240)
            g=m1 +(m2-m1)*(240-hue)/ 60;
        else
            g=m1;

        hue=*h-120;
        while(hue > 360)
            hue-=360;
        while(hue < 0)
            hue +=360;

        if(hue < 60)
            b=m1 +(m2-m1)* hue / 60;
        else if(hue < 180)
            b=m2;
        else if(hue < 240)
            b=m1 +(m2-m1)*(240-hue)/ 60;
        else
            b=m1;

        *h=r;
        *l=g;
        *s=b;
    }
}

static qtc_bool qtc_equal(double d1, double d2)
{
    return (fabs(d1 - d2) < 0.0001);
}

#endif

#endif

#ifdef QTC_CONFIG_DIALOG
struct OptionsBase
#else
#ifdef __cplusplus
struct Options
#else
typedef struct
#endif
#endif
{
    int              contrast;
    double           highlightFactor;
    ERound           round;
    qtc_bool         vArrow,
                     embolden,
                     crLabelHighlight,
                     lighterPopupMenuBgnd,
                     highlightTab,
                     highlightEdits,
                     lvDark,
                     drawStatusBarFrames,
                     menubarRoundTopOnly,
                     stripedProgress,
                     animatedProgress,
                     fillSlider;
    EFocus           focus;
    ETBarBorder      toolbarBorders;
    EDefBtnIndicator defBtnIndicator;
    ELine            sliderThumbs,
                     handles,
                     toolbarSeparators,
                     splitters;
    ELvExpander      lvExpander;
    ELvLines         lvLines;
    EHeaderColor     lvHeaderColor;
    EAppearance      appearance,
                     menubarAppearance,
                     toolbarAppearance,
                     lvHeaderAppearance,
                     selectedTabAppearance,
                     normalTabAppearance;
    EShade           shadeSliders,
                     shadeMenubars;
    qtc_color        customMenubarsColor,
                     customSlidersColor,
                     customLvHeaderColor;
#ifndef __cplusplus
} Options;
#else
};
#endif

#ifdef QTC_CONFIG_DIALOG
struct Options : public OptionsBase
{
    Options & operator=(const Options &rhs)
    {
        if(this!=&rhs)
        {
            memcpy(this, (void *)&rhs, sizeof(OptionsBase));
            name=rhs.name;
            readOnly=rhs.readOnly;
        }

        return *this;
    }

    QString name,
            file;
    bool    readOnly;
};
#endif


#endif
