/*
  QtCurve (C) Craig Drummond, 2003 Craig.Drummond@lycos.co.uk

  Based upon FreeCurve/B???Curve
  ----

 * B???curve theme engine
 * Copyright (C) 2001 R?d H?t, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Written by Owen Taylor <otaylor@r?dh?t.com>
 * modified by Alexander Larsson <alexl@r?dh?t.com>
 */

#include <gmodule.h>
#include <gtk/gtk.h>
#include <gtk/gtkstyle.h>
#include <gdk/gdktypes.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include "qtcurve.h"
#include "qt_settings.c"
#if GTK_MAJOR_VERSION>1
#include "animation.c"
#endif
#include "config.h"

#if GTK_MAJOR_VERSION>1
#define QT_CURVE_STYLE_VAR QtCurveStyle *qtcurve_style = QTCURVE_STYLE(style);
#define QT_STYLE style
#define PCONST const
#define WIDGET_TYPE_NAME(xx) (widget && !strcmp(g_type_name (G_TYPE_FROM_INSTANCE(widget)), (xx)))
#define FN_CHECK g_return_if_fail(GTK_IS_STYLE(style)); g_return_if_fail(window != NULL);

#ifndef GTK_IS_COMBO_BOX_ENTRY
#define GTK_IS_COMBO_BOX_ENTRY(x) 0
#endif
#ifndef GTK_IS_COMBO_BOX
#define GTK_IS_COMBO_BOX(x) 0
#endif

#elif GTK_MAJOR_VERSION==1
#define QT_CURVE_STYLE_VAR QtCurveStyle *qtcurve_style = style->engine_data;
#define QT_STYLE style->klass
#define PCONST
#define WIDGET_TYPE_NAME(xx) (FALSE)
#define FN_CHECK g_return_if_fail(window != NULL);
#endif

#define SCALE_SIZE 5
#define LARGE_ARR_WIDTH  7
#define LARGE_ARR_HEIGHT (opts.vArrow ? 5 : 4)
#define SMALL_ARR_WIDTH  5
#define SMALL_ARR_HEIGHT (opts.vArrow ? 4 : 3)

#define MENU_GC(GC) /* use_shaded ? qtcurve_style->shade_menuitem_gc[GC] \
                                  : */ qtcurve_style->menuitem_gc[GC]

#ifdef QTC_DEBUG
static void display_widget(GtkWidget *widget, int level)
{
    if(level>=0)
    {
        printf("%s(%s) ", widget ? gtk_type_name(GTK_WIDGET_TYPE(widget)) : "NULL",
               widget && widget->name ? widget->name : "NULL");
        /*if(widget)
            printf("[%d, %dx%d : %d,%d , %0X] ", widget->state, widget->allocation.x,
                   widget->allocation.y,
                   widget->allocation.width, widget->allocation.height, widget->window);*/
        if(widget && widget->parent)
            display_widget(widget->parent, --level);
        else
            printf("\n");
    }
    else
        printf("\n");
}
#endif

static GtkStyleClass *parent_class;
static Options       opts;

#if GTK_MAJOR_VERSION==1
typedef struct _GtkBorder GtkBorder;
struct _GtkBorder
{
    gint left;
    gint right;
    gint top;
    gint bottom;
};
#endif

static GtkRequisition default_option_indicator_size    = { 6, 13 };
static GtkBorder      default_option_indicator_spacing = { 7, 5, 1, 1 };

#define DETAIL(xx) ((detail) &&(!strcmp(xx, detail)))

#define QTC_PANED "paned-qtc"
#define QTC_CHECKBOX "checkbox-qtc"
#define IS_QTC_PANED DETAIL(QTC_PANED)

static void shade(GdkColor *a, GdkColor *b, float k);

static gboolean use_button_color(const gchar *detail)
{
    return detail &&( 0==strcmp(detail, "optionmenu") ||
                       0==strcmp(detail, "button") ||
                       0==strcmp(detail, QTC_CHECKBOX) ||
                       (QTC_ROUNDED && (0==strcmp(detail, "buttondefault") ||
                                       0==strcmp(detail, "togglebuttondefault"))) ||
                       0==strcmp(detail, "togglebutton") ||
                       0==strcmp(detail, "hscale") ||
                       0==strcmp(detail, "vscale") ||
                       0==strcmp(detail, "spinbutton") ||
                       0==strcmp(detail, "spinbutton_up") ||
                       0==strcmp(detail, "spinbutton_down") ||
                       0==strcmp(detail, "slider") ||
                       0==strcmp(detail, "vscrollbar") ||
                       0==strcmp(detail, "hscrollbar") ||
                       0==strcmp(detail, QTC_PANED) );
}

#define QT_COL_EQ(A, B)(abs(A-B)<(3<<8))

#define QT_CUSTOM_COLOR_BUTTON(style) \
    (style && \
    !(QT_COL_EQ(qt_settings.colors[COLOR_WINDOW].red,(style->bg[GTK_STATE_NORMAL].red)) && \
      QT_COL_EQ(qt_settings.colors[COLOR_WINDOW].green,(style->bg[GTK_STATE_NORMAL].green)) && \
      QT_COL_EQ(qt_settings.colors[COLOR_WINDOW].blue,(style->bg[GTK_STATE_NORMAL].blue))))

static void shade_colors(GdkColor *base, GdkColor *vals)
{
    QTC_SHADES

    int i;

    for(i=0; i<NUM_STD_SHADES; ++i)
        shade(base, &vals[i], QTC_SHADE(opts.contrast, i));
    shade(base, &vals[SHADE_ORIG_HIGHLIGHT], opts.highlightFactor);
    shade(&vals[4], &vals[SHADE_4_HIGHLIGHT], opts.highlightFactor);
    vals[ORIGINAL_SHADE]=*base;
}

static GdkGC * realize_color(GtkStyle *style, GdkColor *color);

#define GEN_GCS(style, colors, gcs) \
{ \
    int loop_count; \
 \
    for(loop_count=0;loop_count<TOTAL_SHADES+1;++loop_count) \
        gcs[loop_count] = realize_color(style, &colors[loop_count]); \
}

#define RELEASE_GCS(gcs) \
{ \
    int loop_count; \
 \
    for(loop_count=0; loop_count<TOTAL_SHADES+1;++loop_count) \
        gtk_gc_release(gcs[loop_count]); \
}

static void gen_custom_gcs(GtkStyle *style)
{
    QT_CURVE_STYLE_VAR
    qtcurve_style->button_text_gc=realize_color(style, &qt_settings.colors[COLOR_BUTTON_TEXT]);
}

static void release_custom_gcs(GtkStyle *style)
{
    QT_CURVE_STYLE_VAR
    gtk_gc_release(qtcurve_style->button_text_gc);
}

#if GTK_MAJOR_VERSION==1
void gdk_rgb_find_color(GdkColormap *colormap, GdkColor *color)
{
    color->pixel = gdk_rgb_xpixel_from_rgb(((color->red >> 8) << 16) | ((color->green >> 8) << 8) |
                                           (color->blue >> 8));
}
#endif

inline int limit(double c)
{
    return c < 0.0
               ? 0
               : c > 65536.0
                     ? 65536
                     : (int)c;
}

static void generate_mid_color(GdkColor *a, GdkColor *b, GdkColor *mid, double factor)
{
    *mid=*b;

    mid->red=(a->red+limit(b->red*factor))>>1; \
    mid->green=(a->green+limit(b->green*factor))>>1; \
    mid->blue=(a->blue+limit(b->blue*factor))>>1; \
}

static GdkGC * set_mid_color(GtkStyle *style, GdkRectangle *area, int num, double factor, GdkColor *a, GdkColor *b)
{
    QT_CURVE_STYLE_VAR
    GdkColor mid_color=*b;

    generate_mid_color(a, b, &mid_color, factor);

    gdk_rgb_find_color(style->colormap, &mid_color);
    if(qtcurve_style->mid_gc[num])
        gdk_gc_set_foreground(qtcurve_style->mid_gc[num], &mid_color);
    else
        qtcurve_style->mid_gc[num]=realize_color(style, &mid_color);
    gdk_gc_set_clip_rectangle(qtcurve_style->mid_gc[num], area ? area : NULL);
    return qtcurve_style->mid_gc[num];
}

#define QTC_SET_MID_COLOR_FACTOR2(GC, A, B, factor) set_mid_color(style, area, 1, factor, &(A), &(B));
#define QTC_SET_MID_COLOR2(GC, A, B)                set_mid_color(style, area, 1, 1.0, &(A), &(B));
#define QTC_SET_MID_COLOR_FACTOR(A, B, factor)      set_mid_color(style, area, 0, factor, &(A), &(B));
#define QTC_SET_MID_COLOR(A, B)                     set_mid_color(style, area, 0, 1.0, &(A), &(B));

#define QTC_ARROW_STATE(state) (GTK_STATE_INSENSITIVE==state ? state : GTK_STATE_NORMAL)
/* (GTK_STATE_ACTIVE==state ? GTK_STATE_NORMAL : state) */

static gboolean is_on_toolbar(GtkWidget *widget, gboolean *horiz, int level)
{
    if(widget)
        if(GTK_IS_TOOLBAR(widget))
        {
            if(horiz)
            {
#if GTK_MAJOR_VERSION>1
                *horiz=GTK_ORIENTATION_HORIZONTAL==gtk_toolbar_get_orientation(GTK_TOOLBAR(widget));
#else
                GtkToolbar *tb=GTK_TOOLBAR(widget);

                if(tb)
                    *horiz=GTK_ORIENTATION_HORIZONTAL==tb->orientation;
#endif
            }
            return TRUE;
        }
        else if(level<4)
            return is_on_toolbar(widget->parent, horiz, ++level);

    return FALSE;
}

static gboolean is_on_handlebox(GtkWidget *widget, gboolean *horiz, int level)
{
    if(widget)
        if(GTK_IS_HANDLE_BOX(widget))
        {
            if(horiz)
            {
#if GTK_MAJOR_VERSION>1
                GtkPositionType pos=gtk_handle_box_get_handle_position(GTK_HANDLE_BOX(widget));
                *horiz=GTK_POS_LEFT==pos || GTK_POS_RIGHT==pos;
#else
                GtkHandleBox *box=GTK_HANDLE_BOX(widget);

                if(box)
                    *horiz=GTK_POS_LEFT==box->handle_position;
#endif
            }
            return TRUE;
        }
        else if(level<4)
            return is_on_handlebox(widget->parent, horiz, ++level);

    return FALSE;
}

static gboolean is_button_on_toolbar(GtkWidget *widget, gboolean *horiz)
{
    return (widget && widget->parent && GTK_IS_BUTTON(widget))
               ? is_on_toolbar(widget->parent, horiz, 0)
               : FALSE;
}

static gboolean is_button_on_handlebox(GtkWidget *widget, gboolean *horiz)
{
    return (widget && widget->parent && GTK_IS_BUTTON(widget))
               ? is_on_handlebox(widget->parent, horiz, 0)
               : FALSE;
}

static gboolean is_list(GtkWidget *widget)
{
    return widget &&
           (GTK_IS_CLIST(widget) ||
            GTK_IS_LIST(widget) ||
#if GTK_MAJOR_VERSION>1
            GTK_IS_TREE_VIEW(widget) ||
#ifdef GTK_ENABLE_BROKEN
            GTK_IS_TREE(widget) ||
#endif
#else
            GTK_IS_TREE(widget) ||
#endif
            GTK_IS_CTREE(widget));

}

static gboolean is_list_view_header(GtkWidget *widget)
{
    return widget && GTK_IS_BUTTON(widget) && widget->parent && is_list(widget->parent);
}

#if GTK_MAJOR_VERSION>1
static gboolean is_combo_box_button(GtkWidget *widget)
{
    return widget && GTK_IS_BUTTON(widget) && widget->parent &&
           (GTK_IS_COMBO_BOX_ENTRY(widget->parent) || GTK_IS_COMBO(widget->parent));
}

static gboolean is_combo_box_entry(GtkWidget *widget)
{
    return widget && GTK_IS_ENTRY(widget) && widget->parent &&
           (GTK_IS_COMBO_BOX_ENTRY(widget->parent) || GTK_IS_COMBO(widget->parent));
}

static gboolean is_on_combo_entry(GtkWidget *w, int level)
{
    if(w)
        if(GTK_IS_COMBO_BOX_ENTRY(w))
            return TRUE;
        else if(level<4)
            return is_on_combo_entry(w->parent, ++level);

    return FALSE;
}

static gboolean is_on_combo(GtkWidget *w, int level)
{
    if(w)
        if(GTK_IS_COMBO_BOX(w))
            return TRUE;
        else if(level<4)
            return is_on_combo(w->parent, ++level);

    return FALSE;
}

#else
static gboolean is_combo_box_entry(GtkWidget *widget)
{
    return widget && GTK_IS_ENTRY(widget) && widget->parent && GTK_IS_COMBO(widget->parent);
}
#endif

static gboolean is_active_combo(GtkWidget *widget)
{
    if(GTK_IS_OPTION_MENU(widget))
    {
        GtkWidget *menu=gtk_option_menu_get_menu(GTK_OPTION_MENU(widget));
        if(menu && GTK_WIDGET_VISIBLE(menu) && GTK_WIDGET_REALIZED(menu))
            return TRUE;
    }
    return FALSE;
}

static gboolean is_spinbutton(GtkWidget *widget)
{
    return widget && GTK_IS_SPIN_BUTTON(widget);
}

gboolean reverse_layout(GtkWidget *widget)
{
#if GTK_MAJOR_VERSION>1
    GtkTextDirection dir;

    if (widget)
        return GTK_TEXT_DIR_RTL==gtk_widget_get_direction(widget);
#endif
    return FALSE;
}


#if GTK_MAJOR_VERSION>1
/* CPD Another HACK!!! */
struct _GtkRangeLayout
{
    GdkRectangle stepper_a,
                 stepper_b,
                 stepper_c,
                 stepper_d;
};

static gboolean is_stepper_a(GtkWidget * widget, gint x, gint y)
{
    if (GTK_IS_RANGE(widget))
    {
        GtkRange * range = GTK_RANGE(widget);
        return range->has_stepper_a && (range->layout->stepper_a.x == (x - widget->allocation.x))
                                    && (range->layout->stepper_a.y == (y - widget->allocation.y));
    }

    return FALSE;
}

/*
static gboolean is_stepper_b(GtkWidget * widget, gint x, gint y)
{
    if (GTK_IS_RANGE(widget))
    {   
        GtkRange *range = GTK_RANGE(widget);
        return range->has_stepper_b && (range->layout->stepper_b.x == (x - widget->allocation.x))
                                    && (range->layout->stepper_b.y == (y - widget->allocation.y));
    }

    return FALSE;
}

static gboolean is_stepper_c(GtkWidget * widget, gint x, gint y)
{
    if (GTK_IS_RANGE(widget))
    {   
        GtkRange *range = GTK_RANGE(widget);
        return range->has_stepper_c && (range->layout->stepper_c.x == (x - widget->allocation.x))
                                    && (range->layout->stepper_c.y == (y - widget->allocation.y));
    }

    return FALSE;
}
*/

static gboolean is_stepper_d(GtkWidget * widget, gint x, gint y)
{
    if (GTK_IS_RANGE(widget))
    {
        GtkRange *range = GTK_RANGE(widget);
        return range->has_stepper_d && (range->layout->stepper_d.x == (x - widget->allocation.x))
                                    && (range->layout->stepper_d.y == (y - widget->allocation.y));
    }

    return FALSE;
}

#endif

static int get_fill(GtkStateType state, gboolean set, gboolean allow_mouse_over_set)
{
    return GTK_STATE_INSENSITIVE==state
               ? 1
               : GTK_STATE_PRELIGHT==state
                   ? set && allow_mouse_over_set
                       ? SHADE_4_HIGHLIGHT
                       : SHADE_ORIG_HIGHLIGHT
                   : set || GTK_STATE_ACTIVE==state
                       ? 4
                       : ORIGINAL_SHADE;
}

static int qtc_get_round(const char *detail, GtkWidget *widget
#if GTK_MAJOR_VERSION>1
                        , int x, int y
#endif
                       )
{
    if(QTC_ROUNDED)
        if(detail)
            if(0==strcmp(detail, "slider"))
                return ROUNDED_NONE;
            else if(0==strcmp(detail, "splitter") || 0==strcmp(detail, "optionmenu")  ||
                    0==strcmp(detail, "togglebutton") || 0==strcmp(detail, "hscale") ||
                    0==strcmp(detail, "vscale") || 0==strcmp(detail, QTC_CHECKBOX)
                    /* || 0==strcmp(detail, "paned") || 0==strcmp(detail, QTC_PANED)*/ )
                return ROUNDED_ALL;
            else if(0==strcmp(detail, "spinbutton_up"))
                return ROUNDED_TOPRIGHT;
            else if(0==strcmp(detail, "spinbutton_down"))
                return ROUNDED_BOTTOMRIGHT;
            else if(0==strcmp(detail, "vscrollbar") || 0==strcmp(detail, "hscrollbar"))
            {
#if GTK_MAJOR_VERSION>1
                return is_stepper_a(widget, x, y)
                           ? 'h'==detail[0]
                               ? ROUNDED_LEFT
                               : ROUNDED_TOP
                           : is_stepper_d(widget, x, y)
                               ? 'v'==detail[0]
                                   ? ROUNDED_BOTTOM
                                   : ROUNDED_RIGHT
                               : ROUNDED_NONE;
#endif
                return ROUNDED_NONE;
            }
            else if(0==strcmp(detail, "button"))
            {
                if(is_list_view_header(widget))
                    return ROUNDED_NONE;
#if GTK_MAJOR_VERSION>1
                else if(is_combo_box_button(widget))
                    return ROUNDED_RIGHT;
#endif
                else
                    return ROUNDED_ALL;
            }

    return ROUNDED_NONE;
}

static gboolean is_horizontal_pbar(GtkWidget *widget)
{
    if(!widget ||
#if GTK_MAJOR_VERSION>1
       GTK_APP_MOZILLA==qt_settings.app ||
#endif
       !GTK_IS_PROGRESS_BAR(widget) 
      )
        return TRUE;

    switch(GTK_PROGRESS_BAR(widget)->orientation)
    {
        default:
        case GTK_PROGRESS_LEFT_TO_RIGHT:
        case GTK_PROGRESS_RIGHT_TO_LEFT:
            return TRUE;
        case GTK_PROGRESS_BOTTOM_TO_TOP:
        case GTK_PROGRESS_TOP_TO_BOTTOM:
            return FALSE;
    }
}

static int get_pbar_round(GtkWidget *widget)
{
#if GTK_MAJOR_VERSION>1
    if(!widget || !GTK_IS_PROGRESS_BAR(widget) ||
       GTK_APP_MOZILLA==qt_settings.app ||
       qtc_equal(gtk_progress_bar_get_fraction(GTK_PROGRESS_BAR(widget)), 100.0)
      )
        return ROUNDED_NONE;

    switch(GTK_PROGRESS_BAR(widget)->orientation)
    {
        default:
        case GTK_PROGRESS_LEFT_TO_RIGHT:
            return ROUNDED_RIGHT;
        case GTK_PROGRESS_RIGHT_TO_LEFT:
            return ROUNDED_LEFT;
        case GTK_PROGRESS_BOTTOM_TO_TOP:
            return ROUNDED_TOP;
        case GTK_PROGRESS_TOP_TO_BOTTOM:
            return ROUNDED_BOTTOM;
    }
#else
    return ROUNDED_NONE;
#endif
}

static GdkGC * get_parent_bg_gc(GtkWidget *widget)
{
    if(GTK_IS_SCROLLBAR(widget))
        widget=widget->parent;

    return widget && widget->parent && widget->parent->style
               ? widget->parent->style->bg_gc[widget->parent->state]
               : NULL;
}

static void draw_bgnd(GdkWindow *window, GdkGC *gc, GtkWidget *widget, GdkRectangle *area, int x, int y, int width,
                     int height)
{
    GdkGC *parent_gc=get_parent_bg_gc(widget),
          *bgnd_gc=QTC_ROUNDED && parent_gc
                       ? parent_gc
                       : gc;

    if(area)
        gdk_gc_set_clip_rectangle(bgnd_gc, area);
    gdk_draw_rectangle(window, bgnd_gc, TRUE, x, y, width, height);
    if(area)
        gdk_gc_set_clip_rectangle(bgnd_gc, NULL);
}

static void shade(GdkColor * a, GdkColor * b, float k)
{
    if(qtc_equal(k, 1.0))
    {
        b->red = a->red;
        b->green = a->green;
        b->blue = a->blue;
    }
    else
    {
        gdouble red =(gdouble) a->red / 65535.0,
                green =(gdouble) a->green / 65535.0,
                blue =(gdouble) a->blue / 65535.0;

        qtc_rgb2hls(&red, &green, &blue);

        green *= k;
        if(green > 1.0)
            green = 1.0;
        else if(green < 0.0)
            green = 0.0;

        blue *= k;
        if(blue > 1.0)
            blue = 1.0;
        else if(blue < 0.0)
            blue = 0.0;

        qtc_hls2rgb(&red, &green, &blue);

        b->red = red * 65535.0;
        b->green = green * 65535.0;
        b->blue = blue * 65535.0;
    }
}

static void draw_area_color(GtkStyle *style, GdkWindow *window, GdkRectangle *area, GdkRegion *region,
                            GdkColor *col, gint x, gint y, gint width, gint height)
{
    GdkGCValues old_values;
    GdkGC       *gc=style->bg_gc[0];

    gdk_gc_get_values(gc, &old_values);

    if(area)
        gdk_gc_set_clip_rectangle(gc, area);
    else if(region)
        gdk_gc_set_clip_region(gc, region);

    gdk_rgb_find_color(style->colormap, col);
    gdk_gc_set_foreground(gc, col);
    gdk_draw_rectangle(window, gc, TRUE, x, y, width, height);
    gdk_gc_set_foreground(gc, &old_values.foreground);

    if(area)
        gdk_gc_set_clip_rectangle(gc, NULL);
    else if(region)
        gdk_gc_set_clip_region(gc, NULL);
}

static void draw_area_mod_color(GtkStyle *style, GdkWindow *window, GdkRectangle *area, GdkRegion *region,
                                GdkColor *orig, double mod, gint x, gint y, gint width, gint height)
{
    GdkColor modified;

    if(!qtc_equal(mod, 0.0))
        shade(orig, &modified, mod);
    else
        modified=*orig;

    draw_area_color(style, window, area, region, &modified, x, y, width, height);
}

#define draw_area_mod(/* GtkStyle *     */  style, \
                      /* GdkWindow *    */  window, \
                      /* GtkStateType   */  state, \
                      /* GdkRectangle * */  area, \
                      /* GdkRegion *    */  region, \
                      /* double         */  mod, \
                      /* gint           */  x, \
                      /* gint           */  y, \
                      /* gint           */  width, \
                      /* gint           */  height) \
    draw_area_mod_color(style, window, area, region, &style->bg[state], mod, x, y, width, height)

#if GTK_MAJOR_VERSION>1
static void constrain_rect(GdkRectangle *rect, GdkRectangle *con)
{
    if(rect && con)
    {
        if(rect->x<con->x)
        {
            rect->width-=(con->x-rect->x);
            rect->x=con->x;
        }
        if(rect->y<con->y)
        {
            rect->height-=(rect->y-con->y);
            rect->y=con->y;
        }
        if((rect->x+rect->width)>(con->x+con->width))
            rect->width-=(rect->x+rect->width)-(con->x+con->width);
        if((rect->y+rect->height)>(con->y+con->height))
            rect->height-=(rect->y+rect->height)-(con->y+con->height);
    }
}
#endif

static void draw_flat_box(GtkStyle *style, GdkWindow *window, GtkStateType state,
                          GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                          PCONST gchar *detail, gint x, gint y, gint width,gint height);
static void draw_box(GtkStyle *style, GdkWindow *window, GtkStateType state,
                     GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                     PCONST gchar *detail, gint x, gint y, gint width, gint height);
static void draw_box_qtc(GtkStyle *style, GdkWindow *window, GtkStateType state,
                         GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                         PCONST gchar *detail, gint x, gint y, gint width, gint height,
                         gboolean btn_down);
static void draw_shadow(GtkStyle *style, GdkWindow *window, GtkStateType state,
                        GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                        PCONST gchar *detail, gint x, gint y, gint width, gint height);

static gboolean sanitize_size(GdkWindow *window, gint *width, gint *height)
{
    gboolean set_bg = FALSE;

    if((-1==*width) && (-1==*height))
    {
#if GTK_MAJOR_VERSION>1
        set_bg = GDK_IS_WINDOW(window);
#endif
        gdk_window_get_size(window, width, height);
    }
    else if(-1==*width)
        gdk_window_get_size(window, width, NULL);
    else if(-1==*height)
        gdk_window_get_size(window, NULL, height);

  return set_bg;
}

static void draw_gradient(GdkWindow *window, GdkGC *gc, GdkColormap *colormap, GdkRectangle *area,
                          GdkRegion *region, int x, int y, int width, int height,
                          GdkColor *begin_color, GdkColor *end_color, gboolean horiz,
                          gboolean increase)
{
    if(width>0 && height>0)
    {
        GdkColor     col=*begin_color;
        int          i,
                     last=horiz ? height : width,
                     dr=(end_color->red - begin_color->red) / last,
                     dg=(end_color->green - begin_color->green) / last,
                     db=(end_color->blue - begin_color->blue) / last;
        GdkRectangle clip;
        GdkGCValues  old_values;

        clip.x = x;
        clip.y = y;
        clip.width = width;
        clip.height = height;

        gdk_gc_get_values(gc, &old_values);

        if(area)
        {
            GdkRectangle clip2;

            if(gdk_rectangle_intersect(area, &clip, &clip2))
                gdk_gc_set_clip_rectangle(gc, gdk_rectangle_intersect(area, &clip, &clip2)
                                                  ? &clip2 : &clip);
        }
        else if(region)
            gdk_gc_set_clip_region(gc, region);

        if(increase)
            for(i = 0; i < last; i++)
            {
                gdk_rgb_find_color(colormap, &col);
                gdk_gc_set_foreground(gc, &col);
                if(horiz)
                    gdk_draw_line(window, gc, x, y + i, x + width - 1, y + i);
                else
                    gdk_draw_line(window, gc, x + i, y,  x + i, y + height - 1);
                col.red += dr;
                col.green += dg;
                col.blue += db;
            }
        else
            for(i=last-1; i>=0; i--)
            {
                gdk_rgb_find_color(colormap, &col);
                gdk_gc_set_foreground(gc, &col);
                if(horiz)
                    gdk_draw_line(window, gc, x, y + i, x + width - 1, y + i);
                else
                    gdk_draw_line(window, gc, x + i, y,  x + i, y + height - 1);
                col.red += dr;
                col.green += dg;
                col.blue += db;
            }

        gdk_gc_set_foreground(gc, &old_values.foreground);
        if(area)
            gdk_gc_set_clip_rectangle(gc, NULL);
        else if(region)
            gdk_gc_set_clip_region(gc, NULL);
    }
}

static void draw_bevel_gradient(GtkStyle *style, GdkWindow *window, GdkGC *gc, GdkColormap *colormap,
                                GdkRectangle *area, GdkRegion *region, int x, int y, int width,
                                int height, GdkColor *base, double shade_top, double shade_bot,
                                gboolean horiz, gboolean increase, gboolean sel, EAppearance bevApp,
                                EWidget w)
{
    EAppearance app=APPEARANCE_BEVELLED!=bevApp || WIDGET_BUTTON(w) || WIDGET_LISTVIEW_HEADER==w
                        ? bevApp
                        : APPEARANCE_GRADIENT;

    if(!sel && IS_GLASS(app))
    {
        if(WIDGET_TAB_BOT==w)
        {
            double t=shade_top;
            shade_top=shade_bot;
            shade_bot=t;
        }

        {  /* C variable scoping */
        double   shadeTopA=WIDGET_TAB_BOT==w ? 1.0 : shade_top*SHADE_GLASS_TOP_A(app, w),
                 shadeTopB=WIDGET_TAB_BOT==w ? 1.0 : shade_top*SHADE_GLASS_TOP_B(app, w),
                 shadeBotA=WIDGET_TAB_TOP==w ? 1.0 : shade_bot*SHADE_GLASS_BOT_A(app),
                 shadeBotB=WIDGET_TAB_TOP==w ? 1.0 : shade_bot*SHADE_GLASS_BOT_B(app);
        GdkColor topA,
                 topB,
                 botA,
                 botB;
        int      x1=x, x2=x, x3=x, y1=y, y2=y, y3=y,
                 height1=height, height2=height, height3=height,
                 width1=width, width2=width, width3=width;

        topA.pixel=botA.pixel=topB.pixel=botB.pixel=0;
        shade(base, &topA, shadeTopA);
        shade(base, &topB, shadeTopB);
        shade(base, &botA, shadeBotA);
        shade(base, &botB, shadeBotB);

        if(APPEARANCE_SHINY_GLASS==app)
        {
            int shadeBorder=(int)(((horiz ? height : width)*GLASS_BORDER)+0.5);

/*
            if(shadeBorder>GLASS_MAX_PIXELS)
                shadeBorder=GLASS_MAX_PIXELS;
*/
            if(horiz)
            {
                height1=height3=shadeBorder;
                height2=height-(height1+height3);
                y2=y+height1;
                y3=y2+height2;
            }
            else
            {
                width1=width3=shadeBorder;
                width2=width-(width1+width3);
                x2=x+width1;
                x3=x2+width2;
            }

            draw_gradient(window, gc, colormap, area, region, x1, y1, width1, height1, &topA, &topB,
                          horiz, TRUE);
            draw_area_color(style, window, area, region, WIDGET_TAB_BOT==w ? &topA : &botA, x2, y2, width2,
                            height2);
            draw_gradient(window, gc, colormap, area, region, x3, y3, width3, height3, &botA, &botB,
                          horiz, TRUE);
        }
        else
        {
            if(horiz)
            {
                height1/=2;
                y2+=height1;
                height2-=height1;
            }
            else
            {
                width1/=2;
                x2+=width1;
                width2-=width1;
            }

            draw_gradient(window, gc, colormap, area, region, x1, y1, width1, height1, &topA, &topB,
                          horiz, increase);
            draw_gradient(window, gc, colormap, area, region, x2, y2, width2, height2, &botA, &botB,
                          horiz, increase);
        }
        }
    }
    else if(!sel && APPEARANCE_BEVELLED==app &&
            ((horiz ? height : width) > (((WIDGET_BUTTON(w) ? 2 : 1)*BEVEL_BORDER(w))+4)))
    {
        if(WIDGET_LISTVIEW_HEADER==w)
        {
            GdkColor bot;
            int      x1=x, x2=x, y1=y, y2=y,
                     height1=height, height2=height,
                     width1=width, width2=width;

            if(horiz)
            {
                height2=BEVEL_BORDER(w);
                height1=height-height2;
                y2=y+height1;
            }
            else
            {
                width2=BEVEL_BORDER(w);
                width1=width-width2;
                x2=x+width1;
            }
            bot.pixel=0;
            shade(base, &bot, SHADE_BEVEL_BOT(w));
            draw_area_color(style, window, area, region, base, x1, y1, width1, height1);
            draw_gradient(window, gc, colormap, area, region, x2, y2, width2, height2, base,
                          &bot, horiz, TRUE);
        }
        else
        {
            GdkColor bot,
                     midTop,
                     midBot,
                     top;
            int      x1=x, x2=x, x3=x, y1=y, y2=y, y3=y,
                     height1=height, height2=height, height3=height,
                     width1=width, width2=width, width3=width;

            bot.pixel=midTop.pixel=midBot.pixel=top.pixel=0;

            if(horiz)
            {
                height1=height3=BEVEL_BORDER(w);
                height2=height-(height1+height3);
                y2=y+height1;
                y3=y2+height2;
            }
            else
            {
                width1=width3=BEVEL_BORDER(w);
                width2=width-(width1+width3);
                x2=x+width1;
                x3=x2+width2;
            }

            shade(base, &top, SHADE_BEVEL_TOP);
            shade(base, &midTop, SHADE_BEVEL_MID_TOP);
            shade(base, &midBot, SHADE_BEVEL_MID_BOT);
            shade(base, &bot, SHADE_BEVEL_BOT(w));

            draw_gradient(window, gc, colormap, area, region, x1, y1, width1, height1, &top,
                          &midTop, horiz, TRUE);
            draw_gradient(window, gc, colormap, area, region, x2, y2, width2, height2, &midTop,
                          &midBot, horiz, TRUE);
            draw_gradient(window, gc, colormap, area, region, x3, y3, width3, height3, &midBot,
                          &bot, horiz, TRUE);
        }
    }
    else
    {
        GdkColor top,
                 bot,
                 *t,
                 *b;

        top.pixel=bot.pixel=0;

        if(qtc_equal(1.0, shade_top))
            t=base;
        else
        {
            shade(base, &top, shade_top);
            t=&top;
        }
        if(qtc_equal(1.0, shade_bot))
            b=base;
        else
        {
            shade(base, &bot, shade_bot);
            b=&bot;
        }

        draw_gradient(window, gc, colormap, area, region, x, y, width, height, t, b, horiz,
                      sel || APPEARANCE_INVERTED!=app ? increase : !increase);
    }
}

static void draw_lines(GdkWindow *window, int rx, int ry, int rwidth, int rheight, gboolean horiz,
                       int n_lines, int offset, GdkGC *gcs[], GdkRectangle *area, gboolean etched,
                       int dark, int etchedDisp)
{
    int   space =(n_lines*2)+(etchedDisp ? (n_lines-1) : 0),
          step = etchedDisp ? 3 : 2,
          x = horiz ? rx : rx+((rwidth-space)>>1),
          y = horiz ? ry+((rheight-space)>>1) : ry,
          x2 = rx + rwidth-1,
          y2 = ry + rheight-1,
          i,
          displacement = etched ? etchedDisp : 0;
    GdkGC *gc1 = gcs[etched ? dark : 0],
          *gc2 = gcs[etched ? 0 : dark];

    if(area)
    {
        gdk_gc_set_clip_rectangle(gc1, area);
        gdk_gc_set_clip_rectangle(gc2, area);
    }
    if(horiz)
    {
        for(i=0; i<space; i+=step)
            gdk_draw_line(window, gc1, x+offset, y+i, x2-(offset+displacement), y+i);

        for(i=1; i<space; i+=step)
             gdk_draw_line(window, gc2, x+offset+displacement, y+i, x2-offset, y+i);
    }  
    else
    {
        for(i=0; i<space; i+=step)
            gdk_draw_line(window, gc1, x+i, y+offset, x+i, y2-(offset+displacement));

        for(i=1; i<space; i+=step)
            gdk_draw_line(window, gc2, x+i, y+offset+displacement, x+i, y2-offset);
    }
    if(area)
    {
        gdk_gc_set_clip_rectangle(gc1, NULL);
        gdk_gc_set_clip_rectangle(gc2, NULL);
    }
}

static void draw_dots(GdkWindow *window, int rx, int ry, int rwidth, int rheight, gboolean horiz,
                      int n_lines, int offset, GdkGC *gcs[], GdkRectangle *area, int startOffset,
                      int dark)
{
    int   space =(n_lines*2)+(n_lines-1),
          x = horiz ? rx : rx+((rwidth-space)>>1),
          y = horiz ? ry+((rheight-space)>>1) : ry,
          i, j,
          numDots=(horiz ? (rwidth-(2*offset))/3 : (rheight-(2*offset))/3)+1;
    GdkGC *gc1 = gcs[dark],
          *gc2 = gcs[0];

    if(area)
    {
        gdk_gc_set_clip_rectangle(gc1, area);
        gdk_gc_set_clip_rectangle(gc2, area);
    }

    if(horiz)
    {
        if(startOffset && y+startOffset>0)
            y+=startOffset;

        for(i=0; i<space; i+=3)
            for(j=0; j<numDots; j++)
                gdk_draw_point(window, gc1, x+offset+(3*j), y+i);

        for(i=1; i<space; i+=3)
            for(j=0; j<numDots; j++)
                gdk_draw_point(window, gc2, x+offset+1+(3*j), y+i);
    }
    else
    {
        if(startOffset && x+startOffset>0)
            x+=startOffset;

        for(i=0; i<space; i+=3)
            for(j=0; j<numDots; j++)
                gdk_draw_point(window, gc1, x+i, y+offset+(3*j));

        for(i=1; i<space; i+=3)
            for(j=0; j<numDots; j++)
                gdk_draw_point(window, gc2, x+i, y+offset+1+(3*j));
    }
    if(area)
    {
        gdk_gc_set_clip_rectangle(gc1, NULL);
        gdk_gc_set_clip_rectangle(gc2, NULL);
    }
}

/* NOTE: This function *really* needs cleaning and splitting up - way too many params! */
static void draw_3d_border(GtkStyle *style, GdkWindow *window, GtkStateType state, GdkRectangle *area,
                           gint x, gint y, gint width, gint height, gboolean largeArc,
                           GdkGC *outer_gc, GdkColor *outer_col, GdkGC *gc1, GdkGC *gc2,
                           GdkGC **btn_gcs, GdkColor *btn_colors, int round, gboolean draw_inside,
                           gboolean bevelledButton, EBorder borderProfile, gboolean blend, gboolean do_corners)
{
    GdkGC *midgc=NULL;

    if(ROUND_FULL!=opts.round)
        largeArc=FALSE;

    if(ROUND_NONE==opts.round)
        round=ROUNDED_NONE;

    if(area)
    {
        int i=0; 

        gdk_gc_set_clip_rectangle(outer_gc, area);
        gdk_gc_set_clip_rectangle(gc1, area);
        gdk_gc_set_clip_rectangle(gc2, area);
        for(i=0; i<TOTAL_SHADES+1; ++i)
            if(btn_gcs[i]!=gc1 && btn_gcs[i]!=gc2 && btn_gcs[i]!=outer_gc)
                gdk_gc_set_clip_rectangle(btn_gcs[i], area);
    }

    if(!IS_GLASS(opts.appearance) && draw_inside)
    {
        /* Top and left */
        if(QT_STYLE->ythickness > 0)
            gdk_draw_line(window, gc2, x + 1, y + 1, x + width - 2, y + 1);
        if(QT_STYLE->xthickness > 0)
            gdk_draw_line(window, gc2, x + 1, y + 1, x + 1, y + height - 2);

        if(bevelledButton || APPEARANCE_FLAT==opts.appearance)
        {
            /* Right and bottom edge */
            if(QT_STYLE->ythickness > 0)
                gdk_draw_line(window, gc1, x + 1, y + height - 2, x + width - 2, y + height - 2);
            if(QT_STYLE->xthickness > 0)
                gdk_draw_line(window, gc1, x + width - 2, y + 1, x + width - 2, y + height - 2);
        }
    }

    switch(borderProfile)
    {
        case BORDER_FLAT:
            break;
        case BORDER_RAISED:
        case BORDER_SUNKEN:
        {
            if(GTK_STATE_INSENSITIVE!=state)
                if(blend)
                    midgc=QTC_SET_MID_COLOR(btn_colors[BORDER_RAISED==borderProfile ? 0 : 4],
                                      style->base[GTK_STATE_NORMAL])
                else
                    midgc=btn_gcs[BORDER_RAISED==borderProfile ? 0 : 4];
            else
                midgc=style->bg_gc[state];

            gdk_draw_line(window, midgc, x+1, y+1, x+1, y+height-2);
            gdk_draw_line(window, midgc, x+1, y+1, x+width-2, y+1);
            if(GTK_STATE_INSENSITIVE!=state)
                if(blend)
                    midgc=QTC_SET_MID_COLOR(btn_colors[BORDER_RAISED==borderProfile ? 4 : 0],
                                            style->base[GTK_STATE_NORMAL])
                else
                    midgc=btn_gcs[BORDER_RAISED==borderProfile ? 4 : 0];
            else
                midgc=style->bg_gc[state];

            gdk_draw_line(window, midgc, x+width-2, y+1, x+width-2, y+height-2);
            gdk_draw_line(window, midgc, x+1, y+height-2, x+width-2, y+height-2);
        }
    }

    if(ROUNDED_NONE==round)
        gdk_draw_rectangle(window, outer_gc, FALSE, x, y, width - 1, height - 1);
    else
    {
        GdkGC *midgc2=style->bg_gc[GTK_STATE_NORMAL];

        midgc=QTC_SET_MID_COLOR(*outer_col, style->bg[GTK_STATE_NORMAL])
        if(!largeArc && do_corners)
            midgc2=QTC_SET_MID_COLOR2(1, btn_colors[3], style->bg[GTK_STATE_NORMAL])

        gdk_draw_line(window, outer_gc, x+1, y, x+width-2, y);
        gdk_draw_line(window, outer_gc, x+1, y+height-1, x+width-2, y+height-1);
        gdk_draw_line(window, outer_gc, x, y+1, x, y+height-2);
        gdk_draw_line(window, outer_gc, x+width-1, y+1, x+width-1, y+height-2);

        if(round&CORNER_TL)
        {
            if(largeArc)
            {
                gdk_draw_point(window, outer_gc, x+1, y+1);
                gdk_draw_line(window, midgc, x, y+1, x+1, y);
            }
            if(do_corners)
                gdk_draw_point(window, midgc2, x, y);
        }
        else
            gdk_draw_point(window, outer_gc, x, y);

        if(round&CORNER_TR)
        {
            if(largeArc)
            {
                gdk_draw_point(window, outer_gc, x+width-2, y+1);
                gdk_draw_line(window, midgc, x+width-2, y, x+width-1, y+1);
            }
            if(do_corners)
                gdk_draw_point(window, midgc2, x+width-1, y);
        }
        else
            gdk_draw_point(window, outer_gc, x+width-1, y);

        if(round&CORNER_BR)
        {
            if(largeArc)
            {
                gdk_draw_point(window, outer_gc, x+width-2, y+height-2);
                gdk_draw_line(window, midgc, x+width-2, y+height-1, x+width-1, y+height-2);
            }
            if(do_corners)
                gdk_draw_point(window, midgc2, x+width-1, y+height-1);
        }
        else
            gdk_draw_point(window, outer_gc, x+width-1, y+height-1);

        if(round&CORNER_BL)
        {
            if(largeArc)
            {
                gdk_draw_point(window, outer_gc, x+1, y+height-2);
                gdk_draw_line(window, midgc, x, y+height-2, x+1, y+height-1);
            }
            if(do_corners)
                gdk_draw_point(window, midgc2, x, y+height-1);
        }
        else
            gdk_draw_point(window, outer_gc, x, y+height-1);
    }

    if(area)
    {
        int i=0;

        gdk_gc_set_clip_rectangle(outer_gc, NULL);
        gdk_gc_set_clip_rectangle(gc1, NULL);
        gdk_gc_set_clip_rectangle(gc2, NULL);
        for(i=0; i<TOTAL_SHADES+1; ++i)
            if(btn_gcs[i]!=gc1 && btn_gcs[i]!=gc2 && btn_gcs[i]!=outer_gc)
                gdk_gc_set_clip_rectangle(btn_gcs[i], NULL);
    }
}

static void qtc_draw_box_gap(GtkStyle *style, GdkWindow *window, GtkShadowType shadow_type, GtkStateType state,
                             GtkWidget *widget, GdkRectangle *area, gint x, gint y, gint width,
                             gint height, GtkPositionType gap_side, gint gap_x, gint gap_width,
                             EBorder borderProfile, gboolean isTab)
{
    QT_CURVE_STYLE_VAR

    FN_CHECK

    gtk_style_apply_default_background(style, window, widget && !GTK_WIDGET_NO_WINDOW(widget), state,
                                       area, x, y, width, height);
    sanitize_size(window, &width, &height);

    if(QTC_ROUNDED)
    {
        if(GTK_SHADOW_NONE!=shadow_type)
            draw_3d_border(widget && widget->parent ? widget->parent->style : style,
                           window, state, area, x, y, width, height, TRUE, qtcurve_style->gray_gc[5],
                           &(qtcurve_style->gray[5]), qtcurve_style->gray_gc[0], qtcurve_style->gray_gc[0],
                           qtcurve_style->gray_gc, qtcurve_style->gray,
                           ROUNDED_ALL, FALSE, FALSE, borderProfile, !isTab, TRUE);
    }
    else
    {
        GdkGC *outer_gc=qtcurve_style->gray_gc[5],
              *gc1 = NULL,
              *gc2 = NULL;

        if(area)
        {
            gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[5], area);
            gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[4], area);
            gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[0], area);
        }

        switch(shadow_type)
        {
            case GTK_SHADOW_NONE:
                return;
            case GTK_SHADOW_ETCHED_IN:
                gdk_draw_rectangle(window, qtcurve_style->gray_gc[0], FALSE, x+1, y+1, width-2, height-2);
                gdk_draw_rectangle(window, qtcurve_style->gray_gc[5], FALSE, x, y, width-2, height-2);
                break;
            case GTK_SHADOW_ETCHED_OUT:
                gdk_draw_rectangle(window, qtcurve_style->gray_gc[0], FALSE, x, y, width-2, height-2);
                gdk_draw_rectangle(window, qtcurve_style->gray_gc[5], FALSE, x+1, y+1, width-2, height-2);
                break;
            case GTK_SHADOW_IN:
            case GTK_SHADOW_OUT:
                gdk_draw_rectangle(window, qtcurve_style->gray_gc[5], FALSE, x, y, width-1, height-1);
                gdk_draw_line(window, qtcurve_style->gray_gc[GTK_SHADOW_ETCHED_IN==shadow_type ? 4 : 0],
                              x+1, y+1, x+1, y+height-2);
                gdk_draw_line(window, qtcurve_style->gray_gc[GTK_SHADOW_ETCHED_IN==shadow_type ? 4 : 0],
                              x+1, y+1, x+width-2, y+1);

                gdk_draw_line(window, qtcurve_style->gray_gc[GTK_SHADOW_ETCHED_IN==shadow_type ? 0 : 4],
                              x+1, y+height-2, x+width-2, y+height-2);
                gdk_draw_line(window, qtcurve_style->gray_gc[GTK_SHADOW_ETCHED_IN==shadow_type ? 0 : 4],
                              x+width-2, y+1, x+width-2, y+height-2);
        }

        if(area)
        {
            gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[5], NULL);
            gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[4], NULL);
            gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[0], NULL);
        }
    }

    if(gap_width>0)
    {
        if(area)
            gdk_gc_set_clip_rectangle(style->bg_gc[state], area);

        switch(gap_side)
        {
            case GTK_POS_TOP:
                gdk_draw_line(window, style->bg_gc[state], (x+gap_x)-1, y, (x+gap_x+gap_width)-1, y);
                gdk_draw_line(window, style->bg_gc[state], (x+gap_x)-1, y+1, (x+gap_x+gap_width)-1, y+1);
                break;
            case GTK_POS_BOTTOM:
                gdk_draw_line(window, style->bg_gc[state], (x+gap_x)-1, y+height-1,
                              (x+gap_x+gap_width)-1, y+height-1);
                gdk_draw_line(window, style->bg_gc[state], (x+gap_x)-1, y+height-2,
                              (x+gap_x+gap_width)-1, y+height-2);
                break;
            case GTK_POS_LEFT:
                gdk_draw_line(window, style->bg_gc[state], x, (y+gap_x)-1, x, (y+gap_x+gap_width)-1);
                gdk_draw_line(window, style->bg_gc[state], x+1, (y+gap_x)-1, x+1, (y+gap_x+gap_width)-1);
                break;
            case GTK_POS_RIGHT:
                gdk_draw_line(window, style->bg_gc[state], x+width-1, (y+gap_x)-1,
                              x+width-1, (y+gap_x+gap_width)-1);
                gdk_draw_line(window, style->bg_gc[state], x+width-2, (y+gap_x)-1,
                              x+width-2, (y+gap_x+gap_width)-1);
                break;
        }

        if(area)
            gdk_gc_set_clip_rectangle(style->bg_gc[state], NULL);
    }
}

static void draw_entry_field(GtkStyle *style, GdkWindow *window, GtkStateType state,
                             GtkWidget *widget, GdkRectangle *area, gint x, gint y, gint width,
                             gint height, int round)
{
    QT_CURVE_STYLE_VAR
    GdkGC    *new_gcs[TOTAL_SHADES+1],
             **gcs=NULL,
             *bgnd_gc=style->bg_gc[state],
             *gc=NULL,
             *midgc=NULL;
    GdkColor new_colors[TOTAL_SHADES+1],
             *colors;
    gboolean custom_c = FALSE,
             highlight= opts.highlightEdits && GTK_WIDGET_HAS_FOCUS(widget);

#ifdef QTC_DEBUG
printf("Draw entry_field %d %d %d %d %d %d ", state, x, y, width, height, round);
display_widget(widget, 3);
#endif

    if(highlight)
    {
        custom_c=TRUE;
        shade_colors(&(qtcurve_style->menuitem[state]), new_colors);
        GEN_GCS(style, new_colors, new_gcs);
        gcs=new_gcs;
        colors=new_colors;
    }
    else
    {
        colors=qtcurve_style->gray;
        gcs=qtcurve_style->gray_gc;
    }

    if(ROUNDED_ALL!=round && !highlight)
        width++;

    midgc=QTC_SET_MID_COLOR(style->base[state], colors[3])

    gdk_draw_line(window, midgc, x+1, y+1, x+1, y+height-2);
    gdk_draw_line(window, midgc, x+1, y+1, x+width-1, y+1);

    if(GTK_STATE_INSENSITIVE==state || !GTK_WIDGET_IS_SENSITIVE(widget))
        gc=style->bg_gc[state];
    else
    {
        midgc=QTC_SET_MID_COLOR(style->base[state], colors[0])
        gc=midgc;
    }

    gdk_draw_line(window, gc, x+width-2, y+1, x+width-2, y+height-2);
    gdk_draw_line(window, gc, x+1, y+height-2, x+width-2, y+height-2);

    gdk_draw_point(window, bgnd_gc, x, y);
    gdk_draw_point(window, bgnd_gc, x+width-1, y);
    gdk_draw_point(window, bgnd_gc, x, y+height-1);
    gdk_draw_point(window, bgnd_gc, x+width-1, y+height-1);
    draw_3d_border(widget && widget->parent ? widget->parent->style : style,
                   window, state, area, x, y, width, height, TRUE, gcs[5], &(colors[5]), gcs[0],
                   gcs[0], gcs, colors, round, FALSE, FALSE, BORDER_FLAT, FALSE, TRUE);

    if(custom_c)
        RELEASE_GCS(new_gcs);
}

static void draw_check(GtkStyle *style, GdkWindow *window, GtkStateType state,
                       GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                       PCONST gchar *detail, gint x, gint y, gint width, gint height)
{
    QT_CURVE_STYLE_VAR
    gboolean mnu=DETAIL("check"),
             list=!mnu && is_list(widget),
             on=GTK_SHADOW_IN==shadow_type,
             tri=GTK_SHADOW_ETCHED_IN==shadow_type;
    GdkGC    *new_gcs[TOTAL_SHADES+1],
             **btn_gcs=NULL;
    GdkColor new_colors[TOTAL_SHADES+1],
             *btn_colors;
    gboolean custom_c = FALSE;
    int      ind_state=!mnu && GTK_STATE_INSENSITIVE==state ? state : GTK_STATE_NORMAL;

    if(QT_CUSTOM_COLOR_BUTTON(style))
    {
        custom_c=TRUE;
        shade_colors(&(style->bg[state]), new_colors);
        GEN_GCS(style, new_colors, new_gcs);
        btn_gcs=new_gcs;
        btn_colors=new_colors;
    }
    else
    {
        btn_colors=qtcurve_style->button;
        btn_gcs=qtcurve_style->button_gc;
    }

    x+=(width-QTC_CHECK_SIZE)>>1;
    y+=(height-QTC_CHECK_SIZE)>>1;

    if(mnu)
    {
        y+=2;
#if GTK_MAJOR_VERSION>1
        if(GTK_APP_MOZILLA==qt_settings.app)
            x+=2;
        else
#endif
            x-=2;
    }

#ifdef QTC_DEBUG
printf("Draw check %d %d %d %s  ", state, shadow_type, mnu, detail ? detail : "NULL");
display_widget(widget, 3);
#endif

    if(list)
    {
        if(area)
            gdk_gc_set_clip_rectangle(style->text_gc[state], area);

        x++; y++;
        gdk_draw_rectangle(window, style->text_gc[state], FALSE, x, y, QTC_CHECK_SIZE-1,
                           QTC_CHECK_SIZE-1);
        gdk_draw_rectangle(window, style->text_gc[state], FALSE, x+1, y+1, QTC_CHECK_SIZE-3,
                           QTC_CHECK_SIZE-3);

        if(area)
            gdk_gc_set_clip_rectangle(style->text_gc[state], NULL);
    }
    else if(!mnu)
        draw_box_qtc(style, window, state,
                     GTK_SHADOW_ETCHED_IN==shadow_type ? GTK_SHADOW_IN : shadow_type,
                     area, widget, QTC_CHECKBOX, x, y, width,
                     height, on || tri || GTK_STATE_ACTIVE==state);

    if(area && (on || tri))
    {
        gdk_gc_set_clip_rectangle(style->text_gc[ind_state], area);
        if(mnu)
        {
            gdk_gc_set_clip_rectangle(btn_gcs[0], area);
            gdk_gc_set_clip_rectangle(btn_gcs[5], area);
            gdk_gc_set_clip_rectangle(btn_gcs[2], area);
        }
    }

    if(on)
    {
        int      i;
        GdkPoint check[3]={ {x+3, y+4}, {x+5, y+6}, {x+9, y+2} };

        if(mnu)
        {
            gint x_mnu=x-1, y_mnu=y-1, width_mnu=QTC_CHECK_SIZE+2, height_mnu=QTC_CHECK_SIZE+2;

            draw_area_mod_color(style, window, area, NULL, &btn_colors[2],
                                opts.lighterPopupMenuBgnd ? POPUPMENU_LIGHT_FACTOR : 0.0,
                                x_mnu+1, y_mnu+1, width_mnu-2, height_mnu-2);

            gdk_draw_line(window, btn_gcs[5], x_mnu, y_mnu, x_mnu, y_mnu+height_mnu-1);
            gdk_draw_line(window, btn_gcs[5], x_mnu, y_mnu, x_mnu+width_mnu-1, y_mnu);
            gdk_draw_line(window, btn_gcs[0], x_mnu, y_mnu+height_mnu-1, x_mnu+width_mnu-1,
                          y_mnu+height_mnu-1);
            gdk_draw_line(window, btn_gcs[0], x_mnu+width_mnu-1, y_mnu, x_mnu+width_mnu-1,
                          y_mnu+height_mnu-1);
        }

        for(i=0; i<3; i++)
        {
            check[0].y++;
            check[1].y++;
            check[2].y++;
            gdk_draw_lines(window, style->text_gc[ind_state], check, 3);
        }
    }
    else if (tri)
    {
        int tx=x+(QTC_CHECK_SIZE/2),
            ty=y+(QTC_CHECK_SIZE/2);

        gdk_draw_line(window, style->text_gc[ind_state], tx-3, ty, tx+3, ty);
        gdk_draw_line(window, style->text_gc[ind_state], tx-3, ty+1, tx+3, ty+1);
    }

    if(area && (on || tri))
    {
        gdk_gc_set_clip_rectangle(style->text_gc[ind_state], NULL);
        if(mnu)
        {
            gdk_gc_set_clip_rectangle(btn_gcs[0], NULL);
            gdk_gc_set_clip_rectangle(btn_gcs[5], NULL);
            gdk_gc_set_clip_rectangle(btn_gcs[2], NULL);
        }
    }

    if(custom_c)
        RELEASE_GCS(new_gcs);
}

static void draw_option(GtkStyle *style, GdkWindow *window, GtkStateType state,
                        GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                        PCONST gchar *detail, gint x, gint y, gint width, gint height)
{
    QT_CURVE_STYLE_VAR
    gboolean mnu=DETAIL("option"),
             list=!mnu && is_list(widget);

    if(mnu)
        draw_check(style, window, state, shadow_type, area, widget, "check", x, y, width, height);
    else
    {
        gboolean on=GTK_SHADOW_IN==shadow_type,
                 tri=GTK_SHADOW_ETCHED_IN==shadow_type,
                 set=on||tri;
        int      ind_state=GTK_STATE_INSENSITIVE==state ? state : GTK_STATE_NORMAL;
        GdkGC    *midgc=NULL;

        x+=(width-QTC_RADIO_SIZE)>>1;
        y+=(height-QTC_RADIO_SIZE)>>1;

        { /* So can modify X above, and then declare outer... */
        GdkPoint outer[24]={ {x, y+8}, {x, y+4}, {x+1, y+3}, {x+1, y+2}, {x+2, y+1}, {x+3, y+1},
                        {x+4, y}, {x+8, y}, {x+9, y+1}, {x+10, y+1}, {x+11, y+2}, {x+11, y+3},
                        {x+12, y+4}, {x+12, y+8}, {x+11, y+9}, {x+11, y+10}, {x+10, y+11},
                        {x+9, y+11}, {x+8, y+12}, {x+4, y+12}, {x+3, y+11}, {x+2, y+11}, {x+1, y+10},
                        {x+1, y+9} };

        if(list)
        {
            GdkPoint inner[20]={ {x+1,  y+8},  {x+1,  y+4},  {x+2,  y+3},  {x+2,  y+2},
                                 {x+3,  y+2},  {x+4,  y+1},  {x+8,  y+1},  {x+9,  y+2},
                                 {x+10, y+2},  {x+10, y+3},  {x+11, y+4},  {x+11, y+8},
                                 {x+10, y+9},  {x+10, y+10}, {x+9,  y+10}, {x+8,  y+11},
                                 {x+4,  y+11}, {x+3,  y+10}, {x+2,  y+10}, {x+2,  y+9} },
                     aa[16]=   { {x+2,  y+4}, {x+4, y+2},  {x+8, y+2},  {x+10, y+4},
                                 {x+10, y+8}, {x+8, y+10}, {x+4, y+10}, {x+2,  y+8},
                                 {x,    y+3}, {x+3, y},    {x+9, y},    {x+12, y+3},
                                 {x+12, y+9}, {x+9, y+12}, {x+3, y+12}, {x,    y+9} };

            midgc=QTC_SET_MID_COLOR_FACTOR(style->base[state], style->text[state], 1.5)
            if(area)
                gdk_gc_set_clip_rectangle(style->text_gc[state], area);
            gdk_draw_lines(window, style->text_gc[state], outer, 24);
            gdk_draw_lines(window, style->text_gc[state], inner, 20); 
            gdk_draw_points(window, midgc, aa, 16);
            if(area)
                gdk_gc_set_clip_rectangle(style->text_gc[state], NULL);
        }
        else
        {
            GdkGC     *new_gcs[TOTAL_SHADES+1],
                      **btn_gcs=NULL;
            GdkColor  new_colors[TOTAL_SHADES+1],
                      *btn_colors,
                      *left_shadow_color,
                      *right_shadow_color,
                      outer_left_color,
                      outer_right_color;
            gboolean  custom_c = FALSE;
            int       bgnd=0;
            GdkPoint  shadow[9]={ /*{x+4, y+11}, */{x+2, y+11}, {x+2, y+9}, {x+1, y+8}, {x+1, y+4},
                                   {x+2, y+3}, {x+2, y+2}, {x+3, y+2}, {x+4, y+1}, {x+8, y+1} },
                      outer_aa_left[8]= { { x,    y+3}, {x+1,  y+1},  {x+3,  y},     { x+9,  y},
                                         {x+11, y+1},  {x+12, y+3},  { x+1,  y+11}, {x,    y+9} },
                      outer_aa_right[4]={ { x+12, y+9}, {x+11, y+11}, {x+9,  y+12},  { x+3,  y+12} };
            GdkRegion *region=gdk_region_polygon(outer, 24, GDK_EVEN_ODD_RULE);

            if(QT_CUSTOM_COLOR_BUTTON(style))
            {
                custom_c=TRUE;
                shade_colors(&(style->bg[state]), new_colors);
                GEN_GCS(style, new_colors, new_gcs);
                btn_gcs=new_gcs;
                btn_colors=new_colors;
            }
            else
            {
                btn_colors=qtcurve_style->button;
                btn_gcs=qtcurve_style->button_gc;
            }

            if(area)
            {
                gdk_gc_set_clip_rectangle(style->base_gc[state], area);
                gdk_gc_set_clip_rectangle(btn_gcs[5], area);
                gdk_gc_set_clip_rectangle(btn_gcs[4], area);
                gdk_gc_set_clip_rectangle(btn_gcs[0], area);
            }

            bgnd=get_fill(state, set, TRUE);
            if(IS_FLAT(opts.appearance))
            {
                int st=GTK_STATE_INSENSITIVE==state ? state : GTK_STATE_NORMAL;
                if(area)
                    gdk_gc_set_clip_region(btn_gcs[bgnd], region);

                gdk_draw_rectangle(window, btn_gcs[bgnd], TRUE, x+1, y+1, QTC_RADIO_SIZE-2,
                                   QTC_RADIO_SIZE-2);
                if(area)
                    gdk_gc_set_clip_region(btn_gcs[bgnd], NULL);
            }
            else
                draw_bevel_gradient(style, window, btn_gcs[bgnd], style->colormap, NULL, region, x+1,
                                    y+1, width-2, height-2, &qtcurve_style->button[bgnd],
                                    set ? SHADE_BEVEL_GRAD_SEL_LIGHT
                                        : SHADE_BEVEL_GRAD_LIGHT,
                                    set ? SHADE_BEVEL_GRAD_SEL_DARK
                                        : SHADE_BEVEL_GRAD_DARK,
                                    TRUE, !set, set, opts.appearance, WIDGET_OTHER);
            gdk_region_destroy(region);
            if(!set && GTK_STATE_ACTIVE!=state)
            {
                if(!IS_GLASS(opts.appearance))
                    gdk_draw_lines(window, btn_gcs[set ? 4 : 0], shadow, 9);
                left_shadow_color=&(btn_colors[set ? 0 : 4]);
                right_shadow_color=&(btn_colors[set ? 0 : 4]);
            }
            else
                left_shadow_color=right_shadow_color=&(btn_colors[bgnd]);

            gdk_draw_lines(window, btn_gcs[5], outer, 24);
            shade(&btn_colors[5], &outer_right_color, 1.1);

            midgc=QTC_SET_MID_COLOR(outer_right_color, style->bg[state])
            gdk_draw_points(window, midgc, outer_aa_right, 4);

            gdk_draw_points(window, midgc, outer_aa_left, 8);

            midgc=QTC_SET_MID_COLOR_FACTOR(btn_colors[bgnd], btn_colors[5], 1.75)

            if(!set && GTK_STATE_ACTIVE!=state)
            {
                GdkPoint inner_aa[3]={ {x+1, y+4},  {x+2, y+2},  {x+4, y+1} };
                gdk_draw_points(window, midgc, inner_aa, 3);
                midgc=QTC_SET_MID_COLOR_FACTOR(outer_right_color, style->bg[state], 1.5)
                gdk_draw_point(window, midgc, x+2, y+10);
            }

            if(area)
            {
                gdk_gc_set_clip_rectangle(style->base_gc[state], NULL);
                gdk_gc_set_clip_rectangle(btn_gcs[5], NULL);
                gdk_gc_set_clip_rectangle(btn_gcs[4], NULL);
                gdk_gc_set_clip_rectangle(btn_gcs[0], NULL);
            }
            if(custom_c)
                RELEASE_GCS(new_gcs);
        }

        if(on)
        {
            midgc=QTC_SET_MID_COLOR(style->base[ind_state], style->text[ind_state])

            if(area)
                gdk_gc_set_clip_rectangle(style->text_gc[ind_state], area);

            gdk_draw_line(window, midgc, x+5, y+4, x+7, y+4);
            gdk_draw_line(window, midgc, x+5, y+8, x+7, y+8);
            gdk_draw_line(window, midgc, x+4, y+5, x+4, y+7);
            gdk_draw_line(window, midgc, x+8, y+5, x+8, y+7);
            gdk_draw_rectangle(window, style->text_gc[ind_state], TRUE, x+5, y+5, 3, 3);

            if(area)
                gdk_gc_set_clip_rectangle(style->text_gc[ind_state], NULL);
        }
        else if(tri)
        {
            int tx=x+(QTC_RADIO_SIZE/2),
                ty=y+(QTC_RADIO_SIZE/2);

            gdk_draw_line(window, style->text_gc[ind_state], tx-3, ty, tx+3, ty);
            gdk_draw_line(window, style->text_gc[ind_state], tx-3, ty+1, tx+3, ty+1);
        }

        }   /* So can modify X above, and then declare outer... */
    }
}

#if GTK_MAJOR_VERSION==1
static void real_draw_slider(GtkStyle *style, GdkWindow *window, GtkStateType state,
                             GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                             gchar *detail, gint x, gint y, gint width, gint height,
                             GtkOrientation orientation);
#endif

static GtkMenuBar * get_menu_bar(GtkWidget *w, int level)
{
    if(w)
        if(GTK_IS_MENU_BAR(w))
            return (GtkMenuBar*)w;
        else if(level<3)
            return get_menu_bar(w->parent, level++);

    return NULL;
}

static gboolean is_menu_item(GtkWidget *w, int level)
{
    if(w)
        if(GTK_IS_MENU_ITEM(w))
            return TRUE;
        else if(level<3)
            return is_menu_item(w->parent, level++);

    return FALSE;
}

#define IS_MENU_ITEM(WIDGET) is_menu_item(WIDGET, 0)

static gboolean is_on_a_button(GtkWidget *w, int level, gboolean *def)
{
    if(w)
        if(GTK_IS_BUTTON(w) &&(!(GTK_IS_RADIO_BUTTON(w) || GTK_IS_CHECK_BUTTON(w) ||
                               GTK_IS_OPTION_MENU(w))))
        {
            if(def)
                *def=GTK_WIDGET_HAS_DEFAULT(w);
            return TRUE;
        }
        else if(level<3)
            return is_on_a_button(w->parent, level++, def);

    return FALSE;
}   

#if GTK_MAJOR_VERSION>1
static void draw_layout(GtkStyle *style, GdkWindow *window, GtkStateType state, gboolean use_text,
                        GdkRectangle *area, GtkWidget *widget, const gchar *detail, gint x, gint y,
                        PangoLayout *layout)
{
    if(GTK_IS_PROGRESS(widget) || GTK_IS_PROGRESS_BAR(widget) || DETAIL("progressbar"))
        parent_class->draw_layout(style, window, state, use_text, area, widget, detail, x, y, layout);
    else
    {
        QT_CURVE_STYLE_VAR

        gboolean isMenuItem=IS_MENU_ITEM(widget),
                selectedText=isMenuItem && GTK_STATE_PRELIGHT==state,
                but=FALSE,
                def_but=FALSE;
        GdkGC    *prevGcs[4];
        int      i=0;

    #ifdef QTC_DEBUG
    printf("Draw layout %s %d %d %d %s  ", pango_layout_get_text(layout), state, use_text,
            IS_MENU_ITEM(widget), detail ? detail : "NULL");
    display_widget(widget, 3);
    #endif

        /* The following fixes the text in list views... if not used, when an item is selected it
           gets the selected text color - but when the window changes focus it gets the normal
           text color! */
        if(DETAIL("cellrenderertext") && GTK_STATE_ACTIVE==state)
            state=GTK_STATE_SELECTED;

        if(!isMenuItem && GTK_STATE_PRELIGHT==state)
            state=GTK_STATE_NORMAL;

        but=is_on_a_button(widget, 0, &def_but);

        if(but && GTK_STATE_INSENSITIVE!=state)
        {
            use_text=TRUE;
            for(i=0; i<4; ++i)
            {
                prevGcs[i]=style->text_gc[i];
                style->text_gc[i]=qtcurve_style->button_text_gc;
            }
        }
        else if(isMenuItem)
        {
            GtkMenuBar *menu=get_menu_bar(widget, 0);

    /*
            if(menu && USE_SHADED_MENU_BAR_COLORS && TOO_DARK(opts.customMenubarsColor))
            {
                selectedText=!selectedText;
                if(GTK_STATE_ACTIVE==state)
                    state=GTK_STATE_NORMAL;
                else if(GTK_STATE_PRELIGHT==state)
                    state=GTK_STATE_ACTIVE;
            }
    */
            if(menu && (SHADE_SELECTED==opts.shadeMenubars ||
                    (SHADE_CUSTOM==opts.shadeMenubars &&
                     TOO_DARK(qtcurve_style->menubar[ORIGINAL_SHADE]))))
                selectedText=TRUE;
        }

        parent_class->draw_layout(style, window, selectedText ? GTK_STATE_SELECTED : state,
                                  use_text || selectedText, area, widget, detail, x, y, layout);
        if(opts.embolden && def_but)
            parent_class->draw_layout(style, window, selectedText ? GTK_STATE_SELECTED : state,
                                      use_text || selectedText,
                                      area, widget, detail, x+1, y, layout);

        if(but && GTK_STATE_INSENSITIVE!=state)
            for(i=0; i<4; ++i)
                style->text_gc[i]=prevGcs[i];
    }
}
#else

static void draw_string(GtkStyle *style, GdkWindow *window, GtkStateType state, GdkRectangle *area,
                        GtkWidget *widget, PCONST gchar *detail, gint x, gint y, const gchar * string)
{
    if(GTK_IS_PROGRESS(widget) || GTK_IS_PROGRESS_BAR(widget))
        parent_class->draw_string(style, window, state, area, widget, detail, x, y, string);
    else
    {
        QT_CURVE_STYLE_VAR
        gboolean def_but;
        GdkGC    *prevGcs[4];
        int      i=0;

        g_return_if_fail(style != NULL);
        g_return_if_fail(window != NULL);

#ifdef QTC_DEBUG
printf("Draw string %d %s \"%s\" %d :%d: ", state, detail ? detail : "NULL", string ? string : "NULL",
widget && widget->parent ? GTK_WIDGET_STATE(widget->parent) : -1,
is_on_a_button(widget, 0, &def_but));
display_widget(widget, 3);
#endif

        if(is_on_a_button(widget, 0, &def_but))
        {
            GdkGC *gc=GTK_STATE_PRELIGHT==state || GTK_STATE_ACTIVE==state
                        ? style->text_gc[GTK_STATE_NORMAL]
                        : style->text_gc[state];
            int   x_offset=GTK_STATE_ACTIVE==state ? 1 : 0,
                  y_offset=x_offset; 

            if(area)
            {
                gdk_gc_set_clip_rectangle(style->white_gc, area);
                gdk_gc_set_clip_rectangle(gc, area);
            }
            if(GTK_STATE_INSENSITIVE==state)
            {
                gdk_draw_string(window, style->font, style->white_gc, x + 1 + x_offset,
                                y + 1 + y_offset, string);
                if(opts.embolden && def_but)
                    gdk_draw_string(window, style->font, style->white_gc, x + 1 + x_offset +1,
                                    y + 1 + y_offset, string);
            }
            else
                for(i=0; i<4; ++i)
                {
                    prevGcs[i]=style->text_gc[i];
                    style->text_gc[i]=qtcurve_style->button_text_gc;
                }

            gdk_draw_string(window, style->font, gc, x + x_offset, y + y_offset, string);
            if(opts.embolden && def_but)
                gdk_draw_string(window, style->font, gc, x + x_offset +1, y + y_offset, string);

            if(area)
            {
                gdk_gc_set_clip_rectangle(style->white_gc, NULL);
                gdk_gc_set_clip_rectangle(gc, NULL);
            }

            if(GTK_STATE_INSENSITIVE!=state)
                for(i=0; i<4; ++i)
                    style->text_gc[i]=prevGcs[i];
        }
        else
        {
            gboolean mi=IS_MENU_ITEM(widget);

            if(mi)
            {
                GtkMenuBar *menu=get_menu_bar(widget, 0);
    /*
                if(menu && USE_SHADED_MENU_BAR_COLORS && TOO_DARK(opts.customMenubarsColor))
                    if(GTK_STATE_ACTIVE==state)
                        state=GTK_STATE_NORMAL;
                    else if(GTK_STATE_PRELIGHT==state)
                        state=GTK_STATE_ACTIVE;
    */
                if(menu && (SHADE_SELECTED==opts.shadeMenubars ||
                            (SHADE_CUSTOM==opts.shadeMenubars &&
                             TOO_DARK(qtcurve_style->menubar[ORIGINAL_SHADE]))) &&
                   GTK_STATE_ACTIVE==state)
                    state=GTK_STATE_NORMAL;
            }
            parent_class->draw_string(style, window, mi && GTK_STATE_PRELIGHT==state
                                                        ? GTK_STATE_SELECTED
                                                        : state,
                                    area, widget, detail, x, y, string);
        }
    }
}
#endif

static void option_menu_get_props(GtkWidget *widget, GtkRequisition *indicator_size,
                                  GtkBorder *indicator_spacing)
{
    GtkRequisition *tmp_size = NULL;
    GtkBorder      *tmp_spacing = NULL;

#if GTK_MAJOR_VERSION>1
    if(widget)
        gtk_widget_style_get(widget, "indicator_size", &tmp_size, "indicator_spacing", &tmp_spacing,
                             NULL);
#endif
    if(tmp_size)
    {
        *indicator_size = *tmp_size;
        g_free(tmp_size);
    }
    else
        *indicator_size = default_option_indicator_size;

    if(tmp_spacing)
    {
        *indicator_spacing = *tmp_spacing;
        g_free(tmp_spacing);
    }
    else
        *indicator_spacing = default_option_indicator_spacing;
}

static void arrow_draw_hline(GdkWindow *window, GdkGC *gc, int x1, int x2, int y, gboolean last)
{
    if(x2 - x1 < 7 && !last) /* 7 to get garretts pixels, otherwise 6 */
        gdk_draw_line(window, gc, x1, y, x2, y);
    else if(last)
    {
        if(x2 - x1 <= 7)
        {
            gdk_draw_line(window, gc, x1+1, y, x1+1, y);
            gdk_draw_line(window, gc, x2-1, y, x2-1, y); 
        }
        else
        {
            gdk_draw_line(window, gc, x1+2, y, x1+2, y);
            gdk_draw_line(window, gc, x2-2, y, x2-2, y);
        }
    }
    else
    {
        gdk_draw_line(window, gc, x1, y, x1+2, y);
        gdk_draw_line(window, gc, x2-2, y, x2, y); 
    }
}

static void arrow_draw_vline(GdkWindow *window, GdkGC *gc, int y1, int y2, int x, gboolean last)
{
    if(y2 - y1 < 7 && !last) /* 7 to get garretts pixels */
        gdk_draw_line(window, gc, x, y1, x, y2);
    else if(last)
    {
        gdk_draw_line(window, gc, x, y1+2, x, y1+2);
        gdk_draw_line(window, gc, x, y2-2, x, y2-2); 
    }
    else
    {
        gdk_draw_line(window, gc, x, y1, x, y1+2);
        gdk_draw_line(window, gc, x, y2-2, x, y2); 
    }
}

static void draw_arrow(GdkWindow *window, GdkGC *gc, GdkRectangle *area, GtkArrowType arrow_type,
                       gint x, gint y, gint width, gint height)
{
    gint i,
         j;

    if(area)
        gdk_gc_set_clip_rectangle(gc, area);

    if(opts.vArrow)
        switch(arrow_type)
        {
            case GTK_ARROW_DOWN:
                for(i = 0, j = -1; i < height; i++, j++)
                    arrow_draw_hline(window, gc, x + j, x + width - j - 1, y + i, i == 0);
                break;
            case GTK_ARROW_UP:
                for(i = height - 1, j = -1; i >= 0; i--, j++)
                    arrow_draw_hline(window, gc, x + j, x + width - j - 1, y + i, i == height - 1);
                break;
            case GTK_ARROW_LEFT:
                for(i = width - 1, j = -1; i >= 0; i--, j++)
                    arrow_draw_vline(window, gc, y + j, y + height - j - 1, x + i, i == width - 1);
                break;
            case GTK_ARROW_RIGHT:
                for(i = 0, j = -1; i < width; i++, j++)
                    arrow_draw_vline(window, gc, y + j, y + height - j - 1,  x + i, i == 0);
        }
    else
        switch(arrow_type)
        {
            case GTK_ARROW_DOWN:
                for(i = 0, j = 0; i < height; i++, j++)
                    gdk_draw_line(window, gc, x + j, y + i, x + width - j - 1, y + i);
                break;
            case GTK_ARROW_UP:
                for(i = height - 1, j = 0; i >= 0; i--, j++)
                    gdk_draw_line(window, gc, x + j, y + i, x + width - j - 1, y + i);
                break;
            case GTK_ARROW_LEFT:
                for(i = width - 1, j = 0; i >= 0; i--, j++)
                    gdk_draw_line(window, gc, x + i, y + j, x + i, y + height - j - 1);
                break;
            case GTK_ARROW_RIGHT:
                for(i = 0, j = 0; i < width; i++, j++)
                    gdk_draw_line(window, gc, x + i, y + j, x + i, y + height - j - 1);
        }

    if(area)
        gdk_gc_set_clip_rectangle(gc, NULL);
}

static void qtcurve_draw_arrow(GtkStyle *style, GdkWindow *window, GtkStateType state,
                               GtkShadowType shadow, GdkRectangle *area, GtkWidget *widget,
                               PCONST gchar *detail, GtkArrowType arrow_type,
                               gboolean fill, gint x, gint y, gint width, gint height)
{
    QT_CURVE_STYLE_VAR

#ifdef QTC_DEBUG
printf("Draw arrow %d %d %d %d %d %d %d %s  ", state, shadow, arrow_type, x, y, width, height, detail ? detail : "NULL");
display_widget(widget, 3);
#endif
    if(DETAIL("arrow"))
    {
#if GTK_MAJOR_VERSION>1
        if(!is_on_combo_entry(widget, 0) && !is_on_combo(widget, 0))
#endif
        if(GTK_ARROW_DOWN==arrow_type || GTK_ARROW_UP==arrow_type)
            draw_arrow(window, style->text_gc[QTC_ARROW_STATE(state)], area,  arrow_type,
                       x+((width - LARGE_ARR_WIDTH)>>1),
                       y+((height-LARGE_ARR_HEIGHT)>>1), LARGE_ARR_WIDTH, LARGE_ARR_HEIGHT);
        else
            draw_arrow(window, style->text_gc[QTC_ARROW_STATE(state)], area,  arrow_type,
                       x+((width - LARGE_ARR_HEIGHT)>>1),
                       y+((height-LARGE_ARR_WIDTH)>>1), LARGE_ARR_HEIGHT, LARGE_ARR_WIDTH); 
    } 
    else
    {
        int is_spinbutton = DETAIL("spinbutton"),
            a_width=LARGE_ARR_WIDTH,
            a_height=LARGE_ARR_HEIGHT;

        sanitize_size(window, &width, &height);

#if GTK_MAJOR_VERSION==1
        if(DETAIL("hscrollbar") || DETAIL("vscrollbar") || is_spinbutton)
        {
            const char *box_detail = detail;
            int        box_x = x,
                       box_y = y,
                       box_width = width,
                       box_height = height;

            if(is_spinbutton)
            {
                box_detail = (GTK_ARROW_DOWN==arrow_type) ? "spinbutton_down" : "spinbutton_up";
                box_x -= 2;
                box_width += 4;
                if(GTK_ARROW_UP==arrow_type)
                {
                    box_y -= 2;
                    box_height += 2;
                }
                else
                {
                    box_y -= 0;
                    box_height += 1; /* 2; CPD: This worked before as 2 - maybe because new Gtk ver, which one!!!*/
                }
            }

            if(is_spinbutton && GTK_SHADOW_ETCHED_IN==shadow)
            {
                shadow = GTK_SHADOW_OUT;
                state = GTK_STATE_INSENSITIVE;
            }

            draw_box(style, window, state, shadow, area, widget, box_detail, box_x, box_y, box_width,
                     box_height);

            if(is_spinbutton)
            {
                x += 3;
                y += 2;
                width -= 6;
                height -= 4;
            }
            else /* scrollbar */
            {
                x += 4;
                y += 4;
                width -= 8;
                height -= 8;
            }
        }
#else
        if(is_spinbutton)
            if(GTK_ARROW_UP==arrow_type)
                y-=1;
            else if(!opts.vArrow && GTK_ARROW_DOWN==arrow_type)
                y+=1;
#endif
        if(is_spinbutton)
        {
            a_height = SMALL_ARR_HEIGHT;
            a_width = SMALL_ARR_WIDTH;
        }
        else if(GTK_ARROW_LEFT==arrow_type || GTK_ARROW_RIGHT==arrow_type || DETAIL("menuitem"))
        {
            a_width = LARGE_ARR_HEIGHT;
            a_height = LARGE_ARR_WIDTH;
        }

        x+=(width-a_width)>>1;
        y+=(height-a_height)>>1;

        if(GTK_ARROW_RIGHT==arrow_type && (width-a_width)%2)
            x++;

        if(GTK_ARROW_DOWN==arrow_type && (height-a_height)%2)
            y++;

        if(GTK_STATE_ACTIVE==state &&
           (DETAIL("hscrollbar") || DETAIL("vscrollbar") || is_spinbutton))
        {
            x++;
            y++;
        }

        draw_arrow(window, style->text_gc[IS_MENU_ITEM(widget) && GTK_STATE_PRELIGHT==state
                           ? GTK_STATE_SELECTED : QTC_ARROW_STATE(state)], 
                   area, arrow_type, x, y, a_width, a_height);
    }
}

static void draw_tab(GtkStyle *style, GdkWindow *window, GtkStateType state,
                     GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                     PCONST gchar *detail, gint x, gint y, gint width, gint height)
{
    if(is_active_combo(widget))
    {
        x++;
        y++;
    }

    draw_arrow(window, style->text_gc[QTC_ARROW_STATE(state)], area, GTK_ARROW_DOWN,
               x+((width-LARGE_ARR_WIDTH)>>1), y+((height-LARGE_ARR_HEIGHT)>>1), LARGE_ARR_WIDTH,
               LARGE_ARR_HEIGHT);
}

static void draw_shadow(GtkStyle *style, GdkWindow *window, GtkStateType state,
                        GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                        PCONST gchar *detail, gint x, gint y, gint width, gint height)
{
    if(DETAIL("entry"))
        draw_entry_field(style, window, state, widget, area, x, y, width, height,
                         is_combo_box_entry(widget) || is_spinbutton(widget)
                             ? ROUNDED_LEFT : ROUNDED_ALL);
    else
    {
        QT_CURVE_STYLE_VAR
        gboolean use_bc = use_button_color(detail),
                 custom_c = FALSE,
                 checkbox=detail && 0==strcmp(detail, QTC_CHECKBOX),
                 frame=!detail || 0==strcmp(detail, "frame"),
                 profiledFrame=DETAIL("scrolled_window"),
                 menu=DETAIL("menu"),
                 slider=DETAIL("slider"),
                 hscale=DETAIL("hscale"),
                 vscale=DETAIL("vscale"),
                 menuitem=DETAIL("menuitem"),
                 button=DETAIL("button") || DETAIL("togglebutton"),
                 optionmenu=DETAIL("optionmenu"),
                 bevelledButton=(button || optionmenu || checkbox) && APPEARANCE_BEVELLED==opts.appearance;
        int      dark=menu || use_bc ? (bevelledButton ? 2 : 4) : 5;
        GdkGC    *outer_gc = NULL,
                 *gc1 = NULL,
                 *gc2 = NULL;
        int      round=qtc_get_round(detail, widget
    #if GTK_MAJOR_VERSION>1
                                 , x, y
    #endif
                                );
        GdkGC    *new_gcs[TOTAL_SHADES+1],
                 **btn_gcs=NULL;
        GdkColor new_colors[TOTAL_SHADES+1],
                 *btn_colors;

    #ifdef QTC_DEBUG
    printf("Draw shadow %d %d %d %d %d %d %d %s  ", round, state, shadow_type, x, y, width, height,
           detail ? detail : "NULL");
    display_widget(widget, 3);
    #endif

    #if GTK_MAJOR_VERSION==1
        if(detail && (0==strcmp(detail, "entry") || 0==strcmp(detail, "text")) &&
           GTK_WIDGET_HAS_FOCUS(widget))
        {
            x--;
            y--;
            width+=2;
            height+=2;
        }
    #endif

        if(use_bc && QT_CUSTOM_COLOR_BUTTON(style))
        {
            custom_c=TRUE;
            shade_colors(&(style->bg[state]), new_colors);
            GEN_GCS(style, new_colors, new_gcs);
            btn_gcs=new_gcs;
            btn_colors=new_colors;
        }
        else
        {
            btn_gcs=SHADE_NONE!=opts.shadeSliders && (slider || vscale || hscale)
                        ? qtcurve_style->slider_gc
                        : qtcurve_style->button_gc;
            btn_colors=SHADE_NONE!=opts.shadeSliders && (slider || vscale || hscale)
                        ? qtcurve_style->slider
                        : qtcurve_style->button;
        }

        sanitize_size(window, &width, &height);

    /* CPD - THIS WAS IN GTK2 VER, and NOT GTK1 ??? */
    #if GTK_MAJOR_VERSION>1 && GTK_MINOR_VERSION<2
        if(DETAIL("slider") && widget && GTK_IS_RANGE(widget))
        {
            GtkAdjustment *adj = GTK_RANGE(widget)->adjustment;

            if(adj->value <= adj->lower &&
               (GTK_RANGE(widget)->has_stepper_a || GTK_RANGE(widget)->has_stepper_b))
            {
                if(GTK_IS_VSCROLLBAR(widget))
                {
                    height += 1;
                    y -= 1;
                }
                else if(GTK_IS_HSCROLLBAR(widget))
                {
                    width += 1;
                    x -= 1;
                }
            }
            if(adj->value >= adj->upper - adj->page_size && (GTK_RANGE(widget)->has_stepper_c || 
               GTK_RANGE(widget)->has_stepper_d))
                if(GTK_IS_VSCROLLBAR(widget))
                    height += 1;
                else if(GTK_IS_HSCROLLBAR(widget))
                    width += 1;
        }
    #endif

        if((frame || profiledFrame) && QTC_ROUNDED)
        {
            if(GTK_SHADOW_NONE!=shadow_type
#if GTK_MAJOR_VERSION>1
               && (!frame || opts.drawStatusBarFrames || GTK_APP_MOZILLA!=qt_settings.app)
#endif
              )
                draw_3d_border(widget && widget->parent ? widget->parent->style : style,
                               window, state, area, x, y, width, height, TRUE, qtcurve_style->gray_gc[5],
                               &(qtcurve_style->gray[5]), qtcurve_style->gray_gc[0], qtcurve_style->gray_gc[0],
                               qtcurve_style->gray_gc, qtcurve_style->gray,
                               ROUNDED_ALL, FALSE, FALSE, profiledFrame ? BORDER_SUNKEN : BORDER_FLAT, TRUE, TRUE);
        }
        else
        {
            if(menuitem)
                outer_gc =MENU_GC(3);
            else
                outer_gc = use_bc ? btn_gcs[5] : qtcurve_style->gray_gc[5];

            switch(shadow_type)
            {
                case GTK_SHADOW_NONE:
                    return;
                case GTK_SHADOW_IN:
                case GTK_SHADOW_ETCHED_IN:
                    if(frame)
                    {
                        gc1 = qtcurve_style->gray_gc[0];
                        gc2 = qtcurve_style->gray_gc[dark];
                    }
                    else
                    {
                        gc1 = use_bc ? btn_gcs[0] : qtcurve_style->gray_gc[0];
                        gc2 = use_bc ? btn_gcs[dark] : qtcurve_style->gray_gc[dark];
                    }
                    break;
                case GTK_SHADOW_OUT:
                case GTK_SHADOW_ETCHED_OUT:
                    if(menuitem)
                    {
                        gc1 = MENU_GC(2);
                        gc2 = MENU_GC(1);
                    }
                    else
                    {
                        gc1 = use_bc ? btn_gcs[dark] : qtcurve_style->gray_gc[dark];
                        gc2 = use_bc ? btn_gcs[0] : qtcurve_style->gray_gc[0];
                    }
                    break;
            }

            switch(shadow_type)
            {
                case GTK_SHADOW_NONE:
                    break;
                case GTK_SHADOW_IN:
                case GTK_SHADOW_OUT:
                    if(optionmenu && GTK_STATE_ACTIVE!=state && is_active_combo(widget))
                        state=GTK_STATE_ACTIVE;

                    if(frame || menu)
                    {
                        if(menu)
                        {
                            gdk_draw_rectangle(window, outer_gc, FALSE, x, y, width - 1, height - 1);
                            x++; y++; width-=2; height-=2;
                        }

                        gdk_draw_line(window, gc2, x,         y,          x+width-2, y);
                        gdk_draw_line(window, gc2, x,         y,          x,         y+height-2);
                        gdk_draw_line(window, gc1, x,         y+height-1, x+width-1, y+height-1);
                        gdk_draw_line(window, gc1, x+width-1, y+height-1, x+width-1, y);
                    }
                    else
                    {
                        if(is_list_view_header(widget))
                        {
                            if(is_list_view_header(widget))
                            {
                                gdk_draw_line(window, qtcurve_style->listview_gc[5], x, y+height-1,
                                              x+width-1, y+height-1);
                                if(x>3 && height>10)
                                {
                                    gdk_draw_line(window, qtcurve_style->listview_gc[5], x, y+5, x,
                                                  y+height-6);
                                    gdk_draw_line(window, qtcurve_style->listview_gc[0], x+1, y+5,
                                                  x+1, y+height-6);
                                }
                            }
                        }
                        else
                        {
                            GdkColor *outer_col=use_bc ? &btn_colors[5] : &qtcurve_style->gray[5];
                            gboolean draw_inside=!( (GTK_SHADOW_IN==shadow_type ||
                                                     GTK_STATE_ACTIVE==state)) && detail &&
                                                          (button || 
                                                           checkbox ||
                                                           slider ||
                                                           hscale ||
                                                           vscale ||
                                                           (0==strcmp(detail, "handlebox")) ||
                                                           optionmenu ||
                                                           (0==strcmp(detail, "notebook")) ||
                                                           (0==strcmp(detail, "spinbutton_up")) ||
                                                           (0==strcmp(detail, "spinbutton_down")) ||
                                                           (0==strcmp(detail, "menuitem")) ||
                                                           (0==strcmp(detail, "vscrollbar")) ||
                                                           (0==strcmp(detail, "hscrollbar")) ||
                                                           (0==strcmp(detail, "stepper")) ||
                                                           (0==strcmp(detail, QTC_PANED)) );
                            GdkColor *colors=btn_colors;
                            GdkGC    **gcs=btn_gcs;

                            if(0==strcmp(detail, "button") && GTK_WIDGET_HAS_DEFAULT(widget))
                                if(IND_FONT_COLOR==opts.defBtnIndicator)
                                {
                                    outer_gc=style->text_gc[GTK_STATE_NORMAL];
                                    outer_col=&style->text[GTK_STATE_NORMAL];
                                }
                                else if(IND_COLORED==opts.defBtnIndicator)
                                {
                                    outer_gc=qtcurve_style->defbtn_gc[5];
                                    outer_col=&qtcurve_style->defbtn[5];
                                    colors=qtcurve_style->defbtn;
                                    gcs=qtcurve_style->defbtn_gc;
                                    if(GTK_SHADOW_OUT==shadow_type ||
                                       GTK_SHADOW_ETCHED_OUT==shadow_type)
                                    {
                                        gc1=qtcurve_style->defbtn_gc[dark];
                                        gc2=qtcurve_style->defbtn_gc[0];
                                    }
                                    else
                                    {
                                        gc1=qtcurve_style->defbtn_gc[0];
                                        gc2=qtcurve_style->defbtn_gc[dark];
                                    }
                                }

#if GTK_MAJOR_VERSION>1 /* Required for Gtk1 too? */
                            if(0==strcmp(detail, "spinbutton_up"))
                                height+=1;
#endif

                            draw_3d_border(style, window, state, area, x, y, width, height,
                                           !checkbox && width>=QTC_MIN_BTN_SIZE && height>=QTC_MIN_BTN_SIZE,
                                           outer_gc, outer_col, gc1, gc2, gcs, colors, round,
                                           draw_inside, bevelledButton, BORDER_FLAT, FALSE, TRUE);
                        }
                    }
                    break;
                case GTK_SHADOW_ETCHED_IN:
                    gdk_draw_rectangle(window, gc1, FALSE, x+1, y+1, width-2, height-2);
                    gdk_draw_rectangle(window, gc2, FALSE, x, y, width-2, height-2);
                    break;
                case GTK_SHADOW_ETCHED_OUT:
                    gdk_draw_rectangle(window, gc2, FALSE, x+1, y+1, width-2, height-2);
                    gdk_draw_rectangle(window, gc1, FALSE, x, y, width-2, height-2);
                    break;
            }
        }
        if(custom_c)
            RELEASE_GCS(new_gcs);
    }
}

static void draw_box_gap(GtkStyle *style, GdkWindow *window, GtkStateType state,
                         GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                         PCONST gchar *detail, gint x, gint y, gint width,
                         gint height, GtkPositionType gap_side, gint gap_x, gint gap_width)
{
    QT_CURVE_STYLE_VAR
    GdkGC *gc1 = qtcurve_style->gray_gc[0],
          *gc2 = qtcurve_style->gray_gc[4],
          *outer = qtcurve_style->gray_gc[5];

    FN_CHECK

    qtc_draw_box_gap(style, window, GTK_SHADOW_OUT, state, widget, area, x, y,
                     width, height, gap_side, gap_x, gap_width, BORDER_RAISED, TRUE);

    sanitize_size(window, &width, &height);

    if(area)
    {
        gdk_gc_set_clip_rectangle(gc1, area);
        gdk_gc_set_clip_rectangle(gc2, area);
        gdk_gc_set_clip_rectangle(outer, area);
    }

    switch(gap_side)
    {
        case GTK_POS_TOP:
            if(gap_x > 0)
            {
                gdk_draw_line(window, gc1, x+gap_x-1, y+1, x+gap_x+1, y+1);
                gdk_draw_line(window, gc1, x+gap_x-1, y, x+gap_x+1, y);
                gdk_draw_line(window, outer, x+gap_x-1, y, x+gap_x, y);
            }
            else
                gdk_draw_line(window, gc1, x+1, y, x+1, y+1);

            if((width -(gap_x + gap_width)) > 0)
            {
                gdk_draw_line(window, gc1, x+gap_x+gap_width-2, y+1, x+gap_x+gap_width, y+1);
                gdk_draw_line(window, gc2, x+gap_x+gap_width-2, y, x+gap_x+gap_width-2,
                              y);
                gdk_draw_line(window, outer, x+gap_x+gap_width-1, y, x+gap_x+gap_width, y);
            }
            gdk_draw_line(window, outer, x, y, x, y+2);
            break;
        case GTK_POS_BOTTOM:
            if(gap_x > 0)
            {
                gdk_draw_line(window, gc1, x+gap_x-1, y+height-1, x+gap_x+1, y+height-2);
                gdk_draw_line(window, gc2, x+gap_x-1, y+height-2, x+gap_x, y+height-2);
                gdk_draw_line(window, outer, x+gap_x-1, y+height-1, x+gap_x, y+height-1);
            }
            else
                gdk_draw_line(window, gc1, x+1, y+height-1, x+1, y+height-2);
            if((width -(gap_x + gap_width)) > 0)
            {
                gdk_draw_line(window, gc2, x+gap_x+gap_width-2, y+height-2, x+gap_x+gap_width,
                              y+height-2);
                gdk_draw_line(window, gc2, x+gap_x+gap_width-2, y+height-1,
                              x+gap_x+gap_width-2, y+height-1);
                gdk_draw_line(window, outer, x+gap_x+gap_width-1, y+height-1, x+gap_x+gap_width,
                              y+height-1);
            }
            gdk_draw_line(window, outer, x, y+height-1, x, y+height-3);
            break;
        case GTK_POS_LEFT:
            if(gap_x>0)
            {
                gdk_draw_line(window, gc1, x+1, y+gap_x-1, x+1, y+gap_x+1);
                gdk_draw_line(window, gc1, x, y+gap_x-1, x, y+gap_x+1);
                gdk_draw_line(window, outer, x, y+gap_x-1, x, y+gap_x);
            }
            else
                gdk_draw_line(window, gc1, x, y+1, x+1, y+1);
            if((height-(gap_x + gap_width)) > 0)
            {
                gdk_draw_line(window, gc1, x+1, y+gap_x+gap_width-2, x+1, y+gap_x+gap_width);
                gdk_draw_line(window, gc2, x, y+gap_x+gap_width-2, x,
                              y+gap_x+gap_width-2);
                gdk_draw_line(window, outer, x, y+gap_x+gap_width-1, x, y+gap_x+gap_width);
            }
            gdk_draw_line(window, outer, x, y, x+2, y);
            break;
        case GTK_POS_RIGHT:
            if(gap_x>0)
            {
                gdk_draw_line(window, gc2, x+width-2, y+gap_x-1, x+width-2, y+gap_x);
                gdk_draw_line(window, gc1, x+width-2, y+gap_x-1, x+width-1, y+gap_x+1);
                gdk_draw_line(window, outer, x+width-1, y+gap_x-1, x+width-1, y+gap_x);
            }
            else
                gdk_draw_line(window, gc1, x+width-2, y+1, x+width, y+1);
            if((height-(gap_x + gap_width)) > 0)
            {
                gdk_draw_line(window, gc2, x+width-2, y+gap_x+gap_width-2, x+width,
                              y+gap_x+gap_width-2);
                gdk_draw_line(window, gc2, x+width-2, y+gap_x+gap_width-1, x+width-2,
                              y+gap_x+gap_width);
                gdk_draw_line(window, outer, x+width-1, y+gap_x+gap_width-1, x+width-1,
                              y+gap_x+gap_width);
            }
            gdk_draw_line(window, outer, x+width-1, y, x+width-3, y);
            break;
    }

    if(area)
    {
        gdk_gc_set_clip_rectangle(gc1, NULL);
        gdk_gc_set_clip_rectangle(gc2, NULL);
        gdk_gc_set_clip_rectangle(outer, NULL);
    }
}

static void fill_tab(GtkStyle *style, GdkWindow *window, GdkRectangle *area, GtkStateType state,
                     GdkGC *fill, GdkColor *col, int x, int y, int width, int height, gboolean horiz,
                     gboolean increase, EWidget tab, gboolean grad)
{
    EAppearance app=GTK_STATE_NORMAL==state ? opts.selectedTabAppearance : opts.normalTabAppearance;

    if(grad && !IS_FLAT(app))
    {
        double s1=increase
                      ? SHADE_TAB_SEL_LIGHT
                      : SHADE_BOTTOM_TAB_SEL_DARK,
               s2=increase
                      ? SHADE_TAB_SEL_DARK
                      : SHADE_BOTTOM_TAB_SEL_LIGHT;

        draw_bevel_gradient(style, window, fill, style->colormap, area, NULL, x, y, width, height,
                            col, s1, s2, horiz, increase, FALSE, app, tab);
    }
    else
        gdk_draw_rectangle(window, fill, TRUE, x, y, width, height);
}

static void draw_extension(GtkStyle *style, GdkWindow *window, GtkStateType state,
                           GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                           PCONST gchar *detail, gint x, gint y, gint width,
                           gint height, GtkPositionType gap_side)
{
    QT_CURVE_STYLE_VAR
    GtkNotebook *notebook=GTK_IS_NOTEBOOK(widget) ? GTK_NOTEBOOK(widget) : NULL;
    GdkGC       *gc1 = NULL,
                *gc2 = NULL,
                *fill = GTK_STATE_NORMAL==state
                            ? style->bg_gc[GTK_STATE_NORMAL] : qtcurve_style->gray_gc[2],
                *outer = qtcurve_style->gray_gc[5],
                *selGc1= qtcurve_style->menuitem_gc[0],
                *selGc2= qtcurve_style->menuitem_gc[IS_FLAT(opts.appearance) ? 0 : 3],
                *midgc=NULL;
    int         dark=4;
    gboolean    firstTab=notebook ? FALSE : TRUE,
                lastTab=notebook ? FALSE : TRUE,
                vertical=GTK_POS_LEFT==gap_side || GTK_POS_RIGHT==gap_side,
                active=GTK_STATE_NORMAL==state; /* Normal -> active tab? */
    GdkColor    *col=active
                         ? &(style->bg[GTK_STATE_NORMAL]) : &(qtcurve_style->gray[2]);
    FN_CHECK

    if(QTC_ROUNDED)
    {
#if GTK_MAJOR_VERSION>1
        /* f'in mozilla apps dont really use Gtk widgets - they just paint to a pixmap. So, no way of knowing
           the position of a tab! The 'best' look seems to be to round both corners. Not nice, but... */
        if(GTK_APP_MOZILLA==qt_settings.app)
            firstTab=lastTab=TRUE;
        else
#endif
        if(notebook)
        {
            /* Borrowed from Qt engine... */
            int num_children=g_list_length(notebook->children),
                i, sdiff = 10000, pos = -1,
                first_shown=-1,
                last_shown=-1;

            for (i = 0; i < num_children; i++ )
            {
                GtkWidget *page=gtk_notebook_get_nth_page(notebook, i),
                          *tab_label=gtk_notebook_get_tab_label(notebook, page);

                int diff=tab_label ? (vertical ? tab_label->allocation.y-y : tab_label->allocation.x-x) : -1;

                if ((diff > 0) && (diff < sdiff))
                {
                    sdiff = diff;
                    pos=i;
                }

                if(GTK_WIDGET_VISIBLE(page))
                {
                    if(i>last_shown)
                        last_shown=i;
                    if(-1==first_shown)
                        first_shown=i;
                }
            }

            if(0==pos || first_shown==pos)
                firstTab=TRUE;
            else if(pos==(num_children-1) || (pos==last_shown))
                lastTab=TRUE;
        }
    }

#ifdef QTC_DEBUG
printf("Draw extension %d %d %d %d %d %d %d %s  ", state, shadow_type, gap_side, x, y, width, height, detail ? detail :
"NULL");
display_widget(widget, 3);
#endif

    gtk_style_apply_default_background(style, window, widget && !GTK_WIDGET_NO_WINDOW(widget),
                                       GTK_STATE_NORMAL, area, x, y, width, height);
    sanitize_size(window, &width, &height);

    switch(shadow_type)
    {
        case GTK_SHADOW_NONE:
            return;
        case GTK_SHADOW_IN:
        case GTK_SHADOW_ETCHED_IN:
            gc1 = qtcurve_style->gray_gc[dark];
            gc2 = qtcurve_style->gray_gc[0];
            break;
        case GTK_SHADOW_OUT:
        case GTK_SHADOW_ETCHED_OUT:
            gc1 = qtcurve_style->gray_gc[0];
            gc2 = qtcurve_style->gray_gc[dark];
            break;
    }

    if(area)
    {
        gdk_gc_set_clip_rectangle(gc1, area);
        gdk_gc_set_clip_rectangle(gc2, area);
        gdk_gc_set_clip_rectangle(fill, area);
        gdk_gc_set_clip_rectangle(outer, area);
        if(notebook && opts.highlightTab && active)
        {
            gdk_gc_set_clip_rectangle(selGc1, area);
            if(!IS_FLAT(opts.appearance))
                gdk_gc_set_clip_rectangle(selGc2, area);
        }
    }

    switch(gap_side)
    {
        case GTK_POS_TOP:  /* => tabs are on bottom !!! */
            fill_tab(style, window, area, state, fill, col, x, y, width, height-1, TRUE,
                     FALSE, WIDGET_TAB_BOT, NULL!=notebook);
            gdk_draw_line(window, gc1, x+1, y , x+1, y+height-1);
            if(active)
            {
                gdk_draw_line(window, gc2, x+1, y+height-2, x+width-2, y+height-2);
                gdk_draw_line(window, gc2, x+width-2, y, x+width-2, y+height-1);
            }
            gdk_draw_line(window, outer, x, y , x, y+height-2);
            gdk_draw_line(window, outer, x+width-1, y, x+width-1, y+height-2);
            if(ROUND_FULL==opts.round && active)
            {
                gdk_draw_line(window, outer, x+1, y+height-1, x+width-2, y+height-1);
                gdk_draw_point(window, outer, x+1, y+height-2);
                gdk_draw_point(window, outer, x+width-2, y+height-2);
                gdk_draw_line(window, gc2, x, y+height-2, x+1, y+height-1);
                gdk_draw_line(window, gc2, x+width-2, y+height-1, x+width-1, y+height-2);
            }
            else
                gdk_draw_line(window, outer, ROUND_FULL==opts.round && firstTab ? x+1 : x, y+height-1,
                              ROUND_FULL==opts.round && lastTab ? x+width-2 : x+width-1, y+height-1);

            if(notebook && opts.highlightTab && active)
            {
                int offset=ROUND_FULL==opts.round ? 1 : 0;

                gdk_draw_line(window, selGc1, x+offset, y+height-3, x+width-(1+offset),
                              y+height-3);
                gdk_draw_line(window, selGc1, x+offset, y+height-2, x+width-(1+offset),
                              y+height-2);
                gdk_draw_line(window, selGc2, x+(offset*2), y+height-1,
                              x+width-(1+(offset*2)), y+height-1);
                if(ROUND_FULL==opts.round)
                {
                    gdk_draw_line(window, selGc2, x+(offset*2), y+height-1, x+offset,
                                  y+height-2);
                    gdk_draw_line(window, selGc2, x+width-(1+(offset*2)), y+height-1,
                                  x+width-(1+offset), y+height-2);
                }
                else
                {
                    gdk_draw_line(window, selGc2, x+offset, y+height-3, x+offset, y+height-2);
                    gdk_draw_line(window, selGc2, x+width-(1+offset), y+height-3, x+width-(1+offset), y+height-2);
                }
            }

            if(ROUND_FULL==opts.round && !active)
            {
                if(firstTab)
                {
                    gdk_draw_point(window, outer, x+1, y+height-2);
                    midgc=QTC_SET_MID_COLOR(qtcurve_style->gray[5], style->bg[GTK_STATE_NORMAL])
                    gdk_draw_point(window, midgc, x, y+height-2);
                    gdk_draw_point(window, midgc, x+1, y+height-1);
                }
                if(lastTab)
                {
                    gdk_draw_point(window, outer, x+width-2, y+height-2);
                    midgc=QTC_SET_MID_COLOR(qtcurve_style->gray[5], style->bg[GTK_STATE_NORMAL])
                    gdk_draw_point(window, midgc, x+width-1, y+height-2);
                    gdk_draw_point(window, midgc, x+width-2, y+height-1);
                }
            }
            if(ROUND_SLIGHT==opts.round && (active || firstTab || lastTab))
            {
                GdkColor *col=active && opts.highlightTab ? &qtcurve_style->menuitem[3] : &qtcurve_style->gray[3];

                midgc=QTC_SET_MID_COLOR(*col, style->bg[GTK_STATE_NORMAL])

                if(active || firstTab)
                    gdk_draw_point(window, midgc, x, y+height-1);
                if(active || lastTab)
                    gdk_draw_point(window, midgc, x+width-1, y+height-1);
            }
            break;
        case GTK_POS_BOTTOM: /* => tabs are on top !!! */
            fill_tab(style, window, area, state, fill, col, x, y+1, width, height-1, TRUE,
                     TRUE, WIDGET_TAB_TOP, NULL!=notebook);
            gdk_draw_line(window, gc1, x+1, y+1 , x+width-2, y+1);
            gdk_draw_line(window, gc1, x+1, y+1, x+1, y+height-1);
            if(active)
                gdk_draw_line(window, gc2, x+width-2, y+1, x+width-2, y+height-1);
            gdk_draw_line(window, outer, x, y+1, x, y+height-1);
            gdk_draw_line(window, outer, x+width-1, y+1, x+width-1, y+height-1);
            if(ROUND_FULL==opts.round && active)
            {
                gdk_draw_line(window, outer, x+1, y , x+width-2, y);
                gdk_draw_point(window, outer, x+1, y+1);
                gdk_draw_point(window, outer, x+width-2, y+1);
                gdk_draw_line(window, gc2, x, y+1, x+1, y);
                gdk_draw_line(window, gc2, x+width-2, y, x+width-1, y+1);
            }
            else
                gdk_draw_line(window, outer, ROUND_FULL==opts.round && firstTab ? x+1 : x, y,
                              ROUND_FULL==opts.round && lastTab ? x+width-2 : x+width-1, y);
            if(notebook && opts.highlightTab && active)
            {
                int offset=ROUND_FULL==opts.round ? 1 : 0;

                gdk_draw_line(window, selGc1, x+offset, y+2, x+width-(1+offset), y+2);
                gdk_draw_line(window, selGc1, x+offset, y+1, x+width-(1+offset), y+1);
                gdk_draw_line(window, selGc2, x+(offset*2), y, x+width-(1+(offset*2)), y);

                if(ROUND_FULL==opts.round)
                {
                    gdk_draw_line(window, selGc2, x+(offset*2), y, x+offset, y+1);
                    gdk_draw_line(window, selGc2, x+width-(1+(offset*2)), y,
                                  x+width-(1+offset), y+1);
                }
                else
                {
                    gdk_draw_line(window, selGc2, x+offset, y+2, x+offset, y+1);
                    gdk_draw_line(window, selGc2, x+width-(1+offset), y+2, x+width-(1+offset), y+1);
                }
            }

            if(ROUND_FULL==opts.round && !active)
            {
                if(firstTab)
                {
                    gdk_draw_point(window, outer, x+1, y+1);
                    midgc=QTC_SET_MID_COLOR(qtcurve_style->gray[5], style->bg[GTK_STATE_NORMAL])
                    gdk_draw_point(window, midgc, x, y+1);
                    gdk_draw_point(window, midgc, x+1, y);
                }
                if(lastTab)
                {
                    gdk_draw_point(window, outer, x+width-2, y+1);
                    midgc=QTC_SET_MID_COLOR(qtcurve_style->gray[5], style->bg[GTK_STATE_NORMAL])
                    gdk_draw_point(window, midgc, x+width-1, y+1);
                    gdk_draw_point(window, midgc, x+width-2, y);
                }
            }
            if(ROUND_SLIGHT==opts.round && (active || firstTab || lastTab))
            {
                GdkColor *col=active && opts.highlightTab ? &qtcurve_style->menuitem[3] : &qtcurve_style->gray[3];

                midgc=QTC_SET_MID_COLOR(*col, style->bg[GTK_STATE_NORMAL])

                if(active || firstTab)
                    gdk_draw_point(window, midgc, x, y);
                if(active || lastTab)
                    gdk_draw_point(window, midgc, x+width-1, y);
            }
            break;
        case GTK_POS_LEFT: /* => tabs are on right !!! */
            fill_tab(style, window, area, state, fill, col, x, y, width-1, height, FALSE,
                     FALSE, WIDGET_TAB_BOT, NULL!=notebook);
            gdk_draw_line(window, gc1, x, y+1, x+width-1, y+1);
            if(active)
            {
                gdk_draw_line(window, gc2, x+width-2, y+1, x+width-2, y+height-2);
                gdk_draw_line(window, gc2, x, y+height-2, x+width-1, y+height-2);
            }
            gdk_draw_line(window, outer, x, y, x+width-2, y);
            gdk_draw_line(window, outer, x, y+height-1, x+width-2, y+height-1);
            if(ROUND_FULL==opts.round && active)
            {
                gdk_draw_line(window, outer, x+width-1, y+1, x+width-1, y+height-2);
                gdk_draw_point(window, outer, x+width-2, y+1);
                gdk_draw_point(window, outer, x+width-2, y+height-2);
                gdk_draw_line(window, gc2, x+width-2, y, x+width-1, y+1);
                gdk_draw_line(window, gc2, x+width-2, y+height-1, x+width-1, y+height-2);
            }
            else
                gdk_draw_line(window, outer, x+width-1, ROUND_FULL==opts.round && firstTab ? y+1 : y, x+width-1,
                              ROUND_FULL==opts.round && lastTab ? y+height-2 : y+height-1);
            if(notebook && opts.highlightTab && active)
            {
                int offset=ROUND_FULL==opts.round ? 1 : 0;

                gdk_draw_line(window, selGc1, x+width-3, y+offset, x+width-3,
                              y+height-(1+offset));
                gdk_draw_line(window, selGc1, x+width-2, y+offset, x+width-2,
                              y+height-(1+offset));
                gdk_draw_line(window, selGc2, x+width-1, y+(offset*2), x+width-1,
                              y+height-(1+(offset*2)));

                if(ROUND_FULL==opts.round)
                {
                    gdk_draw_line(window, selGc2, x+width-1, y+(offset*2), x+width-2,
                                  y+offset);
                    gdk_draw_line(window, selGc2, x+width-1, y+height-(1+(offset*2)),
                                  x+width-2, y+height-(1+offset));
                }
                else
                {
                    gdk_draw_line(window, selGc2, x+width-3, y+offset, x+width-2, y+offset);
                    gdk_draw_line(window, selGc2, x+width-3, y+height-(1+offset), x+width-2, y+height-(1+offset));
                }
            }
            if(ROUND_FULL==opts.round && !active)
            {
                if(firstTab)
                {
                    gdk_draw_point(window, outer, x+width-2, y+1);
                    midgc=QTC_SET_MID_COLOR(qtcurve_style->gray[5], style->bg[GTK_STATE_NORMAL])
                    gdk_draw_point(window, midgc, x+width-1, y+1);
                    gdk_draw_point(window, midgc, x+width-2, y);
                }
                if(lastTab)
                {
                    gdk_draw_point(window, outer, x+width-2, y+height-2);
                    midgc=QTC_SET_MID_COLOR(qtcurve_style->gray[5], style->bg[GTK_STATE_NORMAL])
                    gdk_draw_point(window, midgc, x+width-1, y+height-2);
                    gdk_draw_point(window, midgc, x+width-2, y+height-1);
                }
            }
            if(ROUND_SLIGHT==opts.round && (active || firstTab || lastTab))
            {
                GdkColor *col=active && opts.highlightTab ? &qtcurve_style->menuitem[3] : &qtcurve_style->gray[3];

                midgc=QTC_SET_MID_COLOR(*col, style->bg[GTK_STATE_NORMAL])

                if(active || firstTab)
                    gdk_draw_point(window, midgc, x+width-1, y);
                if(active || lastTab)
                    gdk_draw_point(window, midgc, x+width-1, y+height-1);
            }
            break;
        case GTK_POS_RIGHT: /* => tabs are on left !!! */
            fill_tab(style, window, area, state, fill, col, x+1, y, width-1, height,
                     FALSE, TRUE, WIDGET_TAB_TOP, NULL!=notebook);
            gdk_draw_line(window, gc1, x+1, y+1, x+1, y+height-2);
            gdk_draw_line(window, gc1, x, y+1, x+width-1, y+1);
            if(active)
                gdk_draw_line(window, gc2, x, y+height-2, x+width-1, y+height-2);
            gdk_draw_line(window, outer, x+1, y, x+width-1, y);
            gdk_draw_line(window, outer, x+1, y+height-1, x+width-1, y+height-1);
            if(ROUND_FULL==opts.round && active)
            {
                gdk_draw_line(window, outer, x, y+1, x, y+height-2);
                gdk_draw_point(window, outer, x+1, y+1);
                gdk_draw_point(window, outer, x+1, y+height-2);
                gdk_draw_line(window, gc2, x, y+1, x+1, y);
                gdk_draw_line(window, gc2, x, y+height-2, x+1, y+height-1);
            }
            else
                gdk_draw_line(window, outer, x, ROUND_FULL==opts.round && firstTab ? y+1 : y, x,
                              ROUND_FULL==opts.round && lastTab ? y+height-2 : y+height-1);

            if(notebook && opts.highlightTab && active)
            {
                int offset=ROUND_FULL==opts.round ? 1 : 0;

                gdk_draw_line(window, selGc1, x+2, y+offset, x+2, y+height-(1+offset));
                gdk_draw_line(window, selGc1, x+1, y+offset, x+1, y+height-(1+offset));
                gdk_draw_line(window, selGc2, x, y+(offset*2), x,
                              y+height-(1+(offset*2)));
                if(ROUND_FULL==opts.round)
                {
                    gdk_draw_line(window, selGc2, x, y+(offset*2), x+1, y+offset);
                    gdk_draw_line(window, selGc2, x, y+height-(1+(offset*2)),
                                  x+1, y+height-(1+offset));
                }
                else
                {
                    gdk_draw_line(window, selGc2, x+2, y+offset, x+1, y+offset);
                    gdk_draw_line(window, selGc2, x+2, y+height-(1+offset), x+1, y+height-(1+offset));
                }
            }
            if(ROUND_FULL==opts.round && !active)
            {
                if(firstTab)
                {
                    gdk_draw_point(window, outer, x+1, y+1);
                    midgc=QTC_SET_MID_COLOR(qtcurve_style->gray[5], style->bg[GTK_STATE_NORMAL])
                    gdk_draw_point(window, midgc, x, y+1);
                    gdk_draw_point(window, midgc, x+1, y);
                }
                if(lastTab)
                {
                    gdk_draw_point(window, outer, x+1, y+height-2);
                    midgc=QTC_SET_MID_COLOR(qtcurve_style->gray[5], style->bg[GTK_STATE_NORMAL])
                    gdk_draw_point(window, midgc, x, y+height-2);
                    gdk_draw_point(window, midgc, x+1, y+height-1);
                }
            }
            if(ROUND_SLIGHT==opts.round && (active || firstTab || lastTab))
            {
                GdkColor *col=active && opts.highlightTab ? &qtcurve_style->menuitem[3] : &qtcurve_style->gray[3];

                midgc=QTC_SET_MID_COLOR(*col, style->bg[GTK_STATE_NORMAL])

                if(active || firstTab)
                    gdk_draw_point(window, midgc, x, y);
                if(active || lastTab)
                    gdk_draw_point(window, midgc, x, y+height-1);
            }
            break;
    }

    if(area)
    {
        gdk_gc_set_clip_rectangle(gc1, NULL);
        gdk_gc_set_clip_rectangle(gc2, NULL);
        gdk_gc_set_clip_rectangle(fill, NULL);
        gdk_gc_set_clip_rectangle(outer, NULL);

        if(notebook && opts.highlightTab && active)
        {
            gdk_gc_set_clip_rectangle(selGc1, NULL);
            if(!IS_FLAT(opts.appearance))
                gdk_gc_set_clip_rectangle(selGc2, NULL);
        }
    }
}

static void draw_handle(GtkStyle *style, GdkWindow *window, GtkStateType state,
                        GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                        PCONST gchar *detail, gint x, gint y, gint width,
                        gint height, GtkOrientation orientation)
{
    QT_CURVE_STYLE_VAR
    gboolean paf=WIDGET_TYPE_NAME("PanelAppletFrame");
    FN_CHECK

#ifdef QTC_DEBUG
printf("Draw handle %d %d %d %d %s  ", state, shadow_type, width, height, detail ? detail : "NULL");
display_widget(widget, 3);
#endif

    sanitize_size(window, &width, &height);
    gtk_style_apply_default_background(style, window, widget && !GTK_WIDGET_NO_WINDOW(widget), state,
                                       area, x, y, width, height);

#if GTK_MAJOR_VERSION>1
/* CPD: From Industrial */
    if (DETAIL("dockitem") || paf)
        if(GTK_ORIENTATION_HORIZONTAL==orientation)
            orientation=GTK_ORIENTATION_VERTICAL;
        else
            orientation=GTK_ORIENTATION_HORIZONTAL;
#endif
    if(detail && (!strcmp(detail, "paned") || !strcmp(detail+1, "paned")))
    {
        draw_flat_box(style, window, state, shadow_type, area, widget, QTC_PANED, x, y, width,
                      height);

            switch(opts.splitters)
            {
                case LINE_DOTS:
                default:
                    draw_dots(window, x, y, width, height, height>width, NUM_SPLITTER_DASHES, 1,
                              qtcurve_style->gray_gc, area, 0, 5);
                    break;
                case LINE_RAISED:
                    draw_lines(window, x, y, width, height, height>width, NUM_SPLITTER_DASHES, 1,
                        qtcurve_style->gray_gc, area, FALSE, 3, 1);
                    break;
                case LINE_SUNKEN:
                    draw_lines(window, x, y, width, height, height>width, NUM_SPLITTER_DASHES, 1,
                        qtcurve_style->gray_gc, area, TRUE, 3, 1);
                    break;
                case LINE_DASHES:
                    draw_lines(window, x, y, width, height, height>width, NUM_SPLITTER_DASHES, 1,
                        qtcurve_style->gray_gc, area, TRUE, 3, 0);
            }
    }
    else if((DETAIL("handlebox") && widget && GTK_IS_HANDLE_BOX(widget)) || DETAIL("dockitem") || paf)
    {
        if(paf)  /* The paf here is expected to be on the gnome panel */
            if(height<width)
                y++;
            else
                x++;
        else
            draw_box(style, window, state, shadow_type, area, widget, "handlebox", x, y, width,
                     height);

        switch(opts.handles)
        {
            case LINE_DOTS:
                draw_dots(window, x, y, width, height, height<width, 2, 5, qtcurve_style->gray_gc,
                          area, 2, 5);
                break;
            case LINE_DASHES:
                if(height>width)
                    draw_lines(window, x+3, y, 5, height, TRUE, (height-8)/3, 0,
                               qtcurve_style->gray_gc, area, TRUE, 5, 1);
                else
                    draw_lines(window, x, y+3, width, 5, FALSE, (width-8)/3, 0,
                               qtcurve_style->gray_gc, area, TRUE, 5, 1);
                break;
            default:
                draw_lines(window, x, y, width, height, height<width, 2, 4, qtcurve_style->gray_gc,
                           area, LINE_SUNKEN==opts.handles, 3, 1);
        }
    }
}

#ifdef QTC_FIX_PARENTLESS_DIALOGS
#define QTC_GIMP_MAIN   "GimpToolbox"      /* Main GIMP toolbox */
#define QTC_GIMP_WINDOW "GimpDisplayShell" /* Image window */

static void qtc_dialog_set_transient(GtkWidget *widget, gpointer user_data)
{
    GtkWidget *top=NULL;
    GList     *topWindows,
              *node;

    if(GTK_IS_DIALOG(widget) || GTK_APP_GIMP!=qt_settings.app)
        for(topWindows=node=gtk_window_list_toplevels(); node; node = node->next)
        {
            GtkWidget *w=node->data;

            if(w && GTK_IS_WIDGET(w) && w->window && w!=widget &&
               gtk_window_has_toplevel_focus(GTK_WINDOW(w)) &&
               gtk_window_is_active(GTK_WINDOW(w)))
            {
                top=w;
                break;
            }
        }

    if(!top && GTK_APP_GIMP==qt_settings.app)
    {
        for(topWindows=node=gtk_window_list_toplevels(); node; node = node->next)
        {
            GtkWidget *w=node->data;

            if(w && GTK_IS_WIDGET(w) && 0==strcmp(gtk_type_name(GTK_WIDGET_TYPE(w)), QTC_GIMP_MAIN))
            {
                top=w;
                break;
            }
        }
    }

    if(top)
    {
        gdk_window_set_transient_for(widget->window, top->window);
        gtk_window_set_skip_taskbar_hint(GTK_WINDOW(widget), TRUE);
        gtk_window_set_skip_pager_hint(GTK_WINDOW(widget), TRUE);
    }
}

#endif

static void draw_flat_box(GtkStyle *style, GdkWindow *window, GtkStateType state,
                          GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                          PCONST gchar *detail, gint x, gint y, gint width, gint height)
{
#ifdef QTC_DEBUG
printf("Draw flat box %d %d %d %d %d %d %s  ", state, shadow_type, x, y, width, height, detail ? detail : "NULL");
display_widget(widget, 3);
#endif

#ifdef QTC_FIX_PARENTLESS_DIALOGS

#define QTC_MODAL_HACK_NAME "--kgtk-modal-dialog-hack--"
    if(GTK_IS_WINDOW(widget) && detail && 0==strcmp(detail, "base"))
    {
        const gchar *typename=gtk_type_name(GTK_WIDGET_TYPE(widget));

        if(GTK_APP_GIMP_PLUGIN==qt_settings.app)
        {
            /* CPD should really try to find active GIMP window... */
            gtk_window_set_skip_taskbar_hint(GTK_WINDOW(widget), TRUE);
            gtk_window_set_skip_pager_hint(GTK_WINDOW(widget), TRUE);
            gtk_window_set_keep_above(GTK_WINDOW(widget), TRUE);
        }
        else if((GTK_WINDOW(widget)->modal || GTK_IS_DIALOG(widget) ||
                (GTK_APP_GIMP==qt_settings.app &&
                 strcmp(typename, QTC_GIMP_WINDOW) &&
                 strcmp(typename, QTC_GIMP_MAIN) ) ) &&
               (!widget->name || strcmp(widget->name, QTC_MODAL_HACK_NAME)) &&
               NULL==gtk_window_get_transient_for(GTK_WINDOW(widget)))
        {
            /* Give the widget a name so that we dont keep on performing this function... */
            if(!widget->name)
                gtk_widget_set_name(widget, QTC_MODAL_HACK_NAME);

            /*
              For non-modal dialogs we set the transient hint when the "map" event is received, this has the
              effect that the dialog is placed where it would've been without this hack, but it does not get
              a taskbar entry... This "fixes" gimp and its multitude of dialogs...
            */
            if(!GTK_WINDOW(widget)->modal)
                g_signal_connect(G_OBJECT(widget), "map", G_CALLBACK(qtc_dialog_set_transient), widget);
            else
                qtc_dialog_set_transient(widget, NULL);
        }
    }
#endif
    if( GTK_STATE_PRELIGHT==state && (detail && 0==strcmp(detail, QTC_PANED)) ||
        (opts.crLabelHighlight &&
         (GTK_IS_RADIO_BUTTON(widget) || GTK_IS_CHECK_BUTTON(widget))) )
        draw_area_mod(style, window, GTK_STATE_PRELIGHT, area, NULL, opts.highlightFactor, x, y, width, height);
    else
        parent_class->draw_flat_box(style, window, state, shadow_type, area, widget, detail, x, y,
                                    width, height);
}

static void draw_box(GtkStyle *style, GdkWindow *window, GtkStateType state,
                     GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                     PCONST gchar *detail, gint x, gint y, gint width, gint height)
{
    draw_box_qtc(style, window, state, shadow_type, area, widget, detail, x, y, width, height,
                 GTK_STATE_ACTIVE==state
#if GTK_MAJOR_VERSION>1
                 || (GTK_IS_BUTTON(widget) && GTK_BUTTON(widget)->depressed)
#endif
                );
}

static void draw_box_qtc(GtkStyle *style, GdkWindow *window, GtkStateType state,
                         GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                         PCONST gchar *detail, gint x, gint y, gint width,
                         gint height, gboolean btn_down)
{
    QT_CURVE_STYLE_VAR
    gboolean custom_c = FALSE,
             pbar=DETAIL("bar") && GTK_IS_PROGRESS_BAR(widget),
             qtc_paned=IS_QTC_PANED,
             slider=DETAIL("slider"),
             hscale=DETAIL("hscale"),
             vscale=DETAIL("vscale"),
             menubar=DETAIL("menubar"),
             button=DETAIL("button") || DETAIL("togglebutton");
    GdkGC    *new_gcs[TOTAL_SHADES+1],
             **btn_gcs=NULL,
             *midgc=NULL;
    GdkColor new_cols[TOTAL_SHADES+1],
             *btn_cols;
    gboolean lvh=is_list_view_header(widget);
    int      bgnd=0;
#ifdef QTC_DEBUG
printf("Draw box %d %d %d %d %d %d %d %s  ", btn_down, state, shadow_type, x, y, width, height,
       detail ? detail : "NULL");
display_widget(widget, 3);
#endif

    sanitize_size(window, &width, &height);

    bgnd=get_fill(state, btn_down, DETAIL(QTC_CHECKBOX));

    if(use_button_color(detail))
        if(QT_CUSTOM_COLOR_BUTTON(style))
        {
            custom_c=TRUE;
            shade_colors(&(style->bg[state]), new_cols);
            GEN_GCS(style, new_cols, new_gcs);
            btn_gcs=new_gcs;
            btn_cols=new_cols;
        }
        else
        {
            btn_gcs=lvh
                        ? qtcurve_style->listview_gc
                        : SHADE_NONE!=opts.shadeSliders && (slider || vscale || hscale)
                            ? qtcurve_style->slider_gc
                            : qtcurve_style->button_gc;
            btn_cols=lvh
                        ? qtcurve_style->listview
                        : SHADE_NONE!=opts.shadeSliders && (slider || vscale || hscale)
                            ? qtcurve_style->slider
                            : qtcurve_style->button;
        }

    g_return_if_fail(style != NULL);
    g_return_if_fail(window != NULL);

    if((-1==width) &&(-1==height))
        gdk_window_get_size(window, &width, &height);
    else if(-1==width)
        gdk_window_get_size(window, &width, NULL);
    else if(-1==height)
        gdk_window_get_size(window, NULL, &height);

    if(detail && (0==strcmp(detail, "spinbutton_up") || 0==strcmp(detail, "spinbutton_down")))
    {
#if GTK_MAJOR_VERSION>1
        x--;
        y--;
        width+=2;
        height+=2;
#else
        height++;
        if(0==strcmp(detail, "spinbutton_down"))
        {
            y--;
            height++;
        }
#endif

        draw_bgnd(window, btn_gcs[bgnd], widget, area, x+1, y+1, width-2, height-2);

        if(!IS_FLAT(opts.appearance))
        {
            int      sunken=btn_down, /*(NUM_SHADES+1)==bgnd || 3==bgnd, */
                     offset=!sunken ? 2 : 1,
                     d_offset=offset;

            draw_bevel_gradient(style, window, btn_gcs[bgnd], style->colormap, area, NULL, x+offset,
                                y+offset, width-d_offset, height-d_offset, &btn_cols[bgnd],
                                sunken ? SHADE_BEVEL_GRAD_SEL_LIGHT
                                       : SHADE_BEVEL_GRAD_LIGHT,
                                sunken ? SHADE_BEVEL_GRAD_SEL_DARK
                                       : SHADE_BEVEL_GRAD_DARK, TRUE,
                                !sunken, sunken, opts.appearance, WIDGET_OTHER);
        }

        gtk_paint_shadow(style, window, state, shadow_type, area, widget, detail, x+1, y+1,
                         width-2, height-2);
    }
    else if(DETAIL("spinbutton"))
        gtk_style_apply_default_background(style, window, widget && !GTK_WIDGET_NO_WINDOW(widget),
                                           GTK_STATE_INSENSITIVE==state 
                                               ? GTK_STATE_INSENSITIVE 
                                               : GTK_STATE_NORMAL, 
                                           area, x, y, width, height);
    else if(detail &&( button ||
                       0==strcmp(detail, QTC_CHECKBOX) ||
                       /*0==strcmp(detail, "spinbutton") || */
                       0==strcmp(detail, "hscrollbar") ||
                       0==strcmp(detail, "vscrollbar")  ||
                       hscale ||
                       vscale ||
                       slider ||
                       qtc_paned))
    {
        gboolean horiz_tbar,
                 tbar_button=is_button_on_toolbar(widget, &horiz_tbar),
                 handle_button=!tbar_button && is_button_on_handlebox(widget, &horiz_tbar);

        draw_bgnd(window, btn_gcs[bgnd], widget, area, x, y, width, height);

        if(!qtc_paned)
        {
            int x_offset=lvh ? 0 : !IS_GLASS(opts.appearance) && !btn_down ? 2 : 1,
                y_offset=x_offset,
                w_offset=!(tbar_button || handle_button) ? x_offset : x_offset*2,
                h_offset=w_offset;
            gboolean horiz=(tbar_button || handle_button) && IS_GLASS(opts.appearance) &&
                           IS_GLASS(opts.toolbarAppearance)
                               ? horiz_tbar
                               : (slider && width<height) || 0==strcmp(detail, "vscrollbar") ||
                                  vscale
                                   ? FALSE
                                   : TRUE;

            if(IS_FLAT(opts.appearance))
                gdk_draw_rectangle(window, btn_gcs[bgnd], TRUE, x+x_offset, y+y_offset,
                                   width-w_offset, height-h_offset);
            else
            {
                if(!btn_down && !lvh)
                    if(APPEARANCE_BEVELLED==opts.appearance && button)
                    {
                        y+=2;
                        height-=4;
                        y_offset=h_offset=0;
                    }
                    else if(tbar_button || handle_button)
                    {
                        y+=1;
                        y_offset=h_offset=0;
                        height-=2;
                    }

                draw_bevel_gradient(style, window, btn_gcs[bgnd], style->colormap, area, NULL,
                                    x+x_offset, y+y_offset,
                                    width-w_offset, height-h_offset, &btn_cols[bgnd],
                                    btn_down ? SHADE_BEVEL_GRAD_SEL_LIGHT
                                             : SHADE_BEVEL_GRAD_LIGHT,
                                    btn_down ? SHADE_BEVEL_GRAD_SEL_DARK
                                             : SHADE_BEVEL_GRAD_DARK, horiz,
                                    !btn_down, btn_down,
                                    lvh ? opts.lvHeaderAppearance : opts.appearance,
                                    lvh
                                        ? WIDGET_LISTVIEW_HEADER
                                        : tbar_button || button
                                            ? WIDGET_STD_BUTTON
                                            : WIDGET_OTHER);

                if(!btn_down && !lvh)
                    if(APPEARANCE_BEVELLED==opts.appearance && button)
                    {
                        y-=2;
                        height+=4;
                    }
                    else if(tbar_button || handle_button)
                    {
                        y-=1;
                        height+=2;
                    }
            }
            if(button && GTK_WIDGET_HAS_DEFAULT(widget))
                if(IND_CORNER==opts.defBtnIndicator)
                {
                    int      sunken=2==bgnd || 3==bgnd,
                             offset=sunken ? 4 : 3;
                    GdkGC    *gc=btn_gcs[GTK_STATE_ACTIVE==state ? 0 : 4];
                    GdkPoint points[3] = { { x+offset, y+offset }, { x+offset+6, y+offset},
                                           { x+offset, y+offset+6}};

                    if(area)
                        gdk_gc_set_clip_rectangle(gc, area);

                    gdk_draw_polygon(window, gc, TRUE, points, 3);

                    if(area)
                        gdk_gc_set_clip_rectangle(gc, NULL);
                }
#if GTK_MAJOR_VERSION>1
                else if(IND_COLORED==opts.defBtnIndicator && (COLORED_BORDER_SIZE>2))
                {
                    int       b=COLORED_BORDER_SIZE-2,
                              b2=b*2,
                              xx=x+x_offset, yy=y+x_offset, ww=width-x_offset, hh=height-x_offset,
                              i_off=btn_down || IS_GLASS(opts.appearance) ? 1 : 0;
                    GdkGC     *gc=qtcurve_style->defbtn_gc[bgnd];
                    GdkPoint  outer[4]={ {xx, yy}, {xx+ww-1, yy}, {xx+ww-1, yy+hh-1}, {xx, yy+hh-1} },
                              inner[4]={ {xx+b+i_off, yy+b+i_off },
                                         {(xx+ww-1)-b2, yy+b+i_off},
                                         {(xx+ww-1)-b2, (yy+hh-1)-b2}, {xx+b+i_off, (yy+hh-1)-b2} };
                    GdkRegion *outer_region=gdk_region_polygon(outer, 4, GDK_EVEN_ODD_RULE),
                              *inner_region=gdk_region_polygon(inner, 4, GDK_EVEN_ODD_RULE);

                    gdk_region_xor(inner_region, outer_region);

                    draw_bevel_gradient(style, window, gc, style->colormap,
                                        NULL, inner_region, xx, yy, ww, hh,
                                        &qtcurve_style->defbtn[bgnd],
                                        btn_down ? SHADE_BEVEL_GRAD_SEL_LIGHT
                                                 : SHADE_BEVEL_GRAD_LIGHT,
                                        btn_down ? SHADE_BEVEL_GRAD_SEL_DARK
                                                 : SHADE_BEVEL_GRAD_DARK, horiz,
                                        !btn_down, btn_down, opts.appearance,
                                        WIDGET_DEF_BUTTON);

                    gdk_region_destroy(inner_region);
                    gdk_region_destroy(outer_region);
                }
#endif
        }

/*
        if(tbar_button)
            if(horiz_tbar)
                height--;
            else
                width--;
*/
        gtk_paint_shadow(style, window, state, shadow_type, area, widget,
                         qtc_paned ? QTC_PANED : detail, x, y,
                         width, height);

#if GTK_MAJOR_VERSION>1
        if(DETAIL("button"))
        {
            gboolean combo=is_on_combo(widget, 0),
                     combo_entry=is_on_combo_entry(widget, 0);

            if(combo || combo_entry)
            {
                int vx=x+(width - (1 + (combo_entry ? 24 : 20))),
                    vwidth=width-(vx-x);

                if(!combo_entry)
                {
                    if(area)
                    {
                        gdk_gc_set_clip_rectangle(btn_gcs[5], area);
                        gdk_gc_set_clip_rectangle(btn_gcs[0], area);
                    }

                    gdk_draw_line(window, btn_gcs[5], vx, y+4, vx, y+height-5);
                    gdk_draw_line(window, btn_gcs[0], vx+1, y+4, vx+1, y+height-5);

                    if(area)
                    {
                        gdk_gc_set_clip_rectangle(btn_gcs[5], NULL);
                        gdk_gc_set_clip_rectangle(btn_gcs[0], NULL);
                    }
                }

                if(GTK_STATE_ACTIVE==state)
                {
                    vx++;
                    y++;
                }

                draw_arrow(window, style->text_gc[QTC_ARROW_STATE(state)], area,  GTK_ARROW_DOWN,
                           vx+((vwidth - LARGE_ARR_WIDTH)>>1),
                           y+((height-LARGE_ARR_HEIGHT)>>1), LARGE_ARR_WIDTH, LARGE_ARR_HEIGHT);
            }
        }
#endif
    }
    else if(detail && (0==strcmp(detail, "buttondefault") ||
                       0==strcmp(detail, "togglebuttondefault")))
    {
    }
    else if(widget && DETAIL("trough"))
    {
        gboolean pbar=GTK_IS_PROGRESS_BAR(widget);
        GdkGC    *bgnd=pbar ? qtcurve_style->gray_gc[ORIGINAL_SHADE] : qtcurve_style->gray_gc[2],
                 *gcl =pbar ? qtcurve_style->gray_gc[0] : qtcurve_style->gray_gc[4],
                 *gcd =/*pbar ? qtcurve_style->gray_gc[5] : */qtcurve_style->gray_gc[5];
        GdkColor *bgndcol=&qtcurve_style->gray[2];
#if GTK_MAJOR_VERSION>1
        gboolean horiz=GTK_IS_RANGE(widget) ? GTK_ORIENTATION_HORIZONTAL==GTK_RANGE(widget)->orientation : width>height;
#else
        gboolean horiz=width>height;
#endif

        if(area)
        {
            gdk_gc_set_clip_rectangle(bgnd, area);
            gdk_gc_set_clip_rectangle(gcl, area);
            gdk_gc_set_clip_rectangle(gcd, area);
        }

        if(GTK_IS_SCALE(widget))
        {
            GtkAdjustment *adjustment = gtk_range_get_adjustment(GTK_RANGE(widget));
            int           used_x=x, used_y=y, used_h=0, used_w=0,
                          rest_x=x, rest_y=y, rest_h=height, rest_w=width,
                          pos=(int)(((double)(horiz ? width : height) /
                                     (adjustment->upper - adjustment->lower))  *
                                 (adjustment->value - adjustment->lower));
#if GTK_MAJOR_VERSION>1
            gboolean      reverse=reverse_layout(widget) || gtk_range_get_inverted(GTK_RANGE(widget));
#else
            gboolean      reverse=FALSE;
#endif

            gtk_style_apply_default_background(style, window, widget && !GTK_WIDGET_NO_WINDOW(widget),
                                               GTK_STATE_INSENSITIVE==state
                                                   ? GTK_STATE_INSENSITIVE 
                                                   : GTK_STATE_NORMAL, 
                                               area, x, y, width, height);

            if(horiz)
            {
                y +=(height - SCALE_SIZE)>>1;
                height = SCALE_SIZE;
                rest_y=used_y=y;
                rest_h=used_h=height;
            }
            else
            {
                x +=(width - SCALE_SIZE)>>1;
                width = SCALE_SIZE;
                rest_x=used_x=x;
                rest_w=used_w=width;
            }

            if(opts.fillSlider && adjustment->upper!=adjustment->lower)
            {
                if(horiz)
                    if(reverse)
                    {
                        used_x=width-pos;
                        used_w=pos;
                        rest_w-=pos;
                    }
                    else
                    {
                        used_w=pos;
                        rest_w-=pos;
                        rest_x+=pos;
                    }
                else
                    if(reverse)
                    {
                        used_y+=height-pos;
                        used_h=pos;
                        rest_h=height-pos;
                    }
                    else
                    {
                        used_h=height-pos;
                        rest_h=pos;
                        used_y+=pos;
                    }

                used_x++; used_y++; used_h-=2; used_w-=2;

                if(used_w>0 && used_h>0)
                {
                    GdkGC *usedgc=SHADE_NONE!=opts.shadeSliders
                                    ? qtcurve_style->slider_gc[ORIGINAL_SHADE]
                                    : qtcurve_style->menuitem_gc[2];

                    if(APPEARANCE_FLAT==opts.appearance)
                    {
                        if(area)
                            gdk_gc_set_clip_rectangle(usedgc, area);
                        gdk_draw_rectangle(window, usedgc, TRUE, used_x, used_y, used_w, used_h);
                        if(area)
                            gdk_gc_set_clip_rectangle(usedgc, NULL);
                    }
                    else
                    {
                        GdkColor *usedcol=SHADE_NONE!=opts.shadeSliders
                                        ? &qtcurve_style->slider[ORIGINAL_SHADE]
                                        : &qtcurve_style->menuitem[2];
                        draw_bevel_gradient(style, window, usedgc, style->colormap, area, NULL, used_x,
                                            used_y, used_w, used_h, usedcol, SHADE_SLIDER_LIGHT,
                                            SHADE_SLIDER_DARK, horiz, FALSE, FALSE, APPEARANCE_GRADIENT,
                                            WIDGET_OTHER);
                    }
                }
            }

            rest_x++; rest_y++; rest_h-=2; rest_w-=2;

            if(rest_w>0 && rest_h>0)
                if(APPEARANCE_FLAT==opts.appearance)
                    gdk_draw_rectangle(window, bgnd, TRUE, rest_x, rest_y, rest_w, rest_h);
                else
                    draw_bevel_gradient(style, window, bgnd, style->colormap, area, NULL, rest_x,
                                        rest_y, rest_w, rest_h, bgndcol, SHADE_SLIDER_LIGHT,
                                        SHADE_SLIDER_DARK, horiz, FALSE, FALSE, APPEARANCE_GRADIENT,
                                        WIDGET_OTHER);
            gdk_draw_rectangle(window, gcd, FALSE, x, y, width - 1, height - 1);

            if(QTC_ROUNDED)
            {
                midgc=QTC_SET_MID_COLOR(qtcurve_style->gray[5], style->bg[state])
                gdk_draw_point(window, midgc, x, y);
                gdk_draw_point(window, midgc, x+width-1, y);
                gdk_draw_point(window, midgc, x+width-1, y+height-1);
                gdk_draw_point(window, midgc, x, y+height-1);
            }
        }
        else if(GTK_IS_PROGRESS_BAR(widget))
        {
            gdk_draw_rectangle(window, bgnd, TRUE, x, y, width, height);

            if(GTK_STATE_INSENSITIVE!=state)
            {
                if(area)
                    gdk_gc_set_clip_rectangle(style->base_gc[state], area);
                gdk_draw_rectangle(window, style->base_gc[state], TRUE, x+2, y+2, width-4, height-4);
                if(area)
                    gdk_gc_set_clip_rectangle(style->base_gc[state], NULL);
            }

            if(QTC_ROUNDED)
            {
                draw_3d_border(widget && widget->parent ? widget->parent->style : style,
                               window, state, area, x, y, width, height, TRUE,
                               qtcurve_style->gray_gc[5], &(qtcurve_style->gray[5]),
                               qtcurve_style->gray_gc[0], qtcurve_style->gray_gc[0],
                               qtcurve_style->gray_gc, qtcurve_style->gray,
                               ROUNDED_ALL, FALSE, FALSE, BORDER_SUNKEN, TRUE, TRUE);
            }
            else
            {
                gdk_draw_line(window, gcd, x,         y,          x+width-2, y);
                gdk_draw_line(window, gcd, x,         y,          x,         y+height-2);
                gdk_draw_line(window, gcl, x,         y+height-1, x+width-1, y+height-1);
                gdk_draw_line(window, gcl, x+width-1, y+height-1, x+width-1, y);
            }
        }
        else /* Scrollbars... */
        {
            if(APPEARANCE_FLAT==opts.appearance)
                gdk_draw_rectangle(window, bgnd, TRUE, x, y, width, height);
            else
                draw_bevel_gradient(style, window, bgnd, style->colormap, area, NULL, x+1,
                                    y+1, width-2, height-2, bgndcol, SHADE_SBAR_LIGHT,
                                    SHADE_SBAR_DARK, horiz, FALSE, FALSE, APPEARANCE_GRADIENT,
                                    WIDGET_OTHER);
            gdk_draw_rectangle(window, gcd, FALSE, x, y, width - 1, height - 1);
        }

        if(area)
        {
            gdk_gc_set_clip_rectangle(bgnd, NULL);
            gdk_gc_set_clip_rectangle(gcl, NULL);
            gdk_gc_set_clip_rectangle(gcd, NULL);
        }
    }
    else if(widget && ( (detail && ( menubar || 0==strcmp(detail,"toolbar") ||
                                     0==strcmp(detail,"dockitem") ||
                                     0==strcmp(detail,"dockitem_bin") ||
                                     0==strcmp(detail, "handlebox") ||
                                     0==strcmp(detail,"handlebox_bin") ) )
                        || WIDGET_TYPE_NAME("PanelAppletFrame")) && shadow_type != GTK_SHADOW_NONE)
    {
        GdkColor    bgnd=menubar && USE_SHADED_MENU_BAR_COLORS
                                ? qtcurve_style->menubar[ORIGINAL_SHADE]
                                : style->bg[state];
        GdkGCValues old_values;
        GdkGC       *gc=menubar && USE_SHADED_MENU_BAR_COLORS
                            ? qtcurve_style->menubar_gc[ORIGINAL_SHADE]
                            : style->bg_gc[state];
        EAppearance app=menubar ? opts.menubarAppearance : opts.toolbarAppearance;

        /* Toolbars and menus */
        if(!IS_FLAT(app))
        {
            if(menubar && SHADE_DARKEN==opts.shadeMenubars)
            {
                shade(&bgnd, &bgnd, MENUBAR_DARK_FACTOR);

                gdk_gc_get_values(gc, &old_values);
                gdk_rgb_find_color(style->colormap, &bgnd);
                gdk_gc_set_foreground(gc, &bgnd);
            }

            draw_bevel_gradient(style, window, gc, style->colormap, area, NULL, x, y, width,
                                height, &bgnd,
                                IS_GLASS(app)
                                    ? SHADE_BEVEL_GRAD_LIGHT
                                    : SHADE_MENU_LIGHT,
                                IS_GLASS(app)
                                    ? SHADE_BEVEL_GRAD_DARK
                                    : SHADE_MENU_DARK,
                                menubar
                                    ? TRUE
                                    : DETAIL("handlebox")
                                          ? width<height
                                          : width>height,
                                TRUE, FALSE, app, WIDGET_OTHER);

            if(menubar && SHADE_DARKEN==opts.shadeMenubars)
                gdk_gc_set_foreground(gc, &old_values.foreground);
        }
        else if(menubar && SHADE_DARKEN==opts.shadeMenubars)
            draw_area_mod(style, window, GTK_STATE_NORMAL, area, NULL, MENUBAR_DARK_FACTOR, x, y,
                          width, height);
#if GTK_MAJOR_VERSION>1
        else if(qt_settings.app!=GTK_APP_OPEN_OFFICE)
            gdk_draw_rectangle(window, gc, TRUE, x, y, width, height);
        else
            gtk_style_apply_default_background(style, window, widget && !GTK_WIDGET_NO_WINDOW(widget),
                                               state, area, x, y, width, height);
            /*Causes OO.o gtk2 errors? gdk_draw_rectangle(window, gc, TRUE, x, y, width, height);*/
#else
        else
            gdk_draw_rectangle(window, gc, TRUE, x, y, width, height);
#endif

        if(TB_NONE!=opts.toolbarBorders)
        {
            gboolean top=FALSE,
                     bottom=FALSE,
                     left=FALSE,
                     right=FALSE;
            int      border=TB_DARK==opts.toolbarBorders ? 5 : 3;
            GdkGC    **gcs=menubar && USE_SHADED_MENU_BAR_COLORS
                             ? qtcurve_style->menubar_gc : qtcurve_style->gray_gc;

            if(area)
            {
                gdk_gc_set_clip_rectangle(gcs[0], area);
                gdk_gc_set_clip_rectangle(gcs[border], area);
            }

            if(menubar)
                top=bottom=left=right=TRUE;
            else if(0==strcmp(detail,"toolbar")) /*  && (GTK_IS_TOOLBAR(widget) ||
                   WIDGET_TYPE_NAME("BonoboUIToolbar"))) */
            {
                if(!GTK_IS_TOOLBAR(widget))
                    if(width>height)
                        top=bottom=right=TRUE;
                    else   /* MUST have a handle */
                        left=right=bottom=TRUE;
                else
                    top=bottom=left=right=TRUE;
#if 0
#if GTK_MAJOR_VERSION>1
                    if(GTK_ORIENTATION_HORIZONTAL==gtk_toolbar_get_orientation(GTK_TOOLBAR(widget)))
#else
                    if(GTK_ORIENTATION_HORIZONTAL==GTK_PROGRESS_BAR(widget)->orientation)
#endif
                        top=bottom=TRUE;
                    else   /* MUST have a handle */
                        left=right=bottom=TRUE;
#endif
            }
            else if(0==strcmp(detail,"dockitem_bin") || /* CPD: bit risky - what if only 1 item ??? */
                    0==strcmp(detail, "handlebox_bin"))
            {
                if(width<height)
                    left=right=bottom=TRUE;
                else
                    top=bottom=right=TRUE;
            }
            else /* handle */
                if(width<height) /* on horiz toolbar */
                    top=bottom=left=TRUE;
                else
                    left=right=top=TRUE;

            if(top)
                gdk_draw_line(window, gcs[0], x, y, x + width-1, y);
            if(left)
                gdk_draw_line(window, gcs[0], x, y, x, y+height-1);
            if(bottom)
                gdk_draw_line(window, gcs[border], x, y + height - 1, x + width-1,
                              y + height - 1);
            if(right)
                gdk_draw_line(window, gcs[border], x+width-1, y, x + width-1, y + height - 1);

            if(area)
            {
                gdk_gc_set_clip_rectangle(gcs[0], NULL);
                gdk_gc_set_clip_rectangle(gcs[border], NULL);
            }
        }
    }
    else if(widget &&(DETAIL("menuitem") || pbar))
    {
        GdkRegion *region=NULL;
        gboolean  is_menubar_item=DETAIL("menuitem") && get_menu_bar(widget, 0);
        int       offset=APPEARANCE_GRADIENT==opts.appearance ? 0 : 1;
#if GTK_MAJOR_VERSION>1
        int       animShift=-PROGRESS_CHUNK_WIDTH;
#endif

#if GTK_MAJOR_VERSION>1
        if(pbar && opts.stripedProgress)
        {
            GdkRectangle rect={x+offset, y+offset, width-2, height-2};
            int          stripeOffset;

            if(opts.animatedProgress && QTC_IS_PROGRESS_BAR(widget))
            {
                if(!GTK_PROGRESS(widget)->activity_mode)
                    qtc_animation_progressbar_add((gpointer)widget);

                animShift+=((int)(qtc_animation_elapsed(widget)*PROGRESS_CHUNK_WIDTH))%(PROGRESS_CHUNK_WIDTH*2);
            }

            constrain_rect(&rect, area);
            region=gdk_region_rectangle(&rect);

            if(is_horizontal_pbar(widget))
                for(stripeOffset=0; stripeOffset<(width+PROGRESS_CHUNK_WIDTH);
                    stripeOffset+=(PROGRESS_CHUNK_WIDTH*2))
                {
                    GdkRectangle inner_rect={x+stripeOffset+animShift, y+1, PROGRESS_CHUNK_WIDTH, height-2};

                    constrain_rect(&inner_rect, area);
                    if(inner_rect.width>0 && inner_rect.height>0)
                    {
                        GdkRegion *inner_region=gdk_region_rectangle(&inner_rect);

                        gdk_region_xor(region, inner_region);
                        gdk_region_destroy(inner_region);
                    }
                }
            else
                for(stripeOffset=0; stripeOffset<(height+PROGRESS_CHUNK_WIDTH);
                    stripeOffset+=(PROGRESS_CHUNK_WIDTH*2))
                {
                    GdkRectangle inner_rect={x+1, y+stripeOffset+animShift, width-2, PROGRESS_CHUNK_WIDTH};

                    constrain_rect(&inner_rect, area);
                    if(inner_rect.width>0 && inner_rect.height>0)
                    {
                        GdkRegion *inner_region=gdk_region_rectangle(&inner_rect);

                        gdk_region_xor(region, inner_region);
                        gdk_region_destroy(inner_region);
                    }
                }
        }
#endif

        switch(opts.appearance)
        {
            default:
            {
                GdkGC    *border_gc=qtcurve_style->menuitem_gc[5];
                GdkColor *border_col=&qtcurve_style->menuitem[5];
                int      round=pbar ? get_pbar_round(widget)
                                    : is_menubar_item && opts.menubarRoundTopOnly
                                       ? ROUNDED_TOP
                                       : ROUNDED_ALL;

                if(area)
                    gdk_gc_set_clip_rectangle(style->base_gc[state], area);

                if(pbar)
                {
                    x++; y++; width-=2, height-=2;
                }

                draw_bevel_gradient(style, window, qtcurve_style->menuitem_gc[ORIGINAL_SHADE],
                                    style->colormap, area, NULL, x+offset, y+offset,
                                    width-(2*offset), height-(2*offset),
                                    &qtcurve_style->menuitem[ORIGINAL_SHADE],
                                    SHADE_BEVEL_GRAD_LIGHT, SHADE_BEVEL_GRAD_DARK,
                                    TRUE, TRUE, FALSE, opts.appearance, WIDGET_OTHER);

#if GTK_MAJOR_VERSION>1
                if(pbar && opts.stripedProgress)
                    draw_bevel_gradient(style, window, qtcurve_style->menuitem_gc[1], style->colormap, NULL,
                                        region, x+offset, y+offset+1,
                                        width-(2*offset), height-((2*offset)+2),
                                        &qtcurve_style->menuitem[1],
                                        SHADE_BEVEL_GRAD_LIGHT, SHADE_BEVEL_GRAD_DARK,
                                        TRUE, TRUE, FALSE, opts.appearance, WIDGET_OTHER);
#endif

                draw_3d_border(style, window, state, area, x, y, width, height, TRUE,
                               border_gc, border_col,
                               qtcurve_style->menuitem_gc[4],
                               qtcurve_style->menuitem_gc[/*APPEARANCE_GRADIENT==opts.appearance ? 6 : */0],
                               qtcurve_style->menuitem_gc, qtcurve_style->menuitem, round, TRUE, FALSE,
                               BORDER_FLAT, FALSE, !USE_SHADED_MENU_BAR_COLORS);

                if(pbar && QTC_ROUNDED && ROUNDED_ALL!=round)
                {
                    midgc=QTC_SET_MID_COLOR(qtcurve_style->menuitem[2],
                                            qtcurve_style->gray[ORIGINAL_SHADE])

                    x--; y--; width+=2; height+=2;

                    if(!(round&CORNER_TL))
                        gdk_draw_point(window, midgc, x, y);
                    if(!(round&CORNER_TR))
                        gdk_draw_point(window, midgc, x+width-1, y);
                    if(!(round&CORNER_BR))
                        gdk_draw_point(window, midgc, x+width-1, y+height-1);
                    if(!(round&CORNER_BL))
                        gdk_draw_point(window, midgc, x, y+height-1);
                }

                if(area)
                    gdk_gc_set_clip_rectangle(style->base_gc[state], NULL);
                break;
            }
            case APPEARANCE_FLAT:
                if(area)
                    gdk_gc_set_clip_rectangle(qtcurve_style->menuitem_gc[opts.stripedProgress ? ORIGINAL_SHADE : 0], area);

                gdk_draw_rectangle(window, qtcurve_style->menuitem_gc[opts.stripedProgress ? ORIGINAL_SHADE : 0],
                                   TRUE, x, y, width, height);

                if(area)
                    gdk_gc_set_clip_rectangle(qtcurve_style->menuitem_gc[opts.stripedProgress ? ORIGINAL_SHADE : 0], NULL);

#if GTK_MAJOR_VERSION>1
                if(pbar && opts.stripedProgress)
                {
                    gdk_gc_set_clip_region(qtcurve_style->menuitem_gc[1], region);
                    gdk_draw_rectangle(window, qtcurve_style->menuitem_gc[1], TRUE, x, y, width, height);
                    gdk_gc_set_clip_region(qtcurve_style->menuitem_gc[1], NULL);
                }
#endif
        }

        if(region)
            gdk_region_destroy(region);
    }
    else if(widget && DETAIL("optionmenu"))
    {
        GtkRequisition indicator_size;
        GtkBorder      indicator_spacing;
        gboolean       sunken=2==bgnd || 3==bgnd;

        if(!sunken && is_active_combo(widget))
        {
            sunken=TRUE;
            bgnd=4;
        }

        if(!style->bg_pixmap[state]
#if GTK_MAJOR_VERSION>1
                || GDK_IS_PIXMAP(window)
#endif
         )
        {
            draw_bgnd(window, btn_gcs[bgnd], widget, area, x, y, width, height);
            if(!IS_FLAT(opts.appearance))
            {
                int offset=1;

                draw_bevel_gradient(style, window, btn_gcs[bgnd], style->colormap, area, NULL,
                                    x+offset, y+offset, width-(2*offset), height-(2*offset),
                                    &btn_cols[bgnd],
                                    sunken ? SHADE_BEVEL_GRAD_SEL_LIGHT
                                           : SHADE_BEVEL_GRAD_LIGHT,
                                    sunken ? SHADE_BEVEL_GRAD_SEL_DARK
                                           : SHADE_BEVEL_GRAD_DARK,
                                    TRUE, !sunken, sunken, opts.appearance, WIDGET_STD_BUTTON);
            }
        }
        else
            gtk_style_apply_default_background(style, window, widget && !GTK_WIDGET_NO_WINDOW(widget),
                                               state, area, x, y, width, height);

        gtk_paint_shadow(style, window, state, shadow_type, area, widget, detail, x, y, width,
                         height);
        option_menu_get_props(widget, &indicator_size, &indicator_spacing);

        if(area)
        {
            gdk_gc_set_clip_rectangle(btn_gcs[0], area);
            gdk_gc_set_clip_rectangle(btn_gcs[5], area);
        }

#if (GTK_MAJOR_VERSION>1) && (GTK_MINOR_VERSION<2)
        y++;
        height-=2;
#endif
        y+=3;
        height-=6;

        if(sunken)
        {
            x++;
            y++;
            height--;
        }

        gdk_draw_line(window, btn_gcs[5],
                      x + width -(indicator_size.width + indicator_spacing.left +
                          indicator_spacing.right) - 
                          QT_STYLE->xthickness,
                      y + QT_STYLE->ythickness,
                      x + width -(indicator_size.width + indicator_spacing.left +
                          indicator_spacing.right) - 
                          QT_STYLE->xthickness,
                      y + height - QT_STYLE->ythickness-1);

        if(!sunken)
            gdk_draw_line(window, btn_gcs[0],
                    x + width -(indicator_size.width + indicator_spacing.left + indicator_spacing.right) - 
                        QT_STYLE->xthickness + 1,
                    y + QT_STYLE->ythickness,
                    x + width -(indicator_size.width + indicator_spacing.left + indicator_spacing.right) - 
                        QT_STYLE->xthickness + 1,
                    y + height - QT_STYLE->ythickness - 1);

        if(area)
        {
            gdk_gc_set_clip_rectangle(btn_gcs[0], NULL);
            gdk_gc_set_clip_rectangle(btn_gcs[5], NULL);
        }
    }
    else if(DETAIL("menu") && opts.lighterPopupMenuBgnd)
    {
        draw_area_mod(style, window, state, area, NULL, POPUPMENU_LIGHT_FACTOR, x, y, width, height);
        if(area)
            gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[5], area);
        gdk_draw_rectangle(window, qtcurve_style->gray_gc[5], FALSE, x, y, width-1, height-1);
        if(area)
            gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[5], NULL);
    }
    else
        parent_class->draw_box(style, window, state, shadow_type, area, widget, detail, x, y, width,
                               height);

#if GTK_MAJOR_VERSION==1
    if(DETAIL("slider"))
    {
        const char     *slider_detail = detail;
        GtkOrientation orientation = GTK_ORIENTATION_VERTICAL;

        if(widget)
        {
            if(GTK_IS_HSCALE(widget))
            {
                slider_detail = "hscale";
                orientation = GTK_ORIENTATION_HORIZONTAL;
            }
            else if(GTK_IS_VSCALE(widget))
            {
                slider_detail = "vscale";
                orientation = GTK_ORIENTATION_VERTICAL;
            }
            else if(GTK_IS_HSCROLLBAR(widget))
                orientation = GTK_ORIENTATION_HORIZONTAL;
        }

        real_draw_slider(style, window, state, shadow_type, area, widget, slider_detail, x, y, width,
                         height, orientation);
    }
#endif
    if(detail &&(!strcmp(detail, "paned") || !strcmp(detail+1, "paned")))
    {
        GtkOrientation orientation = GTK_ORIENTATION_HORIZONTAL;

        if(*detail == 'h')
            orientation = GTK_ORIENTATION_VERTICAL;

        draw_handle(style, window, state, shadow_type, area, widget, detail, x, y, width, height,
                    orientation);
    }
    if(custom_c)
        RELEASE_GCS(new_gcs);

#if GTK_MAJOR_VERSION==1
        /* CPD: HACK - force trough to be drawn */
        if(widget && GTK_IS_RANGE(widget))
        {
            static int called=0;

            if(!called)  /* Prevent recursion */
            {
                called=1;
                gtk_range_draw_trough(GTK_RANGE(widget));
                called=0;
            }
        }
#endif
}

#if GTK_MAJOR_VERSION>1
static void draw_slider
#else
static void real_draw_slider
#endif
               (GtkStyle *style, GdkWindow *window, GtkStateType state, GtkShadowType shadow_type, 
                GdkRectangle *area, GtkWidget *widget, PCONST gchar *detail, gint x, gint y,
                gint width, gint height, GtkOrientation orientation)
{
    QT_CURVE_STYLE_VAR
    gboolean custom_c = FALSE,
             slider=DETAIL("slider"),
             hscale=DETAIL("hscale"),
             vscale=DETAIL("vscale");
    GdkGC    *new_gcs[TOTAL_SHADES+1],
             **btn_gcs;
    int      min=MIN_SLIDER_SIZE(opts.sliderThumbs);

    if(use_button_color(detail))
        if(QT_CUSTOM_COLOR_BUTTON(style))
        {
            GdkColor new_colors[TOTAL_SHADES+1];
            custom_c=TRUE;
            shade_colors(&(style->bg[state]), new_colors);
            GEN_GCS(style, new_colors, new_gcs);
            btn_gcs=new_gcs;
        }
        else
            btn_gcs=SHADE_NONE!=opts.shadeSliders && (slider || vscale || hscale)
                        ? qtcurve_style->slider_gc
                        : qtcurve_style->button_gc;

    FN_CHECK
    sanitize_size(window, &width, &height);

#if GTK_MAJOR_VERSION>1
    gtk_paint_box(style, window, state, shadow_type, area, widget, detail, x, y, width, height);
#endif

   /* Orientation is always vertical with Mozilla, why? Anyway this hack should be OK - as we only draw dashes when 
      slider is larger than 'min' pixels... */
    orientation=width<height ? GTK_ORIENTATION_VERTICAL : GTK_ORIENTATION_HORIZONTAL;
    if(detail &&(slider || hscale || vscale) &&
      LINE_NONE!=opts.sliderThumbs &&
      (((hscale || GTK_ORIENTATION_HORIZONTAL==orientation) && width>=min) || height>=min))
        switch(opts.sliderThumbs)
        {
            case LINE_SUNKEN:
                draw_lines(window, x, y, width, height,
                           !(hscale || GTK_ORIENTATION_HORIZONTAL==orientation),
                           4, 3, btn_gcs, area, TRUE, 3, 1);
                break;
            case LINE_RAISED:
                draw_lines(window, x, y, width, height,
                           !(hscale || GTK_ORIENTATION_HORIZONTAL==orientation),
                           4, 3, btn_gcs, area, FALSE, 3, 1);
                break;
            default:
            case LINE_DOTS:
                draw_dots(window, x, y, width, height,
                           !(hscale || GTK_ORIENTATION_HORIZONTAL==orientation),
                           5, 2, btn_gcs, area, 0, 5);
        }

    if(custom_c)
        RELEASE_GCS(new_gcs);
}

#if GTK_MAJOR_VERSION==1
static void draw_slider(GtkStyle *style, GdkWindow *window, GtkStateType state,
                        GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                        PCONST gchar *detail, gint x, gint y, gint width,
                        gint height, GtkOrientation orientation)
{
    QT_CURVE_STYLE_VAR
    FN_CHECK
    sanitize_size(window, &width, &height);
    gtk_paint_box(style, window, state, shadow_type, area, widget, detail, x, y, width, height);
    real_draw_slider(style, window, state, shadow_type, area, widget, detail, x, y, width, height,
                     orientation);
}
#endif

static void draw_shadow_gap(GtkStyle *style, GdkWindow *window, GtkStateType state,
                            GtkShadowType shadow_type, GdkRectangle *area, GtkWidget *widget,
                            PCONST gchar *detail, gint x, gint y, gint width,
                            gint height, GtkPositionType gap_side, gint gap_x, gint gap_width)
{
    qtc_draw_box_gap(style, window, shadow_type, state, widget, area, x, y,
                     width, height, gap_side, gap_x, gap_width, BORDER_FLAT, FALSE);
}

static void draw_hline(GtkStyle *style, GdkWindow *window, GtkStateType state, GdkRectangle *area, 
                       GtkWidget *widget, PCONST gchar *detail, gint x1, gint x2, gint y)
{
    QT_CURVE_STYLE_VAR
    gboolean tbar=DETAIL("toolbar");
    int      light=0,
             dark=5;
    FN_CHECK

#ifdef QTC_DEBUG
printf("Draw hline %d %d %d %d %s  ", state, x1, x2, y, detail ? detail : "NULL");
display_widget(widget, 3);
#endif

    if(tbar)
    {
        dark=3;

        switch(opts.toolbarSeparators)
        {
            case LINE_RAISED:
                light=dark;
                dark=0;
                break;
            case LINE_DOTS:
                draw_dots(window, x1, y, x2-x1, 2, FALSE, (((x2-x1)/3.0)+0.5), 0,
                          qtcurve_style->gray_gc, area, 0, 5);
                return;
            case LINE_NONE:
                return;
        }
    }

    if(area)
    {
        gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[light], area);
        gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[dark], area);
    }

    if(DETAIL("label"))
    {
        if(state == GTK_STATE_INSENSITIVE)
            gdk_draw_line(window, qtcurve_style->gray_gc[light], x1 + 1, y + 1, x2 + 1, y + 1);
        gdk_draw_line(window, style->text_gc[state], x1, y, x2, y);     
    }
    else
    {
        gdk_draw_line(window, qtcurve_style->gray_gc[dark], x1, y, x2, y);
        if(tbar || DETAIL("menuitem"))
            gdk_draw_line(window, qtcurve_style->gray_gc[light], x1, y+1, x2, y+1);
    }

    if(area)
    {
        gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[light], NULL);
        gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[dark], NULL);
    }
}

static void draw_vline(GtkStyle *style, GdkWindow *window, GtkStateType state, GdkRectangle *area, 
                       GtkWidget *widget, PCONST gchar *detail, gint y1, gint y2, gint x)
{
    QT_CURVE_STYLE_VAR
    FN_CHECK

#ifdef QTC_DEBUG
printf("Draw vline %d %d %d %d %s  ", state, x, y1, y2, detail ? detail : "NULL");
display_widget(widget, 3);
#endif

#if GTK_MAJOR_VERSION>1
    if(!(DETAIL("vseparator") && is_on_combo(widget, 0))) /* CPD: Combo handled in qtc_draw_box */
#endif
    {
        int      dark=5,
                 light=0;
        gboolean tbar=DETAIL("toolbar");

        if(tbar)
        {
            dark=3;

            switch(opts.toolbarSeparators)
            {
                case LINE_RAISED:
                    light=dark;
                    dark=0;
                    break;
                case LINE_DOTS:
                    draw_dots(window, x, y1, 2, y2-y1, TRUE, (((y2-y1)/3.0)+0.5), 0,
                            qtcurve_style->gray_gc, area, 0, 5);
                    return;
                case LINE_NONE:
                    return;
            }
        }

        if(area)
        {
            gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[dark], area);
            gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[light], area);
        }

        gdk_draw_line(window, qtcurve_style->gray_gc[dark], x, y1, x, y2 - 1);

        if(tbar)
            gdk_draw_line(window, qtcurve_style->gray_gc[light], x+1, y1, x+1, y2 - 1);

        if(area)
        {
            gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[dark], NULL);
            gdk_gc_set_clip_rectangle(qtcurve_style->gray_gc[light], NULL);
        }
    }
}

static void draw_focus(GtkStyle *style, GdkWindow *window, 
#if GTK_MAJOR_VERSION>1
                       GtkStateType state,
#endif
                       GdkRectangle *area, GtkWidget *widget, PCONST gchar *detail, gint x, gint y,
                       gint width, gint height)
{
    QT_CURVE_STYLE_VAR
    GdkGC    *gc=FOCUS_COLORED==opts.focus ? qtcurve_style->focus_gc : style->black_gc;

#ifdef QTC_DEBUG
printf("Draw focus %d %d %d %d  ", x, y, width, height);
display_widget(widget, 3);
#endif

    if(GTK_IS_EDITABLE(widget))
        return;

#if GTK_MAJOR_VERSION==1
    if(GTK_IS_OPTION_MENU(widget) || GTK_IS_BUTTON(widget) || GTK_IS_RADIO_BUTTON(widget) || 
       GTK_IS_CHECK_BUTTON(widget))
    {
        if(GTK_IS_OPTION_MENU(widget))
        {
            x+=4;
            y+=4;
            width-=26;
            height-=7;
        }
        else if(!(detail && 0==strcmp(detail, "togglebutton")) &&(GTK_IS_RADIO_BUTTON(widget) || 
                GTK_IS_CHECK_BUTTON(widget)))
        {
            x+=18;
            width-=18;
        }
        else
        {
            x+=4;
            y+=4;
            width-=7;
            height-=7;
        }
    }
#endif

    sanitize_size(window, &width, &height);

#if 0
    if(0==x && is_list(widget))
    {
        x++;
        y++;
        width-=2;
        height-=2;
    }
#endif

    if(area)
        gdk_gc_set_clip_rectangle(gc, area);

    if(FOCUS_COLORED==opts.focus)
    {
#if 0
        if(QTC_ROUNDED)
        {
            gdk_draw_line(window, gc, x+1, y, x+width-2, y);
            gdk_draw_line(window, gc, x+1, y+height-1, x+width-2, y+height-1);
            gdk_draw_line(window, gc, x, y+1, x, y+height-2);
            gdk_draw_line(window, gc, x+width-1, y+1, x+width-1, y+height-2);
        }
        else
#endif
            gdk_draw_rectangle(window, gc, FALSE, x, y, width-1, height-1);
    }
    else
    {
        GdkPoint points[5];
        gboolean free_dash_list = FALSE;
        gint     line_width = 1,
                 hl=0;
        char     *dash_list =(char *)"\1\1";
        gint     dash_len;

#if GTK_MAJOR_VERSION>1
        if(widget)
        {
            gtk_widget_style_get(widget, "focus-line-width", &line_width, "focus-line-pattern",
                                 (gchar *)&dash_list, NULL);
            free_dash_list = TRUE;

            if(GTK_IS_TOGGLE_BUTTON(widget) && widget->parent && GTK_IS_COMBO_BOX(widget->parent) &&
              !GTK_IS_COMBO_BOX_ENTRY(widget->parent))
                width-=20;
        }
#endif
        gdk_gc_set_line_attributes(gc, line_width, dash_list[0] ? GDK_LINE_ON_OFF_DASH : GDK_LINE_SOLID,
                                   GDK_CAP_BUTT, GDK_JOIN_MITER);

        if(detail && !strcmp(detail, "add-mode"))
        {
            if(free_dash_list)
                g_free(dash_list);

            dash_list =(char *)"\4\4";
            free_dash_list = FALSE;
        }

        hl=line_width>>1;
        points[0].x = x + hl;
        points[0].y = y + hl;
        points[1].x = x + width - line_width + hl;
        points[1].y = y + hl;
        points[2].x = x + width - line_width + hl;
        points[2].y = y + height - line_width + hl;
        points[3].x = x + hl;
        points[3].y = y + height - line_width + hl;
        points[4] = points[0];

        if(!dash_list[0])
            gdk_draw_lines(window, gc, points, 5);
        else
        {
            /* We go through all the pain below because the X rasterization rules don't really work right
               for dashed 
            * lines if you want continuity in segments that go between top/right and left/bottom. For
              instance, a top
            * left corner with a 1-1 dash is drawn as:
            *
            *  X X X 
            *  X
            *
            *  X
            *
            * This is because pixels on the top and left boundaries of polygons are drawn, but not on the
              bottom and 
            * right.  So, if you have a line going up that turns the corner and goes right, there is a one
              pixel shift 
            * in the pattern.
            *
            * So, to fix this, we drawn the top and right in one call, then the left and bottom in another
              call, fixing 
            * up the dash offset for the second call ourselves to get continuity at the upper left.
            *
            * It's not perfect since we really should have a join at the upper left and lower right
              instead of two
            * intersecting lines but that's only really apparent for no-dashes, which(for this reason) are
              done as one
            * polygon and don't to through this code path.
            */

            dash_len = strlen(dash_list);

            if(dash_list[0])
                gdk_gc_set_dashes(gc, 0, dash_list, dash_len);

            gdk_draw_lines(window, gc, points, 3);

            /* We draw this line one farther over than it is "supposed" to because of another
              rasterization problem ...
            * if two 1 pixel unjoined lines meet at the lower right, there will be a missing pixel.
            */
            points[2].x += 1;

            if(dash_list[0])
            {
                gint dash_pixels = 0;
                gint i;

                /* Adjust the dash offset for the bottom and left so we match up at the upper left. */
                for(i = 0; i < dash_len; i++)
                    dash_pixels += dash_list[i];

                if(dash_len % 2 == 1)
                    dash_pixels *= 2;

                gdk_gc_set_dashes(gc, dash_pixels -(width + height - 2 * line_width) % dash_pixels,
                                  dash_list, dash_len);
            }

            gdk_draw_lines(window, gc, points + 2, 3);
        }

        gdk_gc_set_line_attributes(gc, 0, GDK_LINE_SOLID, GDK_CAP_BUTT, GDK_JOIN_MITER);

        if(free_dash_list)
            g_free(dash_list);
    }
    if(area)
        gdk_gc_set_clip_rectangle(gc, NULL);
}

#if GTK_MAJOR_VERSION>1
static void draw_resize_grip(GtkStyle *style, GdkWindow *window, GtkStateType state,
                             GdkRectangle *area, GtkWidget *widget, const gchar *detail,
                             GdkWindowEdge edge, gint x, gint y, gint width, gint height)
{
    QT_CURVE_STYLE_VAR
    FN_CHECK

    if(area)
    {
        gdk_gc_set_clip_rectangle(style->light_gc[state], area);
        gdk_gc_set_clip_rectangle(style->dark_gc[state], area);
        gdk_gc_set_clip_rectangle(style->bg_gc[state], area);
    }

    switch(edge)
    {
        case GDK_WINDOW_EDGE_NORTH_WEST:
            /* make it square */
            if(width < height)
                height = width;
            else if(height < width)
                width = height;
            break;
        case GDK_WINDOW_EDGE_NORTH:
            if(width < height)
                height = width;
            break;
        case GDK_WINDOW_EDGE_NORTH_EAST:
            /* make it square, aligning to top right */
            if(width < height)
                height = width;
            else if(height < width)
            {
                x +=(width - height);
                width = height;
            }
            break;
        case GDK_WINDOW_EDGE_WEST:
            if(height < width)
                width = height;
            break;
        case GDK_WINDOW_EDGE_EAST:
            /* aligning to right */
            if(height < width)
            {
                x +=(width - height);
                width = height;
            }
            break;
        case GDK_WINDOW_EDGE_SOUTH_WEST:
            /* make it square, aligning to bottom left */
            if(width < height)
            {
                y +=(height - width);
                height = width;
            }
            else if(height < width)
                width = height;
            break;
        case GDK_WINDOW_EDGE_SOUTH:
            /* align to bottom */
            if(width < height)
            {
                y +=(height - width);
                height = width;
            }
            break;
        case GDK_WINDOW_EDGE_SOUTH_EAST:
            /* make it square, aligning to bottom right */
            if(width < height)
            {
                y +=(height - width);
                height = width;
            }
            else if(height < width)
            {
                x +=(width - height);
                width = height;
            }
            break;
        default:
            g_assert_not_reached();
    }

    /* Clear background */
    gtk_style_apply_default_background(style, window, FALSE, state, area, x, y, width, height);   

    switch(edge)
    {
        case GDK_WINDOW_EDGE_WEST:
        case GDK_WINDOW_EDGE_EAST:
        {
            gint xi = x;

            while(xi < x + width)
            {
                gdk_draw_line(window, qtcurve_style->gray_gc[0], xi, y, xi, y + height);
                xi++;
                gdk_draw_line(window, qtcurve_style->gray_gc[5], xi, y, xi, y + height);
                xi += 2;
            }
            break;
        }
        case GDK_WINDOW_EDGE_NORTH:
        case GDK_WINDOW_EDGE_SOUTH:
        {
            gint yi = y;

            while(yi < y + height)
            {
                gdk_draw_line(window, qtcurve_style->gray_gc[0], x, yi, x + width, yi);
                yi++;
                gdk_draw_line(window, qtcurve_style->gray_gc[5], x, yi, x + width, yi);
                yi+= 2;
            }
            break;
        }
        case GDK_WINDOW_EDGE_NORTH_WEST:
        {
            gint xi = x + width,
                 yi = y + height;

            while(xi > x + 3)
            {
                gdk_draw_line(window, qtcurve_style->gray_gc[5], xi, y, x, yi);
                --xi;
                --yi;
                gdk_draw_line(window, qtcurve_style->gray_gc[0], xi, y, x, yi);
                xi -= 3;
                yi -= 3;
            }
            break;
        }
        case GDK_WINDOW_EDGE_NORTH_EAST:
        {
            gint xi = x,
                 yi = y + height;

            while(xi <(x + width - 3))
            {
                gdk_draw_line(window, qtcurve_style->gray_gc[0], xi, y, x + width, yi);                           
                ++xi;
                --yi;
                gdk_draw_line(window, qtcurve_style->gray_gc[5], xi, y, x + width, yi);
                xi += 3;
                yi -= 3;
            }
            break;
        }
        case GDK_WINDOW_EDGE_SOUTH_WEST:
        {
            gint xi = x + width,
            yi = y;

            while(xi > x + 3)
            {
                gdk_draw_line(window, qtcurve_style->gray_gc[5], x, yi, xi, y + height);
                --xi;
                ++yi;
                gdk_draw_line(window, qtcurve_style->gray_gc[0], x, yi, xi, y + height);
                xi -= 3;
                yi += 3;
            }
            break;
        }
        case GDK_WINDOW_EDGE_SOUTH_EAST:
        {
            gint xi = x,
                 yi = y;

            while(xi <(x + width - 3))
            {
                gdk_draw_line(window, qtcurve_style->gray_gc[0], xi, y + height, x + width, yi);
                ++xi;
                ++yi;
                gdk_draw_line(window, qtcurve_style->gray_gc[5], xi, y + height, x + width, yi);
                xi += 3;
                yi += 3;
            }
            break;
        }
        default:
            g_assert_not_reached();
    }

    if(area)
    {
        gdk_gc_set_clip_rectangle(style->light_gc[state], NULL);
        gdk_gc_set_clip_rectangle(style->dark_gc[state], NULL);
        gdk_gc_set_clip_rectangle(style->bg_gc[state], NULL);
    }
}

static void draw_expander(GtkStyle *style, GdkWindow *window, GtkStateType state, GdkRectangle *area,
                          GtkWidget *widget, const gchar *detail, gint x, gint y,
                          GtkExpanderStyle expander_style)
{
    GdkGC *gc=style->text_gc[QTC_ARROW_STATE(state)];
    int   lv_size=QTC_LV_SIZE(opts.lvExpander);
#ifdef QTC_DEBUG
printf("Draw expander %d %s  ", state, detail ? detail : "NULL");
display_widget(widget, 5);
#endif

    x-=lv_size>>1;
    y-=lv_size>>1;

    if(LV_LINES_NONE!=opts.lvLines)
    {
        GdkGC *mid_gc=style->text_gc[ /* opts.lv_dark ? GTK_STATE_NORMAL : */ GTK_STATE_INSENSITIVE];
        int   lo=QTC_ROUNDED ? 2 : 0;

        gdk_draw_line(window, mid_gc, (x-2)+lo, y-2, (x+2+lv_size-1)-lo, y-2);
        gdk_draw_line(window, mid_gc, (x-2)+lo, y+2+lv_size-1, (x+2+lv_size-1)-lo, y+2+lv_size-1);
        gdk_draw_line(window, mid_gc, x-2, (y-2)+lo, x-2, (y+2+lv_size-1)-lo);
        gdk_draw_line(window, mid_gc, x+2+lv_size-1, (y-2)+lo, x+2+lv_size-1, (y+2+lv_size-1)-lo);

        if(QTC_ROUNDED)
        {
/*
            GdkGC *midgc=NULL;
*/

            gdk_draw_point(window, mid_gc, x-1, y-1);
            gdk_draw_point(window, mid_gc, x-1, y+lv_size);
            gdk_draw_point(window, mid_gc, x+lv_size, y-1);
            gdk_draw_point(window, mid_gc, x+lv_size, y+lv_size);
/*
CPD: Can't tell when an item is selected - therefore AA looks bad, :-(
            midgc=QTC_SET_MID_COLOR(style->text[opts.lv_dark ? GTK_STATE_NORMAL : GTK_STATE_INSENSITIVE],
                                    style->bg[state])
            gdk_draw_line(window, midgc, x-2, y-1, x-1, y-2);
            gdk_draw_line(window, midgc, x+lv_size, y-2, x+lv_size+1, y-1);
            gdk_draw_line(window, midgc, x-2, y+lv_size, x-1, y+lv_size+1);
            gdk_draw_line(window, midgc, x+lv_size, y+lv_size+1, x+lv_size+1, y+lv_size);
*/
        }
    }

    if(LV_EXP_ARR==opts.lvExpander)
    {
        if(GTK_EXPANDER_COLLAPSED==expander_style)
            draw_arrow(window, gc, area, reverse_layout(widget) ? GTK_ARROW_LEFT : GTK_ARROW_RIGHT,
                       x+2, y, LARGE_ARR_HEIGHT, LARGE_ARR_WIDTH);
        else
            draw_arrow(window, gc, area, GTK_ARROW_DOWN, x, y+2, LARGE_ARR_WIDTH, LARGE_ARR_HEIGHT);
    }
    else
    {
        int mid=lv_size>>1;

        gdk_draw_line(window, gc, x+(mid-2), y+mid, x+lv_size-(mid-1), y+mid);
        if(GTK_EXPANDER_COLLAPSED==expander_style)
            gdk_draw_line(window, gc, x+mid, y+(mid-2), x+mid, y+lv_size-(mid-1));
    }
}

#endif

static GdkGC * realize_color(GtkStyle *style, GdkColor *color)
{
    GdkGCValues gc_values;

    gdk_colormap_alloc_color(style->colormap, color, FALSE, TRUE);
    gc_values.foreground = *color;

    return gtk_gc_get(style->depth, style->colormap, &gc_values, GDK_GC_FOREGROUND);
}

static void gen_menuitem_gcs(GtkStyle *style, GdkGC **gcs, GdkColor *cols)
{
    QT_CURVE_STYLE_VAR

    if(IS_FLAT(opts.appearance) && !opts.stripedProgress)
        gcs[0] = realize_color(style, &cols[0]);
    else
        GEN_GCS(style, cols, gcs);
}

#if GTK_MAJOR_VERSION>1
static void qtcurve_style_realize(GtkStyle *style)
#else
static void theme_realize_style(GtkStyle *style)
#endif
{
    QT_CURVE_STYLE_VAR
    int i;

#if GTK_MAJOR_VERSION>1
    parent_class->realize(style);
#endif

    GEN_GCS(style, qtcurve_style->gray, qtcurve_style->gray_gc);
    GEN_GCS(style, qtcurve_style->button, qtcurve_style->button_gc);
    gen_custom_gcs(style);

    gen_menuitem_gcs(style, qtcurve_style->menuitem_gc, qtcurve_style->menuitem);

    if(USE_SHADED_MENU_BAR_COLORS)
        GEN_GCS(style, qtcurve_style->menubar, qtcurve_style->menubar_gc)
    else
        qtcurve_style->menubar_gc[0]=NULL;

    if(SHADE_NONE!=opts.shadeSliders)
        GEN_GCS(style, qtcurve_style->slider, qtcurve_style->slider_gc)
    else
        qtcurve_style->slider_gc[0]=NULL;

    if(IND_COLORED==opts.defBtnIndicator)
        if(SHADE_SELECTED==opts.shadeSliders)
            memcpy(qtcurve_style->defbtn_gc, qtcurve_style->slider_gc,
               sizeof(GdkGC *)*(TOTAL_SHADES+1));
        else
            GEN_GCS(style, qtcurve_style->defbtn, qtcurve_style->defbtn_gc)

    switch(opts.lvHeaderColor)
    {
        default:
        case HEADER_COLOR_BGND:
            memcpy(qtcurve_style->listview_gc, qtcurve_style->gray_gc,
                   sizeof(GdkGC *)*(TOTAL_SHADES+1));
            break;
        case HEADER_COLOR_BTN:
            memcpy(qtcurve_style->listview_gc, qtcurve_style->button_gc,
                   sizeof(GdkGC *)*(TOTAL_SHADES+1));
            break;
        case HEADER_COLOR_CUSTOM:
            GEN_GCS(style, qtcurve_style->listview, qtcurve_style->listview_gc)
    }

    if(FOCUS_COLORED==opts.focus)
        qtcurve_style->focus_gc=realize_color(style, &qtcurve_style->focus);
    qtcurve_style->mid_gc[0]=qtcurve_style->mid_gc[1]=NULL;
}

#if GTK_MAJOR_VERSION>1
static void qtcurve_style_unrealize(GtkStyle *style)
#else
static void theme_unrealize_style(GtkStyle *style)
#endif
{
    QT_CURVE_STYLE_VAR
    int i;

    /* We don't free the colors, because we don't know if gtk_gc_release() actually freed the GC.
       FIXME - need
     * a way of ref'ing colors explicitely so GtkGC can handle things properly.
     */
    RELEASE_GCS(qtcurve_style->gray_gc);
    RELEASE_GCS(qtcurve_style->button_gc);
    release_custom_gcs(style);

    if(IS_FLAT(opts.appearance) && !opts.stripedProgress)
        gtk_gc_release(qtcurve_style->menuitem_gc[0]);
    else
        RELEASE_GCS(qtcurve_style->menuitem_gc);

    if(qtcurve_style->menubar_gc[0])
        RELEASE_GCS(qtcurve_style->menubar_gc);

    if(qtcurve_style->defbtn_gc[0]&& qtcurve_style->defbtn_gc[0]!=qtcurve_style->slider_gc[0])
        RELEASE_GCS(qtcurve_style->defbtn_gc);

    if(qtcurve_style->slider_gc[0])
        RELEASE_GCS(qtcurve_style->slider_gc);

    if(qtcurve_style->listview_gc[0] && qtcurve_style->listview_gc[0]!=qtcurve_style->gray_gc[0] &&
       qtcurve_style->listview_gc[0]!=qtcurve_style->button_gc[0])
        RELEASE_GCS(qtcurve_style->listview_gc);

    if(FOCUS_COLORED==opts.focus)
        gtk_gc_release(qtcurve_style->focus_gc);

    for(i=0; i<2; ++i)
        if (qtcurve_style->mid_gc[i])
        {
            gtk_gc_release(qtcurve_style->mid_gc[i]);
            qtcurve_style->mid_gc[i]=NULL;
        }
}

static void qtc_generate_menuitem_colors(GdkColor *cols)
{
    if(IS_FLAT(opts.appearance) && !opts.stripedProgress)
        cols[0]=qt_settings.colors[COLOR_SELECTED];
    else
        shade_colors(&qt_settings.colors[COLOR_SELECTED], cols);
}

static void qtc_generate_colors(GtkStyle *style)
{
    QT_CURVE_STYLE_VAR

    shade_colors(&qt_settings.colors[COLOR_WINDOW], qtcurve_style->gray);
    shade_colors(&qt_settings.colors[COLOR_BUTTON], qtcurve_style->button);
    qtc_generate_menuitem_colors(qtcurve_style->menuitem);

    if(SHADE_CUSTOM==opts.shadeMenubars)
        shade_colors(&opts.customMenubarsColor, qtcurve_style->menubar);
    else if(SHADE_SELECTED==opts.shadeMenubars)
    {
        GdkColor color;

        shade(&qtcurve_style->menuitem[ORIGINAL_SHADE], &color, MENUBAR_GLASS_SELECTED_DARK_FACTOR);
        shade_colors(&color, qtcurve_style->menubar);
    }

    if(SHADE_CUSTOM==opts.shadeSliders)
        shade_colors(&opts.customSlidersColor, qtcurve_style->slider);
    else if(SHADE_SELECTED==opts.shadeSliders)
    {
        GdkColor mid;

        generate_mid_color(&qtcurve_style->menuitem[ORIGINAL_SHADE], &qtcurve_style->button[ORIGINAL_SHADE],
                           &mid, 1.0);
        shade_colors(&mid, qtcurve_style->slider);
    }

    if(IND_COLORED==opts.defBtnIndicator)
        if(SHADE_SELECTED==opts.shadeSliders)
            memcpy(qtcurve_style->defbtn, qtcurve_style->slider, sizeof(GdkColor)*(TOTAL_SHADES+1));
        else
        {
            GdkColor mid;

            generate_mid_color(&qtcurve_style->menuitem[ORIGINAL_SHADE], &qtcurve_style->button[ORIGINAL_SHADE],
                               &mid, 1.0);
            shade_colors(&mid, qtcurve_style->defbtn);
        }

    switch(opts.lvHeaderColor)
    {
        default:
        case HEADER_COLOR_BGND:
            memcpy(qtcurve_style->listview, qtcurve_style->gray, sizeof(GdkColor)*(TOTAL_SHADES+1));
            break;
        case HEADER_COLOR_BTN:
            memcpy(qtcurve_style->listview, qtcurve_style->button,
                   sizeof(GdkColor)*(TOTAL_SHADES+1));
            break;
        case HEADER_COLOR_CUSTOM:
        shade_colors(&opts.customLvHeaderColor, qtcurve_style->listview);
    }

    if(FOCUS_COLORED==opts.focus)
        generate_mid_color(&qtcurve_style->menuitem[ORIGINAL_SHADE], &qtcurve_style->gray[ORIGINAL_SHADE],
                           &qtcurve_style->focus, 1.0);
}

#if GTK_MAJOR_VERSION>1
static void qtcurve_style_init_from_rc(GtkStyle *style, GtkRcStyle *rc_style)
{
    QT_CURVE_STYLE_VAR

    parent_class->init_from_rc(style, rc_style);
    qtc_generate_colors(style);
}
#endif

#if GTK_MAJOR_VERSION>1
void qtcurve_style_class_init(QtCurveStyleClass *klass)
#else
void qtcurve_initialize_style(GtkStyleClass *style_class, GtkStyleClass *parent)
#endif
{
#if GTK_MAJOR_VERSION>1
    GtkStyleClass *style_class = GTK_STYLE_CLASS(klass);

    parent_class = g_type_class_peek_parent(klass);
#else
    parent_class = parent;    /* Save for later use */
    *style_class = *parent;
#endif

#if GTK_MAJOR_VERSION>1
    style_class->realize = qtcurve_style_realize;
    style_class->unrealize = qtcurve_style_unrealize;
    style_class->init_from_rc = qtcurve_style_init_from_rc;
    style_class->draw_resize_grip = draw_resize_grip;
    style_class->draw_expander = draw_expander;
#endif
    style_class->draw_arrow = qtcurve_draw_arrow;
    style_class->draw_tab = draw_tab;
    style_class->draw_shadow = draw_shadow;
    style_class->draw_box_gap = draw_box_gap;
    style_class->draw_extension = draw_extension;
    style_class->draw_handle = draw_handle;
    style_class->draw_box = draw_box;
    style_class->draw_flat_box = draw_flat_box;
    style_class->draw_check = draw_check;
    style_class->draw_slider = draw_slider;
    style_class->draw_option = draw_option;
    style_class->draw_shadow_gap = draw_shadow_gap;
    style_class->draw_hline = draw_hline;
    style_class->draw_vline = draw_vline;
    style_class->draw_focus = draw_focus;
#if GTK_MAJOR_VERSION>1
    style_class->draw_layout = draw_layout;
#else
    style_class->draw_string = draw_string;
#endif
}

#if GTK_MAJOR_VERSION>1
static GtkRcStyleClass *parent_rc_class;
GType qtcurve_type_rc_style = 0;
#endif

#if GTK_MAJOR_VERSION==1
static void qtcurve_rc_data_ref(QtCurveRcStyle *qtcurve_style)
{
    qtcurve_style->refcount++;
}

static void qtcurve_rc_data_unref(QtCurveRcStyle *qtcurve_style)
{
    qtcurve_style->refcount--;
    if(0==qtcurve_style->refcount)
        g_free(qtcurve_style);
}
#endif

#if GTK_MAJOR_VERSION==1
enum
{
    TOKEN_THICKNESS_HACK = G_TOKEN_LAST + 1,
    TOKEN_XTHICK,
    TOKEN_YTHICK
};

static struct
{
    const gchar *name;
    guint       token;
}
theme_symbols[] =
{
    { "xthickness", TOKEN_XTHICK  },
    { "ythickness", TOKEN_YTHICK  }
};

static guint n_theme_symbols = sizeof(theme_symbols) / sizeof(theme_symbols[0]);
#endif

#if GTK_MAJOR_VERSION==1
static guint qtcurve_theme_parse_int(GScanner *scanner, int *i)
{
    guint token = g_scanner_get_next_token(scanner);
    token = g_scanner_get_next_token(scanner);

    if(token != G_TOKEN_EQUAL_SIGN)
        return G_TOKEN_EQUAL_SIGN;

    token = g_scanner_get_next_token(scanner);

    if(token != G_TOKEN_INT && token != G_TOKEN_STRING)
        return G_TOKEN_STRING;
    *i = G_TOKEN_STRING==token ? atoi(scanner->value.v_string) : scanner->value.v_int;

    return G_TOKEN_NONE;
}
#endif

#if GTK_MAJOR_VERSION>1
static guint qtcurve_rc_style_parse(GtkRcStyle *rc_style, GtkSettings *settings, GScanner *scanner)
#else
static guint theme_parse_rc_style(GScanner *scanner, GtkRcStyle *rc_style)
#endif
{
    static GQuark scope_id = 0;
#if GTK_MAJOR_VERSION==1
    QtCurveRcStyle *qtcurve_style;
#endif
    guint old_scope,
          token;

    /* Set up a new scope in this scanner. */
    if(!scope_id)
        scope_id = g_quark_from_string("qtcurve_theme_engine");

    /* If we bail out due to errors, we *don't* reset the scope, so the error messaging code can make
       sense of our tokens. */
    old_scope = g_scanner_set_scope(scanner, scope_id);

#if GTK_MAJOR_VERSION==1
  /* We're ready to go, now parse the top level */

    if(!g_scanner_lookup_symbol(scanner, theme_symbols[0].name))
    {
        int i;

        g_scanner_freeze_symbol_table(scanner);
        for(i = 0; i < n_theme_symbols; i++)
            g_scanner_scope_add_symbol(scanner, scope_id, theme_symbols[i].name, 
                                       GINT_TO_POINTER(theme_symbols[i].token));
        g_scanner_thaw_symbol_table(scanner);
    }

    qtcurve_style = g_new(QtCurveRcStyle, 1);
    qtcurve_style->refcount = 1;
    qtcurve_style->xthickness=qtcurve_style->ythickness=1;
#endif
    qt_set_font(rc_style);

    token = g_scanner_peek_next_token(scanner);
    while(token != G_TOKEN_RIGHT_CURLY)
    {
        switch(token)
        {
#if GTK_MAJOR_VERSION==1
            case TOKEN_XTHICK:
                token = qtcurve_theme_parse_int(scanner, &(qtcurve_style->xthickness));
                break;
            case TOKEN_YTHICK:
                token = qtcurve_theme_parse_int(scanner, &(qtcurve_style->ythickness));
                break;
           case TOKEN_THICKNESS_HACK:
                g_scanner_get_next_token(scanner);  /* Ignore... */
                token=G_TOKEN_NONE;
                qtcurve_style->xthickness=qtcurve_style->ythickness=2;
                break;
#endif
           default:
               g_scanner_get_next_token(scanner); 
               token = G_TOKEN_RIGHT_CURLY;
        }

        if(token != G_TOKEN_NONE)
            return token;

        token = g_scanner_peek_next_token(scanner);
    }

    g_scanner_get_next_token(scanner);

#if GTK_MAJOR_VERSION==1
    rc_style->engine_data = qtcurve_style;
#endif
    g_scanner_set_scope(scanner, old_scope);

    return G_TOKEN_NONE;
}

#if GTK_MAJOR_VERSION>1
static void qtcurve_rc_style_merge(GtkRcStyle *dest, GtkRcStyle *src)
{
    QtCurveRcStyle *dest_w,
                   *src_w;

    parent_rc_class->merge(dest, src);

    if(!QTCURVE_IS_RC_STYLE(src))
        return;

    src_w = QTCURVE_RC_STYLE(src);
    dest_w = QTCURVE_RC_STYLE(dest);
}
#else
static void theme_merge_rc_style(GtkRcStyle *dest, GtkRcStyle *src)
{
    QtCurveRcStyle *src_data = src->engine_data;

    if(!dest->engine_data && src_data)
    {
        qtcurve_rc_data_ref(src_data);
        dest->engine_data = src_data;
    }
}
#endif

#if GTK_MAJOR_VERSION==1
static void set_props(GtkStyle *style)
{
  /* TODO: Change and/or add to these: */
#define OPTION_INDICATOR_WIDTH 7
#define OPTION_INDICATOR_LEFT_SPACING 7
#define OPTION_INDICATOR_RIGHT_SPACING 5
    gtk_style_set_prop_experimental(style, "GtkButton::default_spacing", 6);
    gtk_style_set_prop_experimental(style, "GtkCheckButton::indicator_size", QTC_CHECK_SIZE);
    gtk_style_set_prop_experimental(style, "GtkOptionMenu::indicator_width", OPTION_INDICATOR_WIDTH);
    gtk_style_set_prop_experimental(style, "GtkOptionMenu::indicator_left_spacing",
                                    OPTION_INDICATOR_LEFT_SPACING);
    gtk_style_set_prop_experimental(style, "GtkOptionMenu::indicator_right_spacing",
                                    OPTION_INDICATOR_RIGHT_SPACING);
    gtk_style_set_prop_experimental(style, "GtkPaned::handle_full_size", 1);
    gtk_style_set_prop_experimental(style, "GtkPaned::handle_width", 6);
    gtk_style_set_prop_experimental(style, "GtkPaned::handle_size", 6);
    gtk_style_set_prop_experimental(style, "GtkRange::always_draw_trough", 1);
    gtk_style_set_prop_experimental(style, "GtkRange::trough_border", 0);
    gtk_style_set_prop_experimental(style, "GtkRange::slider_width", 15);
    gtk_style_set_prop_experimental(style, "GtkRange::stepper_size", 15);
    gtk_style_set_prop_experimental(style, "GtkRange::stepper_spacing", 0);
    gtk_style_set_prop_experimental(style, "GtkRange::always_redraw", 1);
    gtk_style_set_prop_experimental(style, "GtkScale::slider_width", 15);
    gtk_style_set_prop_experimental(style, "GtkScrollbar::min_slider_length", 16);
    gtk_style_set_prop_experimental(style, "GtkSpinButton::shadow_type", GTK_SHADOW_IN);
}

static void theme_rc_style_to_style(GtkStyle *style, GtkRcStyle *rc_style)
{
    static GtkStyleClass *default_class = NULL;
    GtkStyleClass        *class=NULL;
    QtCurveStyle         *qtcurve_style;
    QtCurveRcStyle       *qtcurve_rc_style=rc_style->engine_data;

    if(!default_class)
    {
        default_class = g_new(GtkStyleClass, 1);
        qtcurve_initialize_style(default_class, style->klass);
        default_class->xthickness = 1;
        default_class->ythickness = 1;
    }

    if(qtcurve_rc_style->xthickness!=default_class->xthickness || 
       qtcurve_rc_style->ythickness!=default_class->ythickness)
    {
        class = g_new(GtkStyleClass, 1);
        qtcurve_initialize_style(class, style->klass);
        class->xthickness = qtcurve_rc_style->xthickness;
        class->ythickness = qtcurve_rc_style->ythickness;
    }
    else
        class=default_class;

    style->klass = class;
    qtcurve_style = style->engine_data = g_new0(QtCurveStyle, 1);

    qtc_generate_colors(style);
    set_props(style);
#ifdef QTC_HIGHLIGHT_CHECK_RADIO_TEXT
    qt_set_colors(style, rc_style, 12);
#else
    qt_set_colors(style, rc_style);
#endif
}

static void theme_duplicate_style(GtkStyle *dest, GtkStyle *src)
{
    dest->engine_data = g_memdup(src->engine_data, sizeof(QtCurveStyle));
    set_props(dest);
}
#else
/* Create an empty style suitable to this RC style */
static GtkStyle * qtcurve_rc_style_create_style(GtkRcStyle *rc_style)
{
    GtkStyle *style=g_object_new(QTCURVE_TYPE_STYLE, NULL);

#ifdef QTC_HIGHLIGHT_CHECK_RADIO_TEXT
    qt_set_colors(style, rc_style, 12);
#else
    qt_set_colors(style, rc_style);
#endif

    return style;
}
#endif

#if GTK_MAJOR_VERSION==1
static void theme_destroy_rc_style(GtkRcStyle *rc_style)
{
    QtCurveRcStyle *rc_data = rc_style->engine_data;
    qtcurve_rc_data_unref(rc_data);
}

static void theme_destroy_style(GtkStyle *style)
{
    g_free(style->engine_data);
}
#endif

#if GTK_MAJOR_VERSION>1
GType qtcurve_type_style = 0;

static void qtcurve_style_init(QtCurveStyle *style)
{
}

void qtcurve_style_register_type(GTypeModule *module)
{
    static const GTypeInfo object_info =
    {
        sizeof(QtCurveStyleClass),
        (GBaseInitFunc) NULL,
        (GBaseFinalizeFunc) NULL,
        (GClassInitFunc) qtcurve_style_class_init,
        NULL,            /* class_finalize */
        NULL,            /* class_data */
        sizeof(QtCurveStyle),
        0,                /* n_preallocs */
        (GInstanceInitFunc) qtcurve_style_init,
         NULL
    };

    qtcurve_type_style = g_type_module_register_type(module, GTK_TYPE_STYLE, "QtCurveStyle",
                                                     &object_info, 0);
}

static void qtcurve_rc_style_init(QtCurveRcStyle *qtcurve_rc)
{
    qt_init(&opts);
#ifdef QTC_ADD_EVENT_FILTER
    qt_add_event_filter();
#endif
}

static void qtcurve_rc_style_finalize(GObject *object)
{
    qt_exit();
    qtc_animation_cleanup();
}

static void qtcurve_rc_style_class_init(QtCurveRcStyleClass *klass)
{
    GtkRcStyleClass *rc_style_class = GTK_RC_STYLE_CLASS(klass);
    GObjectClass    *object_class = G_OBJECT_CLASS(klass);

    parent_rc_class = g_type_class_peek_parent(klass);

    rc_style_class->parse = qtcurve_rc_style_parse;
    rc_style_class->create_style = qtcurve_rc_style_create_style;
    rc_style_class->merge = qtcurve_rc_style_merge;

    object_class->finalize = qtcurve_rc_style_finalize;
}

void qtcurve_rc_style_register_type(GTypeModule *module)
{
    static const GTypeInfo object_info =
    {
        sizeof(QtCurveRcStyleClass),
        (GBaseInitFunc) NULL,
        (GBaseFinalizeFunc) NULL,
        (GClassInitFunc) qtcurve_rc_style_class_init,
        NULL,           /* class_finalize */
        NULL,           /* class_data */
        sizeof(QtCurveRcStyle),
        0,              /* n_preallocs */
        (GInstanceInitFunc) qtcurve_rc_style_init,
        NULL
    };

    qtcurve_type_rc_style = g_type_module_register_type(module, GTK_TYPE_RC_STYLE, "QtCurveRcStyle",
                                                        &object_info, 0);
}
#endif

#if GTK_MAJOR_VERSION>1
G_MODULE_EXPORT void theme_init(GTypeModule *module)
#else
G_MODULE_EXPORT void theme_init(GtkThemeEngine *engine)
#endif
{
#if GTK_MAJOR_VERSION>1
    qtcurve_rc_style_register_type(module);
    qtcurve_style_register_type(module);
#else
    engine->parse_rc_style = theme_parse_rc_style;
    engine->merge_rc_style = theme_merge_rc_style;
    engine->rc_style_to_style = theme_rc_style_to_style;
    engine->duplicate_style = theme_duplicate_style;
    engine->realize_style = theme_realize_style;
    engine->unrealize_style = theme_unrealize_style;
    engine->destroy_rc_style = theme_destroy_rc_style;
    engine->destroy_style = theme_destroy_style;
    engine->set_background = NULL;

    gdk_rgb_init();
    qt_init(&opts);
#endif
}

G_MODULE_EXPORT void theme_exit()
{
#if GTK_MAJOR_VERSION==1
    qt_exit();
#endif
}

#if GTK_MAJOR_VERSION>1
G_MODULE_EXPORT GtkRcStyle * theme_create_rc_style()
{
    return GTK_RC_STYLE(g_object_new(QTCURVE_TYPE_RC_STYLE, NULL));
}
#endif

/* The following function will be called by GTK+ when the module is loaded and checks to see if we are
   compatible with the
 * version of GTK+ that loads us. */
G_MODULE_EXPORT const gchar * g_module_check_init(GModule *module);

const gchar* g_module_check_init(GModule *module)
{
    return gtk_check_version(GTK_MAJOR_VERSION, GTK_MINOR_VERSION,
                             GTK_MICRO_VERSION - GTK_INTERFACE_AGE);
}
