#ifndef __QTCURVE_H__
#define __QTCURVE_H__

/*
  QtCurve (C) Craig Drummond, 2003   Craig.Drummond@lycos.co.uk

  Based upon FreeCurve/B???Curve
  ----

 * B???curve theme engine
 * Copyright (C) 2001 R?d H?t, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Written by Owen Taylor <otaylor@r?dh?t.com>
 * modified by Alexander Larsson <alexl@r?dh?t.com>
 */

#include <gtk/gtk.h>
#include "common.h"

typedef struct _QtCurveStyle QtCurveStyle;

#if GTK_MAJOR_VERSION>1
typedef struct _QtCurveStyleClass QtCurveStyleClass;

extern GType qtcurve_type_style;

#define QTCURVE_TYPE_STYLE              qtcurve_type_style
#define QTCURVE_STYLE(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), QTCURVE_TYPE_STYLE, QtCurveStyle))
#define QTCURVE_STYLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), QTCURVE_TYPE_STYLE, QtCurveStyleClass))
#define QTCURVE_IS_STYLE(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), QTCURVE_TYPE_STYLE))
#define QTCURVE_IS_STYLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), QTCURVE_TYPE_STYLE))
#define QTCURVE_STYLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), QTCURVE_TYPE_STYLE, QtCurveStyleClass))

typedef struct _QtCurveRcStyle QtCurveRcStyle;
typedef struct _QtCurveRcStyleClass QtCurveRcStyleClass;

extern GType qtcurve_type_rc_style;

#define QTCURVE_TYPE_RC_STYLE              qtcurve_type_rc_style
#define QTCURVE_RC_STYLE(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), QTCURVE_TYPE_RC_STYLE, QtCurveRcStyle))
#define QTCURVE_RC_STYLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), QTCURVE_TYPE_RC_STYLE, QtCurveRcStyleClass))
#define QTCURVE_IS_RC_STYLE(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), QTCURVE_TYPE_RC_STYLE))
#define QTCURVE_IS_RC_STYLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), QTCURVE_TYPE_RC_STYLE))
#define QTCURVE_RC_STYLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), QTCURVE_TYPE_RC_STYLE, QtCurveRcStyleClass))

struct _QtCurveRcStyle
{
    GtkRcStyle parent_instance;
};

struct _QtCurveRcStyleClass
{
    GtkRcStyleClass parent_class;
};

void qtcurve_rc_style_register_type (GTypeModule *module);
#endif

struct _QtCurveStyle
{
    GtkStyle parent_instance;
    GdkColor gray[TOTAL_SHADES+1],
             button[TOTAL_SHADES+1],
             slider[TOTAL_SHADES+1],
             defbtn[TOTAL_SHADES+1],
             menubar[TOTAL_SHADES+1],
             listview[TOTAL_SHADES+1],
             menuitem[TOTAL_SHADES+1],
             focus;
  /* from light to dark */
    GdkGC    *gray_gc[TOTAL_SHADES+1],
             *button_gc[TOTAL_SHADES+1],   /* last = orig color */
             *slider_gc[TOTAL_SHADES+1],
             *defbtn_gc[TOTAL_SHADES+1],
             *menubar_gc[TOTAL_SHADES+1],
             *listview_gc[TOTAL_SHADES+1],
             *menuitem_gc[TOTAL_SHADES+1],
             *button_text_gc,
             *focus_gc,
             *mid_gc[2];
};

#if GTK_MAJOR_VERSION>1
struct _QtCurveStyleClass
{
    GtkStyleClass parent_class;
};

#else

typedef struct 
{
    guint refcount;
    gint xthickness,
         ythickness;
} QtCurveRcStyle;

void qtcurve_initialize_style (GtkStyleClass *klass, GtkStyleClass *parent);

#endif

#endif
