/*
Copyright (c) 2005 Nick Bargnesi <nbargnesi@gmail.com>

Copyright (c) 2003 Maksim Orlovich <maksim.orlovich@kdemail.net>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/

#include <stdlib.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qsettings.h>

#include <qvbuttongroup.h>
#include <qvgroupbox.h>
#include <qhbox.h>
#include <qradiobutton.h>
#include <qtabwidget.h>
#include <qslider.h>
#include <qlabel.h>
#include <qdir.h>
#include <qfile.h>
#include <qspinbox.h>
#include <qmessagebox.h>

#include <kdialog.h>
#include <kglobal.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kconfig.h>
#include <kapplication.h>
#include <dcopclient.h>

#include "tiblitconf.h"

bool disableKMenuTitlesOld = false;

extern "C"
{
    QWidget* allocate_kstyle_config(QWidget* parent)
    {
        return new TiblitStyleConfig(parent);
    }
}

TiblitStyleConfig::TiblitStyleConfig(QWidget* parent): QWidget(parent)
{
    //Should have no margins here, the dialog provides them
    QVBoxLayout *layout = new QVBoxLayout(this, 0, 0);
    KGlobal::locale()->insertCatalogue("kstyle_tiblit_config");

    QTabWidget *tabWidget = new QTabWidget(this);
    layout->addWidget(tabWidget);
	//setMinimumSize(600,800);
	setMinimumSize(550, 690);
    //--- tab 1 ---

    QWidget *page1 = new QWidget(tabWidget);
    tabWidget->insertTab(page1, i18n("Menu Colors"));

    layout = new QVBoxLayout(page1, 10, 10);
    //layout->addSpacing(5);

    // Menu colors
    QVGroupBox *colorGrp1 = new QVGroupBox(i18n("Menu Colors"), page1);
    QWidget *colorFrame1  = new QWidget(colorGrp1);
    QGridLayout *cLayout1 = new QGridLayout(colorFrame1, 1, 1, 2);

    useCustomColorBtn1 = new QCheckBox(i18n("Use custom colors"), colorFrame1);
    cLayout1->addMultiCellWidget(useCustomColorBtn1, 1, 1, 0, 3);

    cLayout1->addWidget(new QLabel(i18n("Widget:"), colorFrame1), 2, 0);
    cLayout1->addWidget(new QLabel(i18n("Color:"), colorFrame1), 2, 1);

    cLayout1->addWidget(new QLabel(i18n("Foreground:"), colorFrame1), 3, 0);
    cLayout1->addWidget(new QLabel(i18n("Background:"), colorFrame1), 4, 0);
    cLayout1->addWidget(new QLabel(i18n("Stripe:"), colorFrame1), 5, 0);
    cLayout1->addWidget(new QLabel(i18n("Separator:"), colorFrame1), 6, 0);

    menuFgBtn = new KColorButton(colorFrame1);
    cLayout1->addWidget(menuFgBtn, 3, 1);
    menuBgBtn = new KColorButton(colorFrame1);
    cLayout1->addWidget(menuBgBtn, 4, 1);
    menuStripeBtn = new KColorButton(colorFrame1);
    cLayout1->addWidget(menuStripeBtn, 5, 1);
    menuSeparatorBtn = new KColorButton(colorFrame1);
    cLayout1->addWidget(menuSeparatorBtn, 6, 1);
 
    cLayout1->addMultiCellWidget(new QLabel(i18n("Custom menu colors are effective in"), colorFrame1), 7, 7, 0, 3);
    cLayout1->addMultiCellWidget(new QLabel(i18n("XRender-Blend mode or Disable-Translucent mode."), colorFrame1), 8, 8, 1, 3);

    enableGradBtn = new QCheckBox(i18n("Enable gradients in the XRender-Blend mode"), colorFrame1);
    cLayout1->addMultiCellWidget(enableGradBtn, 9, 9, 0, 3);

    customGradBtn = new QCheckBox(i18n("Custom gradients (Background color to Stripe color)"), colorFrame1);
    cLayout1->addMultiCellWidget(customGradBtn, 10, 10, 1, 3);

    connect(useCustomColorBtn1, SIGNAL(toggled(bool)), this,
            SLOT(slotUseCustomColor1Clicked(bool)));
    connect(menuFgBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    connect(menuBgBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    connect(menuStripeBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    connect(menuSeparatorBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    connect(enableGradBtn, SIGNAL(toggled(bool)), this,
            SLOT(slotEnableGradClicked(bool)));
    connect(customGradBtn, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));

    cLayout1->setColStretch(3, 1);
    layout->addWidget(colorGrp1);
    layout->addSpacing(5);

    // Menu Border
    QVGroupBox *colorGrp1b = new QVGroupBox(i18n("Menu Border"), page1);
    useCustomColorBtn1b = new QCheckBox(i18n("Draw menu border"), colorGrp1b);
    connect(useCustomColorBtn1b, SIGNAL(toggled(bool)), this,
            SLOT(slotUseCustomColor1bClicked(bool)));
    QHBox *colorBox1b = new QHBox(colorGrp1b);
    //QLabel *borderColBtnLbl = new QLabel(i18n("Border color:"), colorBox1b);
    borderColBtn = new KColorButton(colorBox1b);
    connect(borderColBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    colorBox1b->setStretchFactor(new QWidget(colorBox1b), 1);
    layout->addWidget(colorGrp1b);

    layout->addSpacing(5);

    // Selected Menu Item colors
    QVGroupBox *colorGrp1c = new QVGroupBox(i18n("Selected Menu Item"), page1);
    QWidget *colorFrame1c  = new QWidget(colorGrp1c);
    QGridLayout *cLayout1c = new QGridLayout(colorFrame1c, 1, 1, 2);

    useCustomColorBtn1c = new QCheckBox(i18n("Use custom colors"), colorFrame1c);
    cLayout1c->addMultiCellWidget(useCustomColorBtn1c, 1, 1, 0, 2);

    cLayout1c->addWidget(new QLabel(i18n("Widget:"), colorFrame1c), 2, 0);
    cLayout1c->addWidget(new QLabel(i18n("Color:"), colorFrame1c), 2, 1);

    cLayout1c->addWidget(new QLabel(i18n("Foreground:"), colorFrame1c), 3, 0);
    cLayout1c->addWidget(new QLabel(i18n("Background:"), colorFrame1c), 4, 0);
    cLayout1c->addWidget(new QLabel(i18n("Shadow:"), colorFrame1c), 5, 0);

    menuSelFgBtn = new KColorButton(colorFrame1c);
    cLayout1c->addWidget(menuSelFgBtn, 3, 1);
    menuSelBgBtn = new KColorButton(colorFrame1c);
    cLayout1c->addWidget(menuSelBgBtn, 4, 1);
    menuSelShdBtn = new KColorButton(colorFrame1c);
    cLayout1c->addWidget(menuSelShdBtn, 5, 1);

    connect(useCustomColorBtn1c, SIGNAL(toggled(bool)), this,
            SLOT(slotUseCustomColor1cClicked(bool)));
    connect(menuSelFgBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    connect(menuSelBgBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    connect(menuSelShdBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));


    cLayout1c->setColStretch(2, 1);
    layout->addWidget(colorGrp1c);

    layout->addStretch(1);

    //--- tab 1-2 ---

    QWidget *page1p2 = new QWidget(tabWidget);
    layout = new QVBoxLayout(page1p2, 10, 10);
    layout->addSpacing(5);
    tabWidget->insertTab(page1p2, i18n("Menu Options"));

    // Menu BG Image
    QVGroupBox *bgiGrp = new QVGroupBox(i18n("Menu Background Image"), page1p2);
    useMenuBGI = new QCheckBox(i18n("Draw menu background image (XRender-Blend mode only)"), bgiGrp);
    connect(useMenuBGI, SIGNAL(toggled(bool)), this,
            SLOT(slotUseMenuBGIClicked(bool)));

    QHBox *bgiBox = new QHBox(bgiGrp);
    //QLabel *menubgfileLbl = new QLabel(i18n("Image File:"), bgiBox);
    menubgfile = new QLineEdit(bgiBox);
    menubgfile->setMinimumSize(300,8);
    menubgBrowse = new QPushButton(i18n("Browse..."),bgiBox);

    QHBox *bgiBox2 = new QHBox(bgiGrp);
    //QLabel *menubgfileLbldmy1 = new QLabel(i18n("     "), bgiBox2);
    scaledMenuBGI = new QCheckBox(i18n("Use scaled image (Default is tiled)"), bgiBox2);

    connect(menubgfile, SIGNAL(textChanged(const QString &)), this,
            SLOT(slotTextChanged(const QString &)));
    connect(menubgBrowse, SIGNAL(clicked()), this,
            SLOT(slotMenuBGIBrowser()));
    connect(scaledMenuBGI, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));

    //QLabel *useMenuBGILbl1 = new QLabel(i18n("If a menu background image is used, neither custom settings of"), bgiGrp);
    //QLabel *useMenuBGILbl2 = new QLabel(i18n("the menu background and the menu stripe nor use of gradation are effective."), bgiGrp);

    bgiBox->setStretchFactor(new QWidget(bgiBox), 1);
    bgiBox2->setStretchFactor(new QWidget(bgiBox2), 1);
    layout->addWidget(bgiGrp);
    layout->addSpacing(5);

    // Menu 3D Effect
    QVGroupBox *effectGrp3d = new QVGroupBox(i18n("Menu 3D Effects"), page1p2);

    //QLabel *enableMenu3dLbl = new QLabel(i18n("Check widgets which enable 3D effect."), effectGrp3d);
    //QLabel *enableMenu3dLbldmy1 = new QLabel("", effectGrp3d);
    enableMI3d = new QCheckBox(i18n("Selected menu item"), effectGrp3d);
    strong3dmi = new QCheckBox(i18n("Strong 3D effect for selected menu item"), effectGrp3d);
    //QLabel *enableMenu3dLbldmy2 = new QLabel("", effectGrp3d);
    enableMS3d = new QCheckBox(i18n("Menu stripe"), effectGrp3d);
    strong3dms = new QCheckBox(i18n("Strong 3D effect for menu stripe"), effectGrp3d);
    //QLabel *enableMenu3dLbldmy3 = new QLabel("", effectGrp3d);
    //QLabel *enableMenu3dLbl2 = new QLabel(i18n("In custom gradation mode or using menu background image,"), effectGrp3d);
    //QLabel *enableMenu3dLbl3 = new QLabel(i18n("menu stripe 3D effect is invalid."), effectGrp3d);

    connect(enableMI3d, SIGNAL(toggled(bool)), this,
            SLOT(slotEnable3DMIBtnClicked(bool)));
    connect(strong3dmi, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(enableMS3d, SIGNAL(toggled(bool)), this,
            SLOT(slotEnable3DMSBtnClicked(bool)));
    connect(strong3dms, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));

    layout->addWidget(effectGrp3d);

    layout->addStretch(1);
	
	QVGroupBox *decayGrp = new QVGroupBox(i18n("Decay Gradients"), page1p2);
	decayHorizontalGroup = new QButtonGroup(5, Qt::Horizontal,
											"Horizontal Decay Speed",
											decayGrp,
											"Horizontal Decay Speed");
	decayHorizFastest = new QRadioButton("Fastest", decayHorizontalGroup, "Fastest");
	decayHorizFast = new QRadioButton("Fast", decayHorizontalGroup, "Fast");
	decayHorizNormal = new QRadioButton("Normal", decayHorizontalGroup, "Normal");
	decayHorizSlow = new QRadioButton("Slow", decayHorizontalGroup, "Slow");
	decayHorizSlowest = new QRadioButton("Slowest", decayHorizontalGroup, "Slowest");
	
	decayVerticalGroup = new QButtonGroup(5, Qt::Horizontal,
											"Vertical Decay Speed",
											decayGrp,
											"Vertical Decay Speed");
	decayVertFastest = new QRadioButton("Fastest", decayVerticalGroup, "Fastest");
	decayVertFast = new QRadioButton("Fast", decayVerticalGroup, "Fast");
	decayVertNormal = new QRadioButton("Normal", decayVerticalGroup, "Normal");
	decayVertSlow = new QRadioButton("Slow", decayVerticalGroup, "Slow");
	decayVertSlowest = new QRadioButton("Slowest", decayVerticalGroup, "Slowest");
	
	decayType = new QButtonGroup(8, Qt::Vertical,
									"Decay Type",
									decayGrp,
									"Decay Type");
	decayVertical = new QRadioButton("Vertical", decayType, "Vertical");
	decayHorizontal = new QRadioButton("Horizontal", decayType, "Horizontal");
	decayDiagonal = new QRadioButton("Diagonal", decayType, "Diagonal");
	decayCrossDiagonal = new QRadioButton("Cross Diagonal", decayType, "Cross Diagonal");
	decayPyramid = new QRadioButton("Pyramidal", decayType, "Pyramidal");
	decayRectangle = new QRadioButton("Rectangular", decayType, "Rectangular");
	decayPipeCross = new QRadioButton("Pipe-Crossed", decayType, "Pipe-Crossed");
	decayElliptic = new QRadioButton("Elliptical", decayType, "Elliptical");

	connect(decayHorizFastest, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayHorizFast, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayHorizNormal, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayHorizSlow, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayHorizSlowest, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayVertFastest, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayVertFast, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayVertNormal, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayVertSlow, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayVertSlowest, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayVertical, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayHorizontal, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayDiagonal, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayCrossDiagonal, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayPyramid, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayRectangle, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayPipeCross, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(decayElliptic, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	
    layout->addWidget(decayGrp);

    layout->addStretch(1);

    //--- tab 2 ---

    QWidget *page2 = new QWidget(tabWidget);
    layout = new QVBoxLayout(page2, 10, 10);
    layout->addSpacing(5);

    tabWidget->insertTab(page2, i18n("Style Colors"));

    // Upper lines of Active Tab
    QVGroupBox *colorGrp2 = new QVGroupBox(i18n("Upper Lines of Active Tab"), page2);
    QHBox *colorBox2 = new QHBox(colorGrp2);
    useCustomColorBtn2 = new QCheckBox(i18n("Use custom color"), colorBox2);
    connect(useCustomColorBtn2, SIGNAL(toggled(bool)), this,
            SLOT(slotUseCustomColor2Clicked(bool)));
    activeTabBtn = new KColorButton(colorBox2);
    connect(activeTabBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));

    //QLabel *uplOrLbl = new QLabel(i18n("   or   "), colorBox2);
    disableUpperLinesBtn = new QCheckBox(i18n("Disable upper lines"), colorBox2);
    connect(disableUpperLinesBtn, SIGNAL(toggled(bool)), this,
            SLOT(slotDisableUpperLinesClicked(bool)));

    colorBox2->setStretchFactor(new QWidget(colorBox2), 1);
    layout->addWidget(colorGrp2);
    layout->addSpacing(5);

    // Scrollbar colors
    QVGroupBox *colorGrp3 = new QVGroupBox(i18n("Scrollbar and Slider Colors"), page2);
    QWidget *colorFrame3  = new QWidget(colorGrp3);
    QGridLayout *cLayout3 = new QGridLayout(colorFrame3, 1, 1, 2);

    useCustomColorBtn3 = new QCheckBox(i18n("Use custom colors"), colorFrame3);
    cLayout3->addMultiCellWidget(useCustomColorBtn3, 1, 1, 0, 3);

    cLayout3->addWidget(new QLabel(i18n("Scrollbar:"), colorFrame3), 2, 0);
    cLayout3->addWidget(new QLabel(i18n("Arrow Button:"), colorFrame3), 2, 1);
    cLayout3->addWidget(new QLabel(i18n("Arrow:"), colorFrame3), 2, 2);
    cLayout3->addWidget(new QLabel(i18n("Groove:"), colorFrame3), 2, 3);
	cLayout3->addWidget(new QLabel(i18n("Slider:"), colorFrame3), 2, 4);

    scrollbarBtn = new KColorButton(colorFrame3);
    cLayout3->addWidget(scrollbarBtn, 3, 0);
    scrollArbBtn = new KColorButton(colorFrame3);
    cLayout3->addWidget(scrollArbBtn, 3, 1);
    scrollAfgBtn = new KColorButton(colorFrame3);
    cLayout3->addWidget(scrollAfgBtn, 3, 2);
    scrollGrvBtn = new KColorButton(colorFrame3);
    cLayout3->addWidget(scrollGrvBtn, 3, 3);
	sliderBtn = new KColorButton(colorFrame3);
	cLayout3->addWidget(sliderBtn, 3, 4);

    connect(useCustomColorBtn3, SIGNAL(toggled(bool)), this,
            SLOT(slotUseCustomColor3Clicked(bool)));
    connect(scrollbarBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    connect(scrollArbBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    connect(scrollAfgBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    connect(scrollGrvBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
	connect(sliderBtn, SIGNAL(changed(const QColor &)), this,
			SLOT(slotBtnColorChanged(const QColor &)));

    cLayout3->setColStretch(5, 1);
    layout->addWidget(colorGrp3);

    layout->addSpacing(5);

    // Prelight HBox

    QHBox *prelightColorBox = new QHBox(page2);

    //     Pushbutton Prelighting
    QVGroupBox *colorGrp4 = new QVGroupBox(i18n("Pushbutton Prelighting"), prelightColorBox);
    QHBox *colorBox4 = new QHBox(colorGrp4);
    useCustomColorBtn4 = new QCheckBox(i18n("Use custom color"), colorBox4);
    connect(useCustomColorBtn4, SIGNAL(toggled(bool)), this,
            SLOT(slotUseCustomColor4Clicked(bool)));
    btnprlBtn = new KColorButton(colorBox4);
    connect(btnprlBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    colorBox4->setStretchFactor(new QWidget(colorBox4), 1);

    prelightInnerCircumOnlyBtn = new QCheckBox(i18n("Only for the inner circumference"), colorGrp4);
    connect(prelightInnerCircumOnlyBtn, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));

    //     Combobox Prelighting
    QVGroupBox *colorGrpCbx = new QVGroupBox(i18n("Combobox Prelighting"), prelightColorBox);
    QHBox *colorBoxCbx = new QHBox(colorGrpCbx);
    useCustomColorBtnCbx = new QCheckBox(i18n("Use custom color"), colorBoxCbx);
    connect(useCustomColorBtnCbx, SIGNAL(toggled(bool)), this,
            SLOT(slotUseCustomColorCbxClicked(bool)));
    cbxprlBtn = new KColorButton(colorBoxCbx);
    connect(cbxprlBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    colorBoxCbx->setStretchFactor(new QWidget(colorBoxCbx), 1);

    prelightInnerCircumOnlyCbxBtn = new QCheckBox(i18n("Only for inner circumference"), colorGrpCbx);
    connect(prelightInnerCircumOnlyCbxBtn, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));

    layout->addWidget(prelightColorBox);

    layout->addSpacing(5);

    // Border colors
    QVGroupBox *colorGrpButtonBorder = new QVGroupBox(i18n("Border Colors"), page2);
    QWidget *colorFrameButtonBorder  = new QWidget(colorGrpButtonBorder);
    QGridLayout *cLayoutButtonBorder = new QGridLayout(colorFrameButtonBorder, 1, 1, 2);

    cLayoutButtonBorder->addMultiCellWidget(new QLabel(i18n("Check widgets which uses the custom color border"), colorFrameButtonBorder),
					    1, 1, 0, 2);

    useButtonBorderColor = new QCheckBox(i18n("Push button"), colorFrameButtonBorder);
    cLayoutButtonBorder->addWidget(useButtonBorderColor, 2, 0);
    useComboboxBorderColor = new QCheckBox(i18n("Combo box"), colorFrameButtonBorder);
    cLayoutButtonBorder->addWidget(useComboboxBorderColor, 3, 0);
    useStatusbarBorderColor = new QCheckBox(i18n("Statusbar"), colorFrameButtonBorder);
    cLayoutButtonBorder->addWidget(useStatusbarBorderColor, 4, 0);

    buttonBorderColBtn = new KColorButton(colorFrameButtonBorder);
    cLayoutButtonBorder->addWidget(buttonBorderColBtn, 2, 1);
    cLayoutButtonBorder->addWidget(new QLabel(i18n("(Other than small buttons)"), colorFrameButtonBorder), 2, 2);

    comboboxBorderColBtn = new KColorButton(colorFrameButtonBorder);
    cLayoutButtonBorder->addWidget(comboboxBorderColBtn, 3, 1);
    cLayoutButtonBorder->addWidget(new QLabel(i18n("(Other than light weight widgets)"), colorFrameButtonBorder), 3, 2);

    statusbarBorderColBtn = new KColorButton(colorFrameButtonBorder);
    cLayoutButtonBorder->addWidget(statusbarBorderColBtn, 4, 1);
    cLayoutButtonBorder->addWidget(new QLabel(i18n("(For the surround borders)"), colorFrameButtonBorder), 4, 2);

    connect(useButtonBorderColor, SIGNAL(toggled(bool)), this,
            SLOT(slotUseButtonBorderColorClicked(bool)));
    connect(useComboboxBorderColor, SIGNAL(toggled(bool)), this,
            SLOT(slotUseComboboxBorderColorClicked(bool)));
    connect(useStatusbarBorderColor, SIGNAL(toggled(bool)), this,
            SLOT(slotUseStatusbarBorderColorClicked(bool)));
    connect(buttonBorderColBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    connect(comboboxBorderColBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    connect(statusbarBorderColBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));

    cLayoutButtonBorder->setColStretch(3, 1);
    layout->addWidget(colorGrpButtonBorder);

    layout->addSpacing(5);

    // Progressbar colors
    QVGroupBox *colorGrp5 = new QVGroupBox(i18n("Progressbar Colors"), page2);
    QWidget *colorFrame5  = new QWidget(colorGrp5);
    QGridLayout *cLayout5 = new QGridLayout(colorFrame5, 1, 1, 2);

    useCustomColorBtn5 = new QCheckBox(i18n("Use custom colors"), colorFrame5);
    cLayout5->addMultiCellWidget(useCustomColorBtn5, 1, 1, 0, 3);

    cLayout5->addWidget(new QLabel(i18n("Bar:"), colorFrame5), 2, 0);
    cLayout5->addWidget(new QLabel(i18n("Normal text:"), colorFrame5), 2, 1);
    cLayout5->addWidget(new QLabel(i18n("Highlighted text:"), colorFrame5), 2, 2);

    pgbColorBtn = new KColorButton(colorFrame5);
    cLayout5->addWidget(pgbColorBtn, 3, 0);
    pglColorBtn1 = new KColorButton(colorFrame5);
    cLayout5->addWidget(pglColorBtn1, 3, 1);
    pglColorBtn2 = new KColorButton(colorFrame5);
    cLayout5->addWidget(pglColorBtn2, 3, 2);
	cLayout5->addWidget(new QLabel(i18n("Animation time:"), colorFrame5), 4, 0);

    connect(useCustomColorBtn5, SIGNAL(toggled(bool)), this,
            SLOT(slotUseCustomColor5Clicked(bool)));
    connect(pgbColorBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    connect(pglColorBtn1, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));
    connect(pglColorBtn2, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));

    useCustomColorBtn6 = new QCheckBox(i18n("Fill the progressbar groove with the custom color"), colorFrame5);
    cLayout5->addMultiCellWidget(useCustomColorBtn6, 4, 4, 0, 3);
    connect(useCustomColorBtn6, SIGNAL(toggled(bool)), this,
            SLOT(slotUseCustomColor6Clicked(bool)));

    cLayout5->addWidget(new QLabel(i18n("Custom color "), colorFrame5), 5, 0);
    pggColorBtn = new KColorButton(colorFrame5);
    cLayout5->addWidget(pggColorBtn, 5, 1);
    connect(pggColorBtn, SIGNAL(changed(const QColor &)), this,
            SLOT(slotBtnColorChanged(const QColor &)));

    cLayout5->setColStretch(3, 1);

    layout->addWidget(colorGrp5);

    layout->addStretch(1);

   //--- tab 3 ---

    QWidget *page3 = new QWidget(tabWidget);
    layout = new QVBoxLayout(page3, 10, 10);
    layout->addSpacing(5);

    tabWidget->insertTab(page3, i18n("Extra Options"));

    // Extra Options
    QVGroupBox *extraGrp2 = new QVGroupBox(i18n(""), page3);
    useFlb = new QCheckBox(i18n("Use flat bevel buttons"), extraGrp2);
    usePbcBvl = new QCheckBox(i18n("Use pushbutton color for bevel buttons"), extraGrp2);
    useBGCTab = new QCheckBox(i18n("Use background color for tabs"), extraGrp2);
    highlightDefaultButton = new QCheckBox(i18n("Highlight default buttons"), extraGrp2);
    highlightActiveTask = new QCheckBox(i18n("Highlight the active taskbar button with the active tabline color"), extraGrp2);
    flattenActiveTab = new QCheckBox(i18n("Flatten active tab (Top tab only)"), extraGrp2);
    surroundSunkenPanel = new QCheckBox(i18n("Surround the sunken panels and the statusbars with dark borders"), extraGrp2);
    surroundTaskbutton = new QCheckBox(i18n("Surround the taskbar buttons with dark borders"), extraGrp2);
    barBorderFollowsContrast = new QCheckBox(i18n("Border's thickness of menubar and toolbar follows contrast"), extraGrp2);
    removeSublineArea = new QCheckBox(i18n("Remove \"subtract-line\" area from \"add-line\" button of scrollbar"), extraGrp2);
    drawProgressBarValue = new QCheckBox(i18n("Draw progressbar value"), extraGrp2);
    useLowerCaseText = new QCheckBox(i18n("Use lowercase text (affects menus, buttons, tabs)"), extraGrp2);
    removeMenuIcons = new QCheckBox(i18n("Remove menu icons"), extraGrp2);
    drawDashedSeparators = new QCheckBox(i18n("Draw dashed menu separators"), extraGrp2);
	QVGroupBox *extraGrp3 = new QVGroupBox(i18n("Progressbar Options"), page3);
    animateProgressBar = new QCheckBox(i18n("Animate progressbars"), extraGrp3);
	reverseAnimation = new QCheckBox(i18n("Reverse animation"), extraGrp3);
	progressTimerGroup = new QButtonGroup(3, Qt::Horizontal, "Animation Speed", extraGrp3, "Progress Bar Animation Speed");
	progressTimerGroup->setExclusive(true);
	progressTimerSlow = new QRadioButton("Slow", progressTimerGroup, "Slow");
	progressTimerMedium = new QRadioButton("Medium", progressTimerGroup, "Medium");
	progressTimerFast = new QRadioButton("Fast", progressTimerGroup, "Fast");
	progressTimerGroup->insert(progressTimerSlow);
	progressTimerGroup->insert(progressTimerMedium);
	progressTimerGroup->insert(progressTimerFast);
	//QVGroupBox *extraGrp4 = new QVGroupBox(i18n("Button Size"), page3);
	buttonSizeVertGroup = new QButtonGroup(4, Qt::Horizontal, "Button Vertical Size", page3, "Button Vertical Size");
	buttonSizeVertGroup->setExclusive(true);
	buttonSizeVertTiny = new QRadioButton("Tiny", buttonSizeVertGroup, "Tiny");
	buttonSizeVertSmall = new QRadioButton("Small", buttonSizeVertGroup, "Small");
	buttonSizeVertStandard = new QRadioButton("Standard", buttonSizeVertGroup, "Standard");
	buttonSizeVertLarge = new QRadioButton("Large", buttonSizeVertGroup, "Large");
	buttonSizeVertGroup->insert(buttonSizeVertTiny);
	buttonSizeVertGroup->insert(buttonSizeVertSmall);
	buttonSizeVertGroup->insert(buttonSizeVertStandard);
	buttonSizeVertGroup->insert(buttonSizeVertLarge);
	buttonSizeHorizGroup = new QButtonGroup(4, Qt::Horizontal, "Button Horizontal Size", page3, "Button Horizontal Size");
	buttonSizeHorizGroup->setExclusive(true);
	buttonSizeHorizTiny = new QRadioButton("Tiny", buttonSizeHorizGroup, "Tiny");
	buttonSizeHorizSmall = new QRadioButton("Small", buttonSizeHorizGroup, "Small");
	buttonSizeHorizStandard = new QRadioButton("Standard", buttonSizeHorizGroup, "Standard");
	buttonSizeHorizLarge = new QRadioButton("Large", buttonSizeHorizGroup, "Large");
	buttonSizeHorizGroup->insert(buttonSizeHorizTiny);
	buttonSizeHorizGroup->insert(buttonSizeHorizSmall);
	buttonSizeHorizGroup->insert(buttonSizeHorizStandard);
	buttonSizeHorizGroup->insert(buttonSizeHorizLarge);

    connect(animateProgressBar, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
	connect(reverseAnimation, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(progressTimerSlow, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(progressTimerMedium, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(progressTimerFast, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));	
    connect(buttonSizeVertTiny, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(buttonSizeVertSmall, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(buttonSizeVertStandard, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(buttonSizeVertLarge, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
    connect(buttonSizeHorizTiny, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(buttonSizeHorizSmall, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(buttonSizeHorizStandard, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(buttonSizeHorizLarge, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
    connect(useFlb, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(usePbcBvl, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(useBGCTab, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(highlightDefaultButton, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(highlightActiveTask, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(flattenActiveTab, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(surroundSunkenPanel, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(surroundTaskbutton, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(barBorderFollowsContrast, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(removeSublineArea, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(drawProgressBarValue, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(useLowerCaseText, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(removeMenuIcons, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(drawDashedSeparators, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));	

    layout->addWidget(extraGrp2);
	layout->addWidget(extraGrp3);
	layout->addWidget(buttonSizeVertGroup);
	layout->addWidget(buttonSizeHorizGroup);

    layout->addStretch(1);


    //--- tab Others ---

    QWidget *pageOthers = new QWidget(tabWidget);
    layout = new QVBoxLayout(pageOthers, 10, 10);
    layout->addSpacing(5);

    tabWidget->insertTab(pageOthers, i18n("Others"));

    // Use Shadowed Text
    QVGroupBox *otherGrp1 = new QVGroupBox(i18n("Use Shadowed Text"), pageOthers);
    useShdM = new QCheckBox(i18n("Menu"), otherGrp1);

    QHBox *dsbShdBox = new QHBox(otherGrp1);
    //QLabel *dsbShdLblDmy = new QLabel("     ", dsbShdBox);
    disableShdEmpBtn = new QCheckBox(i18n("Disable emphasis of the selected menu item's shadow"), dsbShdBox);

    useShdMB = new QCheckBox(i18n("Menubar"), otherGrp1);
    useShdB = new QCheckBox(i18n("Push button"), otherGrp1);
    useShdT = new QCheckBox(i18n("Tab"), otherGrp1);

    connect(useShdM, SIGNAL(toggled(bool)), this,
            SLOT(slotUseShadowMClicked(bool)));
    connect(disableShdEmpBtn, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(useShdMB, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(useShdB, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(useShdT, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));

    dsbShdBox->setStretchFactor(new QWidget(dsbShdBox), 1);
    layout->addWidget(otherGrp1);
    layout->addSpacing(5);

    // Strong Gradation
    QVGroupBox *otherGrpSg = new QVGroupBox(i18n("Strong Gradients"), pageOthers);
    //useSgb  = new QCheckBox(i18n("Use strong gradation for push buttons(other than small buttons)"), otherGrpSg);
    useSgbv = new QCheckBox(i18n("Use strong gradients for bevel buttons"), otherGrpSg);
    useSgc  = new QCheckBox(i18n("Use strong gradients for comboboxes"), otherGrpSg);

    //connect(useSgb, SIGNAL(toggled(bool)), this,
            //SLOT(slotCheckBtnClicked(bool)));
    connect(useSgbv, SIGNAL(toggled(bool)), this,
            SLOT(slotUseSgbvClicked(bool)));
    connect(useSgc, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));

    layout->addWidget(otherGrpSg);

    layout->addSpacing(5);

    // Light weight widgets
    QVGroupBox *otherGrp2 = new QVGroupBox(i18n("Lightweight Widgets"), pageOthers);
    //QLabel *lwwLblDmy = new QLabel("Check widgets which you want to make light weight", otherGrp2);
    useLightCombo = new QCheckBox(i18n("Editable comboboxes"), otherGrp2);
    useLightNECombo = new QCheckBox(i18n("Standard comboboxes"), otherGrp2);
	//useLightButtons = new QCheckBox(i18n("Light buttons"), otherGrp2);

    connect(useLightCombo, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(useLightNECombo, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
	//connect(useLightButtons, SIGNAL(toggled(bool)), this,
			//SLOT(slotCheckBtnClicked(bool)));

    layout->addWidget(otherGrp2);

    layout->addSpacing(5);

	buttonTypeGroup = new QButtonGroup(3, Qt::Horizontal, "Button Type", pageOthers, "Button Type");
	buttonTypeGroup->setExclusive(true);
	buttonLight = new QRadioButton("Light", buttonTypeGroup, "Light");
	buttonStrongGradients = new QRadioButton("Gradient", buttonTypeGroup, "Gradient");
	buttonStandard = new QRadioButton("Standard", buttonTypeGroup, "Standard");

	connect(buttonLight, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(buttonStrongGradients, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));
	connect(buttonStandard, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));

	layout->addWidget(buttonTypeGroup);
	
	layout->addSpacing(5);

    //Features to disable
    QVGroupBox *otherGrp3 = new QVGroupBox(i18n("Features to Disable"), pageOthers);
    disableBB = new QCheckBox(i18n("Disable border of menubars and toolbars"), otherGrp3);
    disableScrollbarBorder = new QCheckBox(i18n("Disable border of scrollbar grooves"), otherGrp3);
    useSingleLineHandles = new QCheckBox(i18n("Disable 2nd line of toolbar handles and applet handles"), otherGrp3);
    //useShadowlessButton = new QCheckBox(i18n("Disable shadow of pushbuttons and comboboxes"), otherGrp3);
    disableKMenuTitles = new QCheckBox(i18n("Disable KMenu Titles(This setting is effective in other styles too)"), otherGrp3);
    dontDrawDisabledMenuItems = new QCheckBox(i18n("Do not draw disabled menu items"), otherGrp3);
	dontDrawMenuSeparators = new QCheckBox(i18n("Do not draw menu separators"), otherGrp3);   

    connect(disableBB, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(disableScrollbarBorder, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(useSingleLineHandles, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    //connect(useShadowlessButton, SIGNAL(toggled(bool)), this,
            //SLOT(slotCheckBtnClicked(bool)));
    connect(disableKMenuTitles, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
    connect(dontDrawDisabledMenuItems, SIGNAL(toggled(bool)), this,
            SLOT(slotCheckBtnClicked(bool)));
	connect(dontDrawMenuSeparators, SIGNAL(toggled(bool)), this,
			SLOT(slotCheckBtnClicked(bool)));

    layout->addWidget(otherGrp3);

    layout->addStretch(1);

   //--- tab Scheme ---

    QWidget *pageScheme = new QWidget(tabWidget);
    layout = new QVBoxLayout(pageScheme, 10, 10);
    layout->addSpacing(5);
    tabWidget->insertTab(pageScheme, i18n("Scheme"));

    // Scheme
    QVGroupBox *scmGrp = new QVGroupBox(i18n("Configuration Scheme"), pageScheme);
    //QLabel *schemeDmyLbl1 = new QLabel(i18n("\nThe config scheme is saved at"), scmGrp);
    //QLabel *schemeDmyLbl2 = new QLabel(i18n("   \"$HOME/.qt/tiblit_<scheme name>.kcmrc\" file."), scmGrp);
    //QLabel *schemeDmyLbl3 = new QLabel(i18n("   The characters which can be used for a scheme name are"), scmGrp);
    //QLabel *schemeDmyLbl4 = new QLabel(i18n("   small letters of the alphabet, all digits, \"-\", and \"_\".\n"), scmGrp);

    QHBox *scmBox = new QHBox(scmGrp);
    //QLabel *schemeLbl = new QLabel(i18n("Scheme Name:"), scmBox);
    schemeName = new QLineEdit(scmBox);
    loadSchemeBtn = new QPushButton(i18n("Load"),scmBox);
    saveSchemeBtn = new QPushButton(i18n("Save"),scmBox);
    delSchemeBtn = new QPushButton(i18n("Delete"),scmBox);
    scmBox->setStretchFactor(new QWidget(scmBox), 1);
	scmBox->setSpacing(20);

    schemeListBox = new QListBox(scmGrp);
    schemeListBox->setMinimumSize(100,520);

    //QLabel *schemeDmyLbl11 = new QLabel(i18n("\nScheme manager can also read the global scheme files."), scmGrp);
    //QLabel *schemeDmyLbl12 = new QLabel(i18n("\"Global scheme file\" means the scheme files stored in"), scmGrp);
    //QLabel *schemeDmyLbl13 = new QLabel(i18n("   \"$KDEDIR/share/apps/kdisplay/styleconfs\" directory."), scmGrp);
    //QLabel *schemeDmyLbl14 = new QLabel(i18n("The global file is ignored when the same name files exist"), scmGrp);
    //QLabel *schemeDmyLbl15 = new QLabel(i18n("   in both $HOME/.qt and the global directory."), scmGrp);

    connect(loadSchemeBtn, SIGNAL(clicked()), this,
            SLOT(slotLoadScheme()));
    connect(saveSchemeBtn, SIGNAL(clicked()), this,
            SLOT(slotSaveScheme()));
    connect(delSchemeBtn, SIGNAL(clicked()), this,
            SLOT(slotDelScheme()));
    connect(schemeListBox, SIGNAL(clicked(QListBoxItem *)), this,
            SLOT(slotSchemeListClicked(QListBoxItem *)));
    connect(schemeListBox, SIGNAL(selectionChanged(QListBoxItem *)), this,
            SLOT(slotSchemeListClicked(QListBoxItem *)));

    layout->addWidget(scmGrp);
    layout->addStretch(1);

    loadSettings("/qt", false);
    searchScheme();

    menuFgBtn->setEnabled(useCustomColorBtn1->isOn());
    menuBgBtn->setEnabled(useCustomColorBtn1->isOn());
    menuStripeBtn->setEnabled(useCustomColorBtn1->isOn());
    menuSeparatorBtn->setEnabled(useCustomColorBtn1->isOn());

    customGradBtn->setEnabled(enableGradBtn->isOn());

    borderColBtn->setEnabled(useCustomColorBtn1b->isOn());

    menuSelFgBtn->setEnabled(useCustomColorBtn1c->isOn());
    menuSelBgBtn->setEnabled(useCustomColorBtn1c->isOn());
    menuSelShdBtn->setEnabled(useCustomColorBtn1c->isOn());

    menubgfile->setEnabled(useMenuBGI->isOn());
    menubgBrowse->setEnabled(useMenuBGI->isOn());
    scaledMenuBGI->setEnabled(useMenuBGI->isOn());

    strong3dmi->setEnabled(enableMI3d->isOn());
    strong3dms->setEnabled(enableMS3d->isOn());

    activeTabBtn->setEnabled(useCustomColorBtn2->isOn() && !disableUpperLinesBtn->isOn());
    useCustomColorBtn2->setEnabled(!disableUpperLinesBtn->isOn());

    scrollbarBtn->setEnabled(useCustomColorBtn3->isOn());
    scrollArbBtn->setEnabled(useCustomColorBtn3->isOn());
    scrollAfgBtn->setEnabled(useCustomColorBtn3->isOn());
    scrollGrvBtn->setEnabled(useCustomColorBtn3->isOn());
	sliderBtn->setEnabled(useCustomColorBtn3->isOn());

    btnprlBtn->setEnabled(useCustomColorBtn4->isOn());
    prelightInnerCircumOnlyBtn->setEnabled(useCustomColorBtn4->isOn());

    cbxprlBtn->setEnabled(useCustomColorBtnCbx->isOn());
    prelightInnerCircumOnlyCbxBtn->setEnabled(useCustomColorBtnCbx->isOn());

    buttonBorderColBtn->setEnabled(useButtonBorderColor->isOn());
    comboboxBorderColBtn->setEnabled(useComboboxBorderColor->isOn());
    statusbarBorderColBtn->setEnabled(useStatusbarBorderColor->isOn());

    pgbColorBtn->setEnabled(useCustomColorBtn5->isOn());
    pglColorBtn1->setEnabled(useCustomColorBtn5->isOn());
    pglColorBtn2->setEnabled(useCustomColorBtn5->isOn());

    pggColorBtn->setEnabled(useCustomColorBtn6->isOn());

    disableShdEmpBtn->setEnabled(useShdM->isOn());

    schemeName->setEnabled(true);
    loadSchemeBtn->setEnabled(true);
    saveSchemeBtn->setEnabled(true);
    delSchemeBtn->setEnabled(true);

    schemeListBox->setEnabled(true);
}

void TiblitStyleConfig::loadSettings(const QString &searchPath, bool globalScheme)
{
    QSettings settings;

    if (globalScheme) {
          settings.insertSearchPath( QSettings::Unix, QString(getenv("KDEDIR")) + "/share/apps/kdisplay/styleconfs" );
    }

    QString mfgcolstr = settings.readEntry(searchPath + "/Tiblit/MenuFG");
    QString mbgcolstr = settings.readEntry(searchPath + "/Tiblit/MenuBG");
    QString mstcolstr = settings.readEntry(searchPath + "/Tiblit/MenuStripe");
    QString menuSepColStr = settings.readEntry(searchPath + "/Tiblit/MenuSeparator");

    if (!mbgcolstr.isNull()) {
          useCustomColorBtn1->setChecked(true);
          menuFgBtn->setColor(QColor(mfgcolstr));
	  menuBgBtn->setColor(QColor(mbgcolstr));
	  menuStripeBtn->setColor(QColor(mstcolstr));
	  if (menuSepColStr.isNull()) {
	          menuSeparatorBtn->setColor(QColor(mbgcolstr).dark(133));
	  } else {
	          menuSeparatorBtn->setColor(QColor(menuSepColStr));
	  }
    } else {
          useCustomColorBtn1->setChecked(false);
	  menuFgBtn->setColor(colorGroup().text());
	  menuBgBtn->setColor(colorGroup().background().light(110));
	  menuStripeBtn->setColor(colorGroup().mid());
	  menuSeparatorBtn->setColor(colorGroup().background().dark(133));
    }

    enableGradBtn->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/EnableGradation"));
    customGradBtn->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/CustomGradation"));

    QString mbgifile = settings.readEntry(searchPath + "/Tiblit/MenuBGImage");
    if (!mbgifile.isNull()) {
          useMenuBGI->setChecked(true);
          menubgfile->setText(mbgifile);
    } else {
          useMenuBGI->setChecked(false);
          menubgfile->setText("");
    }
    scaledMenuBGI->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/ScaledMenuBGImage"));

    QString bordercolstr = settings.readEntry(searchPath + "/Tiblit/MenuBorder");

    if (!bordercolstr.isNull()) {
          useCustomColorBtn1b->setChecked(true);
	  borderColBtn->setColor(QColor(bordercolstr));
    } else {
          useCustomColorBtn1b->setChecked(false);
	  borderColBtn->setColor(colorGroup().shadow());
    }

    QString mselfgcolstr = settings.readEntry(searchPath + "/Tiblit/MenuSelectedFG");
    QString mselbgcolstr = settings.readEntry(searchPath + "/Tiblit/MenuSelectedBG");
    QString mselshdcolstr = settings.readEntry(searchPath + "/Tiblit/MenuSelectedShadow");

    if (!mselbgcolstr.isNull()) {
          useCustomColorBtn1c->setChecked(true);
          menuSelFgBtn->setColor(QColor(mselfgcolstr));
	  menuSelBgBtn->setColor(QColor(mselbgcolstr));
	  menuSelShdBtn->setColor(QColor(mselshdcolstr));
    } else {
          useCustomColorBtn1c->setChecked(false);
	  menuSelFgBtn->setColor(colorGroup().highlightedText());
	  menuSelBgBtn->setColor(colorGroup().highlight());
	  menuSelShdBtn->setColor(colorGroup().highlight().dark(130));
    }

    strong3dmi->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/Strong3DMI"));
    strong3dms->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/Strong3DMS"));
    enableMI3d->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/EnableMenuItem3D"));
    enableMS3d->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/EnableStripe3D"));

    QString atcolstr = settings.readEntry(searchPath + "/Tiblit/ActiveTab");

    if (!atcolstr.isNull()) {
          useCustomColorBtn2->setChecked(true);
	  activeTabBtn->setColor(QColor(atcolstr));
    } else {
          useCustomColorBtn2->setChecked(false);
	  activeTabBtn->setColor(colorGroup().highlight());
    }

    disableUpperLinesBtn->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/DisableUpperLines"));

    QString sbcolstr = settings.readEntry(searchPath + "/Tiblit/Scrollbar");
    QString sacolstr = settings.readEntry(searchPath + "/Tiblit/ScrollArrowbtn");
    QString safgcolstr = settings.readEntry(searchPath + "/Tiblit/ScrollArrowFG");
    QString sgcolstr = settings.readEntry(searchPath + "/Tiblit/ScrollGroove");
	QString slidcolstr = settings.readEntry(searchPath + "/Tiblit/Slider");
    if (sacolstr.isNull() && !sbcolstr.isNull()) {
          sacolstr = sbcolstr;
    }

    if (!sbcolstr.isNull()) {
          // For compatibility from older version.
          QColor safgcol = colorGroup().buttonText();
	  QColor sgcol   = colorGroup().button();
	  if (!safgcolstr.isNull()) {
	        safgcol  = QColor(safgcolstr);
	        sgcol    = QColor(sgcolstr);
	  }

      useCustomColorBtn3->setChecked(true);
	  scrollbarBtn->setColor(QColor(sbcolstr));
	  sliderBtn->setColor(QColor(slidcolstr));
	  scrollArbBtn->setColor(QColor(sacolstr));
	  scrollAfgBtn->setColor(safgcol);
	  scrollGrvBtn->setColor(sgcol);
    } else {
          useCustomColorBtn3->setChecked(false);
	  scrollbarBtn->setColor(QColor(settings.readEntry(searchPath + "/KWinPalette/inactiveBackground", "#FFFFFF")));
	  scrollArbBtn->setColor(QColor(settings.readEntry(searchPath + "/KWinPalette/inactiveBackground", "#FFFFFF")));
	  //scrollbarBtn->setColor(QColor(settings.readEntry(searchPath + "/KWinPalette/inactiveBackground", "#d8d8d8")));
	  //scrollArbBtn->setColor(QColor(settings.readEntry(searchPath + "/KWinPalette/inactiveBackground", "#d8d8d8")));
	  scrollAfgBtn->setColor(colorGroup().buttonText());
	  scrollGrvBtn->setColor(colorGroup().button());
    }

    QString btnprlcolstr = settings.readEntry(searchPath + "/Tiblit/ButtonPrelight");
    if (!btnprlcolstr.isNull()) {
          useCustomColorBtn4->setChecked(true);
	  btnprlBtn->setColor(QColor(btnprlcolstr));
	  prelightInnerCircumOnlyBtn->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/PrelightInnerCircumOnly"));
    } else {
          useCustomColorBtn4->setChecked(false);
	  btnprlBtn->setColor(colorGroup().button().light(105));
	  prelightInnerCircumOnlyBtn->setChecked(false);
    }

    QString cbxprlcolstr = settings.readEntry(searchPath + "/Tiblit/ComboboxPrelight");
    if (!cbxprlcolstr.isNull()) {
          useCustomColorBtnCbx->setChecked(true);
	  cbxprlBtn->setColor(QColor(cbxprlcolstr));
	  prelightInnerCircumOnlyCbxBtn->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/PrelightInnerCircumOnlyCombobox"));
    } else {
          useCustomColorBtnCbx->setChecked(false);
	  cbxprlBtn->setColor(colorGroup().button().light(105));
	  prelightInnerCircumOnlyCbxBtn->setChecked(false);
    }

    QString buttonBorderColStr = settings.readEntry(searchPath + "/Tiblit/ButtonBorderColor");
    if (!buttonBorderColStr.isNull()) {
          useButtonBorderColor->setChecked(true);
	  buttonBorderColBtn->setColor(QColor(buttonBorderColStr));
    } else {
          useButtonBorderColor->setChecked(false);
	  buttonBorderColBtn->setColor(colorGroup().button().dark(130));
    }

    QString comboboxBorderColStr = settings.readEntry(searchPath + "/Tiblit/ComboboxBorderColor");
    if (!comboboxBorderColStr.isNull()) {
          useComboboxBorderColor->setChecked(true);
	  comboboxBorderColBtn->setColor(QColor(comboboxBorderColStr));
    } else {
          useComboboxBorderColor->setChecked(false);
	  comboboxBorderColBtn->setColor(colorGroup().button().dark(130));
    }

    QString statusbarBorderColStr = settings.readEntry(searchPath + "/Tiblit/StatusbarBorderColor");
    if (!statusbarBorderColStr.isNull()) {
          useStatusbarBorderColor->setChecked(true);
	  statusbarBorderColBtn->setColor(QColor(statusbarBorderColStr));
    } else {
          useStatusbarBorderColor->setChecked(false);
	  statusbarBorderColBtn->setColor(colorGroup().button().dark(145));
    }

    QString pgbColor  = settings.readEntry(searchPath + "/Tiblit/ProgressbarColor");
    QString pglColor1 = settings.readEntry(searchPath + "/Tiblit/ProgressbarLabelColor1");
    QString pglColor2 = settings.readEntry(searchPath + "/Tiblit/ProgressbarLabelColor2");
    if (!pgbColor.isNull()) {
          useCustomColorBtn5->setChecked(true);
	  pgbColorBtn->setColor(QColor(pgbColor));
	  pglColorBtn1->setColor(QColor(pglColor1));
	  pglColorBtn2->setColor(QColor(pglColor2));
    } else {
          useCustomColorBtn5->setChecked(false);
	  pgbColorBtn->setColor(colorGroup().highlight());
	  pglColorBtn1->setColor(colorGroup().text());
	  pglColorBtn2->setColor(colorGroup().highlightedText());
    }

    QString pggColor  = settings.readEntry(searchPath + "/Tiblit/ProgressbarGrooveColor");
    if (!pggColor.isNull()) {
          useCustomColorBtn6->setChecked(true);
	  pggColorBtn->setColor(QColor(pggColor));
    } else {
          useCustomColorBtn6->setChecked(false);
	  pggColorBtn->setColor(colorGroup().base());
    }

    useShdM->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseShadowTextMenu"));
    disableShdEmpBtn->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/DisableShadowEmphasis"));
    useShdMB->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseShadowTextMenuBar"));
    useShdB->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseShadowTextButton"));
    useShdT->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseShadowTextTab"));

    animateProgressBar->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/animateProgressBar"));
	reverseAnimation->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/reverseAnimation"));
	progressTimerSlow->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/progressTimerSlow"));
	progressTimerMedium->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/progressTimerMedium"));
	progressTimerFast->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/progressTimerFast"));
	buttonSizeVertTiny->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/buttonSizeVertTiny"));	
	buttonSizeVertSmall->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/buttonSizeVertSmall"));	
	buttonSizeVertStandard->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/buttonSizeVertStandard"));	
	buttonSizeVertLarge->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/buttonSizeVertLarge"));	
	buttonSizeHorizTiny->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/buttonSizeHorizTiny"));	
	buttonSizeHorizSmall->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/buttonSizeHorizSmall"));	
	buttonSizeHorizStandard->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/buttonSizeHorizStandard"));	
	buttonSizeHorizLarge->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/buttonSizeHorizLarge"));	
	decayHorizFastest->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayHorizFastest"));
	decayHorizFast->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayHorizFast"));
	decayHorizNormal->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayHorizNormal"));
	decayHorizSlow->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayHorizSlow"));
	decayHorizSlowest->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayHorizSlowest"));
	decayVertFastest->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayVertFastest"));
	decayVertFast->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayVertFast"));
	decayVertNormal->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayVertNormal"));
	decayVertSlow->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayVertSlow"));
	decayVertSlowest->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayVertSlowest"));
	decayVertical->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayVertical"));
	decayHorizontal->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayHorizontal"));
	decayDiagonal->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayDiagonal"));
	decayCrossDiagonal->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayCrossDiagonal"));
	decayPyramid->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayPyramid"));
	decayRectangle->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayRectangle"));
	decayPipeCross->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayPipeCross"));
	decayElliptic->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/decayElliptic"));

	if (animateProgressBar->isOn()) {
		reverseAnimation->setEnabled(true);
		progressTimerSlow->setEnabled(true);
		progressTimerMedium->setEnabled(true);
		progressTimerFast->setEnabled(true);
	} else {
		reverseAnimation->setEnabled(false);
		progressTimerSlow->setEnabled(false);
		progressTimerSlow->setEnabled(false);
		progressTimerSlow->setEnabled(false);
	}

    buttonStrongGradients->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseSGButton"));

	buttonLight->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseLightButtons"));

	if (!buttonStrongGradients->isOn() && !buttonLight->isOn())
		buttonStandard->setChecked(true);

    useSgc->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseSGCombobox"));

    useFlb->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseFlatBevel"));

    if (useFlb->isOn()) {
            useSgbv->setChecked(false);
    } else {
            useSgbv->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseSGBevel", buttonStrongGradients->isOn()));
    }

    usePbcBvl->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UsePBCBevel"));

    highlightDefaultButton->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/HighlightDefaultButton"));

    highlightActiveTask->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/HighlightActiveTask"));

    flattenActiveTab->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/FlattenActiveTab"));

    surroundSunkenPanel->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/SurroundSunkenPanel"));

    surroundTaskbutton->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/SurroundTaskbutton"));

    barBorderFollowsContrast->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/BarBorderFollowsContrast"));

    removeSublineArea->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/RemoveSublineArea"));
 
    drawProgressBarValue->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/DrawProgressBarValue"));

    useLowerCaseText->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseLowerCaseText"));

    removeMenuIcons->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/RemoveMenuIcons"));

    dontDrawDisabledMenuItems->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/DontDrawDisabledMenuItems"));
    drawDashedSeparators->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/DrawDashedSeparators"));
	dontDrawMenuSeparators->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/DontDrawMenuSeparators")); 

    useLightCombo->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseLightWeightCombobox"));

    useLightNECombo->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseLightWeightStdCombobox"));

    disableBB->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/DisableBarBorder"));

    useBGCTab->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseBGColorTab"));

    useSingleLineHandles->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseSingleLineHandles"));

    disableScrollbarBorder->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/DisableScrollbarBorder"));

    //useShadowlessButton->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/UseShadowlessButton"));

    if (qstrcmp(searchPath, "/qt") == 0) {
            disableKMenuTitlesOld = !loadKickerConfig();
	    disableKMenuTitles->setChecked(disableKMenuTitlesOld);
    } else {
            disableKMenuTitles->setChecked(settings.readBoolEntry(searchPath + "/Tiblit/DisableKMenuTitles"));
    }

    slotUseCustomColor1Clicked(useCustomColorBtn1->isChecked());
    slotUseCustomColor1bClicked(useCustomColorBtn1b->isChecked());
    slotUseCustomColor1cClicked(useCustomColorBtn1c->isChecked());
    slotUseMenuBGIClicked(useMenuBGI->isChecked());
    slotEnable3DMIBtnClicked(enableMI3d->isChecked());
    slotEnable3DMSBtnClicked(enableMS3d->isChecked());
    slotEnableGradClicked(enableGradBtn->isChecked());
    slotUseCustomColor2Clicked(useCustomColorBtn2->isChecked());
    slotDisableUpperLinesClicked(disableUpperLinesBtn->isChecked());
    slotUseCustomColor3Clicked(useCustomColorBtn3->isChecked());
    slotUseCustomColor4Clicked(useCustomColorBtn4->isChecked());
    slotUseCustomColorCbxClicked(useCustomColorBtnCbx->isChecked());
    slotUseCustomColor5Clicked(useCustomColorBtn5->isChecked());
    slotUseCustomColor6Clicked(useCustomColorBtn6->isChecked());
    slotUseButtonBorderColorClicked(useButtonBorderColor->isChecked());
    slotUseComboboxBorderColorClicked(useComboboxBorderColor->isChecked());
    slotUseStatusbarBorderColorClicked(useStatusbarBorderColor->isChecked());
    slotUseShadowMClicked(useShdM->isChecked());
    slotBtnColorChanged(colorGroup().background());
    slotUseSgbvClicked(useSgbv->isChecked());

}

bool TiblitStyleConfig::loadKickerConfig() {
    KConfig c("kickerrc", false, false);
    c.setGroup("menus");
    return c.readBoolEntry( "ShowMenuTitles", true );
}

TiblitStyleConfig::~TiblitStyleConfig()
{
    KGlobal::locale()->removeCatalogue("kstyle_tiblit_config");
}


void TiblitStyleConfig::save()
{
    saveSettings("/qt");
}

void TiblitStyleConfig::saveSettings(const QString &searchPath)
{
    QSettings *settings = new QSettings;
    QString aValue;

    if(useCustomColorBtn1->isOn()){
        settings->writeEntry(searchPath + "/Tiblit/MenuFG",  "#" + aValue.sprintf("%06x",
                             (menuFgBtn->color().red()*65536 + menuFgBtn->color().green()*256 + menuFgBtn->color().blue())) );
        settings->writeEntry(searchPath + "/Tiblit/MenuBG",  "#" + aValue.sprintf("%06x",
                             (menuBgBtn->color().red()*65536 + menuBgBtn->color().green()*256 + menuBgBtn->color().blue())) );
        settings->writeEntry(searchPath + "/Tiblit/MenuStripe", "#" +  aValue.sprintf("%06x",
			     (menuStripeBtn->color().red()*65536 + menuStripeBtn->color().green()*256 + menuStripeBtn->color().blue())) );
        settings->writeEntry(searchPath + "/Tiblit/MenuSeparator", "#" +  aValue.sprintf("%06x",
			     (menuSeparatorBtn->color().red()*65536 + menuSeparatorBtn->color().green()*256 + menuSeparatorBtn->color().blue())) );
    } else {
        settings->writeEntry(searchPath + "/Tiblit/MenuFG",QString::null);
        settings->writeEntry(searchPath + "/Tiblit/MenuBG",QString::null);
        settings->writeEntry(searchPath + "/Tiblit/MenuStripe",QString::null);
        settings->writeEntry(searchPath + "/Tiblit/MenuSeparator",QString::null);
    }

    settings->writeEntry(searchPath + "/Tiblit/EnableGradation", enableGradBtn->isOn());
    if (enableGradBtn->isOn()) {
        settings->writeEntry(searchPath + "/Tiblit/CustomGradation", customGradBtn->isOn());
    } else {
        settings->writeEntry(searchPath + "/Tiblit/CustomGradation",QString::null);
    }

    if (useMenuBGI->isOn()) {
        settings->writeEntry(searchPath + "/Tiblit/MenuBGImage", menubgfile->text());
        settings->writeEntry(searchPath + "/Tiblit/ScaledMenuBGImage", scaledMenuBGI->isOn());
    } else {
        settings->writeEntry(searchPath + "/Tiblit/MenuBGImage",QString::null);
        settings->writeEntry(searchPath + "/Tiblit/ScaledMenuBGImage",QString::null);
    }

    if(useCustomColorBtn1b->isOn()){
        settings->writeEntry(searchPath + "/Tiblit/MenuBorder", "#" + aValue.sprintf("%06x",
			     (borderColBtn->color().red()*65536 + borderColBtn->color().green()*256 + borderColBtn->color().blue())) );
    } else {
        settings->writeEntry(searchPath + "/Tiblit/MenuBorder",QString::null);
    }


    if(useCustomColorBtn1c->isOn()){
        settings->writeEntry(searchPath + "/Tiblit/MenuSelectedFG",  "#" + aValue.sprintf("%06x",
                             (menuSelFgBtn->color().red()*65536 + menuSelFgBtn->color().green()*256 + menuSelFgBtn->color().blue())) );
        settings->writeEntry(searchPath + "/Tiblit/MenuSelectedBG",  "#" + aValue.sprintf("%06x",
                             (menuSelBgBtn->color().red()*65536 + menuSelBgBtn->color().green()*256 + menuSelBgBtn->color().blue())) );
        settings->writeEntry(searchPath + "/Tiblit/MenuSelectedShadow", "#" +  aValue.sprintf("%06x",
			     (menuSelShdBtn->color().red()*65536 + menuSelShdBtn->color().green()*256 + menuSelShdBtn->color().blue())) );
    } else {
        settings->writeEntry(searchPath + "/Tiblit/MenuSelectedFG",QString::null);
        settings->writeEntry(searchPath + "/Tiblit/MenuSelectedBG",QString::null);
        settings->writeEntry(searchPath + "/Tiblit/MenuSelectedShadow",QString::null);
    }

    settings->writeEntry(searchPath + "/Tiblit/Strong3DMI", strong3dmi->isOn());
    settings->writeEntry(searchPath + "/Tiblit/Strong3DMS", strong3dms->isOn());
    settings->writeEntry(searchPath + "/Tiblit/EnableMenuItem3D", enableMI3d->isOn());
    settings->writeEntry(searchPath + "/Tiblit/EnableStripe3D", enableMS3d->isOn());

    if(useCustomColorBtn2->isOn()){
        settings->writeEntry(searchPath + "/Tiblit/ActiveTab", "#" + aValue.sprintf("%06x",
			     (activeTabBtn->color().red()*65536 + activeTabBtn->color().green()*256 + activeTabBtn->color().blue())) );
    } else {
        settings->writeEntry(searchPath + "/Tiblit/ActiveTab",QString::null);
    }

    settings->writeEntry(searchPath + "/Tiblit/DisableUpperLines", disableUpperLinesBtn->isOn());

    if(useCustomColorBtn3->isOn()){
        settings->writeEntry(searchPath + "/Tiblit/Scrollbar", "#" + aValue.sprintf("%06x",
			     (scrollbarBtn->color().red()*65536 + scrollbarBtn->color().green()*256 + scrollbarBtn->color().blue())) );
		settings->writeEntry(searchPath + "/Tiblit/Slider", "#" + aValue.sprintf("%06x",
				(sliderBtn->color().red() * 65536 + sliderBtn->color().green() * 256 + sliderBtn->color().blue())) );
        settings->writeEntry(searchPath + "/Tiblit/ScrollArrowbtn", "#" + aValue.sprintf("%06x",
			     (scrollArbBtn->color().red()*65536 + scrollArbBtn->color().green()*256 + scrollArbBtn->color().blue())) );
        settings->writeEntry(searchPath + "/Tiblit/ScrollArrowFG", "#" + aValue.sprintf("%06x",
			     (scrollAfgBtn->color().red()*65536 + scrollAfgBtn->color().green()*256 + scrollAfgBtn->color().blue())) );
        settings->writeEntry(searchPath + "/Tiblit/ScrollGroove", "#" + aValue.sprintf("%06x",
			     (scrollGrvBtn->color().red()*65536 + scrollGrvBtn->color().green()*256 + scrollGrvBtn->color().blue())) );
    } else {
        settings->writeEntry(searchPath + "/Tiblit/Scrollbar",QString::null);
        settings->writeEntry(searchPath + "/Tiblit/ScrollArrowbtn",QString::null);
        settings->writeEntry(searchPath + "/Tiblit/ScrollArrowFG",QString::null);
        settings->writeEntry(searchPath + "/Tiblit/ScrollGroove",QString::null);
		settings->writeEntry(searchPath + "/Tiblit/Slider", QString::null);
    }

    if(useCustomColorBtn4->isOn()){
        settings->writeEntry(searchPath + "/Tiblit/ButtonPrelight", "#" + aValue.sprintf("%06x",
			     (btnprlBtn->color().red()*65536 + btnprlBtn->color().green()*256 + btnprlBtn->color().blue())) );
	settings->writeEntry(searchPath + "/Tiblit/PrelightInnerCircumOnly", prelightInnerCircumOnlyBtn->isOn());
    } else {
        settings->writeEntry(searchPath + "/Tiblit/ButtonPrelight",QString::null);
	settings->writeEntry(searchPath + "/Tiblit/PrelightInnerCircumOnly",QString::null);
    }

    if(useCustomColorBtnCbx->isOn()){
        settings->writeEntry(searchPath + "/Tiblit/ComboboxPrelight", "#" + aValue.sprintf("%06x",
			     (cbxprlBtn->color().red()*65536 + cbxprlBtn->color().green()*256 + cbxprlBtn->color().blue())) );
	settings->writeEntry(searchPath + "/Tiblit/PrelightInnerCircumOnlyCombobox", prelightInnerCircumOnlyCbxBtn->isOn());
    } else {
        settings->writeEntry(searchPath + "/Tiblit/ComboboxPrelight",QString::null);
	settings->writeEntry(searchPath + "/Tiblit/PrelightInnerCircumOnlyCombobox",QString::null);
    }

    if(useButtonBorderColor->isOn()){
        settings->writeEntry(searchPath + "/Tiblit/ButtonBorderColor", "#" + aValue.sprintf("%06x",
			     (buttonBorderColBtn->color().red()*65536 + buttonBorderColBtn->color().green()*256 + buttonBorderColBtn->color().blue())) );
    } else {
        settings->writeEntry(searchPath + "/Tiblit/ButtonBorderColor",QString::null);
    }

    if(useComboboxBorderColor->isOn()){
        settings->writeEntry(searchPath + "/Tiblit/ComboboxBorderColor", "#" + aValue.sprintf("%06x",
			     (comboboxBorderColBtn->color().red()*65536 + comboboxBorderColBtn->color().green()*256 + comboboxBorderColBtn->color().blue())) );
    } else {
        settings->writeEntry(searchPath + "/Tiblit/ComboboxBorderColor",QString::null);
    }

    if(useStatusbarBorderColor->isOn()){
        settings->writeEntry(searchPath + "/Tiblit/StatusbarBorderColor", "#" + aValue.sprintf("%06x",
			     (statusbarBorderColBtn->color().red()*65536 + statusbarBorderColBtn->color().green()*256 + statusbarBorderColBtn->color().blue())) );
    } else {
        settings->writeEntry(searchPath + "/Tiblit/StatusbarBorderColor",QString::null);
    }

    if(useCustomColorBtn5->isOn()){
        settings->writeEntry(searchPath + "/Tiblit/ProgressbarColor", "#" + aValue.sprintf("%06x",
			     (pgbColorBtn->color().red()*65536 + pgbColorBtn->color().green()*256 + pgbColorBtn->color().blue())) );
        settings->writeEntry(searchPath + "/Tiblit/ProgressbarLabelColor1", "#" + aValue.sprintf("%06x",
			     (pglColorBtn1->color().red()*65536 + pglColorBtn1->color().green()*256 + pglColorBtn1->color().blue())) );
        settings->writeEntry(searchPath + "/Tiblit/ProgressbarLabelColor2", "#" + aValue.sprintf("%06x",
			     (pglColorBtn2->color().red()*65536 + pglColorBtn2->color().green()*256 + pglColorBtn2->color().blue())) );
    } else {
        settings->writeEntry(searchPath + "/Tiblit/ProgressbarColor",QString::null);
        settings->writeEntry(searchPath + "/Tiblit/ProgressbarLabelColor1",QString::null);
        settings->writeEntry(searchPath + "/Tiblit/ProgressbarLabelColor2",QString::null);
    }

    if(useCustomColorBtn6->isOn()){
        settings->writeEntry(searchPath + "/Tiblit/ProgressbarGrooveColor", "#" + aValue.sprintf("%06x",
			     (pggColorBtn->color().red()*65536 + pggColorBtn->color().green()*256 + pggColorBtn->color().blue())) );
    } else {
        settings->writeEntry(searchPath + "/Tiblit/ProgressbarGrooveColor",QString::null);
    }

    settings->writeEntry(searchPath + "/Tiblit/UseShadowTextMenu", useShdM->isOn());
    settings->writeEntry(searchPath + "/Tiblit/DisableShadowEmphasis", disableShdEmpBtn->isOn());
    settings->writeEntry(searchPath + "/Tiblit/UseShadowTextMenuBar", useShdMB->isOn());
    settings->writeEntry(searchPath + "/Tiblit/UseShadowTextButton", useShdB->isOn());
    settings->writeEntry(searchPath + "/Tiblit/UseShadowTextTab", useShdT->isOn());

    settings->writeEntry(searchPath + "/Tiblit/animateProgressBar", animateProgressBar->isOn());
	settings->writeEntry(searchPath + "/Tiblit/reverseAnimation", reverseAnimation->isOn());
	settings->writeEntry(searchPath + "/Tiblit/progressTimerSlow", progressTimerSlow->isOn());
	settings->writeEntry(searchPath + "/Tiblit/progressTimerMedium", progressTimerMedium->isOn());
	settings->writeEntry(searchPath + "/Tiblit/progressTimerFast", progressTimerFast->isOn());
	settings->writeEntry(searchPath + "/Tiblit/buttonSizeVertTiny", buttonSizeVertTiny->isOn());
	settings->writeEntry(searchPath + "/Tiblit/buttonSizeVertSmall", buttonSizeVertSmall->isOn());
	settings->writeEntry(searchPath + "/Tiblit/buttonSizeVertStandard", buttonSizeVertStandard->isOn());
	settings->writeEntry(searchPath + "/Tiblit/buttonSizeVertLarge", buttonSizeVertLarge->isOn());
	settings->writeEntry(searchPath + "/Tiblit/buttonSizeHorizTiny", buttonSizeHorizTiny->isOn());
	settings->writeEntry(searchPath + "/Tiblit/buttonSizeHorizSmall", buttonSizeHorizSmall->isOn());
	settings->writeEntry(searchPath + "/Tiblit/buttonSizeHorizStandard", buttonSizeHorizStandard->isOn());
	settings->writeEntry(searchPath + "/Tiblit/buttonSizeHorizLarge", buttonSizeHorizLarge->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayHorizFastest", decayHorizFastest->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayHorizFast", decayHorizFast->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayHorizNormal", decayHorizNormal->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayHorizSlow", decayHorizSlow->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayHorizSlowest", decayHorizSlowest->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayVertFastest", decayVertFastest->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayVertFast", decayVertFast->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayVertNormal", decayVertNormal->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayVertSlow", decayVertSlow->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayVertSlowest", decayVertSlowest->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayVertical", decayVertical->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayHorizontal", decayHorizontal->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayDiagonal", decayDiagonal->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayCrossDiagonal", decayCrossDiagonal->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayPyramid", decayPyramid->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayRectangle", decayRectangle->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayPipeCross", decayPipeCross->isOn());
	settings->writeEntry(searchPath + "/Tiblit/decayElliptic", decayElliptic->isOn());

    settings->writeEntry(searchPath + "/Tiblit/UseSGButton", buttonStrongGradients->isOn());

	settings->writeEntry(searchPath + "/Tiblit/UseLightButtons", buttonLight->isOn());

    settings->writeEntry(searchPath + "/Tiblit/UseSGBevel", useSgbv->isOn());

    settings->writeEntry(searchPath + "/Tiblit/UseSGCombobox", useSgc->isOn());

    if (useSgbv->isOn()) {
            settings->writeEntry(searchPath + "/Tiblit/UseFlatBevel", false);
    } else {
            settings->writeEntry(searchPath + "/Tiblit/UseFlatBevel", useFlb->isOn());
    }

    settings->writeEntry(searchPath + "/Tiblit/UsePBCBevel", usePbcBvl->isOn());

    settings->writeEntry(searchPath + "/Tiblit/HighlightDefaultButton", highlightDefaultButton->isOn());

    settings->writeEntry(searchPath + "/Tiblit/HighlightActiveTask", highlightActiveTask->isOn());

    settings->writeEntry(searchPath + "/Tiblit/FlattenActiveTab", flattenActiveTab->isOn());

    settings->writeEntry(searchPath + "/Tiblit/SurroundSunkenPanel", surroundSunkenPanel->isOn());

    settings->writeEntry(searchPath + "/Tiblit/SurroundTaskbutton", surroundTaskbutton->isOn());

    settings->writeEntry(searchPath + "/Tiblit/BarBorderFollowsContrast", barBorderFollowsContrast->isOn());

    settings->writeEntry(searchPath + "/Tiblit/RemoveSublineArea", removeSublineArea->isOn());

    settings->writeEntry(searchPath + "/Tiblit/DrawProgressBarValue", drawProgressBarValue->isOn());

    settings->writeEntry(searchPath + "/Tiblit/UseLowerCaseText", useLowerCaseText->isOn());

    settings->writeEntry(searchPath + "/Tiblit/RemoveMenuIcons", removeMenuIcons->isOn());

    settings->writeEntry(searchPath + "/Tiblit/DontDrawDisabledMenuItems", dontDrawDisabledMenuItems->isOn());
    
    settings->writeEntry(searchPath + "/Tiblit/DrawDashedSeparators", drawDashedSeparators->isOn());

	settings->writeEntry(searchPath + "/Tiblit/DontDrawMenuSeparators", dontDrawMenuSeparators->isOn());

    settings->writeEntry(searchPath + "/Tiblit/UseLightWeightCombobox", useLightCombo->isOn());

    settings->writeEntry(searchPath + "/Tiblit/UseLightWeightStdCombobox", useLightNECombo->isOn());

    settings->writeEntry(searchPath + "/Tiblit/DisableBarBorder", disableBB->isOn());

    settings->writeEntry(searchPath + "/Tiblit/UseBGColorTab", useBGCTab->isOn());

    settings->writeEntry(searchPath + "/Tiblit/UseSingleLineHandles", useSingleLineHandles->isOn());

    settings->writeEntry(searchPath + "/Tiblit/DisableScrollbarBorder", disableScrollbarBorder->isOn());

    //settings->writeEntry(searchPath + "/Tiblit/UseShadowlessButton", useShadowlessButton->isOn());

    settings->writeEntry(searchPath + "/Tiblit/DisableKMenuTitles", disableKMenuTitles->isOn());
 
    delete settings; // force sync

    if (qstrcmp(searchPath, "/qt") == 0) {
            saveKickerConfig("kickerrc", !disableKMenuTitles->isOn());
	    QString kdeConfigDir = QDir::homeDirPath() + "/.kde/share/config/";
	    for (int sn=0; sn<10; sn++) {
	            QString screenrc = QString("kicker-screen-%1rc").arg(sn);
		    if (QFile::exists(kdeConfigDir + screenrc)) {
		            saveKickerConfig(screenrc, !disableKMenuTitles->isOn());
		    }
	    }
	    if (disableKMenuTitlesOld != disableKMenuTitles->isOn()) {
	            QByteArray data;
		    kapp->dcopClient()->send( "kicker", "Panel", "restart()", data );
	    }
    }
}

void TiblitStyleConfig::saveKickerConfig(const QString &kickerrc, bool showMenuTitles) {
    KConfig c(kickerrc, false, false);
    c.setGroup("menus");
    c.writeEntry( "ShowMenuTitles", showMenuTitles );
    c.sync();
}

void TiblitStyleConfig::defaults()
{
    loadSettings("/tiblit_default.kcm", false);
    emit changed(true);
}

void TiblitStyleConfig::updateChanged()
{
}

void TiblitStyleConfig::slotBtnColorChanged(const QColor &)
{
    emit changed(true);
}

void TiblitStyleConfig::slotCheckBtnClicked(bool en)
{
	if (animateProgressBar->isOn()) {
		reverseAnimation->setEnabled(true);
		progressTimerSlow->setEnabled(true);
		progressTimerMedium->setEnabled(true);
		progressTimerFast->setEnabled(true);
	} else {
		reverseAnimation->setEnabled(false);
		progressTimerSlow->setEnabled(false);
		progressTimerMedium->setEnabled(false);
		progressTimerFast->setEnabled(false);
	}
    emit changed(true);
}

void TiblitStyleConfig::slotTextChanged(const QString &)
{
    emit changed(true);
}

void TiblitStyleConfig::slotUseCustomColor1Clicked(bool en)
{
    menuFgBtn->setEnabled(en);
    menuBgBtn->setEnabled(en);
    menuStripeBtn->setEnabled(en);
    menuSeparatorBtn->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotUseCustomColor1bClicked(bool en)
{
    borderColBtn->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotUseCustomColor1cClicked(bool en)
{
    menuSelFgBtn->setEnabled(en);
    menuSelBgBtn->setEnabled(en);
    menuSelShdBtn->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotUseMenuBGIClicked(bool en)
{
    menubgfile->setEnabled(en);
    menubgBrowse->setEnabled(en);
    scaledMenuBGI->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotMenuBGIBrowser()
{
    QString findStartDir = menubgfile->text();
    if (findStartDir.isNull()) {
          findStartDir = QDir::homeDirPath();
    } else if (findStartDir.length() == 0) {
          findStartDir = QDir::homeDirPath();
    }

    QString mbgifile = KFileDialog::getOpenFileName(
                             findStartDir,
			     "Images (*.png *.xpm *.jpg *.bmp *.PNG *.XPM *.JPG *.BMP)",
			     this,
			     "Select menu background" );

    if (!mbgifile.isNull()) {
          menubgfile->setText(mbgifile);
    }
    emit changed(true);
}

void TiblitStyleConfig::slotEnable3DMIBtnClicked(bool en)
{
    strong3dmi->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotEnable3DMSBtnClicked(bool en)
{
    strong3dms->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotEnableGradClicked(bool en)
{
    customGradBtn->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotUseCustomColor2Clicked(bool en)
{
    activeTabBtn->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotDisableUpperLinesClicked(bool en)
{
    useCustomColorBtn2->setEnabled(!en);
    activeTabBtn->setEnabled(useCustomColorBtn2->isOn() && !disableUpperLinesBtn->isOn());
    emit changed(true);
}

void TiblitStyleConfig::slotUseCustomColor3Clicked(bool en)
{
    scrollbarBtn->setEnabled(en);
    scrollArbBtn->setEnabled(en);
    scrollAfgBtn->setEnabled(en);
    scrollGrvBtn->setEnabled(en);
	sliderBtn->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotUseCustomColor4Clicked(bool en)
{
    btnprlBtn->setEnabled(en);
    prelightInnerCircumOnlyBtn->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotUseCustomColorCbxClicked(bool en)
{
    cbxprlBtn->setEnabled(en);
    prelightInnerCircumOnlyCbxBtn->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotUseButtonBorderColorClicked(bool en)
{
    buttonBorderColBtn->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotUseComboboxBorderColorClicked(bool en)
{
    comboboxBorderColBtn->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotUseStatusbarBorderColorClicked(bool en)
{
    statusbarBorderColBtn->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotUseCustomColor5Clicked(bool en)
{
    pgbColorBtn->setEnabled(en);
    pglColorBtn1->setEnabled(en);
    pglColorBtn2->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotUseCustomColor6Clicked(bool en)
{
    pggColorBtn->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotUseShadowMClicked(bool en)
{
    disableShdEmpBtn->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::slotLoadScheme()
{
    QString schemeNameText = schemeName->text();
    bool globalScheme = false;

    if (schemeNameText.startsWith("(GLOBAL)")) {
          schemeNameText.remove( 0, 8 );
	  globalScheme = true;
    }

    QString schemeStr  = "/tiblit_" + schemeNameText + ".kcm";
    QStringList schemeFile( (QString) (QDir::homeDirPath() + "/.qt" + schemeStr + "rc"));
    schemeFile << (QString) (QString(getenv("KDEDIR")) + "/share/apps/kdisplay/styleconfs" + schemeStr + "rc");
    bool schemeExists = false;
    for ( QStringList::Iterator it = schemeFile.begin(); it != schemeFile.end(); ++it ) {
	if (QFile::exists(*it)) {
	    schemeExists = true;
	    int loadOK = QMessageBox::question(this,
					       i18n("Load Scheme? - Tiblit Scheme Manager"),
					       i18n("Are you sure you want to load \"%1\"?").arg(schemeName->text()) + "\n"
					       + i18n("Current settings will be overwritten."),
					       QMessageBox::Yes,
					       QMessageBox::No,
					       QMessageBox::NoButton);
	    if (loadOK == QMessageBox::Yes) {
	        loadSettings(schemeStr, globalScheme);
		QMessageBox::information(this,
					 i18n("Information - Tiblit Scheme Manager"),
					 i18n("\"%1\" was loaded.").arg(schemeName->text()),
					 QMessageBox::Ok,
					 QMessageBox::NoButton,
					 QMessageBox::NoButton);
		emit changed(true);
	    }
	    break;
	}
    }
    if (!schemeExists) {
        QMessageBox::critical(this,
			      i18n("Error - Tiblit Scheme Manager"),
			      i18n("\"%1\" : No such scheme.").arg(schemeName->text()),
			      QMessageBox::Cancel,
			      QMessageBox::NoButton,
			      QMessageBox::NoButton);          
    }

}

void TiblitStyleConfig::slotSaveScheme()
{

    bool globalScheme = false;
    if ((schemeName->text()).startsWith("(GLOBAL)")) {
        globalScheme = true;
    }
    QString schemeStr  = "/tiblit_" + schemeName->text() + ".kcm";
    QString schemeFile = QDir::homeDirPath() + "/.qt" + schemeStr + "rc";
    int saveOK = QMessageBox::Yes;
    if (QFile::exists(schemeFile)) {
        saveOK = QMessageBox::question(this,
				       i18n("Overwrite Scheme? - Tiblit Scheme Manager"),
				       i18n("A scheme called \"%1\" already exists.").arg(schemeName->text()) + "\n"
				       + i18n("Do you want to overwrite it?"),
				       QMessageBox::Yes,
				       QMessageBox::No,
				       QMessageBox::NoButton);
    }
    if (saveOK == QMessageBox::Yes) {
        if (schemeName->text().length() > 0 && !globalScheme) {
	    saveSettings(schemeStr);
	}
	searchScheme();
	if (QFile::exists(schemeFile)) {
	    QMessageBox::information(this,
				     i18n("Information - Tiblit Scheme Manager"),
				     i18n("\"%1\" was saved.").arg(schemeName->text()),
				     QMessageBox::Ok,
				     QMessageBox::NoButton,
				     QMessageBox::NoButton);
	} else {
	    QMessageBox::critical(this,
				  i18n("Error - Tiblit Scheme Manager"),
				  i18n("Save failed.") + "\n"
				  + i18n("The invalid characters may have been used for the scheme name.."),
				  QMessageBox::Cancel,
				  QMessageBox::NoButton,
				  QMessageBox::NoButton);          

	}
    }
}

void TiblitStyleConfig::slotDelScheme()
{

    QString schemeStr  = "/tiblit_" + schemeName->text() + ".kcm";
    QString schemeFile = QDir::homeDirPath() + "/.qt" + schemeStr + "rc";
    QFile delFile1(schemeFile);
    if (delFile1.exists()) {
        int delOK = QMessageBox::question(this,
					  i18n("Delete Scheme? - Tiblit Scheme Manager"),
					  i18n("A scheme called \"%1\" will be deleted.").arg(schemeName->text()) + "\n"
					  + i18n("Do you continue?"),
					  QMessageBox::Yes,
					  QMessageBox::No,
					  QMessageBox::NoButton);
	if (delOK == QMessageBox::Yes) {
	    delFile1.remove();
	    searchScheme();

	    QFile delFile2(QDir::homeDirPath() + "/.qt/.tiblit_" + schemeName->text() + ".kcmrc.lock");

	    if (delFile2.exists()) {
	        delFile2.remove();
	    }

	    QMessageBox::information(this,
				     i18n("Information - Tiblit Scheme Manager"),
				     i18n("\"%1\" was deleted.").arg(schemeName->text()),
				     QMessageBox::Ok,
				     QMessageBox::NoButton,
				     QMessageBox::NoButton);
	}
    } else {
        QMessageBox::critical(this,
			      i18n("Error - Tiblit Scheme Manager"),
			      i18n("\"%1\" : No such scheme.").arg(schemeName->text()),
			      QMessageBox::Cancel,
			      QMessageBox::NoButton,
			      QMessageBox::NoButton);          
    }
}

void TiblitStyleConfig::slotSchemeListClicked(QListBoxItem *item)
{
      if (item) {
            schemeName->setText(item->text());
      }
}

void TiblitStyleConfig::slotUseSgbvClicked(bool en)
{
    //useFlb->setEnabled(!useSgbv->isOn());
    useFlb->setEnabled(en);
    emit changed(true);
}

void TiblitStyleConfig::searchScheme()
{
    schemeListBox->clear();
    QStringList schemeDirs (QDir::homeDirPath() + "/.qt");
    schemeDirs << (QString) (QString(getenv("KDEDIR")) + "/share/apps/kdisplay/styleconfs");
    for ( QStringList::Iterator it = schemeDirs.begin(); it != schemeDirs.end(); ++it ) {
        QDir schemeDir(*it, "tiblit_*.kcmrc");
	uint schemeCount = schemeDir.count();
	for (uint sidx = 0; sidx<schemeCount; sidx++) {
            QString schemeFile = schemeDir[sidx];
	    uint fnameLen = schemeFile.length();
	    if (fnameLen > 13) { // Use to be > 22
	        schemeFile = schemeFile.right(fnameLen - 7);
		schemeFile = schemeFile.left(fnameLen - 13);
		if (!(schemeListBox->findItem(schemeFile))) {
		    if ( (*it).startsWith(QString(getenv("KDEDIR"))+ "/share/apps/kdisplay/styleconfs") ) {
		        schemeFile = "(GLOBAL)" + schemeFile;
		    }
		    schemeListBox->insertItem(schemeFile);
		}
	    }
	}
    }
}

#include "tiblitconf.moc"
// vim: ts=4 sw=4 noet
// kate: indent-width 4; replace-tabs off; tab-width 4; space-indent off;
