/*
Copyright (c) 2003 Maksim Orlovich <maksim.orlovich@kdemail.net>

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.

*/

#ifndef THINKERAMIKMOD_CONF_H
#define THINKERAMIKMOD_CONF_H

#include <kstddirs.h>
#include <kcolorbutton.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qspinbox.h>

class QSlider;
class KColorButton;
class QGroupBox;
class QVButtonGroup;
class QRadioButton;
class QCheckBox;
class QLabel;

class TiblitStyleConfig: public QWidget
{
	Q_OBJECT
public:
	TiblitStyleConfig(QWidget* parent);
	~TiblitStyleConfig();

	//This signal and the next two slots are the plugin
	//page interface
signals:
	void changed(bool);

public slots:
	void save();
	void defaults();

	//Everything below this is internal.
protected slots:
	void updateChanged();

	void slotUseCustomColor1Clicked(bool on);
	void slotUseCustomColor1bClicked(bool on);
	void slotUseCustomColor1cClicked(bool on);
	void slotUseMenuBGIClicked(bool on);
	void slotMenuBGIBrowser();
	void slotEnable3DMIBtnClicked(bool on);
	void slotEnable3DMSBtnClicked(bool on);
	void slotEnableGradClicked(bool on);
	void slotUseCustomColor2Clicked(bool on);
	void slotDisableUpperLinesClicked(bool on);
	void slotUseCustomColor3Clicked(bool on);
	void slotUseCustomColor4Clicked(bool on);
	void slotUseCustomColorCbxClicked(bool on);
	void slotUseCustomColor5Clicked(bool on);
	void slotUseCustomColor6Clicked(bool on);
	void slotUseButtonBorderColorClicked(bool on);
	void slotUseComboboxBorderColorClicked(bool on);
	void slotUseStatusbarBorderColorClicked(bool on);
	void slotUseShadowMClicked(bool on);
	void slotBtnColorChanged(const QColor &c);
	void slotCheckBtnClicked(bool on);
	void slotTextChanged(const QString &s);
	void slotSaveScheme();
	void slotLoadScheme();
	void slotDelScheme();
	void slotSchemeListClicked(QListBoxItem *);
	void slotUseSgbvClicked(bool on);

protected:
	void saveSettings(const QString &searchPath);
	void saveKickerConfig(const QString &kickerrc, bool showMenuTitles);
	void loadSettings(const QString &searchPath, bool globalScheme);
	bool loadKickerConfig();
	void searchScheme();

	QCheckBox *useCustomColorBtn1;
	QCheckBox *useCustomColorBtn1b;
	QCheckBox *useCustomColorBtn1c;
	QCheckBox *useMenuBGI;
	QCheckBox *scaledMenuBGI;
	QCheckBox *useCustomColorBtn2;
	QCheckBox *disableUpperLinesBtn;
	QCheckBox *useCustomColorBtn3;
	QCheckBox *useCustomColorBtn4;
	QCheckBox *prelightInnerCircumOnlyBtn;
	QCheckBox *useCustomColorBtnCbx;
	QCheckBox *prelightInnerCircumOnlyCbxBtn;
	QCheckBox *useCustomColorBtn5;
	QCheckBox *useCustomColorBtn6;
	QCheckBox *useButtonBorderColor;
	QCheckBox *useComboboxBorderColor;
	QCheckBox *useStatusbarBorderColor;
	QCheckBox *enableGradBtn;
	QCheckBox *customGradBtn;
	QCheckBox *strong3dmi, *strong3dms, *enableMI3d, *enableMS3d;
	QCheckBox *useShdM, *useShdMB, *useShdB, *useShdT, *disableShdEmpBtn;
	QCheckBox *animateProgressBar, *useSgbv, *useSgc, *useFlb, *usePbcBvl,
	          *disableBB, *useBGCTab, *useSingleLineHandles, *reverseAnimation,
	          *disableScrollbarBorder, *highlightDefaultButton, 
		  *drawProgressBarValue, *dontDrawDisabledMenuItems,
	          *flattenActiveTab, *surroundSunkenPanel, *surroundTaskbutton,
	          *useLightCombo, *useLightNECombo, *removeMenuIcons, 
	          *highlightActiveTask, *barBorderFollowsContrast,
	          *removeSublineArea, *disableKMenuTitles, *useLowerCaseText,
		  *drawDashedSeparators, *dontDrawMenuSeparators, *useCustomDecayGradients;
	KColorButton *menuFgBtn, *menuBgBtn, *menuStripeBtn, *menuSeparatorBtn;
	KColorButton *menuSelFgBtn, *menuSelBgBtn, *menuSelShdBtn;
	QButtonGroup *progressTimerGroup;
	QRadioButton *progressTimerSlow, *progressTimerMedium, *progressTimerFast;
	QButtonGroup *buttonSizeVertGroup;
	QRadioButton *buttonSizeVertTiny, *buttonSizeVertSmall, *buttonSizeVertStandard, *buttonSizeVertLarge;
	QButtonGroup *buttonSizeHorizGroup;
	QRadioButton *buttonSizeHorizTiny, *buttonSizeHorizSmall, *buttonSizeHorizStandard, *buttonSizeHorizLarge;
	QButtonGroup *buttonTypeGroup;
	QRadioButton *buttonLight, *buttonStrongGradients, *buttonStandard;
	QButtonGroup *decayHorizontalGroup;
	QRadioButton *decayHorizFastest, *decayHorizFast, *decayHorizNormal, *decayHorizSlow, *decayHorizSlowest;
	QButtonGroup *decayVerticalGroup;
	QRadioButton *decayVertFastest, *decayVertFast, *decayVertNormal, *decayVertSlow, *decayVertSlowest;
	QButtonGroup *decayType;
	QRadioButton *decayVertical, *decayHorizontal, *decayDiagonal, *decayCrossDiagonal, *decayPyramid,
					*decayRectangle, *decayPipeCross, *decayElliptic;
	QLineEdit *menubgfile;
	QPushButton *menubgBrowse;
	KColorButton *borderColBtn;
	KColorButton *activeTabBtn;
	KColorButton *scrollbarBtn, *scrollArbBtn, *scrollAfgBtn, *scrollGrvBtn;
	KColorButton *sliderBtn;
	KColorButton *btnprlBtn, *cbxprlBtn, *buttonBorderColBtn, *comboboxBorderColBtn;
	KColorButton *statusbarBorderColBtn;
	KColorButton *pgbColorBtn, *pglColorBtn1, *pglColorBtn2, *pggColorBtn;

	QLineEdit *schemeName;
	QListBox  *schemeListBox;
	QPushButton *loadSchemeBtn;
	QPushButton *saveSchemeBtn;
	QPushButton *delSchemeBtn;
};

#endif
