#ifndef STRINGLIST_H
#define STRINGLIST_H


// StringList class : implements a doubly linked list of FXString


class StringItem
{
    friend class StringList;
protected:
    FXString str;              // FXString stored in the item
    StringItem *next;          // Pointer to next item
    StringItem *prev;          // Pointer to previous item
};

class StringList
{
public:
    StringItem *first;         // Pointer to begin of list
    StringItem *last;          // Pointer to end of list

    StringList()
    {
        first=NULL;
        last=NULL;
    }

	// Get first item
	StringItem* getFirst(void)
	{
		return this->first;
	}

	// Get last item
	StringItem* getLast(void)
	{
		return this->last;
	}

	// Get previous item
	StringItem* getPrev(StringItem *item)
	{
		return item->prev;
	}

	// Get next item
	StringItem* getNext(StringItem *item)
	{
		return item->next;
	}
	
	// Get string from item
	FXString getString(StringItem *item)
	{
		return item->str;
	}
	
    void insertFirstItem(FXString str);
    void insertLastItem(FXString str);
    void removeFirstItem();
    void removeLastItem();
    void insertBeforeItem(FXString str, StringItem *item);
    void insertAfterItem(FXString str, StringItem *item);
    void removeBeforeItem(StringItem *item);
    void removeAfterItem(StringItem *item);
    void removeItem(StringItem *item);
	FXint getNumItems(void);
	void removeAllItemsBefore(StringItem *item);
	void removeAllItemsAfter(StringItem *item);
	void removeAllItems(void); 
	StringItem* getItemAtPos(const FXint pos);
	void printFromFirst();
    void printFromLast();
};

#endif
