/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

 /* (C) Marcin Kwadrans <quar@vitea.pl> */

#include "include/support.h"
#include "include/environment.h"
#include <string.h>

extern void create_interface ();
extern void set_title (gchar *name);


int
main (int argc, char *argv[])
{
#ifdef ENABLE_NLS
#ifdef _WIN32
	gchar *localedir = g_win32_get_package_installation_subdirectory(NULL, NULL, "share\\locale");
	bindtextdomain (GETTEXT_PACKAGE, localedir);
	g_free (localedir);
#else
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
#endif

	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	gtk_set_locale ();
	
	if (argc > 1)
		if (!strcmp ("--help", argv[1])) {
			char *prgname = g_path_get_basename(argv[0]);

			g_print (_("Syntax: %s [OPTION] [FILE]\n"\
					   "Load little wizard project file or start new project\n"\
					   " --help     Show this message and exit\n"\
			           " --version  Print version info and exit\n"),
						prgname);

			g_free (prgname);
			return 0;
			
		} else if (!strcmp ("--version", argv[1])) {
			g_print ("Little Wizard %s\n",VERSION);
			g_print ("(C) Marcin Kwadrans <quar@vitea.pl>\n"\
					 "This program is distributed in the hope that it will be useful,\n"\
					 "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"\
					 "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"\
					 "GNU General Public License for more details.\n");
			
			return 0;
		}

	gtk_init (&argc, &argv);
		
	LWEnvironment::init();
	LWProject *project = new LWProject();
	LWEnvironment::setProject (project);

	create_interface();

	if (argc > 1) {
		project->load (argv[1]);
		set_title (argv[1]);
	}

	gtk_main ();

	return 0;
}
