//////////////////////////////////////////////////////////////////////////////
// Name:        SVGTransformable.h
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by generate.py
//////////////////////////////////////////////////////////////////////////////

#ifndef WX_SVG_TRANSFORMABLE_H
#define WX_SVG_TRANSFORMABLE_H

#include "SVGLocatable.h"
#include "SVGAnimatedTransformList.h"
#include "String.h"
#include "Element.h"

class wxSVGTransformable:
  public wxSVGLocatable
{
  protected:
    wxSVGAnimatedTransformList m_transform;

  public:
    inline const wxSVGAnimatedTransformList& GetTransform() const { return m_transform; }
    inline void SetTransform(const wxSVGAnimatedTransformList& n) { m_transform = n; }
    inline void SetTransform(const wxSVGTransformList& n) { m_transform.SetBaseVal(n); }

  public:
    virtual ~wxSVGTransformable() {}
    void Transform(const wxSVGMatrix& matrix);
    void Translate(double tx, double ty);
    void Scale(double s);
    void Scale(double sx, double sy);
    void Rotate(double angle, double cx = 0, double cy = 0);
    void SkewX(double angle);
    void SkewY(double angle);
    void UpdateMatrix(wxSVGMatrix& matrix) const;
    static wxSVGTransformable* GetSVGTransformable(wxSVGElement& element);
    static const wxSVGTransformable* GetSVGTransformable(const wxSVGElement& element);
    bool HasAttribute(const wxString& name);
    wxString GetAttribute(const wxString& name);
    bool SetAttribute(const wxString& name, const wxString& value);
    wxXmlAttrHash GetAttributes() const;
};

#endif // WX_SVG_TRANSFORMABLE_H
