##############################################################################
## Name:        cppHeader.py
## Purpose:     generates c++ header and saves it
## Author:      Alex Thuering
## Created:     2005/01/19
## RCS-ID:      $Id: cppHeader.py,v 1.3 2005/06/07 22:07:05 ntalex Exp $
## Copyright:   (c) 2005 Alex Thuering
## Notes:       some modules adapted from svgl project
##############################################################################

import os.path
import genFile
import string

def make_header_name(name):
	pos = 0
	if name[0:3] in ["SVG", "CSS"]:
		pos = 3
	while len(name)>pos:
		if name[pos] == string.upper(name[pos]):
			if pos>0:
				name = name[0:pos] + "_" + name[pos:]
				pos = pos + 1
			pos = pos + 1
			if len(name)>pos and name[pos] == string.upper(name[pos]):
				while len(name)>pos and name[pos] == string.upper(name[pos]):
					pos = pos + 1
				name = name[0:pos-1] + "_" + name[pos-1:]
				pos = pos + 1
		else:
			pos = pos +1
	return string.upper(name)

class Header:
	def __init__(self, name, script_name, prefix="WX"):
		self.name = name
		self.script_name = script_name
		self.prefix = prefix
		
		if self.prefix:
			self.guard = self.prefix+'_'+make_header_name(self.name)+'_H'
		else:
			self.guard = self.name+'_H'

		self.content=''

	def add_content(self, content):
		self.content = self.content + content

	def dump(self, path=''):
		data = '''\
//////////////////////////////////////////////////////////////////////////////
// Name:        %s.h
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by %s
//////////////////////////////////////////////////////////////////////////////

#ifndef %s
#define %s

%s

#endif // %s
'''%(self.name, self.script_name, self.guard, self.guard, self.content, self.guard)

		filename = os.path.join(path, self.name+'.h')
		f = genFile.gfopen(filename,'w')
		f.write(data)
