//////////////////////////////////////////////////////////////////////////////
// Name:        SVGUIControl.cpp
// Purpose:     
// Author:      Laurent Bessard
// Created:     2005/08/18
// RCS-ID:      $Id: SVGUIElement.cpp,v 1.2 2006/01/08 19:42:41 ntalex Exp $
// Copyright:   (c) Laurent Bessard
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#include "SVGUIElement.h"

SVGUIElement::SVGUIElement(wxSVGDocument* doc)
{
	m_doc = doc;
	m_BackgroundElement = NULL;
}

wxString SVGUIElement::GetId()
{
	return GetAttribute(wxT("id"));
}

void SVGUIElement::AddProperty(const wxString& name, const wxString& value)
{
	SetAttribute(name, value);
	wxXmlElement::AddProperty(name, value);
}

bool SVGUIElement::SetAttribute(const wxString& attrName, const wxString& attrValue)
{
  if (attrName == wxT("background_id"))
  	m_BackgroundElement = (wxSVGElement*)m_doc->GetElementById(attrValue);
  else 
    return false;
  return true;
}
