//////////////////////////////////////////////////////////////////////////////
// Name:        SVGUIElement.h
// Purpose:     
// Author:      Laurent Bessard
// Created:     2005/08/18
// RCS-ID:      $Id: SVGUIElement.h,v 1.2 2006/01/08 19:42:41 ntalex Exp $
// Copyright:   (c) Laurent Bessard
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#ifndef SVGUI_ELEMENT_H
#define SVGUI_ELEMENT_H

#include <wx/wx.h>
#include <wxXML/xml.h>
#include <wxSVG/svg.h>
#include <wxSVG/SVGElement.h>
#include "ElementTransform.h"

class SVGUIElement:
	public wxXmlElement
{
	protected:
		wxSVGDocument* m_doc;
		wxSVGElement* m_BackgroundElement;
		
	public:
		SVGUIElement(){};
		SVGUIElement(wxSVGDocument* doc);
		wxString GetId();
		
		virtual bool HitTest(wxPoint pt) = 0;
		virtual wxSVGRect GetBBox() = 0;
		virtual void SendMouseEvent(wxMouseEvent& event) = 0;
		virtual void SendKeyEvent(wxKeyEvent& event) = 0;
		virtual void Update_Elements() = 0;
		
		virtual void AddProperty(const wxString& name, const wxString& value);
		virtual bool SetAttribute(const wxString& attrName, const wxString& attrValue); 
};

#endif //SVGUI_ELEMENT_H
