//////////////////////////////////////////////////////////////////////////////
// Name:        svgview.cpp
// Purpose:     
// Author:      Alex Thuering
// Created:     15/01/2005
// RCS-ID:      $Id: calculette.cpp,v 1.2 2006/01/08 19:42:41 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#if defined(__GNUG__) && !defined(__APPLE__)
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#ifndef __WXMSW__
#include <locale.h>
#endif

#include "calculette.h"
#include <wxSVG/svg.h>

//////////////////////////////////////////////////////////////////////////////
///////////////////////////////  Application /////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

IMPLEMENT_APP(SVGViewApp)

bool SVGViewApp::OnInit()
{
#ifndef __WXMSW__
  setlocale(LC_NUMERIC, "C");
#endif
  //wxLog::SetActiveTarget(new wxLogStderr);		
  
  new MainFrame(NULL, wxT("SVG Viewer"),
	wxDefaultPosition, wxSize(275, 335));
  return true;
}

//////////////////////////////////////////////////////////////////////////////
////////////////////////////////  MainFrame //////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
enum
{
wxID_FIT = 1,
};

BEGIN_EVENT_TABLE(Calculette, SVGUIWindow)
  EVT_BUTTON (XRCID("boutonAC"), Calculette::OnBoutonACClick)
END_EVENT_TABLE()

MainFrame::MainFrame(wxWindow *parent, const wxString& title, const wxPoint& pos,
  const wxSize& size, long style): wxFrame(parent, wxID_ANY, title, pos, size, style)
{
    m_svgCtrl = new Calculette(this);
	if (wxTheApp->argc > 1)
	  m_svgCtrl->LoadFiles(wxTheApp->argv[1],wxTheApp->argv[2]);
	else
	  m_svgCtrl->LoadFiles(wxT("calculette.svg"), wxT("calculette.def"));
	
	Show(true);
	m_svgCtrl->SetFocus();
	m_svgCtrl->Erase();
	m_svgCtrl->SetFitToFrame(true);
	m_svgCtrl->RefreshScale();
	m_svgCtrl->Update();
}

Calculette::Calculette(wxWindow* parent):
 SVGUIWindow(parent)
{
	m_first_key = true;
	m_result = 0;
	m_operation = NO;
}

wxWindow* Calculette::CreateWindow(const wxString& classname)
{
	wxWindow* res = NULL;
	if (classname == wxT("NumKbd"))
		res = new NumKbd(this);
	if (classname == wxT("TrigoKbd"))
		res = new TrigoKbd(this);
	return res;
}

void Calculette::SetNombreValue(const wxString value)
{
	SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementById(wxT("nombre"));
	text->SetValue(value);
	m_first_key = true;
}

void Calculette::Erase()
{
	SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementById(wxT("nombre"));
	text->SetValue(wxT("0"));
	m_first_key = true;
	m_result = 0;
	m_operation = NO;
}

void Calculette::Error()
{
	SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementById(wxT("nombre"));
	text->SetValue(wxT("Error"));
	m_first_key = true;
	m_result = 0;
	m_operation = NO;
}

void Calculette::Calculer()
{
	SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementById(wxT("nombre"));
	double value;
	if (text->GetValue().ToDouble(&value))
	{
		if (m_operation == NO)
			m_result = value;
		else if (m_operation == PLUS)
			m_result += value;
		else if (m_operation == MOINS)
			m_result -= value;
		else if (m_operation == MULTIPLIER)
			m_result *= value;
		else if (m_operation == DIVISER)
		{
			if (value == 0)
			{
				Error();
				return;
			}
			m_result /= value;
		}
		wxString result = wxString::Format(wxT("%.1f"), m_result);
		text->SetValue(result);
		m_first_key = true;
	}
	else
		Error();
}

void Calculette::OnBoutonACClick(wxCommandEvent& event)
{
	wxKeyEvent keyevent(wxEVT_CHAR);
	keyevent.m_keyCode = WXK_DELETE;
	ProcessEvent(keyevent);
	event.Skip();
}

void Calculette::OnChar(wxKeyEvent& event)
{
	SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementById(wxT("nombre"));
	long keycode = event.GetKeyCode();
	if ((char)keycode == '+')
	{
		Calculer();
		m_operation = PLUS;
	}
	else if ((char)keycode == '-')
	{
		Calculer();
		m_operation = MOINS;
	}
	else if ((char)keycode == '*')
	{
		Calculer();
		m_operation = MULTIPLIER;
	}
	else if ((char)keycode == '/')
	{
		Calculer();
		m_operation = DIVISER;
	}
	else if (keycode == WXK_RETURN)
	{
		Calculer();
		m_operation = NO;
	}
	else if (keycode == WXK_DELETE)
	{
		Erase();	
	}
	else if (keycode == (long)'.')
	{
		if (m_first_key)
		{
			m_first_key = false;
			text->SetText(wxT("0"));
		}
		text->SendKeyEvent(event);
	}
	else if (keycode >= (long)'0' && keycode <= (long)'9')
	{
		if (m_first_key)
		{
			m_first_key = false;
			text->SetText(wxT(""));
		}
		text->SendKeyEvent(event);
	}
}

void Calculette::OnSize(wxSizeEvent& event)
{
	RefreshScale();
	SVGUINoteBook* notebook = (SVGUINoteBook*)GetElementById(wxT("onglet"));
	if (notebook)
		notebook->RefreshContentSize(1/m_scale);
	event.Skip();
}
