//////////////////////////////////////////////////////////////////////////////
// Name:        svgview.cpp
// Purpose:     
// Author:      Alex Thuering
// Created:     15/01/2005
// RCS-ID:      $Id: svgui-test.cpp,v 1.2 2006/01/08 19:42:41 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#if defined(__GNUG__) && !defined(__APPLE__)
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#ifndef __WXMSW__
#include <locale.h>
#endif

#include "svgui-test.h"
#include <wxSVG/svg.h>

void Parcourt_Recursif(wxXmlElement* root);

//////////////////////////////////////////////////////////////////////////////
///////////////////////////////  Application /////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

IMPLEMENT_APP(SVGViewApp)

bool SVGViewApp::OnInit()
{
#ifndef __WXMSW__
  setlocale(LC_NUMERIC, "C");
#endif
  //wxLog::SetActiveTarget(new wxLogStderr);		
  
  new MainFrame(NULL, wxT("SVG Viewer"),
	wxDefaultPosition, wxSize(500, 400));
  return true;
}

//////////////////////////////////////////////////////////////////////////////
////////////////////////////////  MainFrame //////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
enum
{
wxID_FIT = 1,
};

BEGIN_EVENT_TABLE(MainFrame, wxFrame)
  EVT_MENU(wxID_OPEN, MainFrame::OnOpen)
  EVT_MENU(wxID_FIT, MainFrame::Fit)
  EVT_MENU(wxID_EXIT, MainFrame::OnExit)
END_EVENT_TABLE()

BEGIN_EVENT_TABLE(MySVGCanvas, SVGUIWindow)
  EVT_BUTTON (XRCID("bouton1"), MySVGCanvas::OnBouton1LeftDown)
  EVT_BUTTON (XRCID("bouton2"), MySVGCanvas::OnBouton2LeftDown)
  EVT_COMMAND_SCROLL_THUMBTRACK(XRCID("scrollbar"), MySVGCanvas::OnScrollBarChanged)
END_EVENT_TABLE()


MainFrame::MainFrame(wxWindow *parent, const wxString& title, const wxPoint& pos,
  const wxSize& size, long style): wxFrame(parent, wxID_ANY, title, pos, size, style)
{
	// Make a menubar
    wxMenu *fileMenu = new wxMenu;
    fileMenu->Append(wxID_OPEN, _T("&Open..."));
    fileMenu->AppendSeparator();
    fileMenu->Append(wxID_EXIT, _T("&Close"));
    fileMenu->AppendSeparator();
    fileMenu->AppendCheckItem(wxID_FIT, _T("&FitToFrame"));
    
    wxMenuBar *menuBar = new wxMenuBar;
    menuBar->Append(fileMenu, _T("&File"));
    SetMenuBar(menuBar);

    m_svgCtrl = new MySVGCanvas(this);
	if (wxTheApp->argc > 2)
        m_svgCtrl->LoadFiles(wxTheApp->argv[1], wxTheApp->argv[2]);
    else if (wxTheApp->argc > 1)
        m_svgCtrl->LoadFiles(wxString(wxTheApp->argv[1]) + wxT(".svg"),
                             wxString(wxTheApp->argv[1]) + wxT(".def"));
	else
	  	m_svgCtrl->LoadFiles(wxT("test.svg"), wxT("test.def"));
	
	m_svgCtrl->InitScrollBar(0, 5, 10);
	Show(true);
	m_svgCtrl->RefreshScale();
	m_svgCtrl->Update();
}

void MainFrame::OnOpen(wxCommandEvent& event)
{
  wxString filename = wxFileSelector(_T("Choose a file to open"),
    _T(""), _T(""), _T(""), _T("SVG files (*.svg)|*.svg|All files (*.*)|*.*"));
  if (!filename.empty())
    m_svgCtrl->LoadFiles(filename, filename.BeforeLast(wxT('.')) + wxT(".def"));
}

void MainFrame::Fit(wxCommandEvent& event)
{
	m_svgCtrl->SetFitToFrame(event.IsChecked());
    m_svgCtrl->Update();
}

void MainFrame::OnExit( wxCommandEvent& WXUNUSED(event) )
{
  Close(true);
}

MySVGCanvas::MySVGCanvas(wxWindow* parent):
 SVGUIWindow(parent)
{
}

void MySVGCanvas::InitScrollBar(unsigned int position, unsigned int thumb, unsigned int range)
{
	SVGUIScrollBar* scrollbar = (SVGUIScrollBar*)GetElementById(wxT("scrollbar"));
    if (scrollbar)
      scrollbar->Init_ScrollBar(position, thumb, range);
}

void MySVGCanvas::OnBouton1LeftDown(wxCommandEvent& event)
{
	SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementById(wxT("text1"));
	text->SetValue(wxT("Text with space"));
	event.Skip();
}

void MySVGCanvas::OnBouton2LeftDown(wxCommandEvent& event)
{
	SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementById(wxT("text2"));
	text->SetValue(wxT("Essai"));
	event.Skip();
}

void MySVGCanvas::OnScrollBarChanged(wxScrollEvent& event)
{
	SVGUIScrollBar* scrollbar = (SVGUIScrollBar*)GetElementById(wxT("scrollbar"));
	SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementById(wxT("text3"));
	text->SetValue(wxString::Format(wxT("%d"), scrollbar->GetThumbPosition()));
	Update();
	event.Skip();
}
