#include <qapplication.h>
#include <qtranslator.h>
#include <qtextcodec.h>
#include <iostream>
#include "guessoform.h"

int main( int argc, char ** argv )
{
	QApplication app( argc, argv );
	QTranslator translator( 0 );
	
	if (argc>1)
	{
		if(strcmp(argv[1],"--help")== 0||strcmp(argv[1],"-h") == 0)
		{
			std::cerr <<	"\nG.u.e.s.s.o version: 0.3 \n";
			std::cerr <<	"By Mohamed Assar <mohasr@gmail.com> \n\n";
			std::cerr <<	"guesso [option] \n";
			std::cerr <<	"[option]\n";
			std::cerr <<	"-lang\t: choose the language . eg: guesso -lang ar    to choose the arabic language\n";
			std::cerr <<	"--help or -h\t: show this help info. \n";
			return(0);
		}else if(strcmp(argv[1],"-lang")== 0)
		{
			if ( !translator.load( QString("translation/guesso_") + argv[2], app.applicationDirPath()  ) )
				translator.load( QString("../share/guesso/translation/guesso_") + argv[2], app.applicationDirPath()  );
		}
	}else
	{
		if ( !translator.load( QString("translation/guesso_") + QTextCodec::locale(), app.applicationDirPath()  ) )
			translator.load( QString("../share/guesso/translation/guesso_") + QTextCodec::locale(), app.applicationDirPath()  );
	}
	
	//=== loading the translation -------------------------------------
	app.installTranslator( &translator );
	
	GuessoForm w;
	w.show();
	w.adjustSize();
	app.connect( &app, SIGNAL( lastWindowClosed() ), &app, SLOT( quit() ) );
	return app.exec();
}
