/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini <emi_barbarossa@yahoo.it>      *
 *                         Cedric Le Gloannec <cedric35530@yahoo.fr>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <iostream>

#include <qcolor.h>
#include <qfile.h>
#include <qstring.h>

#include <kapplication.h>
#include <kmessagebox.h>
#include <klocale.h>

#include "solver.h"

static bool __single =false;

//#define REPLACE_CAR	""
const QString REPLACE_CAR = "";

unsigned int Solver::steps = 0,
     Solver::level = 0,
     Solver::actualSchemePosition = 0;
bool Solver::m_exitFlag = false,
     Solver::m_randomFlag = false,
     Solver::successFlag = false;
QString Solver::possibleValues = "123456789";

Solver::Solver()
{
}

Solver::Solver(const QString& s)
{
  scheme = QStringList::split(",",s);
  initMask();
}

Solver::Solver(QLineEdit* *le, QLabel* *lcd, QLabel* lsteps, QLabel* lpartialsteps, QLabel* llevel, QLabel* lsolutions)
{
//  st = 0;

  partialSteps = 0;

  this->lcd =lcd;
  this->lsteps = lsteps;
  this->lpartialsteps = lpartialsteps;
  this->llevel = llevel;
  this->lsolutions = lsolutions;
  this->le = le;

  m["1"] = QColor("#68BDF2");
  m["2"] = QColor("#92d3a2");
  m["3"] = QColor("#d30349");
  m["4"] = QColor("#c7c7e3");
  m["5"] = QColor("#F2AD9F");
  m["6"] = QColor("#0344A7");
  m["7"] = QColor("#14A771");
  m["8"] = QColor("#d1d99d");
  m["9"] = QColor("#c1aabd");
  m["?"] = QColor(lcd[80]->paletteBackgroundColor ());

  connect(this, SIGNAL(sig(bool)), this, SLOT(slotStop(bool)));
  connect(this, SIGNAL(sigRandom(bool)), this, SLOT(slotRandom(bool)));
}

Solver::~Solver()
{
  lcd = 0;
  lsteps = 0;
  lpartialsteps = 0;
  llevel = 0;
  lsolutions = 0;
  le = 0;

//  if(st) delete st;
}

bool Solver::isInRaw(int r, const QString& s)
{
  r *= 9;
  for(int i = r; i < (r+9); i++)
    if(scheme[i] == s) return true;

  return false;
}

bool Solver::isInColumn(int c, const QString& s)
{
  for(int i = 0; i < 9; i++)
    if(scheme[c + 9*i] == s) return true;

  return false;
}

bool Solver::isInRectangle(int r, int c, const QString& s)
{
  r -= r % 3 ;
  c -= c % 3 ;

  QString t = scheme.join("");

  if(t.mid(9*r,9).mid(c,3).contains(s) != 0) return true;
  if(t.mid(9*(r+1),9).mid(c,3).contains(s) != 0) return true;
  if(t.mid(9*(r+2),9).mid(c,3).contains(s) != 0) return true;

  return false;
}

//to init all mask
void Solver::initMask(){
    //initialize all cells
    for (int r = 0; r < 81; r++) possibleMask.append(possibleValues);

    //we set the mask according to the scheme
    for (int r = 0; r < 9; r++){
	for (int c = 0; c < 9; c++){
	    QString t = scheme[9*r+c];
	    //we do somehing if they are one value
	    if (t != "" and t != "?")
		setMask(t, r,c);
	}
    }
}

//update all cell masks according to the value at row, column
void Solver::setMask(QString val, int row, int column){
    //we unset the value in the row and column
    for (int rc = 0; rc < 9; rc++){
	possibleMask[9*row + rc].replace(val, REPLACE_CAR);
	possibleMask[9*rc + column].replace(val, REPLACE_CAR);
    }
    int rectR = row - (row % 3),
	rectC = column - (column % 3);
    //we unset the value in the rectangle
    for (int r = rectR; r < (rectR+3); r++)
	for (int c = rectC; c < (rectC+3); c++) possibleMask[9*r+c].replace(val, REPLACE_CAR);

    //they are no more possible value in this cell
    possibleMask[9*row+column] = "";
}

//in the list of 9 mask we search a pattern of size 'size'
//if the pattern has the size x it is present in x masks
QStringList Solver::searchPattern(QStringList list, unsigned int size){
    //we search pattern of size value repeated 'size' time (size>=1)
    QStringList result;
    QString res("");
    unsigned int count = 0;
    //we search pattern in the mask with the same size
    for (int indList = 0; indList < 9; indList++){
	//search in mask list 
	if (list[indList].length() == size){
	    if (res.isEmpty())	//perhaps the pattern is found for the fist time
    		res = list[indList];
	    if (list[indList] == res)	//count this solution
		count++;
	}
    }
    if (count == size)
	result.append(res);
    //we found no pattern at all, so we should search into bigger mask
    res = QString("");
    unsigned int CountValue[9] = { 0,0,0, 0,0,0, 0,0,0 };
    //count for [1,2,3,4,5,6,7,8,9]
    for (int indList = 0; indList < 9; indList++)
        for (int val = 0; val < 9; val++)
    	    if (list[indList].find(possibleValues[val]) >= 0)
		(CountValue[val])++;
    //A pattern is size times the value 'size' in CountValue'
    //creer uneliste des element conter x fois
    QStringList value, pattern;
    pattern.append("");
    for (unsigned int i = 0; i < 9; i++) {
        if (CountValue[i] == size)
	    value.append(QString(possibleValues[i]));
    }
    if (value.size() >= size){
        pattern = generatePattern (value,size);
        unsigned int countSize;
        //we verify if the pattern is present 'size' times
       // bool find = false;
        for (unsigned int i = 0; i < pattern.size(); i++) {
	    countSize = 0;
	    for (int maskInd = 0; maskInd < 9; maskInd++) {
	        if (matchPattern(list[maskInd],pattern[i])){
		    countSize ++;
		    res = pattern[i];
		}
	    }
	    if (countSize == size){
	        result.append(res);
    	    }
	}
    }
    return result;
}

//generate a list of pattern of size with distinc element from l
QStringList Solver::generatePattern(QStringList l, unsigned int size){
    QStringList result;
    QString concat;

    if (size == 1) return l;

    if (l.size() == size) result.append(l.join(""));
    else {
	//element de la liste
        QStringList temp = l;
	concat = temp.first();
	l.pop_front();
	result = generatePattern(l, size - 1);
	for (unsigned int i = 0; i < result.size(); i++) result[i].prepend(concat);

	result += generatePattern(l, size);
    }
    return result;
}

//true if all element of pat are in str
bool Solver::matchPattern(QString str,QString pat){
    unsigned int l = pat.length();
    for (unsigned int i = 0; i < l; i++)
	if (str.find(pat[i]) < 0) return false;

    return true;
}

//this function searchs for pattern in the list l and
//return the same list simplified by this pattern
QStringList Solver::updateMaskPattern(QStringList l){
    unsigned int maskSize = 0;
    //search the max size of the pattern (pattern can't be bigger)
    for (int c = 0; c < 9; c++){
        unsigned int ll = l[c].length();
        if (maskSize < ll) maskSize = ll;
    }
    //search for all pattern size
    for (unsigned int p = 1; p <= maskSize; p++){
	QStringList pattern;
	pattern = searchPattern(l,p);
	for (unsigned int pat = 0; pat < pattern.size(); pat++){
	    //we try to update mask for each value of the pattern
	    unsigned int countMatch = 0;
    	    for (int c = 0; c < 9; c++)
		if (matchPattern(l[c],pattern[pat]))  countMatch++;

	    for (int c = 0; c < 9; c++){
		//in  the row exept were they are the pattern we erase the possible value
		//if they are in the pattern
		if (not matchPattern( l[c],pattern[pat])){
		    for (unsigned int i = 0; i < pattern[pat].length(); i++)
			l[c].replace((pattern[pat])[i],REPLACE_CAR);
		}
		else if (countMatch == p or l[c].length() == p)
		    l[c] = pattern[pat];
		else
		    for (unsigned int i = 0; i < pattern[pat].length(); i++)
			l[c].replace((pattern[pat])[i], REPLACE_CAR);
	    }
	}
    }
    return l;
}

//for all values of the mask of only one element
//we set this value
void Solver::setMaskAloneValue(){
    for (int r = 0; r < 9; r++) {
	for (int c = 0; c < 9; c++){
	    if (possibleMask[9*r+c].length() == 1){
		scheme[9*r+c] = possibleMask[9*r+c];
		setMask( possibleMask[9*r+c], r, c);
	    }
	}
    }
}

bool Solver::simplifyMask(){
    bool patternChanged = false;
    //search for row patern
    for (int r = 0; r < 9; r++) {
	QStringList l;
	for (int c=0;c<9;c++) l.append(possibleMask[9*r+c]);
	
	l = updateMaskPattern(l);
	for (int c = 0; c < 9; c++){
	    patternChanged |= (possibleMask[9*r+c] != l[c]);
	    possibleMask[9*r+c] = l[c];
	}
    }
    if (patternChanged) return patternChanged;
    //Search for colomn patern
    for (int c = 0; c < 9; c++) {
        QStringList l;
	for (int r = 0; r < 9; r++) l.append(possibleMask[9*r+c]);
	
	l = updateMaskPattern(l);
    	for (int r = 0; r < 9; r++){
	    patternChanged |= (possibleMask[9*r+c] != l[r]);
	    possibleMask[9*r+c] = l[r];
	}	
    }
    if (patternChanged) return patternChanged;
    //need to detect patern if the other method fail
    //Search fro rectangle patern
    for (int rr = 0; rr < 3; rr++) {
    	for (int rc = 0; rc < 3; rc++){
	    QStringList l;
	    for (int r = 0; r < 3;r++)
		for (int c = 0; c < 3; c++)
		    l.append(possibleMask[9*(r+3*rr)+3*rc+c]);

	    l = updateMaskPattern(l);
	    for (int r = 0; r<3;r++){
		for (int c = 0; c<3; c++){
		    patternChanged |= (possibleMask[9*(r+3*rr)+3*rc+c] != l[3*r+c]);
		    possibleMask[9*(r+3*rr)+3*rc+c] = l[3*r+c];
		}
	    }
	}
    }
    return patternChanged;
}

void Solver::recursionSolve(QTextStream* t){
    //Searching rows for pattern
    while( simplifyMask() ) setMaskAloneValue();
    
    //the last setAlonevalue could create alone value and 
    setMaskAloneValue();
    //we do the display for the simpliied scheme
    printScheme(scheme);
    kapp->processEvents();
    
    if(schemeCompleted()) {
	//there is a solution (we save it)
	solutions.append(scheme.join(","));
	lsolutions->setText(QString::number(lsolutions->text().toInt() + 1));
	//formatting and saving to stream
	if (t) {
	    QString lvs = scheme.join("");
	    (*t) << "Solution_"<<lsolutions->text()<<" : attempts="<<lpartialsteps->text()<<"\n(\n"
                        <<lvs.mid(0,9)<<"\n"
			<<lvs.mid(9,9)<<"\n"
			<<lvs.mid(18,9)<<"\n"
			<<lvs.mid(27,9)<<"\n"
                	<<lvs.mid(36,9)<<"\n"
                        <<lvs.mid(45,9)<<"\n"
                        <<lvs.mid(54,9)<<"\n"
                        <<lvs.mid(63,9)<<"\n"
                        <<lvs.mid(72,9)<<"\n"
                        <<")\n";
	}
	partialSteps = 0;
	//ready to consider single solution or complete
	if (__single)
	    successFlag = true;
    }else{
	//we search an empty cell (no value set yet)
	//and we try all its possible value;
	int currentInd;//=actualSchemePosition;

	findFirstEmptyAndLastFull();

	currentInd = firstEmpty.row*9+firstEmpty.column;
	
	//we save the current mask and scheme (solver state)
	QString maskSave= possibleMask.join(",");
	QString schemeSave= scheme.join(",");
	
	//we have to test the different possible value
	QString possibility=possibleMask[currentInd];
	for (uint i=0; i<possibility.length(); i++){
	    //we set the value to test
	    scheme[currentInd] = possibility[i];
	    setMask( possibility.mid(i,1), currentInd/9, currentInd%9);
	    actualSchemePosition = currentInd;
	    //Update Statistiques
	    lsteps->setText(QString::number(++steps));
            llevel->setText(QString::number(level++));
	    lpartialsteps->setText(QString::number(++partialSteps));
	    //solve with the new value put in the sheme
	    recursionSolve(t);
	    //to quit on demand the solver
	    //or for single solution solve
	    if (m_exitFlag or (__single and successFlag ))
		return;

	    llevel->setText(QString::number(level--));
	    //we must reinit the state to test another value
	    actualSchemePosition = currentInd;
	    scheme = QStringList::split(",",schemeSave,true);
	    possibleMask = QStringList::split(",",maskSave,true);
	}
    }
}

void Solver::solve(){
    //Stop button not yet pressed
    m_exitFlag = false;
    
    for(int i = 0; i < 81; i++)
    {
      QString s = scheme[i];
      lcd[i]->setPaletteForegroundColor (m[s]) ;
      if(le[i]->text() != "") lcd[i]->setBackgroundMode(Qt::PaletteHighlight);
      lcd[i]->setText(s);
    }

    //to put solve in a file
    if(not m_dbPath.isEmpty()) {
	QFile f(m_dbPath);
        if(not f.open(IO_WriteOnly)) KMessageBox::error(0, i18n("Cannot open file %1").arg(m_dbPath));
	QTextStream t(&f);
	
        t << "Scheme:[\n";
	QString z;
	for (int i = 0; i<9;i++) {
	    for (int j=0; j<9; j++) {
		z = le[9*i + j]->text();
        	if(z == "" or z == "?") z = "*";
		t<<z;
	    }
    	    t<<"\n";
        }
	t << "]\n\n";
	
	recursionSolve(&t);
	f.close();
    }
    else recursionSolve();

    //we print the last found scheme
    if ( solutions.size() > 0 )
	{
          printScheme( QStringList::split(",",solutions.last(),true) );
          for(int i = 0; i < 81; i++)
            {
              //QString s = scheme[i];
              //lcd[i]->setPaletteForegroundColor (m[s]) ;
              if(lcd[i]->backgroundMode() == Qt::PaletteHighlight)
                lcd[i]->setBackgroundMode(Qt::PaletteBackground);
              //lcd[i]->setText(s);
            }
         }
}

void Solver::clear()
{
  scheme = QStringList();
  possibleMask = QStringList();
  steps = 0;
  partialSteps = 0;
  level = 0;
  actualSchemePosition = 0;
  solutions = QStringList();
  m_exitFlag = false;
  successFlag = false;
}

bool Solver::schemeCompleted()
{
  if(scheme.join("").contains("?") != 0) return false;

  return true;
}

void Solver::findFirstEmptyAndLastFull()
{
  for(unsigned int i = actualSchemePosition; i < 81; i++)
    {
      QString t = scheme[i];
      if(t == "" or t == "?")
        {
           firstEmpty.row = i / 9;
           firstEmpty.column = i % 9; 
           break;
        }
    }
}

bool Solver::validateScheme()
{
  QStringList mc = scheme;
  unsigned int i = 0;
  while(i < 81)
    {
      if(scheme[i] != "" and scheme[i] != "?")
        {
           QString vi = scheme[i];
           scheme[i] = "?";
           m_wrong.row = i / 9;
           m_wrong.column = i % 9;
           if(isInRaw(m_wrong.row,vi)) { scheme = mc; return false; }
           if(isInColumn(m_wrong.column,vi)) { scheme = mc; return false; }
           if(isInRectangle(m_wrong.row,m_wrong.column,vi)) { scheme = mc; return false; }
	   if(possibleMask[i].length()>0){scheme = mc; return false; }
        }
	else
	  if(possibleMask[i].length()==0){scheme = mc; return false;}
      i++;
    }
  scheme = mc;
  return true;
}

void Solver::printScheme(QStringList sc)
{
  if(sc == QStringList()) return;

  int i;
  for(i = actualSchemePosition; i < 81; i++)
    {
      QString s = sc[i];
      lcd[i]->setPaletteForegroundColor (m[s]) ;
      lcd[i]->setText(s);
    }
}

void Solver::append(const QString &s) 
{
  scheme.append(s);
  if (scheme.size()==81)
    initMask();
}

#include "solver.moc"
