/***************************************************************************
 *   Copyright (C) 2005 by Emiliano Gulmini <emi_barbarossa@yahoo.it>      *
 *                         Cedric Le Gloannec <cedric35530@yahoo.fr>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SOLVER_H
#define SOLVER_H

#include <qobject.h>

#include <qstringlist.h>
#include <qlcdnumber.h>
#include <qlabel.h>
#include <qcolor.h>
#include <qlineedit.h>

#include "casella.h"
//#include "stackelement.h"


/**
This is the solving algorithm

@author Emiliano Gulmini <emi_barbarossa@yahoo.it>
*/

class Solver:public QObject
{
  Q_OBJECT

    QLabel* *lcd;
    QLabel* lsteps;
    QLabel* lpartialsteps;
    QLabel* llevel;
    QLabel* lsolutions;
    QLineEdit* *le;
    //QGroupBox *gbxsolver;
    QMap<QString, QColor> m;
    static QString possibleValues;
    static unsigned int steps;
    unsigned int partialSteps;
    static unsigned int level;
    static bool successFlag;
    static unsigned int actualSchemePosition;
    QStringList scheme,
		solutions,
		lastValidSolution;
    //QString solutionList;
    Casella firstEmpty, lasFull;
    
  public:
    static bool m_exitFlag;
    static bool m_randomFlag;
    QString m_dbPath;    
    Casella m_wrong;
    //StackElement* st;
    
  protected:
    QStringList possibleMask;

  public:
    Solver();
    Solver(const QString& s);
    Solver(QLineEdit* *le, QLabel* *lcd, QLabel* lsteps,QLabel* lpartialsteps, QLabel* llevel, QLabel* lsolutions);
    virtual ~Solver();
    void append(const QString& s);
    QString at(int i) { return scheme[i]; }
    void solve();
    void solveTryAll();
    void clear();
    void emitSig(bool f) { emit sig(f); }
    void emitSigRandom(bool f) {emit sigRandom(f);}
    bool validateScheme();
    void printScheme(QStringList sc = QStringList());
  private:
    void initMask();
    void setMask(QString val, int row, int ccolumn);
    QStringList searchPattern(QStringList list, uint size);
    QStringList generatePattern(QStringList l, uint size);
    QStringList updateMaskPattern(QStringList l);
    void setMaskAloneValue();
    bool matchPattern(QString str,QString pat);
    bool simplifyMask();
    void recursionSolve(QTextStream *t=NULL);
    bool isInRaw(int r, const QString& s);
    bool isInColumn(int c, const QString& s);
    bool isInRectangle(int r, int c, const QString& s);
//    void addPartialSolutionToStack(unsigned int i, QStringList sc, unsigned int act);
//    void delPartialSolutionFromStack();
//    unsigned int getCandidateNumber(Casella c, unsigned int i);
    bool schemeCompleted();
    void findFirstEmptyAndLastFull();
//    void recursion(unsigned int &valueIndex);
    
  public slots:
    void slotStop(bool f) { m_exitFlag = f; }
    void slotRandom(bool f) { m_randomFlag = f; }
    
  signals:
    void sig(bool);
    void sigRandom(bool);
};

#endif
