/*
  Copyright (C) 2005 by Bram Schoenmakers
  bramschoenmakers@kde.nl

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


#include "kboggle.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("A Boggle game for KDE.");

static const char version[] = "0.4.1";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open" ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("kboggle", I18N_NOOP("KBoggle"), version, description,
                     KAboutData::License_GPL, "(C) 2005 Bram Schoenmakers", 0, 0, "bramschoenmakers@kde.nl");
    about.addAuthor( "Bram Schoenmakers", 0, "bramschoenmakers@kde.nl" );
    about.addCredit( "Anneke Schoenmakers", I18N_NOOP("Tester") );
    about.addCredit( "Frank Schoep", I18N_NOOP("KBoggle icon") );
    about.addCredit( "Jérôme Viard", I18N_NOOP("French cubeset") );
    about.addCredit( "Olivier Robin", I18N_NOOP("Patch for entering accents") );
    KCmdLineArgs::init(argc, argv, &about );
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    KBoggle *mainWin = 0;

    if (app.isRestored())
    {
        RESTORE(KBoggle);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        mainWin = new KBoggle();
        app.setMainWidget( mainWin );
        mainWin->show();

        args->clear();
    }

    // mainWin has WDestructiveClose flag by default, so it will delete itself.
    return app.exec();
}

