/*
  Copyright (C) 2005 by Bram Schoenmakers
  bramschoenmakers@kde.nl

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <kdialogbase.h>

class QComboBox;
class QGroupBox;
class QSpinBox;
class KSpellConfig;
class CubesCombo;

/**
  Represents the settings dialog of KBoggle.
  @author Bram Schoenmakers <bramschoenmakers@kde.nl>
*/
class SettingsDialog : public KDialogBase
{
  Q_OBJECT
  public:
    /** Constructor */
    SettingsDialog( QWidget *parent = 0, const char *name = 0 );
    ~SettingsDialog();

    /** Show dialog */
    virtual void show();

    KSpellConfig *spellConfig() const { return mKSConfig; }

  signals:
    /**
       Emits when the configuration has been changed. When the first parameter
       is true, a new game will be requested. When the second parameter is true,
       KBoggle should be restarted.
    */
    void configChanged( bool, bool );

  protected slots:
    virtual void slotOk();
    virtual void slotApply();

    /**
      Notifies the user that KBoggle should start a new game after closing the
      settings dialog.
    */
    void setCriticalModified();

    /**
      Notifies the user that KBoggle should be restarted after closing the
      settings dialog. This is generally only required if the user changes
      KSpell's language.
    */
    void setRestartRequired();

  protected:
    void readSettings();
    void writeSettings();

  private:
    bool mCriticalModified;
    bool mRestartRequired;

    QCheckBox *mHighlightWords;
    QCheckBox *mUseMouse;
    QGroupBox *mUseDictionary;
    CubesCombo *mCubesCombo;
    QSpinBox *mTimeSpinbox;
    KSpellConfig *mKSConfig;
};

#endif
