/*
  Copyright (C) 2005 by Bram Schoenmakers
  bramschoenmakers@kde.nl

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef WORDLIST_H
#define WORDLIST_H

#include <qwidget.h>

class QGridLayout;
class QTimer;

/**
  This is a grid of words.
  @author Bram Schoenmakers <bramschoenmakers@kde.nl>
*/
class WordList : public QWidget
{
  Q_OBJECT
  public:
    WordList( QWidget *parent = 0, const char *name = 0 );
    ~WordList();

    /** Adds a word to the list */
    void addWord( const QString & );
    void addWords( const QStringList & ); // TODO

    /** Highlights a word in red for a couple of seconds */
    void highlight( const QString & );

    /** Clears the grid */
    void clear();

    /** Returns true if this grid contains this word. Otherwise it returns false */
    bool hasWord( const QString & );

    QStringList words() const { return mWords; }

  protected:
    /** Add a new column to the grid and show all the words again. */
    void addColumn();
    void init();

  protected slots:
    /** Removes highlight from label, by referencing mCurrentlyHighlighted */
    void unHighlight();

  private:
    QGridLayout *mLayout;
    QStringList mWords;
    typedef QPtrList<QLabel> Labels;
    Labels mLabels;
    QLabel *mCurrentlyHighlighted;
    QTimer *mTimer;

    int mColumns;
    int mRows;

    int mCount;
};

#endif
